/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.upm.business;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class UpmActionHelper {
    public static Map<DynamicObject, Optional<DynamicObject>> getMasterFiledToSrcBillMap(List<Long> masterFileIds) {
        HashMap<DynamicObject, Optional<DynamicObject>> result = new HashMap<DynamicObject, Optional<DynamicObject>>(16);
        Map<Long, DynamicObject> masterFileIdToDyMap = UpmActionHelper.getMasterFileIdToDyMap(masterFileIds);
        Map<Long, DynamicObject> masterFiledIdToSrcBillMap = UpmActionHelper.getMasterFiledIdToSrcBillMap(masterFileIds);
        for (Map.Entry<Long, DynamicObject> entry : masterFileIdToDyMap.entrySet()) {
            long masterId = entry.getKey();
            DynamicObject masterFile = entry.getValue();
            if (ObjectUtils.isEmpty((Object)masterFile)) continue;
            DynamicObject bill = masterFiledIdToSrcBillMap.get(masterId);
            result.put(masterFile, Optional.ofNullable(bill));
        }
        return result;
    }

    public static Map<Long, DynamicObject> getMasterFiledIdToSrcBillMap(List<Long> masterFileIds) {
        DynamicObject[] srcBills;
        HashMap<Long, DynamicObject> result = new HashMap<Long, DynamicObject>(16);
        QFilter qFilter = new QFilter("masterfileid", "in", masterFileIds).and(new QFilter("billtype", "!=", (Object)" ")).and(new QFilter("billid", ">", (Object)0L));
        DynamicObjectCollection cols = QueryServiceHelper.query((String)"upm_movetrack", (String)"masterfileid,billtype,billid", (QFilter[])qFilter.toArray(), (String)"id desc");
        if (ObjectUtils.isEmpty((Object)cols)) {
            return result;
        }
        HashMap<Long, Set> billIdToMasterFiledIdMap = new HashMap<Long, Set>(16);
        for (DynamicObject col : cols) {
            long billId = col.getLong("billid");
            Set value = billIdToMasterFiledIdMap.getOrDefault(billId, new HashSet(16));
            value.add(col.getLong("masterfileid"));
            billIdToMasterFiledIdMap.put(billId, value);
        }
        String srcEntityNumber = ((DynamicObject)cols.get(0)).getString("billtype");
        for (DynamicObject srcBill : srcBills = BusinessDataServiceHelper.load((Object[])billIdToMasterFiledIdMap.keySet().toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)srcEntityNumber))) {
            long billId = srcBill.getLong("id");
            Set masterFileIdsValue = billIdToMasterFiledIdMap.getOrDefault(billId, new HashSet(16));
            Iterator iterator = masterFileIdsValue.iterator();
            while (iterator.hasNext()) {
                long masterFileId = (Long)iterator.next();
                result.put(masterFileId, srcBill);
            }
        }
        return result;
    }

    public static Map<Long, DynamicObject> getMasterFileIdToDyMap(List<Long> masterFileIds) {
        DynamicObject[] masterFiledList;
        HashMap<Long, DynamicObject> result = new HashMap<Long, DynamicObject>(16);
        for (DynamicObject dynamicObject : masterFiledList = BusinessDataServiceHelper.load((String)"upm_masterfile", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("id", "in", masterFileIds)})) {
            result.put(dynamicObject.getLong("id"), dynamicObject);
        }
        return result;
    }
}

