/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.upm.business;

import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.formula.RowDataModel;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import org.apache.commons.collections4.map.MultiKeyMap;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class UpmImportIdAndNumberConvertHelper {
    public static String convertId2Number(Map<String, BillEntityType> entityTypeCache, MultiKeyMap<String, String> keyCache, String entityType, String fieldKey, String defaultValId) {
        IDataEntityProperty property = UpmImportIdAndNumberConvertHelper.findProperty(entityTypeCache, entityType, fieldKey);
        if (property instanceof BasedataProp || property instanceof MulBasedataProp) {
            String propEntityType = ((BasedataProp)property).getBaseEntityId();
            return UpmImportIdAndNumberConvertHelper.getNumberById(entityTypeCache, keyCache, propEntityType, defaultValId);
        }
        return defaultValId;
    }

    public static String convertNumber2Id(Map<String, BillEntityType> entityTypeCache, MultiKeyMap<String, String> keyCache, String entityType, String fieldKey, String defaultValNumber) {
        IDataEntityProperty property = UpmImportIdAndNumberConvertHelper.findProperty(entityTypeCache, entityType, fieldKey);
        if (property instanceof BasedataProp || property instanceof MulBasedataProp) {
            String propEntityType = ((BasedataProp)property).getBaseEntityId();
            return UpmImportIdAndNumberConvertHelper.getIdByNumber(entityTypeCache, keyCache, propEntityType, defaultValNumber);
        }
        return defaultValNumber;
    }

    private static String getNumberById(Map<String, BillEntityType> entityTypeCache, MultiKeyMap<String, String> keyCache, String propEntityType, String defaultValId) {
        if (StringUtils.isBlank((CharSequence)defaultValId)) {
            return null;
        }
        String value = (String)keyCache.get((Object)propEntityType, (Object)defaultValId);
        if (null != value) {
            return value;
        }
        BasedataEntityType basedataEntityType = (BasedataEntityType)UpmImportIdAndNumberConvertHelper.getDataEntityType(entityTypeCache, propEntityType);
        if (null == basedataEntityType) {
            return null;
        }
        String numberField = basedataEntityType.getNumberProperty();
        if (StringUtils.isBlank((CharSequence)numberField)) {
            return defaultValId;
        }
        String[] ids = StringUtils.split((String)defaultValId, (char)',');
        QFilter qFilter = new QFilter("id", "in", Stream.of(ids).map(Long::parseLong).collect(Collectors.toList()));
        DynamicObject[] dymArray = BusinessDataServiceHelper.load((String)propEntityType, (String)numberField, (QFilter[])qFilter.toArray());
        if (ObjectUtils.isNotEmpty((Object)dymArray)) {
            String number = Stream.of(dymArray).map(item -> item.getString(numberField)).collect(Collectors.joining(","));
            keyCache.put((Object)propEntityType, (Object)defaultValId, (Object)number);
            return number;
        }
        return null;
    }

    private static IDataEntityProperty findProperty(Map<String, BillEntityType> entityTypeCache, String entityType, String fieldKey) {
        BillEntityType mainEntityType = UpmImportIdAndNumberConvertHelper.getDataEntityType(entityTypeCache, entityType);
        if (null == mainEntityType) {
            return null;
        }
        return RowDataModel.findProperty((MainEntityType)mainEntityType, (String)fieldKey);
    }

    private static BillEntityType getDataEntityType(Map<String, BillEntityType> entityTypeCache, String entityType) {
        BillEntityType mainEntityType = entityTypeCache.get(entityType);
        if (null == mainEntityType) {
            mainEntityType = (BillEntityType)MetadataServiceHelper.getDataEntityType((String)entityType);
            if (null == mainEntityType) {
                return null;
            }
            entityTypeCache.put(entityType, mainEntityType);
        }
        return mainEntityType;
    }

    private static String getIdByNumber(Map<String, BillEntityType> entityTypeCache, MultiKeyMap<String, String> keyCache, String propEntityType, String defaultValNumber) {
        if (StringUtils.isBlank((CharSequence)defaultValNumber)) {
            return null;
        }
        String value = (String)keyCache.get((Object)propEntityType, (Object)defaultValNumber);
        if (null != value) {
            return value;
        }
        BasedataEntityType basedataEntityType = (BasedataEntityType)UpmImportIdAndNumberConvertHelper.getDataEntityType(entityTypeCache, propEntityType);
        if (null == basedataEntityType) {
            return null;
        }
        String numberField = basedataEntityType.getNumberProperty();
        if (StringUtils.isBlank((CharSequence)numberField)) {
            return null;
        }
        QFilter qFilter = new QFilter(basedataEntityType.getNumberProperty(), "in", (Object)StringUtils.split((String)defaultValNumber, (char)','));
        DynamicObject[] dymArray = BusinessDataServiceHelper.load((String)propEntityType, (String)"id", (QFilter[])qFilter.toArray());
        if (ObjectUtils.isNotEmpty((Object)dymArray)) {
            String id = Stream.of(dymArray).map(item -> item.getString("id")).collect(Collectors.joining(","));
            keyCache.put((Object)propEntityType, (Object)defaultValNumber, (Object)id);
            return id;
        }
        return null;
    }
}

