/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.upm.business;

import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.extplugin.PluginProxy;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.kdtx.common.CommonParam;
import kd.bos.kdtx.common.Param;
import kd.bos.kdtx.sdk.session.DTX;
import kd.bos.kdtx.sdk.session.DTXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.print.api.PrintTask;
import kd.bos.print.api.PrintWork;
import kd.bos.print.core.service.PrtAttach;
import kd.bos.print.service.BosPrintServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.url.UrlService;
import kd.scmc.upm.business.action.PrintActionModel;
import kd.scmc.upm.business.log.WorkbenchActionLogToolInfo;
import kd.scmc.upm.business.masterfile.MasterfileHelper;
import kd.sdk.scmc.upm.extpoint.ExtDataDefineInfo;
import kd.sdk.scmc.upm.extpoint.IQueryDataPlugin;

public class WorkBenchExecuteHelper {
    private static final Log logger = LogFactory.getLog(WorkBenchExecuteHelper.class);
    private static final String SCENES_CODE = "upm_action_execute";
    private static final String CLOUD_ID = "scmc";
    private static final String APP_ID = "upm";
    private static final String SERVICE_NAME = "UpmMasterAcitionService";

    public static void execute(Long masterFileId, Long actionId, List<Object[]> paramsList) {
        WorkBenchExecuteHelper.validateMasterFile(Collections.singletonList(masterFileId), actionId);
        try (DTXHandle dtx = DTX.requiresNew((String)SCENES_CODE, (DBRoute)DBRoute.of((String)"scm"), (boolean)true);){
            try {
                logger.info("\u5f00\u59cb\u6267\u884c\u5de5\u4f5c\u53f0\u4e3b\u6863\u52a8\u4f5c");
                WorkbenchActionLogToolInfo actionLogToolInfo = new WorkbenchActionLogToolInfo(masterFileId, actionId, SerializationUtils.toJsonString(paramsList));
                Long exeLogId = (Long)actionLogToolInfo.getResult().getPkValue();
                CommonParam param = new CommonParam();
                param.put((Object)"masterFileId", (Object)masterFileId);
                param.put((Object)"actionId", (Object)actionId);
                param.put((Object)"exeLogId", (Object)exeLogId);
                param.put((Object)"params", paramsList);
                dtx.register(CLOUD_ID, APP_ID, SERVICE_NAME, (Param)param);
            }
            catch (Exception e) {
                dtx.markRollback();
                throw e;
            }
        }
    }

    private static void validateMasterFile(List<Long> masterFileIds, Long actionId) {
        DynamicObjectCollection masterFiles = QueryServiceHelper.query((String)"upm_masterfile", (String)"number", (QFilter[])new QFilter[]{new QFilter("id", "in", masterFileIds)});
        for (DynamicObject masterFile : masterFiles) {
            String number = masterFile.getString("number");
            List<Map<String, Object>> params = Collections.singletonList(Collections.singletonMap("number", number));
            Map<String, Object> validResult = MasterfileHelper.handleAction("upm_masterfile", actionId, params, false, true);
            String validFlag = (String)validResult.get("success");
            if (!"N".equals(validFlag)) continue;
            Map allErrorMap = (Map)validResult.get("errmsg");
            throw new KDBizException((String)allErrorMap.get(number));
        }
    }

    public static void retryExecute(Long masterFileId, Long actionId, List<Object[]> paramsList, Long exeLogId) {
        try (DTXHandle dtx = DTX.requiresNew((String)SCENES_CODE, (DBRoute)DBRoute.of((String)"scm"));){
            try {
                logger.info("\u65e5\u5fd7ID:{}\u91cd\u8bd5\u6267\u884c\u5f00\u59cb", (Object)exeLogId);
                CommonParam param = new CommonParam();
                param.put((Object)"masterFileId", (Object)masterFileId);
                param.put((Object)"actionId", (Object)actionId);
                param.put((Object)"exeLogId", (Object)exeLogId);
                param.put((Object)"params", paramsList);
                dtx.register(CLOUD_ID, APP_ID, SERVICE_NAME, (Param)param);
            }
            catch (Exception e) {
                dtx.markRollback();
                throw e;
            }
        }
    }

    public static Date getStartOrEndDate(Date date, boolean isEnd) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        if (isEnd) {
            cal.set(11, 23);
            cal.set(12, 59);
            cal.set(13, 59);
        } else {
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
        }
        return cal.getTime();
    }

    public static List<ExtDataDefineInfo> getExtDataInfo(IDataModel model) {
        try {
            PluginProxy pluginProxy = PluginProxy.create(null, IQueryDataPlugin.class, (String)"SCMC_UPM_WORKBENCH_EXTDATA", null);
            List result = pluginProxy.callReplace(p -> p.getExtDataInfo(model));
            if (result != null && result.size() > 0) {
                return (List)result.get(0);
            }
            return null;
        }
        catch (Throwable e) {
            String expMsg = e.getMessage().concat(Arrays.toString(e.getStackTrace()));
            logger.error("\u6269\u5c55\u573a\u666f\u51fa\u73b0\u5f02\u5e38:{}", (Object)expMsg);
            String message = String.format(ResManager.loadKDString((String)"\u6269\u5c55\u573a\u666f\u51fa\u73b0\u5f02\u5e38:%s", (String)"WorkBenchExecuteHelper_0", (String)"scmc-upm-form", (Object[])new Object[0]), e.getMessage());
            throw new KDBizException(message);
        }
    }

    public static Map<String, Object> getMoveTrackBillId(String formId, Long masterFileId) {
        QFilter filter = new QFilter("masterfileid", "=", (Object)masterFileId);
        filter.and("billtype", "=", (Object)formId);
        HashMap<String, Object> bizData = new HashMap<String, Object>(16);
        try (DataSet bizColl = QueryServiceHelper.queryDataSet((String)"WorkBenchExecuteHelper", (String)"upm_movetrack", (String)"billtype,billid,billno", (QFilter[])filter.toArray(), (String)"createtime desc");){
            int i = 0;
            for (Row row : bizColl) {
                if (i == 0) {
                    bizData.put("billid", row.getString("billid"));
                    bizData.put("billno", row.getString("billno"));
                    ++i;
                    continue;
                }
                break;
            }
        }
        return bizData;
    }

    public static PrintWork getPrintWork(String printLang, String printStyle, String pageId) {
        PrintWork work = new PrintWork();
        work.setBizOp(true);
        work.setPageId(pageId);
        work.setPrintLang(printLang);
        work.setExpType(printStyle);
        return work;
    }

    public static PrintTask getPrintTask(String formId, String defaultTemplateId) {
        PrintTask printTask = new PrintTask();
        printTask.setFormId(formId);
        String tplId = BosPrintServiceHelper.getTplIdByNum((String)defaultTemplateId);
        printTask.setTplId(tplId);
        return printTask;
    }

    public static PrtAttach doPrint(PrintWork work) {
        return BosPrintServiceHelper.doPrint((PrintWork)work);
    }

    public static void preview(IFormView actionView, IFormView previewView, Object printTaskId, List<PrtAttach.AttachDetail> attachList) {
        if (attachList.size() <= 3) {
            for (PrtAttach.AttachDetail attach : attachList) {
                FormShowParameter para = new FormShowParameter();
                para.setFormId("bos_printpreview");
                para.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                HashMap<String, String> reservedSpace = new HashMap<String, String>(1);
                reservedSpace.put("reservedSpace", "true");
                para.getOpenStyle().setCustParam(reservedSpace);
                para.setCustomParam("src", (Object)String.format(UrlService.getDomainContextUrl() + "/api/print/download.do?taskId=%s&attachId=%s", printTaskId, attach.getAttachId()));
                previewView.showForm(para);
                actionView.sendFormAction(previewView);
            }
        } else {
            FormShowParameter para = new FormShowParameter();
            para.setFormId("bos_print_resultview");
            para.setCaption(ResManager.loadKDString((String)"\u6253\u5370\u7ed3\u679c", (String)"UpmWorkbenchPlugin_7", (String)"scmc-upm-form", (Object[])new Object[0]));
            para.getOpenStyle().setShowType(ShowType.Modal);
            para.setCustomParam("taskId", printTaskId);
            previewView.showForm(para);
            actionView.sendFormAction(previewView);
        }
    }

    public static Map<String, DynamicObject> getMasterCombCfg() {
        QFilter cfgQFilter = new QFilter("masterfilemeta", "=", (Object)"upm_masterfile");
        Map masterCombCfg = BusinessDataServiceHelper.loadFromCache((String)"msbd_mastercombcfg", (QFilter[])cfgQFilter.toArray());
        HashMap<String, DynamicObject> kv = new HashMap<String, DynamicObject>(16);
        for (DynamicObject obj : masterCombCfg.values()) {
            DynamicObject masterAddition = obj.getDynamicObject("masteraddition");
            if (masterAddition == null) continue;
            kv.put((String)obj.getDynamicObject("masteraddition").getPkValue(), obj);
        }
        return kv;
    }

    public static Map<String, Object> getPrintActionParameter(Long actionId) {
        PrintActionModel printActionModel = PrintActionModel.getInstance(actionId);
        return printActionModel.getPrintActionParameter();
    }

    public static void exeSaveLog(Long exeLogId, String exp, String expDetail) {
        if (exeLogId != null) {
            DynamicObject exeLog = BusinessDataServiceHelper.loadSingle((String)"upm_wb_exelog", (String)"status,executeinfo,executeinfo_tag", (QFilter[])new QFilter("id", "=", (Object)exeLogId).toArray());
            if (exp == null) {
                exeLog.set("status", (Object)"A");
            } else {
                exeLog.set("status", (Object)"B");
                exeLog.set("executeinfo", (Object)exp);
                exeLog.set("executeinfo_tag", (Object)expDetail);
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{exeLog});
        }
    }

    public static DynamicObject getBizOpService(Long actionId) {
        DynamicObject action = BusinessDataServiceHelper.loadSingle((Object)actionId, (String)"upm_masteraction");
        DynamicObjectCollection actionEntry = action.getDynamicObjectCollection("entryentity");
        for (DynamicObject row : actionEntry) {
            DynamicObject bizOpService = row.getDynamicObject("bizopservice");
            if (bizOpService == null) continue;
            return bizOpService;
        }
        return null;
    }

    public static void execute(List<Long> masterFileIds, long actionId, List<Object[]> paramsList) {
        WorkBenchExecuteHelper.validateMasterFile(masterFileIds, actionId);
        try (DTXHandle dtx = DTX.requiresNew((String)SCENES_CODE, (DBRoute)DBRoute.of((String)"scm"), (boolean)true);){
            try {
                logger.info("\u5f00\u59cb\u6267\u884c\u5de5\u4f5c\u53f0\u4e3b\u6863\u52a8\u4f5c");
                WorkbenchActionLogToolInfo actionLogToolInfo = new WorkbenchActionLogToolInfo(masterFileIds, (Long)actionId, SerializationUtils.toJsonString(paramsList));
                Long exeLogId = (Long)actionLogToolInfo.getResult().getPkValue();
                CommonParam param = new CommonParam();
                param.put((Object)"masterFileId", (Object)masterFileIds.get(0));
                param.put((Object)"masterFileIds", masterFileIds);
                param.put((Object)"actionId", (Object)actionId);
                param.put((Object)"exeLogId", (Object)exeLogId);
                param.put((Object)"params", paramsList);
                dtx.register(CLOUD_ID, APP_ID, SERVICE_NAME, (Param)param);
            }
            catch (Exception e) {
                dtx.markRollback();
                throw e;
            }
        }
    }
}

