/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.upm.business.action;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scmc.upm.business.action.MasterAcitonEntryResult;
import kd.scmc.upm.common.util.OpServiceUtil;

public class MasterAcitonEntryModel {
    private int inParamLength = 1000;
    DynamicObject bizOpService;
    DynamicObject exeLogEntry;
    private Object[] params;
    private MasterAcitonEntryResult acitonEntryResult;
    private String billStatus = "A";
    private String billNoKey = "billno";
    private String statusKey = "billstatus";

    private MasterAcitonEntryModel(DynamicObject actionEntry, DynamicObject bizOpService, Object[] params, DynamicObject exeLogEntry) {
        this.exeLogEntry = exeLogEntry;
        this.bizOpService = bizOpService;
        this.params = params;
        this.acitonEntryResult = new MasterAcitonEntryResult((Long)actionEntry.getPkValue(), bizOpService.getString("actiontype"), bizOpService.getString("desc"), actionEntry.getInt("seq"), params);
    }

    public static MasterAcitonEntryModel getInstance(DynamicObject actionEntry, DynamicObject bizOpService, Object[] params, DynamicObject eceLogEntry) {
        return new MasterAcitonEntryModel(actionEntry, bizOpService, params, eceLogEntry);
    }

    public MasterAcitonEntryResult invoke() {
        try {
            this.execute();
        }
        catch (Exception e) {
            String expMsg = e.getMessage().concat(Arrays.toString(e.getStackTrace()));
            this.acitonEntryResult.setSuccess(false);
            this.acitonEntryResult.setErrMsg(expMsg);
        }
        this.addExeLog();
        return this.acitonEntryResult;
    }

    private void addExeLog() {
        String errMsg;
        this.exeLogEntry.set("actionlinenum", (Object)this.acitonEntryResult.getSeq());
        this.exeLogEntry.set("actiontype", (Object)this.acitonEntryResult.getActiontype());
        this.exeLogEntry.set("inparameter", this.getSpiltparam(SerializationUtils.toJsonString((Object)this.acitonEntryResult.getParams())));
        this.exeLogEntry.set("issuccess", (Object)this.acitonEntryResult.isSuccess());
        String subErrMsg = errMsg = this.acitonEntryResult.getErrMsg();
        if (errMsg != null && errMsg.length() > 200) {
            subErrMsg = subErrMsg.substring(0, 200).concat("...");
        }
        this.exeLogEntry.set("expmsg_tag", (Object)errMsg);
        this.exeLogEntry.set("expmsg", (Object)subErrMsg);
    }

    private Object getSpiltparam(String params) {
        if (StringUtils.isBlank((CharSequence)params) || params.length() <= this.inParamLength) {
            return params;
        }
        return params.substring(0, this.inParamLength - 3).concat("...");
    }

    /*
     * Unable to fully structure code
     */
    private void execute() {
        if (this.exeLogEntry.getBoolean("issuccess")) {
            return;
        }
        var2_2 = actType = this.bizOpService.getString("actiontype");
        var3_3 = -1;
        switch (var2_2.hashCode()) {
            case 2467610: {
                if (!var2_2.equals("PUSH")) break;
                var3_3 = 0;
                break;
            }
            case 63216148: {
                if (!var2_2.equals("BIZOP")) break;
                var3_3 = 1;
                break;
            }
            case 1386383415: {
                if (!var2_2.equals("CERBILL")) break;
                var3_3 = 2;
                break;
            }
            case -1592831339: {
                if (!var2_2.equals("SERVICE")) break;
                var3_3 = 3;
            }
        }
        switch (var3_3) {
            case 0: {
                tx = TX.requiresNew((String)"PUSH");
                var5_7 = null;
                this.invokePush();
                if (tx == null) break;
                if (var5_7 == null) ** GOTO lbl35
                try {
                    tx.close();
                }
                catch (Throwable var6_10) {
                    var5_7.addSuppressed(var6_10);
                }
                break;
lbl35:
                // 1 sources

                tx.close();
                break;
                catch (Throwable var6_11) {
                    try {
                        var5_7 = var6_11;
                        throw var6_11;
                    }
                    catch (Throwable var7_16) {
                        if (tx != null) {
                            if (var5_7 != null) {
                                try {
                                    tx.close();
                                }
                                catch (Throwable var8_17) {
                                    var5_7.addSuppressed(var8_17);
                                }
                            } else {
                                tx.close();
                            }
                        }
                        throw var7_16;
                    }
                }
            }
            case 1: 
            case 2: {
                tx = TX.notSupported((String)"BIZOP");
                var5_8 = null;
                this.invokeBizOp();
                if (tx == null) break;
                if (var5_8 == null) ** GOTO lbl65
                try {
                    tx.close();
                }
                catch (Throwable var6_12) {
                    var5_8.addSuppressed(var6_12);
                }
                break;
lbl65:
                // 1 sources

                tx.close();
                break;
                catch (Throwable var6_13) {
                    try {
                        var5_8 = var6_13;
                        throw var6_13;
                    }
                    catch (Throwable var9_18) {
                        if (tx != null) {
                            if (var5_8 != null) {
                                try {
                                    tx.close();
                                }
                                catch (Throwable var10_19) {
                                    var5_8.addSuppressed(var10_19);
                                }
                            } else {
                                tx.close();
                            }
                        }
                        throw var9_18;
                    }
                }
            }
            case 3: {
                tx = TX.requiresNew((String)"SERVICE");
                var5_9 = null;
                this.invokeService();
                if (tx == null) break;
                if (var5_9 == null) ** GOTO lbl95
                try {
                    tx.close();
                }
                catch (Throwable var6_14) {
                    var5_9.addSuppressed(var6_14);
                }
                break;
lbl95:
                // 1 sources

                tx.close();
                break;
                catch (Throwable var6_15) {
                    try {
                        var5_9 = var6_15;
                        throw var6_15;
                    }
                    catch (Throwable var11_20) {
                        if (tx != null) {
                            if (var5_9 != null) {
                                try {
                                    tx.close();
                                }
                                catch (Throwable var12_21) {
                                    var5_9.addSuppressed(var12_21);
                                }
                            } else {
                                tx.close();
                            }
                        }
                        throw var11_20;
                    }
                }
            }
        }
    }

    private void invokePush() {
        String errMsg;
        DynamicObject tarData;
        String tarFormId;
        String pushStatus = this.bizOpService.getString("pushstatus");
        DynamicObject rule = this.bizOpService.getDynamicObject("botprule");
        if (rule == null) {
            return;
        }
        DynamicObject srcData = rule.getDynamicObject("sourceentitynumber");
        String srcFormId = srcData.getString("number");
        Set<Object> targetBillIds = this.botpPush(rule, srcFormId, tarFormId = (tarData = rule.getDynamicObject("targetentitynumber")).getString("number"));
        if (targetBillIds.isEmpty()) {
            return;
        }
        this.updTarBills(tarFormId, targetBillIds);
        if (("submit".equals(pushStatus) || "audit".equals(pushStatus)) && StringUtils.isNotBlank((CharSequence)(errMsg = this.billSubmitAndAudit(pushStatus, tarFormId, targetBillIds)))) {
            this.acitonEntryResult.setSuccess(false);
            this.acitonEntryResult.setErrMsg(errMsg);
            return;
        }
        this.acitonEntryResult.setSuccess(true);
        this.acitonEntryResult.setSuccessIds(targetBillIds.toArray());
    }

    private Set<Object> botpPush(DynamicObject rule, String srcFormId, String tarFormId) {
        String execStatus = this.exeLogEntry.getString("execstatus");
        long tarBillId = this.exeLogEntry.getLong("tarbillid");
        Set<Object> targetBillIds = new HashSet<Object>(16);
        if (StringUtils.isNotBlank((CharSequence)execStatus) && !"FAIL".equals(execStatus)) {
            targetBillIds.add(tarBillId);
            return targetBillIds;
        }
        PushArgs pushArgs = new PushArgs();
        List<ListSelectedRow> selectedRows = this.getSelectedRows(srcFormId);
        if (selectedRows.isEmpty()) {
            return targetBillIds;
        }
        pushArgs.setSourceEntityNumber(srcFormId);
        pushArgs.setTargetEntityNumber(tarFormId);
        pushArgs.setHasRight(true);
        pushArgs.setRuleId((String)rule.getPkValue());
        pushArgs.setBuildConvReport(true);
        pushArgs.setSelectedRows(selectedRows);
        pushArgs.setAutoSave(true);
        ConvertOperationResult pushResult = ConvertServiceHelper.pushAndSave((PushArgs)pushArgs);
        if (!pushResult.isSuccess()) {
            this.exeLogEntry.set("execstatus", (Object)"FAIL");
            this.acitonEntryResult.setSuccess(false);
            this.acitonEntryResult.setErrMsg(pushResult.getMessage());
            return targetBillIds;
        }
        targetBillIds = pushResult.getTargetBillIds();
        this.exeLogEntry.set("execstatus", (Object)"BOTPSUC");
        this.exeLogEntry.set("tarbillid", targetBillIds.iterator().next());
        return targetBillIds;
    }

    private String billSubmitAndAudit(String opStatus, String tarFormId, Collection<Object> targetBillIds) {
        OperationResult audResult;
        DynamicObject bill = BusinessDataServiceHelper.loadSingle((String)tarFormId, (String)this.statusKey, (QFilter[])new QFilter("id", "in", targetBillIds).toArray());
        if (bill == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u5355\u636e\u4fe1\u606f\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u4f20\u5165\u53c2\u6570\u3002", (String)"MasterAcitonEntryModel_0", (String)"scmc-upm-form", (Object[])new Object[0]));
        }
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", "true");
        option.setVariableValue("ignoreinteraction", String.valueOf(true));
        option.setVariableValue("ignorewarn", String.valueOf(true));
        option.setVariableValue("WF", String.valueOf(false));
        this.billStatus = bill.getString(this.statusKey);
        if ("A".equals(this.billStatus)) {
            OperationResult subResult = OperationServiceHelper.executeOperate((String)"submit", (String)tarFormId, (Object[])targetBillIds.toArray(), (OperateOption)option);
            if (!subResult.isSuccess()) {
                return this.getErroInfo(subResult);
            }
            this.billStatus = "B";
        }
        if ("B".equals(this.billStatus) && "audit".equals(opStatus) && !(audResult = OperationServiceHelper.executeOperate((String)"audit", (String)tarFormId, (Object[])targetBillIds.toArray(), (OperateOption)option)).isSuccess()) {
            return this.getErroInfo(audResult);
        }
        this.exeLogEntry.set("execstatus", (Object)"FULLSUC");
        return null;
    }

    private void updTarBills(String tarFormId, Set<Object> targetBillIds) {
        DynamicObject[] bills;
        String execStatus = this.exeLogEntry.getString("execstatus");
        if (!"BOTPSUC".equals(execStatus)) {
            return;
        }
        if (this.params.length < 2) {
            return;
        }
        Map updProperties = (Map)this.params[1];
        if (updProperties == null) {
            return;
        }
        for (DynamicObject bill : bills = this.getTargetBills(tarFormId, targetBillIds, updProperties)) {
            bill = OpServiceUtil.getDynamic4Map(updProperties, tarFormId, bill);
        }
        SaveServiceHelper.save((DynamicObject[])bills);
        this.exeLogEntry.set("execstatus", (Object)"UPDSUC");
    }

    private DynamicObject[] getTargetBills(String tarFormId, Set<Object> targetBillIds, Map<String, Object> updProperties) {
        return BusinessDataServiceHelper.load((Object[])targetBillIds.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)tarFormId));
    }

    private List<ListSelectedRow> getSelectedRows(String srcFormId) {
        ArrayList<ListSelectedRow> selectedRows = new ArrayList<ListSelectedRow>(16);
        if (this.params == null || this.params.length == 0) {
            return selectedRows;
        }
        Map billMap = (Map)this.params[0];
        if (billMap == null || billMap.isEmpty()) {
            return selectedRows;
        }
        Collection billIds = (Collection)billMap.get("id");
        Collection billNos = (Collection)billMap.get("billno");
        if (billIds != null && billIds.isEmpty()) {
            for (Object billId : billIds) {
                selectedRows.add(this.createSelectedRow(billId));
            }
        } else {
            if (billNos == null || billNos.isEmpty()) {
                return selectedRows;
            }
            MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)srcFormId);
            if (entityType instanceof BasedataEntityType) {
                this.billNoKey = "number";
            }
            Map bills = BusinessDataServiceHelper.loadFromCache((String)srcFormId, (String)"id", (QFilter[])new QFilter(this.billNoKey, "in", (Object)billNos).toArray());
            for (Object billId : bills.keySet()) {
                selectedRows.add(this.createSelectedRow(billId));
            }
        }
        return selectedRows;
    }

    private ListSelectedRow createSelectedRow(Object billId) {
        ListSelectedRow selectedRow = new ListSelectedRow(billId);
        if (this.params.length > 1) {
            Map entryMap = (Map)this.params[1];
            selectedRow.setEntryEntityKey((String)entryMap.get("entryKey"));
            selectedRow.setEntryPrimaryKeyValue(entryMap.get("entryId"));
        }
        return selectedRow;
    }

    private void invokeService() {
        DynamicObject service = this.bizOpService.getDynamicObject("mservice");
        if (service == null) {
            return;
        }
        DynamicObject bizCloud = service.getDynamicObject("bizcloud");
        DynamicObject bizApp = service.getDynamicObject("bizapp");
        boolean isCus = service.getBoolean("iscus");
        if (bizCloud == null || bizApp == null) {
            return;
        }
        String cloudNum = bizCloud.getString("number").toLowerCase();
        String appNum = bizApp.getString("number").toLowerCase();
        String serviceName = service.getString("servicename");
        String serviceMethod = service.getString("servicemethod");
        if (isCus) {
            if (this.params != null) {
                DispatchServiceHelper.invokeService((String)service.getString("factorypre").trim().toLowerCase(), (String)appNum, (String)serviceName, (String)serviceMethod, (Object[])this.params);
            } else {
                DispatchServiceHelper.invokeService((String)service.getString("factorypre").trim().toLowerCase(), (String)appNum, (String)serviceName, (String)serviceMethod, (Object[])new Object[0]);
            }
            this.acitonEntryResult.setSuccess(true);
            return;
        }
        if ("bos".equals(cloudNum)) {
            if (this.params != null) {
                DispatchServiceHelper.invokeBOSService((String)appNum, (String)serviceName, (String)serviceMethod, (Object[])this.params);
            } else {
                DispatchServiceHelper.invokeBOSService((String)appNum, (String)serviceName, (String)serviceMethod, (Object[])new Object[0]);
            }
            this.acitonEntryResult.setSuccess(true);
            return;
        }
        if (this.params != null) {
            DispatchServiceHelper.invokeBizService((String)cloudNum, (String)appNum, (String)serviceName, (String)serviceMethod, (Object[])this.params);
        } else {
            DispatchServiceHelper.invokeBizService((String)cloudNum, (String)appNum, (String)serviceName, (String)serviceMethod, (Object[])new Object[0]);
        }
        this.exeLogEntry.set("execstatus", (Object)"FULLSUC");
        this.acitonEntryResult.setSuccess(true);
    }

    private void invokeBizOp() {
        DynamicObject srcObj;
        String formId;
        MainEntityType entityType;
        OperateOption option = this.getOperateOption();
        String opKey = this.bizOpService.getString("op");
        String actType = this.bizOpService.getString("actiontype");
        if ("CERBILL".equals(actType)) {
            opKey = this.bizOpService.getString("pushstatus");
        }
        if ((entityType = MetadataServiceHelper.getDataEntityType((String)(formId = (String)(srcObj = this.bizOpService.getDynamicObject("srcobj")).getPkValue()))) instanceof BasedataEntityType) {
            this.billNoKey = "number";
            this.statusKey = "status";
        }
        Object[] ids = this.getBillIds(formId);
        ids = this.saveBill(formId, ids);
        if ("save".equals(opKey)) {
            return;
        }
        if (ids == null) {
            this.acitonEntryResult.setSuccess(false);
            String errMsg = this.acitonEntryResult.getErrMsg();
            if (StringUtils.isBlank((CharSequence)errMsg)) {
                this.acitonEntryResult.setErrMsg(ResManager.loadKDString((String)"\u83b7\u53d6\u5355\u636e\u4fe1\u606f\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u4f20\u5165\u53c2\u6570\u3002", (String)"MasterAcitonEntryModel_0", (String)"scmc-upm-form", (Object[])new Object[0]));
            }
            return;
        }
        if ("submit".equals(opKey) || "audit".equals(opKey)) {
            String errMsg = this.billSubmitAndAudit(opKey, formId, Arrays.asList(ids));
            if (StringUtils.isNotBlank((CharSequence)errMsg)) {
                this.acitonEntryResult.setSuccess(false);
                this.acitonEntryResult.setErrMsg(errMsg);
            } else {
                this.acitonEntryResult.setSuccess(true);
                this.acitonEntryResult.setSuccessIds(ids);
            }
            return;
        }
        String unOpKey = null;
        if (this.billStatus.equals("B")) {
            unOpKey = "unsubmit";
        } else if (this.billStatus.equals("C")) {
            unOpKey = "unaudit";
        }
        if ("delete".equals(opKey) && StringUtils.isNotBlank((CharSequence)unOpKey)) {
            OperationResult unOpResult = OperationServiceHelper.executeOperate((String)unOpKey, (String)formId, (Object[])ids, (OperateOption)option);
            if (!unOpResult.isSuccess()) {
                this.acitonEntryResult.setSuccess(false);
                this.acitonEntryResult.setErrMsg(this.getErroInfo(unOpResult));
            }
            OperationResult result = OperationServiceHelper.executeOperate((String)opKey, (String)formId, (Object[])ids, (OperateOption)option);
            this.acitonEntryResult.setSuccess(result.isSuccess());
            this.acitonEntryResult.setSuccessIds(result.getSuccessPkIds().toArray());
            this.acitonEntryResult.setErrMsg(this.getErroInfo(result));
        } else {
            OperationResult result = OperationServiceHelper.executeOperate((String)opKey, (String)formId, (Object[])ids, (OperateOption)option);
            this.acitonEntryResult.setSuccess(result.isSuccess());
            this.acitonEntryResult.setSuccessIds(result.getSuccessPkIds().toArray());
            this.acitonEntryResult.setErrMsg(this.getErroInfo(result));
        }
    }

    private OperateOption getOperateOption() {
        Map operatParams;
        OperateOption create = OperateOption.create();
        if (this.params != null && this.params.length >= 3 && (operatParams = (Map)this.params[2]) != null) {
            for (Map.Entry operatParam : operatParams.entrySet()) {
                create.setVariableValue((String)operatParam.getKey(), (String)operatParam.getValue());
            }
        }
        return create;
    }

    private Object[] saveBill(String formId, Object[] ids) {
        String execStatus = this.exeLogEntry.getString("execstatus");
        long tarBillId = this.exeLogEntry.getLong("tarbillid");
        if (StringUtils.isNotBlank((CharSequence)execStatus)) {
            return new Object[]{tarBillId};
        }
        if (this.params.length < 2) {
            this.exeLogEntry.set("execstatus", (Object)"UPDSUC");
            return ids;
        }
        Map saveProperties = (Map)this.params[1];
        if (saveProperties == null || saveProperties.isEmpty()) {
            this.exeLogEntry.set("execstatus", (Object)"UPDSUC");
            return ids;
        }
        DynamicObject bill = null;
        bill = ids == null ? BusinessDataServiceHelper.newDynamicObject((String)formId) : BusinessDataServiceHelper.loadSingle((Object)ids[0], (String)formId);
        bill = OpServiceUtil.getDynamic4Map(saveProperties, formId, bill);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bill});
        this.exeLogEntry.set("execstatus", (Object)"UPDSUC");
        this.exeLogEntry.set("tarbillid", bill.getPkValue());
        ids = new Object[]{bill.getPkValue()};
        this.acitonEntryResult.setSuccess(true);
        this.acitonEntryResult.setSuccessIds(ids);
        return ids;
    }

    private Object[] getBillIds(String formId) {
        if (this.params == null || this.params.length == 0) {
            return null;
        }
        Map billMap = (Map)this.params[0];
        if (billMap == null || billMap.isEmpty()) {
            return null;
        }
        Collection billIds = (Collection)billMap.get("id");
        Collection billNos = (Collection)billMap.get("billno");
        if (billIds != null && !billIds.isEmpty()) {
            DynamicObject queryOne = QueryServiceHelper.queryOne((String)formId, (String)this.statusKey, (QFilter[])new QFilter("id", "in", (Object)billIds).toArray());
            if (queryOne == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u5355\u636e\u4fe1\u606f\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u4f20\u5165\u53c2\u6570\u3002", (String)"MasterAcitonEntryModel_0", (String)"scmc-upm-form", (Object[])new Object[0]));
            }
            this.billStatus = queryOne.getString(this.statusKey);
            return billIds.toArray();
        }
        if (billNos == null || billNos.isEmpty()) {
            return null;
        }
        Map bills = BusinessDataServiceHelper.loadFromCache((String)formId, (String)("id," + this.statusKey), (QFilter[])new QFilter(this.billNoKey, "in", (Object)billNos).toArray());
        if (bills.isEmpty()) {
            return null;
        }
        this.billStatus = ((DynamicObject)bills.values().iterator().next()).getString(this.statusKey);
        return bills.keySet().toArray();
    }

    private String getErroInfo(OperationResult result) {
        StringBuilder sb = new StringBuilder();
        sb.append(result.getMessage());
        result.getAllErrorOrValidateInfo().forEach(info -> sb.append(info.getMessage()));
        result.getAllErrorInfo().forEach(info -> sb.append(info.getMessage()));
        return sb.toString();
    }
}

