/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.upm.business.action;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scmc.upm.business.action.MasterAcitonEntryModel;
import kd.scmc.upm.business.action.MasterAcitonEntryResult;
import kd.scmc.upm.business.action.MasterAcitonResult;

public class MasterAcitonModel {
    private List<Object[]> paramsList;
    private DynamicObject action;
    private DynamicObject exeLog;
    private MasterAcitonResult acitonResult;

    private MasterAcitonModel(List<Object[]> paramsList, Long actionId, Long exeLogId) {
        this.paramsList = paramsList;
        this.initModel(actionId, exeLogId);
    }

    private void initModel(Long actionId, Long exeLogId) {
        if (actionId != null) {
            this.action = BusinessDataServiceHelper.loadSingleFromCache((String)"upm_masteraction", (String)"number, name, status,enable,entryentity.bizopservice,entryentity.seq", (QFilter[])new QFilter("id", "=", (Object)actionId).toArray());
        }
        if (exeLogId != null) {
            this.exeLog = BusinessDataServiceHelper.loadSingle((String)"upm_wb_exelog", (String)"entitytype,masterfile,action,status,executeinfo,executeinfo_tag,parameter,entry.actionlinenum,entry.actiontype,entry.inparameter,entry.outparameter,entry.issuccess,entry.expmsg,entry.expmsg_tag,entry.execstatus,entry.tarbillid", (QFilter[])new QFilter("id", "=", (Object)exeLogId).toArray());
        }
    }

    public static MasterAcitonModel getInstance(List<Object[]> paramsList, Long actionId, Long exeLogId) {
        return new MasterAcitonModel(paramsList, actionId, exeLogId);
    }

    public void execute() {
        try {
            this.execOpAndService();
        }
        catch (Exception e) {
            this.acitonResult.setErrMsg(e.getMessage());
            this.acitonResult.setSuccess(false);
        }
        this.saveExeLog();
    }

    private void saveExeLog() {
        String errMsg = this.acitonResult.getErrMsg();
        String subErrMsg = errMsg;
        if (StringUtils.isNotBlank((CharSequence)subErrMsg) && subErrMsg.length() > 200) {
            subErrMsg = subErrMsg.substring(0, 200).concat("...");
        }
        this.exeLog.set("executeinfo", (Object)subErrMsg);
        this.exeLog.set("executeinfo_tag", (Object)errMsg);
        if (this.acitonResult.isSuccess()) {
            this.exeLog.set("status", (Object)"A");
        } else {
            this.exeLog.set("status", (Object)"B");
        }
        try (TXHandle tx = TX.requiresNew((String)"MasterAcitonModel.saveExeLog");){
            try {
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.exeLog});
            }
            catch (Exception e) {
                tx.markRollback();
                throw e;
            }
        }
    }

    private void execOpAndService() {
        DynamicObjectCollection actionEntrys = this.action.getDynamicObjectCollection("entryentity");
        if (this.acitonResult == null) {
            this.acitonResult = new MasterAcitonResult();
        }
        HashSet<Object> bizOpServiceIds = new HashSet<Object>(actionEntrys.size());
        for (DynamicObject actionEntry : actionEntrys) {
            DynamicObject bizOpService = actionEntry.getDynamicObject("bizopservice");
            if (bizOpService == null) continue;
            bizOpServiceIds.add(bizOpService.getPkValue());
        }
        QFilter opServiceF = new QFilter("id", "in", bizOpServiceIds).and("enable", "=", (Object)Boolean.TRUE);
        opServiceF.and("isasync", "=", (Object)true);
        Map bizOpServiceMap = BusinessDataServiceHelper.loadFromCache((String)"upm_bizopservice", (String)"number,name,actiontype, srcobj, botprule, op, mservice, desc, pushstatus", (QFilter[])opServiceF.toArray());
        if (this.paramsList == null || this.paramsList.size() < bizOpServiceMap.size()) {
            return;
        }
        HashMap<Integer, DynamicObject> exeLogEntryMap = new HashMap<Integer, DynamicObject>(bizOpServiceMap.size());
        DynamicObjectCollection exeLogEntrys = this.exeLog.getDynamicObjectCollection("entry");
        for (DynamicObject exeLogEntry : exeLogEntrys) {
            exeLogEntryMap.put(exeLogEntry.getInt("seq"), exeLogEntry);
        }
        int rowIndex = 0;
        for (DynamicObject actionEntry : actionEntrys) {
            DynamicObject bizOpService = actionEntry.getDynamicObject("bizopservice");
            String actType = bizOpService.getString("actiontype");
            if ("PRINT".equals(actType)) continue;
            if (bizOpService != null) {
                bizOpService = (DynamicObject)bizOpServiceMap.get(bizOpService.getPkValue());
            }
            if (bizOpService == null) continue;
            int seq = actionEntry.getInt("seq");
            DynamicObject exeLogEntry = (DynamicObject)exeLogEntryMap.get(seq);
            if (exeLogEntry == null) {
                exeLogEntry = exeLogEntrys.addNew();
            }
            MasterAcitonEntryModel masterAcitonEntry = MasterAcitonEntryModel.getInstance(actionEntry, bizOpService, this.paramsList.get(rowIndex), exeLogEntry);
            MasterAcitonEntryResult entryResult = masterAcitonEntry.invoke();
            this.acitonResult.addActionInfos(entryResult);
            if (!entryResult.isSuccess()) {
                this.acitonResult.setSuccess(false);
                this.acitonResult.setErrMsg(entryResult.getErrMsg());
                return;
            }
            ++rowIndex;
        }
        this.acitonResult.setSuccess(true);
    }

    public MasterAcitonResult getAcitonResult() {
        return this.acitonResult;
    }
}

