/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.upm.business.action;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class PrintActionModel {
    private DynamicObject action;

    private PrintActionModel(Long actionId) {
        if (actionId != null) {
            this.action = BusinessDataServiceHelper.loadSingleFromCache((String)"upm_masteraction", (String)"number, name, status,enable,entryentity.bizopservice,entryentity.seq", (QFilter[])new QFilter("id", "=", (Object)actionId).toArray());
        }
    }

    public static PrintActionModel getInstance(Long actionId) {
        return new PrintActionModel(actionId);
    }

    public Map<String, Object> getPrintActionParameter() {
        DynamicObjectCollection actionEntrys = this.action.getDynamicObjectCollection("entryentity");
        HashSet<Object> bizOpServiceIds = new HashSet<Object>(actionEntrys.size());
        for (DynamicObject actionEntry : actionEntrys) {
            DynamicObject bizOpService = actionEntry.getDynamicObject("bizopservice");
            if (bizOpService == null) continue;
            bizOpServiceIds.add(bizOpService.getPkValue());
        }
        Map bizOpServiceMap = BusinessDataServiceHelper.loadFromCache((String)"upm_bizopservice", (String)"number,name,actiontype, srcobj,printtemplate,printlang,desc", (QFilter[])new QFilter("id", "in", bizOpServiceIds).and("enable", "=", (Object)Boolean.TRUE).toArray());
        ArrayList<ExeResultInfo> exeResultInfoList = new ArrayList<ExeResultInfo>(16);
        HashMap<String, Object> exeResultInfoObj = new HashMap<String, Object>(16);
        for (DynamicObject actionEntry : actionEntrys) {
            DynamicObject bizOpService = actionEntry.getDynamicObject("bizopservice");
            if (bizOpService != null) {
                bizOpService = (DynamicObject)bizOpServiceMap.get(bizOpService.getPkValue());
            }
            if (bizOpService == null) continue;
            String actionType = bizOpService.getString("actiontype");
            String actionNumber = bizOpService.getString("number");
            DynamicObject srcObj = bizOpService.getDynamicObject("srcobj");
            if ("PRINT".equals(actionType)) {
                DynamicObject printTemplate = bizOpService.getDynamicObject("printtemplate");
                String printLang = bizOpService.getString("printlang");
                exeResultInfoObj.put("PRINT", new ExeResultInfo(actionNumber, actionType, srcObj.getString("number"), srcObj.getString("name"), printTemplate.getString("number"), printLang));
                continue;
            }
            if ("SERVICE".equals(actionType) && "UPDATE-MASTER-SERVICE".equals(actionNumber)) {
                exeResultInfoObj.put("SERVICE", new ExeResultInfo(actionNumber, actionType));
                continue;
            }
            if (!"BIZOP".equals(actionType)) continue;
            exeResultInfoList.add(new ExeResultInfo(actionNumber, actionType));
        }
        exeResultInfoObj.put("BIZOP", exeResultInfoList);
        return exeResultInfoObj;
    }

    public static class ExeResultInfo {
        private String actionNumber;
        private String actionType;
        private String srcObj;
        private String srcObjName;
        private String printTemplate;
        private String printLang;

        public ExeResultInfo(String actionNumber, String actionType) {
            this.actionNumber = actionNumber;
            this.actionType = actionType;
        }

        public ExeResultInfo(String actionNumber, String actionType, String srcObj, String srcObjName, String printTemplate, String printLang) {
            this.actionNumber = actionNumber;
            this.actionType = actionType;
            this.srcObj = srcObj;
            this.printTemplate = printTemplate;
            this.printLang = printLang;
            this.srcObjName = srcObjName;
        }

        public String getSrcObj() {
            return this.srcObj;
        }

        public void setSrcObj(String srcObj) {
            this.srcObj = srcObj;
        }

        public String getPrintTemplate() {
            return this.printTemplate;
        }

        public void setPrintTemplate(String printTemplate) {
            this.printTemplate = printTemplate;
        }

        public String getPrintLang() {
            return this.printLang;
        }

        public void setPrintLang(String printLang) {
            this.printLang = printLang;
        }

        public String getSrcObjName() {
            return this.srcObjName;
        }

        public void setSrcObjName(String srcObjName) {
            this.srcObjName = srcObjName;
        }

        public String getActionNumber() {
            return this.actionNumber;
        }

        public void setActionNumber(String actionNumber) {
            this.actionNumber = actionNumber;
        }

        public String getActionType() {
            return this.actionType;
        }

        public void setActionType(String actionType) {
            this.actionType = actionType;
        }

        public String toString() {
            return "ExeResultInfo{actionNumber='" + this.actionNumber + '\'' + ", actionType='" + this.actionType + '\'' + ", srcObj='" + this.srcObj + '\'' + ", srcObjName='" + this.srcObjName + '\'' + ", printTemplate='" + this.printTemplate + '\'' + ", printLang='" + this.printLang + '\'' + '}';
        }
    }
}

