/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.upm.business.actionform;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import org.apache.commons.lang3.ObjectUtils;

public class MasterActionFormCfg
implements Serializable {
    private Long masterActionId;
    private List<ActionFormField> actionFormFieldList;
    private Map<String, String> fieldMap;
    private long mappingCfg;
    private String balFieldKey;

    private MasterActionFormCfg() {
    }

    public static MasterActionFormCfg createInstance(DynamicObject cfgDym) {
        if (cfgDym == null) {
            return null;
        }
        MasterActionFormCfg masterActionFormCfg = new MasterActionFormCfg();
        DynamicObjectCollection entryRows = cfgDym.getDynamicObjectCollection("showentry");
        DynamicObject mappingCfgDym = cfgDym.getDynamicObject("mappingcfg");
        if (null != mappingCfgDym) {
            masterActionFormCfg.setMappingCfg(mappingCfgDym.getLong("id"));
        }
        masterActionFormCfg.setBalFieldKey(cfgDym.getString("balfieldkey"));
        if (ObjectUtils.isNotEmpty((Object)entryRows)) {
            int size = entryRows.size();
            masterActionFormCfg.setMasterActionId((Long)cfgDym.getDynamicObject("masteraction").getPkValue());
            ArrayList<ActionFormField> actionFormFieldList = new ArrayList<ActionFormField>(size);
            masterActionFormCfg.setActionFormFieldList(actionFormFieldList);
            HashMap<String, String> fieldMap = new HashMap<String, String>(size);
            masterActionFormCfg.setFieldMap(fieldMap);
            for (DynamicObject entryRow : entryRows) {
                ActionFormField actionFormField = new ActionFormField();
                String entityType = entryRow.getDynamicObject("entitytype").getString("number");
                actionFormField.setEntityType(entityType);
                String fieldKey = entryRow.getString("fieldkey");
                actionFormField.setFieldKey(fieldKey);
                actionFormField.setShow(entryRow.getBoolean("isshow"));
                actionFormField.setEdit(entryRow.getBoolean("isedit"));
                actionFormField.setMustInput(entryRow.getBoolean("ismustinput"));
                actionFormField.setDefaultVal(entryRow.getString("defaultval"));
                actionFormFieldList.add(actionFormField);
                fieldMap.put(fieldKey, entityType);
            }
        }
        return masterActionFormCfg;
    }

    public Long getMasterActionId() {
        return this.masterActionId;
    }

    public MasterActionFormCfg setMasterActionId(Long masterActionId) {
        this.masterActionId = masterActionId;
        return this;
    }

    public List<ActionFormField> getActionFormFieldList() {
        return this.actionFormFieldList;
    }

    public MasterActionFormCfg setActionFormFieldList(List<ActionFormField> actionFormFieldList) {
        this.actionFormFieldList = actionFormFieldList;
        return this;
    }

    public Map<String, String> getFieldMap() {
        return this.fieldMap;
    }

    public MasterActionFormCfg setFieldMap(Map<String, String> fieldMap) {
        this.fieldMap = fieldMap;
        return this;
    }

    public long getMappingCfg() {
        return this.mappingCfg;
    }

    public void setMappingCfg(long mappingCfg) {
        this.mappingCfg = mappingCfg;
    }

    public String getBalFieldKey() {
        return this.balFieldKey;
    }

    public void setBalFieldKey(String balFieldKey) {
        this.balFieldKey = balFieldKey;
    }

    public static class ActionFormField
    implements Serializable {
        private String entityType;
        private String fieldKey;
        private Boolean isShow = true;
        private Boolean isEdit = true;
        private Boolean isMustInput = false;
        private String defaultVal;

        public String getEntityType() {
            return this.entityType;
        }

        public ActionFormField setEntityType(String entityType) {
            this.entityType = entityType;
            return this;
        }

        public String getFieldKey() {
            return this.fieldKey;
        }

        public ActionFormField setFieldKey(String fieldKey) {
            this.fieldKey = fieldKey;
            return this;
        }

        public Boolean getShow() {
            return this.isShow;
        }

        public ActionFormField setShow(Boolean show) {
            this.isShow = show;
            return this;
        }

        public Boolean getEdit() {
            return this.isEdit;
        }

        public ActionFormField setEdit(Boolean edit) {
            this.isEdit = edit;
            return this;
        }

        public Boolean getMustInput() {
            return this.isMustInput;
        }

        public ActionFormField setMustInput(Boolean mustInput) {
            this.isMustInput = mustInput;
            return this;
        }

        public String getDefaultVal() {
            return this.defaultVal;
        }

        public ActionFormField setDefaultVal(String defaultVal) {
            this.defaultVal = defaultVal;
            return this;
        }
    }
}

