/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.upm.business.log;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;

public class WorkbenchActionLogToolInfo {
    private Long masterFile;
    private Long action;
    private Long creator;
    private String executeInfo;
    private String traceId;
    private String parameter;
    private String createDate;
    private String status;
    private DynamicObject exeLog;
    private List<ActionExeProcess> calOpList = new ArrayList<ActionExeProcess>(16);
    private static final Log logger = LogFactory.getLog(WorkbenchActionLogToolInfo.class);

    public DynamicObject getResult() {
        return this.exeLog;
    }

    public WorkbenchActionLogToolInfo(Long masterFileId, Long actionId, String inParameter) {
        this.exeLog = BusinessDataServiceHelper.newDynamicObject((String)"upm_wb_exelog");
        this.exeLog.set("entitytype", (Object)"upm_masterfile");
        this.exeLog.set("masterfile", (Object)masterFileId);
        this.exeLog.set("action", (Object)actionId);
        this.exeLog.set("creator", (Object)UserServiceHelper.getCurrentUserId());
        this.exeLog.set("createdate", (Object)TimeServiceHelper.now());
        this.exeLog.set("traceid", (Object)RequestContext.get().getTraceId());
        if (inParameter.length() > 255) {
            this.exeLog.set("parameter", (Object)inParameter.substring(0, 255));
        } else {
            this.exeLog.set("parameter", (Object)inParameter);
        }
        this.exeLog.set("parameter_tag", (Object)inParameter);
        this.exeLog.set("status", (Object)"C");
        this.saveActionLog();
    }

    public WorkbenchActionLogToolInfo(List<Long> masterFileIds, Long actionId, String inParameter) {
        this.exeLog = BusinessDataServiceHelper.newDynamicObject((String)"upm_wb_exelog");
        this.exeLog.set("entitytype", (Object)"upm_masterfile");
        this.exeLog.set("masterfile", (Object)masterFileIds.get(0));
        this.setMasterFileCollection(masterFileIds);
        this.exeLog.set("action", (Object)actionId);
        this.exeLog.set("creator", (Object)UserServiceHelper.getCurrentUserId());
        this.exeLog.set("createdate", (Object)TimeServiceHelper.now());
        this.exeLog.set("traceid", (Object)RequestContext.get().getTraceId());
        if (inParameter.length() > 255) {
            this.exeLog.set("parameter", (Object)inParameter.substring(0, 255));
        } else {
            this.exeLog.set("parameter", (Object)inParameter);
        }
        this.exeLog.set("parameter_tag", (Object)inParameter);
        this.exeLog.set("status", (Object)"C");
        this.saveActionLog();
    }

    private void setMasterFileCollection(List<Long> masterFileIds) {
        DynamicObjectCollection collection = new DynamicObjectCollection();
        DynamicObjectType dynamicType = this.exeLog.getDynamicObjectCollection("masterfiles").getDynamicObjectType();
        for (Long masterFileId : masterFileIds) {
            DynamicObject masterFleItem = new DynamicObject(dynamicType);
            masterFleItem.set("fbasedataid", (Object)masterFileId);
            collection.add((Object)masterFleItem);
        }
        this.exeLog.set("masterfiles", (Object)collection);
    }

    public void saveExpLogInfo(String expMsg, String expDetailMsg) {
        this.exeLog.set("executeinfo", (Object)expMsg);
        this.exeLog.set("executeinfo_tag", (Object)expDetailMsg);
        this.saveActionLog();
    }

    private WorkbenchActionLogToolInfo() {
    }

    private void saveActionLog() {
        try (TXHandle tx = TX.required((String)WorkbenchActionLogToolInfo.class.getName());){
            try {
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.exeLog});
            }
            catch (Exception e) {
                tx.markRollback();
                logger.error("\u6301\u4e45\u5316\u65e5\u5fd7\u51fa\u73b0\u4e86\u5f02\u5e38:{}", (Object)Arrays.toString(e.getStackTrace()));
            }
        }
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Long getMasterFile() {
        return this.masterFile;
    }

    public String getCreateDate() {
        return this.createDate;
    }

    public void setCreateDate(String createDate) {
        this.createDate = createDate;
    }

    public void setMasterFile(Long masterFile) {
        this.masterFile = masterFile;
    }

    public Long getAction() {
        return this.action;
    }

    public void setAction(Long action) {
        this.action = action;
    }

    public Long getCreator() {
        return this.creator;
    }

    public void setCreator(Long creator) {
        this.creator = creator;
    }

    public String getExecuteInfo() {
        return this.executeInfo;
    }

    public void setExecuteInfo(String executeInfo) {
        this.executeInfo = executeInfo;
    }

    public String getTraceId() {
        return this.traceId;
    }

    public void setTraceId(String traceId) {
        this.traceId = traceId;
    }

    public String getParameter() {
        return this.parameter;
    }

    public void setParameter(String parameter) {
        this.parameter = parameter;
    }

    public List<ActionExeProcess> getCalOpList() {
        return this.calOpList;
    }

    public void setCalOpList(List<ActionExeProcess> calOpList) {
        this.calOpList = calOpList;
    }

    public String toString() {
        return "ActionExecuteLogModel{masterFile=" + this.masterFile + ", action=" + this.action + ", creator=" + this.creator + ", executeInfo='" + this.executeInfo + '\'' + ", traceId='" + this.traceId + '\'' + ", parameter='" + this.parameter + '\'' + ", calOpList=" + this.calOpList + '}';
    }

    public static class ActionExeProcess {
        private Long actionLineNum;
        private String actionType;
        private String inParameter;
        private String outParameter;
        private Boolean success;
        private String expMsg;
        private String expMsg_tag;

        public Long getActionLineNum() {
            return this.actionLineNum;
        }

        public void setActionLineNum(Long actionLineNum) {
            this.actionLineNum = actionLineNum;
        }

        public String getActionType() {
            return this.actionType;
        }

        public void setActionType(String actionType) {
            this.actionType = actionType;
        }

        public String getInParameter() {
            return this.inParameter;
        }

        public void setInParameter(String inParameter) {
            this.inParameter = inParameter;
        }

        public String getOutParameter() {
            return this.outParameter;
        }

        public void setOutParameter(String outParameter) {
            this.outParameter = outParameter;
        }

        public Boolean getSuccess() {
            return this.success;
        }

        public void setSuccess(Boolean success) {
            this.success = success;
        }

        public String getExpMsg() {
            return this.expMsg;
        }

        public void setExpMsg(String expMsg) {
            this.expMsg = expMsg;
        }

        public String getExpMsg_tag() {
            return this.expMsg_tag;
        }

        public void setExpMsg_tag(String expMsg_tag) {
            this.expMsg_tag = expMsg_tag;
        }

        public String toString() {
            return "ActionExeProcess{actionLineNum=" + this.actionLineNum + ", actionType='" + this.actionType + '\'' + ", inParameter='" + this.inParameter + '\'' + ", outParameter='" + this.outParameter + '\'' + ", isSuccess=" + this.success + ", expMsg='" + this.expMsg + '\'' + '}';
        }
    }
}

