/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.upm.business.masterfile;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scmc.upm.business.masterfile.MasterfileHelper;
import kd.scmc.upm.business.masterfile.MasterfileStatusCalor;
import kd.scmc.upm.common.consts.UpmMasterActionServiceConst;

public abstract class MasterfileAbstractHandler {
    protected boolean validMode = false;
    protected Long actionId;
    protected String actionName;
    protected List<Map<String, Object>> masterfileOpes;
    protected int size;
    protected MasterfileStatusCalor statusCalculator;
    protected MainEntityType masterEntityType;
    protected DataEntityPropertyCollection masterProps;
    protected DataEntityPropertyCollection trackProps;
    protected Set<String> masterstatusProps;

    protected MasterfileAbstractHandler(Long actionId, List<Map<String, Object>> masterfileOpes) {
        this.actionId = actionId;
        this.masterfileOpes = masterfileOpes;
        this.size = masterfileOpes.size();
        this.statusCalculator = new MasterfileStatusCalor();
        this.getMetaProps();
        this.getBasedataAttr();
    }

    protected MasterfileAbstractHandler(Long actionId, List<Map<String, Object>> masterfileOpes, boolean validMode) {
        this(actionId, masterfileOpes);
        this.validMode = validMode;
    }

    private void getMetaProps() {
        this.masterEntityType = EntityMetadataCache.getDataEntityType((String)"upm_masterfile");
        this.masterstatusProps = MasterfileHelper.getMasterstatusProps((IDataEntityType)this.masterEntityType);
        if (this.masterstatusProps == null || this.masterstatusProps.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e3b\u6863\u4e0a\u672a\u914d\u7f6e\u4e3b\u6863\u72b6\u6001\u5b57\u6bb5\uff0c\u8bf7\u68c0\u67e5\u5143\u6570\u636e\u914d\u7f6e\u3002", (String)"MasterfileAbstractHandler_0", (String)"scmc-upm-form", (Object[])new Object[0]));
        }
        this.masterProps = this.masterEntityType.getProperties();
        MainEntityType trackEntityType = EntityMetadataCache.getDataEntityType((String)"upm_movetrack");
        this.trackProps = trackEntityType.getProperties();
    }

    private void getBasedataAttr() {
        DynamicObject action = BusinessDataServiceHelper.loadSingleFromCache((Object)this.actionId, (String)"upm_masteraction");
        if (action != null) {
            this.actionName = action.getString("name");
        }
    }

    public abstract Map<String, Object> handle();

    protected DynamicObject buildTrackDyn(Long masterId, Long trackId, Map<String, Object> masterfileOpe, Map<String, Long> newstatusMap, Map<String, Object> relattrMap) {
        String number = (String)masterfileOpe.get("number");
        DynamicObject trackDyn = BusinessDataServiceHelper.newDynamicObject((String)"upm_movetrack");
        trackDyn.set("id", (Object)trackId);
        trackDyn.set("masterfileid", (Object)masterId);
        trackDyn.set("action", (Object)this.actionId);
        trackDyn.set("creator", (Object)RequestContext.get().getCurrUserId());
        for (String string : this.masterstatusProps) {
            Long newstatus = newstatusMap.getOrDefault(string, this.getDefaultStatus(number, string));
            trackDyn.set(string, (Object)newstatus);
        }
        for (Map.Entry entry : relattrMap.entrySet()) {
            String relattr = (String)entry.getKey();
            Object relval = entry.getValue();
            trackDyn.set(relattr, relval);
        }
        Map trackParamMap = masterfileOpe.getOrDefault("upm_movetrack", Collections.emptyMap());
        for (Map.Entry trackParam : trackParamMap.entrySet()) {
            String paramKey = (String)trackParam.getKey();
            if (this.masterstatusProps.contains(paramKey) || UpmMasterActionServiceConst.TRACK_FIXFIELD.contains(paramKey) || !this.trackProps.containsKey((Object)paramKey)) continue;
            Object paramValue = trackParam.getValue();
            trackDyn.set(paramKey, paramValue);
        }
        return trackDyn;
    }

    protected Long getDefaultStatus(String number, String statusfield) {
        return UpmMasterActionServiceConst.INIT_STATUSID;
    }

    protected void putEntryRelattrMap(Long relationId, String statusfield, Long oldstatus, Map<String, Long> newstatusMap, Map<String, Object> otherattrMap) {
        Long newstatus;
        Map<String, Object> relattrs = this.statusCalculator.calMasterfileStatusWithCache(relationId, statusfield, oldstatus, this.actionId);
        if (!relattrs.isEmpty() && !(newstatus = (Long)relattrs.getOrDefault("newstatus", 0L)).equals(0L)) {
            Long location;
            Long actualNewstatus = MasterfileStatusCalor.getNewStatus(newstatus, oldstatus);
            newstatusMap.put(statusfield, actualNewstatus);
            Long usability = (Long)relattrs.getOrDefault("usability", 0L);
            if (!usability.equals(0L)) {
                otherattrMap.put("usability", usability);
            }
            if (!(location = (Long)relattrs.getOrDefault("location", 0L)).equals(0L)) {
                otherattrMap.put("location", location);
            }
        }
    }
}

