/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.upm.business.masterfile;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.upm.business.MasterfileBillConfigHelper;
import kd.scmc.upm.business.masterfile.MasterfileHelper;

public class MasterfileBillOperator {
    private DynamicObject cfg;
    private List<Long> billIds;
    private Map<String, Set<Long>> hasHandleBillMap;
    private String operate;
    private Long actionId;
    private String billtype;
    private MainEntityType mainEntityType;
    private String entrytype;
    private String entrypath;
    private String entrypathId;
    private Boolean iscreate;
    private String seqcol;
    private String upmnumcol;
    private String materialcol;
    private String materialmastercol;
    private String orgcol;
    private LinkedHashMap<String, String> mainfMaps;
    private LinkedHashMap<String, String> trackMaps;
    private HashMap<String, String> mainfDefvalMaps;
    private HashMap<String, String> trackDefvalMaps;

    public MasterfileBillOperator(DynamicObject cfg, String operate, List<Long> billIds, Map<String, Set<Long>> hasHandleBillMap) {
        this.cfg = cfg;
        this.operate = operate;
        this.billIds = billIds;
        this.hasHandleBillMap = hasHandleBillMap;
        this.initOperator();
    }

    private void initOperator() {
        this.actionId = this.cfg.getDynamicObject("action").getLong("id");
        this.iscreate = this.cfg.getBoolean("iscreate");
        this.billtype = this.cfg.getDynamicObject("srcbillobj").getString("number");
        this.mainEntityType = EntityMetadataCache.getDataEntityType((String)this.billtype);
        this.entrytype = this.cfg.getString("srcbillentry");
        this.entrypath = MasterfileBillConfigHelper.getEntryPath(this.mainEntityType, this.entrytype);
        this.entrypathId = this.entrypath + ".id";
        this.seqcol = this.entrypath + ".seq";
        this.upmnumcol = this.cfg.getString("upmnumberfield");
        this.materialcol = MasterfileBillConfigHelper.getMaterialCol(this.cfg);
        if (this.materialcol != null) {
            this.materialmastercol = this.materialcol + ".masterid";
        }
        this.orgcol = MasterfileBillConfigHelper.getOrgCol(this.cfg);
        this.mainfMaps = MasterfileBillConfigHelper.getMainfMaps(this.cfg, "A");
        this.trackMaps = MasterfileBillConfigHelper.getTrackMaps(this.cfg, "A");
        this.mainfDefvalMaps = MasterfileBillConfigHelper.getMainfMaps(this.cfg, "B");
        this.trackDefvalMaps = MasterfileBillConfigHelper.getTrackMaps(this.cfg, "B");
    }

    private QFilter buildBillFilter(Set<Long> billIds) {
        QFilter filter = new QFilter("id", "in", billIds);
        filter.and(this.upmnumcol, "is not null", null);
        filter.and(this.upmnumcol, "!=", (Object)"");
        QFilter cfgFilter = MasterfileBillConfigHelper.parseBillFilter(this.cfg.getString("billfilter"), this.billtype);
        if (cfgFilter != null) {
            filter.and(cfgFilter);
        }
        return filter;
    }

    private String buildBillSelectProps() {
        StringBuilder selectPropsBuilder = new StringBuilder("id");
        selectPropsBuilder.append(',').append(this.entrypathId);
        HashSet<String> selectSourceCols = new HashSet<String>(this.mainfMaps.size() + this.trackMaps.size() + 4);
        selectSourceCols.add(this.seqcol);
        selectSourceCols.add(this.upmnumcol);
        if (this.iscreate.booleanValue()) {
            selectSourceCols.add(this.materialmastercol);
            selectSourceCols.add(this.orgcol);
        }
        if (this.mainfMaps.size() > 0) {
            selectSourceCols.addAll(this.mainfMaps.values());
        }
        if (this.trackMaps.size() > 0) {
            selectSourceCols.addAll(this.trackMaps.values());
        }
        selectPropsBuilder.append(',').append(String.join((CharSequence)",", selectSourceCols));
        return selectPropsBuilder.toString();
    }

    public void operateExec() {
        Set hasHandleBillIds = this.hasHandleBillMap.getOrDefault(this.entrytype, new HashSet(this.billIds.size()));
        HashSet<Long> handleBillIds = new HashSet<Long>(this.billIds);
        handleBillIds.removeAll(hasHandleBillIds);
        if (handleBillIds.isEmpty()) {
            return;
        }
        QFilter filter = this.buildBillFilter(handleBillIds);
        String billSelectProps = this.buildBillSelectProps();
        DynamicObjectCollection billentries = QueryServiceHelper.query((String)this.billtype, (String)billSelectProps, (QFilter[])filter.toArray());
        if (billentries != null && billentries.size() > 0) {
            Set<Object> existsNumbers = Collections.emptySet();
            if (this.iscreate.booleanValue()) {
                ArrayList<String> allNumbers = new ArrayList<String>(billentries.size());
                for (DynamicObject billentry : billentries) {
                    String number = billentry.getString(this.upmnumcol);
                    allNumbers.add(number);
                }
                existsNumbers = MasterfileHelper.getExistsNumbers(allNumbers);
            }
            ArrayList<Map<String, Object>> createParams = new ArrayList<Map<String, Object>>(billentries.size());
            ArrayList<Map<String, Object>> updateParams = new ArrayList<Map<String, Object>>(billentries.size());
            for (DynamicObject billentry : billentries) {
                Long billId = billentry.getLong("id");
                Long entryId = billentry.getLong(this.entrypathId);
                hasHandleBillIds.add(billId);
                String number = billentry.getString(this.upmnumcol);
                HashMap<String, Object> param = new HashMap<String, Object>(5);
                param.put("number", number);
                if (!this.mainfMaps.isEmpty() || !this.mainfDefvalMaps.isEmpty()) {
                    HashMap<String, Object> upmMasterAttrs = new HashMap<String, Object>(this.mainfMaps.size() + this.mainfDefvalMaps.size());
                    this.buildParamFromSrcbillMap(upmMasterAttrs, this.mainfMaps, billentry);
                    this.buildParamFromDefvalMap(upmMasterAttrs, this.mainfDefvalMaps);
                    param.put("upm_masterfile", upmMasterAttrs);
                }
                HashMap<String, Object> upmTrackAttrs = new HashMap<String, Object>(5 + this.trackMaps.size() + this.trackDefvalMaps.size());
                upmTrackAttrs.put("billtype", this.billtype);
                upmTrackAttrs.put("billid", billId);
                upmTrackAttrs.put("billentrytype", this.entrytype);
                upmTrackAttrs.put("billentryid", entryId);
                upmTrackAttrs.put("operate", this.operate);
                this.buildParamFromSrcbillMap(upmTrackAttrs, this.trackMaps, billentry);
                this.buildParamFromDefvalMap(upmTrackAttrs, this.trackDefvalMaps);
                param.put("upm_movetrack", upmTrackAttrs);
                if (!existsNumbers.contains(number) && this.iscreate.booleanValue()) {
                    Long material = billentry.getLong(this.materialmastercol);
                    Long org = billentry.getLong(this.orgcol);
                    param.put("material", material);
                    param.put("org", org);
                    createParams.add(param);
                    continue;
                }
                updateParams.add(param);
            }
            if (!createParams.isEmpty()) {
                MasterfileHelper.handleAction("upm_masterfile", this.actionId, createParams, true, false);
            }
            if (!updateParams.isEmpty()) {
                MasterfileHelper.handleAction("upm_masterfile", this.actionId, updateParams, false, false);
            }
            if (!this.hasHandleBillMap.containsKey(this.entrytype)) {
                this.hasHandleBillMap.put(this.entrytype, hasHandleBillIds);
            }
        }
    }

    private void buildParamFromSrcbillMap(Map<String, Object> paramAttrs, Map<String, String> cfgMap, DynamicObject billentry) {
        for (Map.Entry<String, String> cfgEntry : cfgMap.entrySet()) {
            String targetCol = cfgEntry.getKey();
            String sourceCol = cfgEntry.getValue();
            paramAttrs.put(targetCol, billentry.get(sourceCol));
        }
    }

    private void buildParamFromDefvalMap(Map<String, Object> paramAttrs, Map<String, String> cfgMap) {
        for (Map.Entry<String, String> cfgEntry : cfgMap.entrySet()) {
            String targetCol = cfgEntry.getKey();
            String defval = cfgEntry.getValue();
            if (StringUtils.isBlank((CharSequence)defval)) {
                defval = null;
            }
            paramAttrs.put(targetCol, defval);
        }
    }
}

