/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.upm.business.masterfile;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.upm.business.MasterfileBillConfigHelper;
import kd.scmc.upm.business.masterfile.MasterfileHelper;
import kd.scmc.upm.business.masterfile.ValidateInfoLogger;

public class MasterfileBillValidator {
    private boolean dynamicObjectMode = false;
    private DynamicObject cfg;
    private List<Long> billIds;
    private Map<String, Set<Long>> hasHandleBillMap;
    private DynamicObject billObj;
    private ValidateInfoLogger validateInfo;
    private Long actionId;
    private String billtype;
    private MainEntityType mainEntityType;
    private String entrytype;
    private String entrypath;
    private String entrypathId;
    private Boolean iscreate;
    private String seqcol;
    private String upmnumcol;
    private String materialcol;
    private String materialmastercol;
    private String orgcol;

    public static MasterfileBillValidator build(DynamicObject cfg, List<Long> billIds, Map<String, Set<Long>> hasHandleBillMap, ValidateInfoLogger validateInfo) {
        return new MasterfileBillValidator(cfg, billIds, hasHandleBillMap, validateInfo);
    }

    public static MasterfileBillValidator buildBySingleDynamicObject(DynamicObject cfg, DynamicObject billObj, Map<String, Set<Long>> hasHandleBillMap, ValidateInfoLogger validateInfo) {
        return new MasterfileBillValidator(cfg, billObj, hasHandleBillMap, validateInfo);
    }

    private MasterfileBillValidator(DynamicObject cfg, List<Long> billIds, Map<String, Set<Long>> hasHandleBillMap, ValidateInfoLogger validateInfo) {
        this.cfg = cfg;
        this.billIds = billIds;
        this.hasHandleBillMap = hasHandleBillMap;
        this.validateInfo = validateInfo;
        this.initValidator();
    }

    private MasterfileBillValidator(DynamicObject cfg, DynamicObject billObj, Map<String, Set<Long>> hasHandleBillMap, ValidateInfoLogger validateInfo) {
        this.cfg = cfg;
        this.billIds = Collections.singletonList((Long)billObj.getPkValue());
        this.hasHandleBillMap = hasHandleBillMap;
        this.validateInfo = validateInfo;
        this.dynamicObjectMode = true;
        this.billObj = billObj;
        this.initValidator();
    }

    private void initValidator() {
        this.actionId = this.cfg.getDynamicObject("action").getLong("id");
        this.iscreate = this.cfg.getBoolean("iscreate");
        this.billtype = this.cfg.getDynamicObject("srcbillobj").getString("number");
        this.mainEntityType = EntityMetadataCache.getDataEntityType((String)this.billtype);
        this.entrytype = this.cfg.getString("srcbillentry");
        this.entrypath = MasterfileBillConfigHelper.getEntryPath(this.mainEntityType, this.entrytype);
        this.entrypathId = this.entrypath + ".id";
        this.seqcol = this.entrypath + ".seq";
        this.upmnumcol = this.cfg.getString("upmnumberfield");
        this.materialcol = MasterfileBillConfigHelper.getMaterialCol(this.cfg);
        if (this.materialcol != null) {
            this.materialmastercol = this.materialcol + ".masterid";
        }
        this.orgcol = MasterfileBillConfigHelper.getOrgCol(this.cfg);
    }

    public void validateExec() {
        Set hasHandleBillIds = this.hasHandleBillMap.getOrDefault(this.entrytype, new HashSet(this.billIds.size()));
        HashSet<Long> handleBillIds = new HashSet<Long>(this.billIds);
        handleBillIds.removeAll(hasHandleBillIds);
        if (handleBillIds.isEmpty()) {
            return;
        }
        String billSelectProps = this.buildBillSelectProps();
        DynamicObjectCollection billentries = null;
        if (this.dynamicObjectMode) {
            billentries = this.buildBillentriesFromSingleDynamicObj(billSelectProps);
        } else {
            QFilter filter = this.buildBillFilter(handleBillIds);
            billentries = QueryServiceHelper.query((String)this.billtype, (String)billSelectProps, (QFilter[])filter.toArray());
        }
        HashMap<String, DynamicObject> billentriesMap = new HashMap<String, DynamicObject>(billentries.size());
        if (billentries != null && billentries.size() > 0) {
            for (DynamicObject billentry : billentries) {
                Long org;
                Long material;
                boolean validerr = false;
                Long billId = billentry.getLong("id");
                String upmnum = billentry.getString(this.upmnumcol);
                if (billentriesMap.containsKey(upmnum)) {
                    this.validateInfo.putBillEntryInfo(billId, this.entrytype, billentry.getInt(this.seqcol), String.format(ResManager.loadKDString((String)"\u4e3b\u6863\u7f16\u7801%s\u91cd\u590d\u3002", (String)"MasterfileBillValidator_0", (String)"scmc-upm-form", (Object[])new Object[0]), upmnum));
                    validerr = true;
                }
                if (this.materialcol != null && ((material = Long.valueOf(billentry.getLong(this.materialmastercol))) == null || material.equals(0L))) {
                    this.validateInfo.putBillEntryInfo(billId, this.entrytype, billentry.getInt(this.seqcol), ResManager.loadKDString((String)"\u5355\u636e\u914d\u7f6e\u4e2d\u5bf9\u5e94\u7684\u7269\u6599\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MasterfileBillValidator_1", (String)"scmc-upm-form", (Object[])new Object[0]));
                    validerr = true;
                }
                if (this.iscreate.booleanValue() && ((org = Long.valueOf(billentry.getLong(this.orgcol))) == null || org.equals(0L))) {
                    this.validateInfo.putBillEntryInfo(billId, this.entrytype, billentry.getInt(this.seqcol), ResManager.loadKDString((String)"\u5355\u636e\u914d\u7f6e\u4e2d\u5bf9\u5e94\u7684\u7ec4\u7ec7\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MasterfileBillValidator_2", (String)"scmc-upm-form", (Object[])new Object[0]));
                    validerr = true;
                }
                if (!validerr) {
                    billentriesMap.put(upmnum, billentry);
                }
                hasHandleBillIds.add(billId);
            }
            if (!this.hasHandleBillMap.containsKey(this.entrytype)) {
                this.hasHandleBillMap.put(this.entrytype, hasHandleBillIds);
            }
        }
        if (billentriesMap.isEmpty()) {
            return;
        }
        EntityType entrytypeObj = (EntityType)this.mainEntityType.getAllEntities().get(this.entrytype);
        if (entrytypeObj != null) {
            String entryName = entrytypeObj.getDisplayName().getLocaleValue();
            this.validateInfo.putEntryDisplayName(this.entrytype, entryName);
        }
        Set<Object> existsNumbers = Collections.emptySet();
        if (this.iscreate.booleanValue()) {
            existsNumbers = MasterfileHelper.getExistsNumbers(new ArrayList<String>(billentriesMap.keySet()));
        }
        ArrayList<Map<String, Object>> createParams = new ArrayList<Map<String, Object>>(billentriesMap.size());
        ArrayList<Map<String, Object>> updateParams = new ArrayList<Map<String, Object>>(billentriesMap.size());
        for (Map.Entry billentryEntry : billentriesMap.entrySet()) {
            String upmnum = (String)billentryEntry.getKey();
            DynamicObject billentry = (DynamicObject)billentryEntry.getValue();
            HashMap<String, Object> param = new HashMap<String, Object>(3);
            param.put("number", upmnum);
            if (this.materialcol != null) {
                Long material = billentry.getLong(this.materialmastercol);
                param.put("material", material);
            }
            if (!existsNumbers.contains(upmnum) && this.iscreate.booleanValue()) {
                Long org = billentry.getLong(this.orgcol);
                param.put("org", org);
                createParams.add(param);
                continue;
            }
            updateParams.add(param);
        }
        if (!createParams.isEmpty()) {
            this.callValidService(createParams, true, billentriesMap);
        }
        if (!updateParams.isEmpty()) {
            this.callValidService(updateParams, false, billentriesMap);
        }
    }

    private String buildBillSelectProps() {
        StringBuilder selectPropsBuilder = new StringBuilder("id");
        selectPropsBuilder.append(',').append(this.entrypathId).append(',').append(this.seqcol).append(',').append(this.upmnumcol);
        if (this.materialcol != null) {
            selectPropsBuilder.append(',').append(this.materialmastercol);
        }
        if (this.iscreate.booleanValue()) {
            selectPropsBuilder.append(',').append(this.orgcol);
        }
        return selectPropsBuilder.toString();
    }

    private QFilter buildBillFilter(Set<Long> billIds) {
        QFilter filter = new QFilter("id", "in", billIds);
        filter.and(this.upmnumcol, "is not null", null);
        filter.and(this.upmnumcol, "!=", (Object)"");
        QFilter cfgFilter = MasterfileBillConfigHelper.parseBillFilter(this.cfg.getString("billfilter"), this.billtype);
        if (cfgFilter != null) {
            filter.and(cfgFilter);
        }
        return filter;
    }

    private DynamicObjectCollection buildBillentriesFromSingleDynamicObj(String billSelectProps) {
        DynamicObjectCollection billentries = QueryServiceHelper.query((String)this.billtype, (String)billSelectProps, (QFilter[])new QFilter("id", "=", (Object)-1).toArray());
        String[] entrypathNodes = this.entrypath.split("\\.");
        if (entrypathNodes.length == 1) {
            for (DynamicObject entryObj : this.billObj.getDynamicObjectCollection(this.entrytype)) {
                this.fillDynamicValToBillentries(billentries, this.billObj, entryObj, null);
            }
        } else {
            for (DynamicObject entryObj : this.billObj.getDynamicObjectCollection(entrypathNodes[0])) {
                for (DynamicObject subentryObj : entryObj.getDynamicObjectCollection(entrypathNodes[1])) {
                    this.fillDynamicValToBillentries(billentries, this.billObj, entryObj, subentryObj);
                }
            }
        }
        return billentries;
    }

    private void fillDynamicValToBillentries(DynamicObjectCollection billentries, DynamicObject billObj, DynamicObject entryObj, DynamicObject subentryObj) {
        String upmnum;
        Object upmnumObj = MasterfileBillValidator.getDynamicVal(billObj, entryObj, subentryObj, this.upmnumcol, true);
        if (upmnumObj != null && StringUtils.isNotBlank((CharSequence)(upmnum = (String)upmnumObj))) {
            DynamicObject billentry = billentries.addNew();
            billentry.set("id", billObj.get("id"));
            billentry.set(this.entrypathId, MasterfileBillValidator.getDynamicVal(billObj, entryObj, subentryObj, this.entrypathId, true));
            billentry.set(this.seqcol, MasterfileBillValidator.getDynamicVal(billObj, entryObj, subentryObj, this.seqcol, true));
            billentry.set(this.upmnumcol, MasterfileBillValidator.getDynamicVal(billObj, entryObj, subentryObj, this.upmnumcol, true));
            if (this.materialcol != null) {
                Object materialObj = MasterfileBillValidator.getDynamicVal(billObj, entryObj, subentryObj, this.materialcol, false);
                if (materialObj != null) {
                    DynamicObject material = (DynamicObject)materialObj;
                    billentry.set(this.materialmastercol, (Object)material.getDynamicObject("masterid").getLong("id"));
                } else {
                    billentry.set(this.materialmastercol, (Object)0L);
                }
            }
            if (this.iscreate.booleanValue()) {
                billentry.set(this.orgcol, MasterfileBillValidator.getDynamicVal(billObj, entryObj, subentryObj, this.orgcol, true));
            }
        }
    }

    private static Object getDynamicVal(DynamicObject billObj, DynamicObject entryObj, DynamicObject subentryObj, String attrpath, boolean getDynamicObjectId) {
        String[] attrpathNodes = attrpath.split("\\.");
        Object dynamicVal = null;
        switch (attrpathNodes.length) {
            case 1: {
                dynamicVal = billObj.get(attrpathNodes[0]);
                break;
            }
            case 2: {
                dynamicVal = entryObj.get(attrpathNodes[1]);
                break;
            }
            case 3: {
                dynamicVal = subentryObj.get(attrpathNodes[2]);
                break;
            }
            default: {
                dynamicVal = null;
            }
        }
        if (dynamicVal == null) {
            return null;
        }
        if (dynamicVal instanceof DynamicObject && getDynamicObjectId) {
            return ((DynamicObject)dynamicVal).getLong("id");
        }
        return dynamicVal;
    }

    private void callValidService(List<Map<String, Object>> params, boolean createflag, Map<String, DynamicObject> billentriesMap) {
        Map<String, Object> validResult = MasterfileHelper.handleAction("upm_masterfile", this.actionId, params, createflag, true);
        String validFlag = (String)validResult.get("success");
        if ("N".equals(validFlag)) {
            Map allErrMsgs = (Map)validResult.get("errmsg");
            for (Map.Entry errMsgEntry : allErrMsgs.entrySet()) {
                String upmnum = (String)errMsgEntry.getKey();
                String errMsg = (String)errMsgEntry.getValue();
                DynamicObject billentry = billentriesMap.get(upmnum);
                this.validateInfo.putBillEntryInfo(billentry.getLong("id"), this.entrytype, billentry.getInt(this.seqcol), errMsg);
            }
        }
    }
}

