/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.upm.business.masterfile;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.scmc.upm.business.masterfile.MasterfileAbstractHandler;
import kd.scmc.upm.business.masterfile.MasterfileHelper;
import kd.scmc.upm.common.consts.UpmMasterActionServiceConst;

public class MasterfileCreator
extends MasterfileAbstractHandler {
    private Set<String> existsNumbers;
    private Map<Object, DynamicObject> materialsPieces;
    private Map<String, Long> materialRels;

    MasterfileCreator(Long actionId, List<Map<String, Object>> masterfileOpes) {
        super(actionId, masterfileOpes);
    }

    MasterfileCreator(Long actionId, List<Map<String, Object>> masterfileOpes, boolean validMode) {
        super(actionId, masterfileOpes, validMode);
    }

    @Override
    public Map<String, Object> handle() {
        this.prepareHeadData();
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        HashMap<String, String> allErrMsgs = new HashMap<String, String>(this.size);
        ArrayList<DynamicObject> masterFileDyns = new ArrayList<DynamicObject>(this.size);
        long[] masterIds = new long[]{};
        ArrayList<DynamicObject> trackDyns = new ArrayList<DynamicObject>(this.size);
        long[] trackIds = new long[]{};
        if (!this.validMode) {
            masterIds = DB.genLongIds((String)"t_upm_masterfile", (int)this.size);
            trackIds = DB.genLongIds((String)"t_upm_movetrack", (int)this.size);
        }
        for (int i = 0; i < this.size; ++i) {
            Map masterfileOpe = (Map)this.masterfileOpes.get(i);
            String number = (String)masterfileOpe.get("number");
            Long materialId = (Long)masterfileOpe.get("material");
            Long orgId = (Long)masterfileOpe.get("org");
            StringBuilder materialRelKeyBuilder = new StringBuilder();
            materialRelKeyBuilder.append(materialId).append('.').append(orgId);
            String materialRelKey = materialRelKeyBuilder.toString();
            Long relationId = this.materialRels.getOrDefault(materialRelKey, 0L);
            HashMap<String, Long> newstatusMap = new HashMap<String, Long>(this.masterstatusProps.size());
            HashMap<String, Object> relattrMap = new HashMap<String, Object>(2);
            this.getEntryRelattrs(number, relationId, newstatusMap, relattrMap);
            String errMsg = this.validEntry(number, materialId, relationId, newstatusMap);
            if (!StringUtils.isBlank((String)errMsg)) {
                allErrMsgs.put(number, errMsg);
                if (this.validMode) continue;
                throw new KDBizException(errMsg);
            }
            if (this.validMode) continue;
            long masterId = masterIds[i];
            long trackId = trackIds[i];
            DynamicObject masterFileDyn = this.buildMasterFileDyn(masterId, trackId, relationId, masterfileOpe, newstatusMap, relattrMap);
            masterFileDyns.add(masterFileDyn);
            DynamicObject trackDyn = this.buildTrackDyn(masterId, trackId, masterfileOpe, newstatusMap, relattrMap);
            trackDyns.add(trackDyn);
        }
        if (allErrMsgs.isEmpty()) {
            if (!this.validMode) {
                SaveServiceHelper.save((DynamicObject[])masterFileDyns.toArray(new DynamicObject[0]));
                SaveServiceHelper.save((DynamicObject[])trackDyns.toArray(new DynamicObject[0]));
            }
            result.put("success", "Y");
        } else {
            result.put("success", "N");
        }
        result.put("errmsg", allErrMsgs);
        return result;
    }

    private void prepareHeadData() {
        ArrayList<String> numbers = new ArrayList<String>(this.size);
        ArrayList<Long> materialIds = new ArrayList<Long>(this.size);
        ArrayList<Long> orgIds = new ArrayList<Long>(this.size);
        for (Map masterfileOpe : this.masterfileOpes) {
            String number = (String)masterfileOpe.get("number");
            Long materialId = (Long)masterfileOpe.get("material");
            Long orgId = (Long)masterfileOpe.get("org");
            numbers.add(number);
            materialIds.add(materialId);
            orgIds.add(orgId);
        }
        this.existsNumbers = MasterfileHelper.getExistsNumbers(numbers);
        this.materialsPieces = BusinessDataServiceHelper.loadFromCache((String)"bd_material", (QFilter[])new QFilter("id", "in", materialIds).and("piecemanage", "=", (Object)Boolean.TRUE).toArray());
        this.materialRels = new HashMap<String, Long>(this.size);
        try (DataSet materialRelsDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"upm_materialrelation", (String)"material,org,masterrelation", (QFilter[])new QFilter("material", "in", materialIds).and("org", "in", orgIds).and("enable", "=", (Object)Boolean.TRUE).toArray(), (String)"");){
            for (Row row : materialRelsDataSet) {
                StringBuilder materialRelKeyBuilder = new StringBuilder();
                materialRelKeyBuilder.append(row.getLong("material")).append('.').append(row.getLong("org"));
                this.materialRels.put(materialRelKeyBuilder.toString(), row.getLong("masterrelation"));
            }
        }
    }

    private void getEntryRelattrs(String number, Long relationId, Map<String, Long> newstatusMap, Map<String, Object> otherattrMap) {
        if (relationId.equals(0L)) {
            return;
        }
        for (String statusfield : this.masterstatusProps) {
            Long oldstatus = this.getDefaultStatus(number, statusfield);
            this.putEntryRelattrMap(relationId, statusfield, oldstatus, newstatusMap, otherattrMap);
        }
    }

    private String validEntry(String number, Long materialId, Long relationId, Map<String, Long> newstatusMap) {
        StringBuilder errMsgBuilder = new StringBuilder();
        if (this.existsNumbers.contains(number)) {
            errMsgBuilder.append(String.format(ResManager.loadKDString((String)"\u4e3b\u6863\u7f16\u7801%s\u5df2\u7ecf\u5b58\u5728\u3002", (String)"MasterfileCreator_0", (String)"scmc-upm-form", (Object[])new Object[0]), number));
        }
        if (!this.materialsPieces.containsKey(materialId)) {
            errMsgBuilder.append(ResManager.loadKDString((String)"\u7269\u6599\u672a\u542f\u7528\u5355\u4ef6\u7ba1\u7406\u3002", (String)"MasterfileCreator_1", (String)"scmc-upm-form", (Object[])new Object[0]));
        }
        if (relationId.equals(0L)) {
            errMsgBuilder.append(ResManager.loadKDString((String)"\u7269\u6599\u672a\u5173\u8054\u52a8\u4f5c\u72b6\u6001\u77e9\u9635\u3002", (String)"MasterfileCreator_2", (String)"scmc-upm-form", (Object[])new Object[0]));
        } else if (newstatusMap.isEmpty()) {
            errMsgBuilder.append(String.format(ResManager.loadKDString((String)"%s\u672a\u914d\u7f6e\u521d\u59cb\u72b6\u6001\u548c\u52a8\u4f5c\u5bf9\u5e94\u7684\u77e9\u9635\u5173\u7cfb\u3002", (String)"MasterfileCreator_3", (String)"scmc-upm-form", (Object[])new Object[0]), number));
        }
        return errMsgBuilder.toString();
    }

    private DynamicObject buildMasterFileDyn(Long masterId, Long trackId, Long relationId, Map<String, Object> masterfileOpe, Map<String, Long> newstatusMap, Map<String, Object> relattrMap) {
        String number = (String)masterfileOpe.get("number");
        Long materialId = (Long)masterfileOpe.get("material");
        Long orgId = (Long)masterfileOpe.get("org");
        DynamicObject masterFileDyn = BusinessDataServiceHelper.newDynamicObject((String)"upm_masterfile");
        masterFileDyn.set("id", (Object)masterId);
        masterFileDyn.set("masterid", (Object)masterId);
        masterFileDyn.set("number", (Object)number);
        masterFileDyn.set("masterfiletype", (Object)1401417099242528768L);
        masterFileDyn.set("material", (Object)materialId);
        masterFileDyn.set("org", (Object)orgId);
        masterFileDyn.set("masterrelation", (Object)relationId);
        masterFileDyn.set("finaltrack", (Object)trackId);
        masterFileDyn.set("status", (Object)"C");
        masterFileDyn.set("enable", (Object)"1");
        masterFileDyn.set("creator", (Object)RequestContext.get().getCurrUserId());
        Date now = new Date();
        masterFileDyn.set("mainstatusdate", (Object)now);
        masterFileDyn.set("secondstatusdate", (Object)now);
        for (String string : this.masterstatusProps) {
            Long newstatus = newstatusMap.getOrDefault(string, this.getDefaultStatus(number, string));
            masterFileDyn.set(string, (Object)newstatus);
        }
        for (Map.Entry entry : relattrMap.entrySet()) {
            String relattr = (String)entry.getKey();
            Object relval = entry.getValue();
            masterFileDyn.set(relattr, relval);
        }
        Map masterfileParamMap = masterfileOpe.getOrDefault("upm_masterfile", Collections.emptyMap());
        for (Map.Entry masterfileParam : masterfileParamMap.entrySet()) {
            String paramKey = (String)masterfileParam.getKey();
            if (this.masterstatusProps.contains(paramKey) || UpmMasterActionServiceConst.MASTERFILE_FIXFIELD.contains(paramKey) || !this.masterProps.containsKey((Object)paramKey)) continue;
            Object paramValue = masterfileParam.getValue();
            masterFileDyn.set(paramKey, paramValue);
        }
        return masterFileDyn;
    }
}

