/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.upm.business.masterfile;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.property.BasedataProp;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.scmc.upm.business.MasterfileBillConfigHelper;
import kd.scmc.upm.business.masterfile.MasterfileBillOperator;
import kd.scmc.upm.business.masterfile.MasterfileBillValidator;
import kd.scmc.upm.business.masterfile.MasterfileCreator;
import kd.scmc.upm.business.masterfile.MasterfileUpdater;
import kd.scmc.upm.business.masterfile.ValidateInfoLogger;

public class MasterfileHelper {
    protected static final Log logger = LogFactory.getLog(MasterfileHelper.class);

    public static Set<String> getMasterstatusProps(IDataEntityType masterEntityType) {
        HashSet<String> masterstatusProps = new HashSet<String>(8);
        for (IDataEntityProperty pro : masterEntityType.getProperties()) {
            String entityId;
            if (!(pro instanceof BasedataProp) || !"upm_masterstatus".equals(entityId = ((BasedataProp)pro).getBaseEntityId())) continue;
            masterstatusProps.add(pro.getName());
        }
        return masterstatusProps;
    }

    public static Map<String, Object> handleAction(String masterfileEntity, Long actionId, List<Map<String, Object>> masterfileOpes, boolean isCreate, boolean onlyValid) {
        MasterfileHelper.checkActionParams(masterfileEntity, actionId, masterfileOpes, isCreate);
        logger.info("MasterfileHelper.handleAction(actionId):" + actionId + "(isCreate):" + isCreate + "(onlyValid):" + onlyValid + "(masterfileOpes):" + masterfileOpes);
        Map<String, Object> result = isCreate ? new MasterfileCreator(actionId, masterfileOpes, onlyValid).handle() : new MasterfileUpdater(actionId, masterfileOpes, onlyValid).handle();
        return result;
    }

    private static void checkActionParams(String masterfileEntity, Long actionId, List<Map<String, Object>> masterfileOpes, boolean isCreate) {
        if (StringUtils.isBlank((String)masterfileEntity) || actionId == null || actionId.equals(0L) || masterfileOpes == null || masterfileOpes.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8c03\u7528\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MasterfileHelper_0", (String)"scmc-upm-form", (Object[])new Object[0]));
        }
        HashSet<String> numbers = new HashSet<String>(masterfileOpes.size());
        for (Map<String, Object> masterfileOpe : masterfileOpes) {
            String number;
            if (masterfileOpe == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8c03\u7528\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MasterfileHelper_0", (String)"scmc-upm-form", (Object[])new Object[0]));
            }
            MasterfileHelper.validEmptyParam(masterfileOpe, "number", String.class);
            if (isCreate) {
                MasterfileHelper.validEmptyParam(masterfileOpe, "material", Long.class);
                MasterfileHelper.validEmptyParam(masterfileOpe, "org", Long.class);
            }
            if (numbers.contains(number = (String)masterfileOpe.get("number"))) {
                throw new KDBizException(ResManager.loadKDString((String)"masterfileOpes\u53c2\u6570\u5404\u6761\u76ee\u7684number\u9879\u503c\u5b58\u5728\u91cd\u590d\u3002", (String)"MasterfileHelper_3", (String)"scmc-upm-form", (Object[])new Object[0]));
            }
            numbers.add(number);
        }
    }

    private static void validEmptyParam(Map<String, Object> masterfileOpe, String field, Class<?> paramClass) {
        String value;
        if (!masterfileOpe.containsKey(field)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"masterfileOpes\u53c2\u6570\u5404\u6761\u76ee\u7684key\u4e2d\u5fc5\u987b\u5305\u542b%s\u3002", (String)"MasterfileHelper_1", (String)"scmc-upm-form", (Object[])new Object[0]), field));
        }
        if (String.class == paramClass ? StringUtils.isBlank((String)(value = (String)masterfileOpe.get(field))) : Long.class == paramClass && (value = (Long)masterfileOpe.get(field)).equals(0L)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"masterfileOpes\u53c2\u6570\u5404\u6761\u76ee\u7684%s\u9879\u503c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MasterfileHelper_2", (String)"scmc-upm-form", (Object[])new Object[0]), field));
        }
    }

    public static void handleByBillOperate(String formid, String operate, List<Long> billIds) {
        MasterfileHelper.checkOperateParams(formid, operate, billIds);
        Collection<DynamicObject> cfgs = MasterfileBillConfigHelper.getBillConfig(formid, operate);
        HashMap<String, Set<Long>> hasHandleBillMap = new HashMap<String, Set<Long>>(2);
        for (DynamicObject cfg : cfgs) {
            new MasterfileBillOperator(cfg, operate, billIds, hasHandleBillMap).operateExec();
        }
    }

    public static Map<Long, List<String>> validByBillOperate(String formid, String operate, List<Long> billIds) {
        MasterfileHelper.checkOperateParams(formid, operate, billIds);
        ValidateInfoLogger validateInfo = new ValidateInfoLogger();
        Collection<DynamicObject> cfgs = MasterfileBillConfigHelper.getBillConfig(formid, operate);
        boolean cfgRepeat = false;
        Map<String, Set<String>> billCfgsMap = MasterfileBillConfigHelper.getBillCfgsMatchMap(formid, cfgs, billIds);
        for (Map.Entry<String, Set<String>> billCfgsEntry : billCfgsMap.entrySet()) {
            Set<String> cfgSet = billCfgsEntry.getValue();
            if (cfgSet.size() <= 1) continue;
            cfgRepeat = true;
            String ident = billCfgsEntry.getKey();
            String[] identArray = ident.split("\\.");
            String entrykey = identArray[0];
            Long billid = Long.valueOf(identArray[1]);
            validateInfo.putBillEntryInfo(billid, entrykey, 0, String.format(ResManager.loadKDString((String)"\u540c\u65f6\u5339\u914d\u4e86\u591a\u4e2a\u914d\u7f6e\u89c4\u5219:%s\u3002", (String)"MasterfileHelper_4", (String)"scmc-upm-form", (Object[])new Object[0]), cfgSet.toString()));
        }
        if (cfgRepeat) {
            return validateInfo.getValidateInfo();
        }
        HashMap<String, Set<Long>> hasHandleBillMap = new HashMap<String, Set<Long>>(2);
        for (DynamicObject cfg : cfgs) {
            MasterfileBillValidator.build(cfg, billIds, hasHandleBillMap, validateInfo).validateExec();
        }
        return validateInfo.getValidateInfo();
    }

    public static Map<Long, List<String>> validSingleByBillOperate(String formid, String operate, DynamicObject billObj) {
        Long billid = (Long)billObj.getPkValue();
        ValidateInfoLogger validateInfo = new ValidateInfoLogger();
        Collection<DynamicObject> cfgs = MasterfileBillConfigHelper.getBillConfig(formid, operate);
        boolean cfgRepeat = false;
        HashMap<String, Set> billCfgsMap = new HashMap<String, Set>(2);
        HashSet<DynamicObject> matchCfgs = new HashSet<DynamicObject>(cfgs.size());
        for (DynamicObject dynamicObject : cfgs) {
            if (!MasterfileBillConfigHelper.isDynamicObjectMatchCfg(formid, billObj, dynamicObject)) continue;
            String entrykey = dynamicObject.getString("srcbillentry");
            Set cfgSet = billCfgsMap.getOrDefault(entrykey, new HashSet(3));
            cfgSet.add(dynamicObject.getString("number"));
            if (!billCfgsMap.containsKey(entrykey)) {
                billCfgsMap.put(entrykey, cfgSet);
            }
            matchCfgs.add(dynamicObject);
        }
        for (Map.Entry entry : billCfgsMap.entrySet()) {
            Set cfgSet = (Set)entry.getValue();
            if (cfgSet.size() <= 1) continue;
            cfgRepeat = true;
            String entrykey = (String)entry.getKey();
            validateInfo.putBillEntryInfo(billid, entrykey, 0, String.format(ResManager.loadKDString((String)"\u540c\u65f6\u5339\u914d\u4e86\u591a\u4e2a\u914d\u7f6e\u89c4\u5219:%s\u3002", (String)"MasterfileHelper_4", (String)"scmc-upm-form", (Object[])new Object[0]), cfgSet.toString()));
        }
        if (cfgRepeat) {
            return validateInfo.getValidateInfo();
        }
        HashMap<String, Set<Long>> hasHandleBillMap = new HashMap<String, Set<Long>>(2);
        for (DynamicObject cfg : matchCfgs) {
            MasterfileBillValidator.buildBySingleDynamicObject(cfg, billObj, hasHandleBillMap, validateInfo).validateExec();
        }
        return validateInfo.getValidateInfo();
    }

    private static void checkOperateParams(String formid, String operate, List<Long> billIds) {
        if (formid == null || formid.isEmpty() || billIds == null || billIds.isEmpty() || operate == null || operate.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8c03\u7528\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MasterfileHelper_0", (String)"scmc-upm-form", (Object[])new Object[0]));
        }
    }

    public static Set<String> getExistsNumbers(List<String> numbers) {
        HashSet<String> existsNumbers = new HashSet<String>(numbers.size());
        try (DataSet upmMasterDataSet = QueryServiceHelper.queryDataSet((String)MasterfileHelper.class.getName(), (String)"upm_masterfile", (String)"number", (QFilter[])new QFilter("number", "in", numbers).toArray(), (String)"");){
            for (Row row : upmMasterDataSet) {
                existsNumbers.add(row.getString("number"));
            }
        }
        return existsNumbers;
    }
}

