/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.upm.business.masterfile;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.upm.common.consts.UpmMasterActionServiceConst;

public class MasterfileStatusCalor {
    private Map<String, Map<String, Map<String, Object>>> calResultCache = new HashMap<String, Map<String, Map<String, Object>>>();

    public Map<String, Object> calMasterfileStatusWithCache(Long relationid, String statusfield, Long oldstatus, Long action) {
        String firstKey = MasterfileStatusCalor.getFirstKey(relationid, action);
        if (!this.calResultCache.containsKey(firstKey)) {
            this.pushRelationsFromDB(relationid, action);
        }
        Map<String, Map<String, Object>> rels = this.calResultCache.get(firstKey);
        return this.getMasterfileStatusFromRels(rels, statusfield, oldstatus);
    }

    private void pushRelationsFromDB(Long relationid, Long action) {
        String firstKey = MasterfileStatusCalor.getFirstKey(relationid, action);
        HashMap rels = new HashMap();
        try (DataSet relsDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"upm_masterrelation", (String)"entryentity.updstafield as updstafield, entryentity.oldstatus as oldstatus, entryentity.newstatus as newstatus, entryentity.usability as usability, entryentity.location as location", (QFilter[])new QFilter("id", "=", (Object)relationid).and("entryentity.action", "=", (Object)action).and("entryentity.isenable", "=", (Object)true).toArray(), (String)"");){
            for (Row row : relsDataSet) {
                String statusfield = row.getString("updstafield");
                Long oldstatus = row.getLong("oldstatus");
                HashMap<String, Long> result = new HashMap<String, Long>(3);
                result.put("newstatus", row.getLong("newstatus"));
                result.put("usability", row.getLong("usability"));
                result.put("location", row.getLong("location"));
                rels.put(MasterfileStatusCalor.getSecondKey(statusfield, oldstatus), result);
            }
        }
        this.calResultCache.put(firstKey, rels);
    }

    private Map<String, Object> getMasterfileStatusFromRels(Map<String, Map<String, Object>> rels, String statusfield, Long oldstatus) {
        String secondKey = MasterfileStatusCalor.getSecondKey(statusfield, oldstatus);
        Map<String, Object> result = rels.get(secondKey);
        if (result == null) {
            secondKey = MasterfileStatusCalor.getSecondKey(statusfield, UpmMasterActionServiceConst.NULL_STATUSID);
            result = rels.getOrDefault(secondKey, Collections.emptyMap());
        }
        return result;
    }

    public Set<String> getExistsRelFields(Long relationid, Long action, Set<String> statusfields) {
        String firstKey = MasterfileStatusCalor.getFirstKey(relationid, action);
        Map<String, Map<String, Object>> rels = this.calResultCache.get(firstKey);
        HashSet<String> existsRelFields = new HashSet<String>(statusfields.size());
        block0: for (String statusfield : statusfields) {
            for (String secondKey : rels.keySet()) {
                if (!secondKey.startsWith(statusfield + "_")) continue;
                existsRelFields.add(statusfield);
                continue block0;
            }
        }
        return existsRelFields;
    }

    public static Long getNewStatus(Long newstatus, Long oldstatus) {
        if (UpmMasterActionServiceConst.NULL_STATUSID.equals(newstatus)) {
            return oldstatus;
        }
        return newstatus;
    }

    private static String getFirstKey(Long relationid, Long action) {
        return relationid + "_" + action;
    }

    private static String getSecondKey(String statusfield, Long oldstatus) {
        return statusfield + "_" + oldstatus;
    }
}

