/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.upm.business.masterfile;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.scmc.upm.business.masterfile.MasterfileAbstractHandler;
import kd.scmc.upm.common.consts.UpmMasterActionServiceConst;

public class MasterfileUpdater
extends MasterfileAbstractHandler {
    private Map<String, Map<String, Object>> currentMasterAttrs;
    private Map<String, DynamicObject> currentMasterDyns;

    MasterfileUpdater(Long actionId, List<Map<String, Object>> masterfileOpes) {
        super(actionId, masterfileOpes);
    }

    MasterfileUpdater(Long actionId, List<Map<String, Object>> masterfileOpes, boolean validMode) {
        super(actionId, masterfileOpes, validMode);
    }

    @Override
    public Map<String, Object> handle() {
        this.prepareHeadData();
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        HashMap<String, String> allErrMsgs = new HashMap<String, String>(this.size);
        ArrayList<DynamicObject> masterFileDyns = new ArrayList<DynamicObject>(this.size);
        ArrayList<DynamicObject> trackDyns = new ArrayList<DynamicObject>(this.size);
        long[] trackIds = new long[]{};
        if (!this.validMode) {
            trackIds = DB.genLongIds((String)"t_upm_movetrack", (int)this.size);
        }
        for (int i = 0; i < this.size; ++i) {
            Map masterfileOpe = (Map)this.masterfileOpes.get(i);
            String number = (String)masterfileOpe.get("number");
            Map<String, Object> masterAttr = this.currentMasterAttrs.getOrDefault(number, Collections.emptyMap());
            HashMap<String, Long> newstatusMap = new HashMap<String, Long>(this.masterstatusProps.size());
            HashMap<String, Object> relattrMap = new HashMap<String, Object>(2);
            this.getEntryRelattrs(masterAttr, newstatusMap, relattrMap);
            String errMsg = this.validEntry(masterfileOpe, newstatusMap);
            if (!StringUtils.isBlank((String)errMsg)) {
                allErrMsgs.put(number, errMsg);
                if (this.validMode) continue;
                throw new KDBizException(errMsg);
            }
            if (this.validMode) continue;
            long masterId = (Long)masterAttr.get("id");
            long trackId = trackIds[i];
            DynamicObject masterFileDyn = this.currentMasterDyns.get(number);
            this.updateMasterFileDyn(masterFileDyn, trackId, masterfileOpe, newstatusMap, relattrMap);
            masterFileDyns.add(masterFileDyn);
            DynamicObject trackDyn = this.buildTrackDyn(masterId, trackId, masterfileOpe, newstatusMap, relattrMap);
            trackDyns.add(trackDyn);
        }
        if (allErrMsgs.isEmpty()) {
            if (!this.validMode) {
                SaveServiceHelper.save((DynamicObject[])masterFileDyns.toArray(new DynamicObject[0]));
                SaveServiceHelper.save((DynamicObject[])trackDyns.toArray(new DynamicObject[0]));
            }
            result.put("success", "Y");
        } else {
            result.put("success", "N");
        }
        result.put("errmsg", allErrMsgs);
        return result;
    }

    private void prepareHeadData() {
        ArrayList<String> numbers = new ArrayList<String>(this.size);
        for (Object masterfileOpe : this.masterfileOpes) {
            String number = (String)masterfileOpe.get("number");
            numbers.add(number);
        }
        StringBuilder selectPropsBuilder = new StringBuilder("id,number,masterrelation,material");
        for (String statusfield : this.masterstatusProps) {
            selectPropsBuilder.append(',').append(statusfield);
            selectPropsBuilder.append(',').append(statusfield).append('.').append("name");
        }
        String selectProps = selectPropsBuilder.toString();
        this.currentMasterAttrs = new HashMap<String, Map<String, Object>>(this.size);
        ArrayList<Long> ids = new ArrayList<Long>(this.size);
        DynamicObject[] dynamicObjectArray = null;
        try (DataSet upmMasterDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"upm_masterfile", (String)selectProps, (QFilter[])new QFilter("number", "in", numbers).toArray(), (String)"");){
            for (Row row : upmMasterDataSet) {
                Long id = row.getLong("id");
                HashMap<String, Object> masterAttr = new HashMap<String, Object>(3 + this.masterstatusProps.size() * 2);
                masterAttr.put("id", id);
                masterAttr.put("masterrelation", row.getLong("masterrelation"));
                masterAttr.put("material", row.getLong("material"));
                for (String statusfield : this.masterstatusProps) {
                    masterAttr.put(statusfield, row.getLong(statusfield));
                    String statusnamefield = statusfield + '.' + "name";
                    masterAttr.put(statusnamefield, row.getString(statusnamefield));
                }
                this.currentMasterAttrs.put(row.getString("number"), masterAttr);
                ids.add(id);
            }
        }
        catch (Throwable object) {
            dynamicObjectArray = object;
            throw object;
        }
        this.currentMasterDyns = new HashMap<String, DynamicObject>(ids.size());
        if (!ids.isEmpty()) {
            DynamicObject[] masterDynArray;
            for (DynamicObject masterDyn : masterDynArray = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)this.masterEntityType)) {
                String number = masterDyn.getString("number");
                this.currentMasterDyns.put(number, masterDyn);
            }
        }
    }

    private void getEntryRelattrs(Map<String, Object> masterAttr, Map<String, Long> newstatusMap, Map<String, Object> otherattrMap) {
        Long relationId = (Long)masterAttr.getOrDefault("masterrelation", 0L);
        if (relationId.equals(0L)) {
            return;
        }
        for (String statusfield : this.masterstatusProps) {
            Long oldstatus = (Long)masterAttr.get(statusfield);
            this.putEntryRelattrMap(relationId, statusfield, oldstatus, newstatusMap, otherattrMap);
        }
    }

    private String validEntry(Map<String, Object> masterfileOpe, Map<String, Long> newstatusMap) {
        String number = (String)masterfileOpe.get("number");
        StringBuilder errMsgBuilder = new StringBuilder();
        if (!this.currentMasterAttrs.containsKey(number)) {
            errMsgBuilder.append(ResManager.loadKDString((String)"\u5355\u4ef6\u4e3b\u6863\u66f4\u65b0\u5931\u8d25\uff0c\u627e\u4e0d\u5230\u5355\u4ef6\u4e3b\u6863{0}\u3002", (String)"MasterfileUpdater_0", (String)"scmc-upm-form", (Object[])new Object[]{number}));
        } else {
            long curMaterialId;
            long materialId;
            Map<String, Object> masterAttr = this.currentMasterAttrs.get(number);
            String statusdesc = this.buildStatusDesc(masterAttr);
            if (newstatusMap.isEmpty()) {
                errMsgBuilder.append(String.format(ResManager.loadKDString((String)"\u4e3b\u6863\u5f53\u524d\u72b6\u6001\u4e3a%1$s\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\"%2$s\"\u3002", (String)"MasterfileUpdater_1", (String)"scmc-upm-form", (Object[])new Object[0]), statusdesc, this.actionName));
            } else if (newstatusMap.size() < this.masterstatusProps.size()) {
                Long relationId = (Long)masterAttr.getOrDefault("masterrelation", 0L);
                HashSet<String> notRelStatusProps = new HashSet<String>(this.masterstatusProps);
                notRelStatusProps.removeAll(newstatusMap.keySet());
                if (!this.statusCalculator.getExistsRelFields(relationId, this.actionId, notRelStatusProps).isEmpty()) {
                    errMsgBuilder.append(String.format(ResManager.loadKDString((String)"\u4e3b\u6863\u5f53\u524d\u72b6\u6001\u4e3a%1$s\uff0c\u4e0d\u80fd\u6267\u884c\"%2$s\"\uff0c\u8bf7\u68c0\u67e5\u52a8\u4f5c\u77e9\u9635\u7684\u65e7\u72b6\u6001\u914d\u7f6e\u3002", (String)"MasterfileUpdater_3", (String)"scmc-upm-form", (Object[])new Object[0]), statusdesc, this.actionName));
                }
            }
            if (masterfileOpe.containsKey("material") && (materialId = ((Long)masterfileOpe.get("material")).longValue()) != (curMaterialId = ((Long)masterAttr.getOrDefault("material", 0L)).longValue())) {
                errMsgBuilder.append(String.format(ResManager.loadKDString((String)"%s\u5bf9\u5e94\u7269\u6599\u4e0d\u4e00\u81f4\u3002", (String)"MasterfileUpdater_2", (String)"scmc-upm-form", (Object[])new Object[0]), number));
            }
        }
        return errMsgBuilder.toString();
    }

    private String buildStatusDesc(Map<String, Object> masterAttr) {
        StringBuilder statusDescBuilder = new StringBuilder();
        statusDescBuilder.append("(\"").append(masterAttr.get("mainstatus.name")).append("\",\"").append(masterAttr.get("secondarystatus.name")).append("\")");
        return statusDescBuilder.toString();
    }

    private void updateMasterFileDyn(DynamicObject masterFileDyn, Long trackId, Map<String, Object> masterfileOpe, Map<String, Long> newstatusMap, Map<String, Object> relattrMap) {
        masterFileDyn.set("finaltrack", (Object)trackId);
        Date now = new Date();
        for (String string : this.masterstatusProps) {
            Long newstatus = newstatusMap.getOrDefault(string, 0L);
            if (newstatus.equals(0L)) continue;
            masterFileDyn.set(string, (Object)newstatus);
            switch (string) {
                case "mainstatus": {
                    masterFileDyn.set("mainstatusdate", (Object)now);
                    break;
                }
                case "secondarystatus": {
                    masterFileDyn.set("secondstatusdate", (Object)now);
                }
            }
        }
        for (Map.Entry entry : relattrMap.entrySet()) {
            String relattr = (String)entry.getKey();
            Object relval = entry.getValue();
            masterFileDyn.set(relattr, relval);
        }
        Map masterfileParamMap = masterfileOpe.getOrDefault("upm_masterfile", Collections.emptyMap());
        for (Map.Entry masterfileParam : masterfileParamMap.entrySet()) {
            String paramKey = (String)masterfileParam.getKey();
            if (this.masterstatusProps.contains(paramKey) || UpmMasterActionServiceConst.MASTERFILE_FIXFIELD.contains(paramKey) || !this.masterProps.containsKey((Object)paramKey)) continue;
            Object paramValue = masterfileParam.getValue();
            masterFileDyn.set(paramKey, paramValue);
        }
    }

    @Override
    protected Long getDefaultStatus(String number, String statusfield) {
        Map masterAttr = this.currentMasterAttrs.getOrDefault(number, Collections.emptyMap());
        return (Long)masterAttr.get(statusfield);
    }
}

