/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.upm.formplugin;

import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.operate.OperationTypeCache;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.plugin.AbstractFormPlugin;

public class BizOpFormPlugin
extends AbstractFormPlugin {
    private static final String BTNOK = "btnok";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTNOK});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        JSONObject jsonObject = (JSONObject)this.getView().getFormShowParameter().getCustomParam("params");
        String formId = jsonObject.getString("formId");
        List ops = EntityMetadataCache.getDataEntityOperate((String)formId);
        TableValueSetter vs = new TableValueSetter(new String[0]);
        for (Map op : ops) {
            String opType = (String)op.get("type");
            if (!OperationTypeCache.isEntityOperation((String)opType)) continue;
            String opKey = (String)op.get("key");
            vs.addField("op", new Object[]{opKey});
            Map mapLocaleString = (Map)op.get("name");
            String opName = opKey;
            if (mapLocaleString != null) {
                opName = LocaleString.fromMap((Map)mapLocaleString).toString();
            }
            vs.addField("opname", new Object[]{opName});
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.batchCreateNewEntryRow("entryentity", vs);
        this.getView().updateView("entryentity");
    }

    public void click(EventObject e) {
        String key;
        super.click(e);
        switch (key = ((Control)e.getSource()).getKey()) {
            case "btnok": {
                this.handleBtnokEvent();
                break;
            }
        }
    }

    private void handleBtnokEvent() {
        JSONObject result = this.getSelectedRowsInfo();
        if (result.isEmpty()) {
            this.getView().close();
            return;
        }
        this.getView().returnDataToParent((Object)result.toJSONString());
        this.getView().close();
    }

    private JSONObject getSelectedRowsInfo() {
        JSONObject result = new JSONObject();
        EntryGrid grid = (EntryGrid)this.getView().getControl("entryentity");
        IDataModel model = this.getModel();
        int[] selectedRows = grid.getSelectRows();
        if (selectedRows.length == 0) {
            return result;
        }
        result.put("op", model.getValue("op", selectedRows[0]));
        result.put("opname", model.getValue("opname", selectedRows[0]));
        return result;
    }
}

