/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.upm.formplugin;

import java.util.EventObject;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.scmc.upm.common.util.FormUtil;

public class UpmActionBasePlugin
extends AbstractBasePlugIn
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        FormUtil.addF7Listener(this, "bizopservice");
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        int rows = model.getEntryCurrentRowIndex("entryentity");
        for (int i = 0; i < rows; ++i) {
            Boolean isPreset = (Boolean)model.getValue("eispreset", i);
            view.setEnable(Boolean.valueOf(isPreset == false), new String[]{"bizopservice"});
        }
        this.setVisableEntry((Boolean)model.getValue("isworkbenche"));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        switch (key) {
            case "isworkbenche": {
                this.setVisableEntry((Boolean)newValue);
                this.clearEntry();
                break;
            }
        }
    }

    private void clearEntry() {
        this.getModel().deleteEntryData("entryentity");
        this.getModel().createNewEntryRow("entryentity");
    }

    private void setVisableEntry(Boolean isWorkBenche) {
        this.getView().setVisible(isWorkBenche, new String[]{"advconap"});
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        super.beforeDeleteRow(e);
        boolean eIspreset = (Boolean)this.getModel().getValue("eispreset", e.getRowIndexs()[0]);
        if (eIspreset) {
            this.getView().showTipNotification("\u7cfb\u7edf\u9884\u8bbe\u6570\u636e\u4e0d\u5141\u8bb8\u5220\u9664\u3002");
            e.setCancel(true);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String fieldKey;
        switch (fieldKey = e.getProperty().getName()) {
            case "bizopservice": {
                this.beforeBizOpSelect(e);
                break;
            }
        }
    }

    private void beforeBizOpSelect(BeforeF7SelectEvent e) {
        int row = e.getRow();
        IDataModel model = this.getModel();
        int rows = model.getEntryCurrentRowIndex("entryentity");
        boolean isSelect = false;
        for (int i = 0; i < rows; ++i) {
            String actionType;
            DynamicObject bizOp;
            if (i == row || (bizOp = (DynamicObject)model.getValue("bizopservice", i)) == null || !"PUSH".equals(actionType = bizOp.getString("actiontype")) && !"BIZOP".equals(actionType)) continue;
            isSelect = true;
            break;
        }
        if (isSelect) {
            ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
            showParameter.getListFilterParameter().getQFilters().add(new QFilter("actiontype", "=", (Object)"SERVICE"));
        }
    }
}

