/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.upm.formplugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.treebuilder.EntityFieldTreeBuildOption;
import kd.bos.metadata.treebuilder.FormTreeBuilder;
import kd.bos.metadata.treebuilder.PropTreeBuildOption;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.scmc.upm.business.actionform.ActionFormCfgHelper;
import kd.scmc.upm.business.colsassist.SelectParams;
import kd.scmc.upm.common.util.ColsTreeUtil;
import kd.scmc.upm.common.util.FormUtil;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class UpmActionFormCfgEditPlugin
extends AbstractBasePlugIn {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"fieldname", "defaultvalname", "balfieldname"});
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.showControl();
    }

    private void showControl() {
        Object formType = this.getModel().getValue("formtype");
        if ("upm_createbillactionform".equals(formType)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"otherformid"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"mappingcfg", "balfieldname", "showentryap"});
        } else if ("upm_pushactionform".equals(formType)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"otherformid", "mappingcfg"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"balfieldname"});
            boolean isOpenPushPage = false;
            DynamicObject actionDym = (DynamicObject)this.getModel().getValue("masteraction");
            if (actionDym != null) {
                Long actionId = (Long)actionDym.getPkValue();
                isOpenPushPage = ActionFormCfgHelper.isOpenPushPage(actionId);
            }
            this.getView().setVisible(Boolean.valueOf(!isOpenPushPage), new String[]{"showentryap"});
            if (isOpenPushPage) {
                this.getModel().deleteEntryData("showentry");
            }
        } else if ("upm_simpleationform".equals(formType)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"otherformid", "mappingcfg"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"balfieldname", "showentryap"});
        } else if ("other_form".equals(formType)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"otherformid"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"mappingcfg", "balfieldname", "showentryap"});
            this.getModel().deleteEntryData("showentry");
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"mappingcfg", "balfieldname", "otherformid"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"showentryap"});
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "fieldname": {
                int rowIdx = this.getModel().getEntryCurrentRowIndex("showentry");
                this.clickSrcFormField(key, rowIdx);
                break;
            }
            case "defaultvalname": {
                int rowIdx = this.getModel().getEntryCurrentRowIndex("showentry");
                this.clickDefaultValField(key, rowIdx);
                break;
            }
            case "balfieldname": {
                this.clickBalField(key);
            }
        }
    }

    private void clickBalField(String key) {
        String formType = (String)this.getModel().getValue("formtype");
        if ("upm_pushactionform".equals(formType)) {
            String targetEntityType = this.getBotpTargetEntityNumber();
            if (StringUtils.isBlank((CharSequence)targetEntityType)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e3b\u6863\u52a8\u4f5c\u672a\u914d\u7f6e\u76f8\u5173\u7684botp\u89c4\u5219\u3002", (String)"UpmActionFormCfgEditPlugin_0", (String)"scmc-upm-form", (Object[])new Object[0]));
                return;
            }
            this.showColumnSelectForm(targetEntityType, key, (IDataEntityProperty)new TextProp());
        } else if ("upm_simpleationform".equals(formType)) {
            String targetEntityType = this.getSrcEntitType();
            if (StringUtils.isBlank((CharSequence)targetEntityType)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e3b\u6863\u52a8\u4f5c\u672a\u914d\u7f6e\u76f8\u5173\u7684\u8c03\u7528\u4e1a\u52a1\u64cd\u4f5c\u3002", (String)"UpmActionFormCfgEditPlugin_1", (String)"scmc-upm-form", (Object[])new Object[0]));
                return;
            }
            this.showColumnSelectForm(targetEntityType, key, (IDataEntityProperty)new TextProp());
        } else {
            this.showColumnSelectForm("im_inv_realbalance", key, (IDataEntityProperty)new TextProp());
        }
    }

    private String getSrcEntitType() {
        DynamicObject actionDym = (DynamicObject)this.getModel().getValue("masteraction");
        if (null == actionDym) {
            return null;
        }
        DynamicObject action = BusinessDataServiceHelper.loadSingle((Object)actionDym.getPkValue(), (String)"upm_masteraction");
        DynamicObjectCollection rows = action.getDynamicObjectCollection("entryentity");
        for (DynamicObject row : rows) {
            DynamicObject bizOpDym = row.getDynamicObject("bizopservice");
            DynamicObject srcObj = bizOpDym.getDynamicObject("srcobj");
            if (null == srcObj) continue;
            return srcObj.getString("number");
        }
        return null;
    }

    private String getBotpTargetEntityNumber() {
        DynamicObject actionDym = (DynamicObject)this.getModel().getValue("masteraction");
        if (null == actionDym) {
            return null;
        }
        DynamicObject botpDym = ActionFormCfgHelper.getBotpRule((Long)actionDym.getPkValue());
        if (null != botpDym) {
            return (String)botpDym.getDynamicObject("targetentitynumber").getPkValue();
        }
        return null;
    }

    private void clickDefaultValField(String key, int rowIdx) {
        IDataModel model = this.getModel();
        DynamicObject entityTypeDym = (DynamicObject)model.getValue("entitytype", rowIdx);
        String entityType = entityTypeDym.getString("number");
        String fieldKey = (String)model.getValue("fieldkey", rowIdx);
        BillEntityType billEntityType = (BillEntityType)MetadataServiceHelper.getDataEntityType((String)entityType);
        IDataEntityProperty property = billEntityType.findProperty(fieldKey);
        if (property instanceof BasedataProp) {
            ActionFormCfgHelper.showListSelectPage((AbstractFormPlugin)this, ((BasedataProp)property).getBaseEntityId(), "defaultvalname");
        } else if (fieldKey.equals(billEntityType.getBillNo())) {
            ActionFormCfgHelper.showListSelectPage((AbstractFormPlugin)this, entityType, "defaultvalname");
        } else {
            HashMap<String, Object> pageParam = new HashMap<String, Object>(2);
            pageParam.put("entitytype", entityType);
            pageParam.put("fieldkey", fieldKey);
            this.showSimpleActionPage(pageParam, "defaultvalname");
        }
    }

    private void showSimpleActionPage(Map<String, Object> pageParam, String closeBackSymbol) {
        Object masterFile = null;
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("upm_defaulval_form");
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, closeBackSymbol));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.getCustomParams().putAll(pageParam);
        if (masterFile != null) {
            showParameter.setCustomParam("masterfileid", masterFile.getPkValue());
        }
        this.getView().showForm(showParameter);
    }

    private void clickSrcFormField(String key, int rowIdx) {
        DynamicObject row = this.getModel().getEntryRowEntity("showentry", rowIdx);
        String entityType = row.getDynamicObject("entitytype").getString("number");
        this.showColumnSelectForm(entityType, key, null);
    }

    private void showColumnSelectForm(String entityType, String key, IDataEntityProperty property) {
        SelectParams params = new SelectParams();
        MainEntityType type = MetadataServiceHelper.getDataEntityType((String)entityType);
        EntityFieldTreeBuildOption option = new EntityFieldTreeBuildOption();
        option.setIncludeBDPropPK(false);
        option.setIncludeBDRefProp(false);
        option.setMatchedProperty(property);
        option.addInvalidClassTypes(FlexProp.class);
        TreeNode node = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)type, (PropTreeBuildOption)option);
        params.setJsonTree(SerializationUtils.toJsonString((Object)node));
        FormShowParameter fp = FormUtil.readyColsTreePage(params.toMap(), new CloseCallBack((IFormPlugin)this, key));
        this.getView().showForm(fp);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String key;
        super.closedCallBack(evt);
        switch (key = evt.getActionId()) {
            case "fieldname": {
                this.callbackSrcFormField(evt);
                break;
            }
            case "defaultvalname": {
                this.callbackDefaultValName(evt);
                break;
            }
            case "balfieldname": {
                this.callbackBalFieldName(evt);
            }
        }
    }

    private void callbackBalFieldName(ClosedCallBackEvent evt) {
        JSONArray data = ColsTreeUtil.parseReturnData(evt);
        if (data == null || data.isEmpty()) {
            return;
        }
        JSONObject info = data.getJSONObject(0);
        String id = info.getString("id");
        String name = info.getString("text");
        this.getModel().setValue("balfieldkey", (Object)id);
        this.getModel().setValue("balfieldname", (Object)name);
    }

    private void callbackDefaultValName(ClosedCallBackEvent evt) {
        int rowIdx = this.getModel().getEntryCurrentRowIndex("showentry");
        Object returnVal = evt.getReturnData();
        String name = null;
        Object val = null;
        if (ObjectUtils.isEmpty((Object)returnVal)) {
            return;
        }
        if (returnVal instanceof Map) {
            Map returnMap = (Map)returnVal;
            name = MapUtils.getString((Map)returnMap, (Object)"defaultvalname");
            val = MapUtils.getObject((Map)returnMap, (Object)"defaultval");
        } else if (returnVal instanceof ListSelectedRowCollection) {
            ListSelectedRowCollection rows = (ListSelectedRowCollection)returnVal;
            ListSelectedRow row = rows.get(0);
            if (ObjectUtils.isNotEmpty((Object)row.getBillNo())) {
                name = row.getBillNo();
                val = row.getBillNo();
            } else if (ObjectUtils.isNotEmpty((Object)row.getName())) {
                name = row.getName();
                val = row.getPrimaryKeyValue();
            } else {
                name = row.getNumber();
                val = row.getPrimaryKeyValue();
            }
        }
        this.getModel().setValue("defaultvalname", (Object)name, rowIdx);
        this.getModel().setValue("defaultval", val, rowIdx);
    }

    private void callbackSrcFormField(ClosedCallBackEvent evt) {
        int rowIdx = this.getModel().getEntryCurrentRowIndex("showentry");
        JSONArray data = ColsTreeUtil.parseReturnData(evt);
        if (data == null || data.isEmpty()) {
            return;
        }
        JSONObject info = data.getJSONObject(0);
        String id = info.getString("id");
        String name = info.getString("text");
        this.getModel().setValue("fieldkey", (Object)id, rowIdx);
        this.getModel().setValue("fieldname", (Object)name, rowIdx);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        int rowIdx = changeSet[0].getRowIndex();
        Object newValue = changeSet[0].getNewValue();
        Object oldValue = changeSet[0].getOldValue();
        switch (propertyName) {
            case "masteraction": {
                this.changeAction(newValue, oldValue);
                break;
            }
            case "entitytype": {
                this.changeEntityType(newValue, oldValue, rowIdx);
                break;
            }
            case "fieldname": {
                this.changeSrcField(newValue, oldValue, rowIdx);
                break;
            }
            case "defaultvalname": {
                this.changeDefaultValName(newValue, oldValue, rowIdx);
                break;
            }
            case "formtype": {
                this.changeFormType(newValue, oldValue);
                break;
            }
            case "balfieldname": {
                this.changeBalFieldName(newValue, oldValue);
            }
        }
    }

    private void changeAction(Object newValue, Object oldValue) {
        this.getModel().beginInit();
        this.getModel().setValue("mappingcfg", null);
        this.getModel().setValue("balfieldname", null);
        this.getModel().setValue("balfieldkey", null);
        this.getModel().setValue("otherformid", null);
        this.getModel().endInit();
        this.getView().updateView("mappingcfg");
        this.getView().updateView("balfieldname");
        this.getView().updateView("balfieldkey");
        this.getView().updateView("otherformid");
        this.showControl();
    }

    private void changeFormType(Object newValue, Object oldValue) {
        this.getModel().beginInit();
        this.getModel().setValue("mappingcfg", null);
        this.getModel().setValue("balfieldname", null);
        this.getModel().setValue("balfieldkey", null);
        this.getModel().setValue("otherformid", null);
        this.getModel().endInit();
        this.getView().updateView("mappingcfg");
        this.getView().updateView("balfieldname");
        this.getView().updateView("balfieldkey");
        this.getView().updateView("otherformid");
        this.showControl();
    }

    private void changeBalFieldName(Object newValue, Object oldValue) {
        this.getModel().beginInit();
        if (ObjectUtils.isEmpty((Object)newValue)) {
            this.getModel().setValue("balfieldname", null);
            this.getModel().setValue("balfieldkey", null);
        }
        this.getModel().endInit();
        this.getView().updateView("balfieldname");
        this.getView().updateView("balfieldkey");
    }

    private void changeDefaultValName(Object newValue, Object oldValue, int rowIdx) {
        if (ObjectUtils.isEmpty((Object)newValue)) {
            this.getModel().beginInit();
            this.getModel().setValue("defaultvalname", null, rowIdx);
            this.getModel().setValue("defaultval", null, rowIdx);
            this.getModel().endInit();
            this.getView().updateView("showentry", rowIdx);
        }
    }

    private void changeEntityType(Object newValue, Object oldValue, int rowIdx) {
        this.getModel().beginInit();
        this.getModel().setValue("fieldname", null);
        this.getModel().setValue("fieldkey", null);
        this.getModel().setValue("isshow", (Object)true);
        this.getModel().setValue("isedit", (Object)true);
        this.getModel().setValue("ismustinput", (Object)false);
        this.getModel().setValue("defaultval", (Object)"");
        this.getModel().setValue("defaultvalname", (Object)"");
        this.getModel().endInit();
        this.getView().updateView("showentry", rowIdx);
    }

    private void changeSrcField(Object newValue, Object oldValue, int rowIdx) {
        this.getModel().beginInit();
        if (ObjectUtils.isEmpty((Object)newValue)) {
            this.getModel().setValue("fieldkey", null, rowIdx);
        }
        this.getModel().setValue("defaultvalname", null, rowIdx);
        this.getModel().setValue("defaultval", null, rowIdx);
        this.getModel().endInit();
        this.getView().updateView("showentry", rowIdx);
    }
}

