/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.upm.formplugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.operate.OperationTypeCache;
import kd.bos.entity.property.BasedataProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.scmc.upm.business.actionform.ActionFormCfgHelper;
import kd.scmc.upm.business.colsassist.CompositeStrategy;
import kd.scmc.upm.business.colsassist.DefaultSelectStrategy;
import kd.scmc.upm.business.colsassist.EntryNodeStrategy;
import kd.scmc.upm.business.colsassist.EntryStrategy;
import kd.scmc.upm.business.colsassist.FilterStrategy;
import kd.scmc.upm.business.colsassist.IColsSelectStrategy;
import kd.scmc.upm.business.colsassist.MetaHelper;
import kd.scmc.upm.business.colsassist.SelectParams;
import kd.scmc.upm.business.colsassist.SimpleStrategy;
import kd.scmc.upm.business.colsassist.TypeSelectStategy;
import kd.scmc.upm.common.util.ColsTreeUtil;
import kd.scmc.upm.common.util.FormUtil;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.ObjectUtils;

public class UpmBillConfigEditPlugin
extends AbstractBasePlugIn
implements EntryGridBindDataListener {
    private static final String SRCBILLENTRYCB = "srcbillentryCB";
    private static final String UPMNUMBERCB = "upmNumberCB";
    private static final String MAINF_COLCB = "mainfColCB";
    private static final String MAINFSRC_COLCB = "mainfsrcbillColCB";
    private static final String MAINFDEF_COLCB = "mainfdefvalColCB";
    private static final String TRACK_COLCB = "trackColCB";
    private static final String TRACKSRC_COLCB = "tracksrcbillColCB";
    private static final String TRACKDEF_COLCB = "trackdefvalColCB";
    private static final String SRCENTRY_NOTNEED = "*";
    private static final List<String> mainfileFixCols = Arrays.asList("id", "number", "masterfiletype", "masterrelation", "finaltrack", "masterid", "status", "enable", "mainstatusdate", "secondstatusdate", "mainstatus", "secondarystatus", "creator", "createtime", "modifier", "modifytime");
    private static final List<String> movetrackFixCols = Arrays.asList("id", "masterfileid", "action", "billtype", "billid", "billentrytype", "billentryid", "operate", "mainstatus", "secondarystatus", "creator", "createtime");

    public void initialize() {
        EntryGrid trackentry;
        super.initialize();
        EntryGrid mainfentry = (EntryGrid)this.getView().getControl("mainfentry");
        if (mainfentry != null) {
            mainfentry.addDataBindListener((EntryGridBindDataListener)this);
        }
        if ((trackentry = (EntryGrid)this.getView().getControl("trackentry")) != null) {
            trackentry.addDataBindListener((EntryGridBindDataListener)this);
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.setCols4FilterGridAndOpe();
        this.bindBillFilterInfo();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setEnable();
    }

    private void setCols4FilterGridAndOpe() {
        IFormView view = this.getView();
        FilterGrid filterGrid = (FilterGrid)view.getControl("billfiltergrid");
        ComboEdit operate = (ComboEdit)view.getControl("operate");
        MainEntityType entityType = this.getSourceBillMainEntityType();
        if (entityType == null) {
            filterGrid.setFilterColumns(Collections.emptyList());
            operate.setComboItems(Collections.emptyList());
        } else {
            EntityTypeUtil helper = new EntityTypeUtil();
            List cols = helper.getFilterColumns((IDataEntityType)entityType, true);
            filterGrid.setEntityNumber(entityType.getName());
            filterGrid.setFilterColumns(cols);
            List ops = EntityMetadataCache.getDataEntityOperate((String)entityType.getName());
            ArrayList<ComboItem> operationItems = new ArrayList<ComboItem>(10);
            for (Map op : ops) {
                String opType = (String)op.get("type");
                if (!OperationTypeCache.isEntityOperation((String)opType)) continue;
                operationItems.add(new ComboItem(LocaleString.fromMap((Map)((Map)op.get("name"))), (String)op.get("key")));
            }
            operate.setComboItems(operationItems);
        }
        view.updateView("billfiltergrid");
    }

    private void bindBillFilterInfo() {
        String billFilterStr = this.getModel().getDataEntity().getString("billfilter");
        FilterCondition condition = null;
        condition = StringUtils.isBlank((CharSequence)billFilterStr) ? new FilterCondition() : (FilterCondition)SerializationUtils.fromJsonString((String)billFilterStr, FilterCondition.class);
        FilterGrid filterGrid = (FilterGrid)this.getControl("billfiltergrid");
        filterGrid.SetValue(condition);
    }

    private void setSrcEntryEnable(MainEntityType entityType) {
        if (entityType instanceof BillEntityType) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"srcbillentry"});
        } else {
            this.getView().setEnable(Boolean.FALSE, new String[]{"srcbillentry"});
        }
    }

    private MainEntityType getSourceBillMainEntityType() {
        IDataModel model = this.getModel();
        DynamicObject sourceBill = model.getDataEntity().getDynamicObject("srcbillobj");
        if (sourceBill == null) {
            return null;
        }
        String metaDataNo = sourceBill.getString("number");
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)metaDataNo);
        return mainEntityType;
    }

    private void setEnable() {
        Boolean isPreset = this.getModel().getDataEntity().getBoolean("ispreset");
        if (isPreset.booleanValue()) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"conentpanel"});
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{"conentpanel"});
        }
        MainEntityType entityType = this.getSourceBillMainEntityType();
        this.setSrcEntryEnable(entityType);
    }

    public void entryGridBindData(EntryGridBindDataEvent e) {
        String entrykey;
        List entities = e.getRows();
        EntryGrid source = (EntryGrid)e.getSource();
        switch (entrykey = source.getEntryKey()) {
            case "mainfentry": {
                this.setEntryGridEnable(entities, "mainfsrctype", "mainfsrcbillcolno", "mainfdefval");
                break;
            }
            case "trackentry": {
                this.setEntryGridEnable(entities, "tracksrctype", "tracksrcbillcolno", "trackdefval");
            }
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        RowDataEntity[] rows;
        super.afterAddRow(e);
        IFormView view = this.getView();
        String entrykey = e.getEntryProp().getName();
        block8: for (RowDataEntity row : rows = e.getRowDataEntities()) {
            int rowIndex = row.getRowIndex();
            switch (entrykey) {
                case "mainfentry": {
                    view.setEnable(Boolean.valueOf(false), rowIndex, new String[]{"mainfdefval"});
                    continue block8;
                }
                case "trackentry": {
                    view.setEnable(Boolean.valueOf(false), rowIndex, new String[]{"trackdefval"});
                }
            }
        }
    }

    private void setEntryGridEnable(List<RowDataEntity> entities, String srctypeCol, String srcbillCol, String defvalCol) {
        IFormView view = this.getView();
        entities.forEach(entry -> {
            int rowIndex = entry.getRowIndex();
            DynamicObject entryObj = entry.getDataEntity();
            String srctype = entryObj.getString(srctypeCol);
            if ("A".equals(srctype)) {
                view.setEnable(Boolean.valueOf(true), rowIndex, new String[]{srcbillCol});
                view.setEnable(Boolean.valueOf(false), rowIndex, new String[]{defvalCol});
            } else {
                view.setEnable(Boolean.valueOf(false), rowIndex, new String[]{srcbillCol});
                view.setEnable(Boolean.valueOf(true), rowIndex, new String[]{defvalCol});
            }
        });
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"srcbillentry", "upmnumberfield", "mainfcolno", "mainfsrcbillcolno", "mainfdefval", "trackcolno", "tracksrcbillcolno", "trackdefval"});
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "srcbillentry": {
                this.clickSrcBillEntry();
                break;
            }
            case "upmnumberfield": {
                this.clickCtrlCol(key);
                break;
            }
            case "mainfcolno": 
            case "trackcolno": {
                this.clickTargetObjCol(key);
                break;
            }
            case "mainfsrcbillcolno": 
            case "tracksrcbillcolno": {
                this.clickSourceObjCol(key);
                break;
            }
            case "mainfdefval": 
            case "trackdefval": {
                this.clickDefvalCol(key);
            }
        }
    }

    private void clickSrcBillEntry() {
        IDataModel model = this.getModel();
        String sourcebilltype = this.checkSourcebilltype(model);
        if (sourcebilltype == null) {
            return;
        }
        this.showColsTreePage(sourcebilltype, new EntryStrategy(), SRCBILLENTRYCB);
    }

    private void clickCtrlCol(String key) {
        IDataModel model = this.getModel();
        String sourcebilltype = this.checkSourcebilltype(model);
        if (sourcebilltype == null) {
            return;
        }
        MainEntityType sourceEntityType = this.getSourceBillMainEntityType();
        String sourceBillEntry = this.checkSourceBillEntry(model);
        if (sourceBillEntry == null) {
            return;
        }
        MainEntityType billTplEntityType = EntityMetadataCache.getDataEntityType((String)"upm_billconf");
        IDataEntityProperty property = null;
        String colCBName = null;
        switch (key) {
            case "upmnumberfield": {
                property = billTplEntityType.findProperty("number");
                colCBName = UPMNUMBERCB;
            }
        }
        TypeSelectStategy typeSelectStategy = new TypeSelectStategy(property, false);
        DefaultSelectStrategy strategy = null;
        if (sourceEntityType instanceof BillEntityType) {
            EntryNodeStrategy entrynodeStategy = new EntryNodeStrategy(Collections.singletonList(sourceBillEntry), false);
            strategy = new CompositeStrategy(Arrays.asList(typeSelectStategy, entrynodeStategy));
        } else {
            strategy = typeSelectStategy;
        }
        this.showColsTreePage(sourcebilltype, strategy, colCBName);
    }

    private void clickTargetObjCol(String key) {
        String entryName = null;
        String colName = null;
        String colCBName = null;
        String targetObj = null;
        switch (key) {
            case "mainfcolno": {
                entryName = "mainfentry";
                colName = "mainfcol";
                colCBName = MAINF_COLCB;
                targetObj = "upm_masterfile";
                break;
            }
            case "trackcolno": {
                entryName = "trackentry";
                colName = "trackcol";
                colCBName = TRACK_COLCB;
                targetObj = "upm_movetrack";
                break;
            }
            default: {
                return;
            }
        }
        ArrayList<String> existCols = new ArrayList<String>(16);
        DynamicObjectCollection colsMap = this.getModel().getEntryEntity(entryName);
        for (DynamicObject colMap : colsMap) {
            String targetObjCol = colMap.getString(colName);
            if (!StringUtils.isNotEmpty((CharSequence)targetObjCol)) continue;
            existCols.add(targetObjCol);
        }
        if ("upm_masterfile".equals(targetObj)) {
            existCols.add("entryentity");
            existCols.addAll(mainfileFixCols);
        } else if ("upm_movetrack".equals(targetObj)) {
            existCols.addAll(movetrackFixCols);
        }
        this.showColsTreePage(targetObj, new FilterStrategy(existCols, true), colCBName);
    }

    private void clickSourceObjCol(String key) {
        String targetObjtype = null;
        String entryName = null;
        String targetColName = null;
        String srcColCBName = null;
        switch (key) {
            case "mainfsrcbillcolno": {
                targetObjtype = "upm_masterfile";
                entryName = "mainfentry";
                targetColName = "mainfcol";
                srcColCBName = MAINFSRC_COLCB;
                break;
            }
            case "tracksrcbillcolno": {
                targetObjtype = "upm_movetrack";
                entryName = "trackentry";
                targetColName = "trackcol";
                srcColCBName = TRACKSRC_COLCB;
                break;
            }
            default: {
                return;
            }
        }
        IDataModel model = this.getModel();
        String sourcebilltype = this.checkSourcebilltype(model);
        if (sourcebilltype == null) {
            return;
        }
        MainEntityType sourceEntityType = this.getSourceBillMainEntityType();
        String sourceBillEntry = this.checkSourceBillEntry(model);
        if (sourceBillEntry == null) {
            return;
        }
        int index = model.getEntryCurrentRowIndex(entryName);
        String prop = (String)model.getValue(targetColName, index);
        if (StringUtils.isEmpty((CharSequence)prop)) {
            String message = ResManager.loadKDString((String)"\u5f53\u524d\u884c\u76ee\u6807\u4e1a\u52a1\u5bf9\u8c61\u5b9e\u4f53\u540d\u79f0\u4e3a\u7a7a\uff0c\u8bf7\u5148\u9009\u62e9\u76ee\u6807\u4e1a\u52a1\u5bf9\u8c61\u5b9e\u4f53\u540d\u79f0\u3002", (String)"UpmBillConfigEditPlugin_0", (String)"scmc-upm-form", (Object[])new Object[0]);
            this.getView().showTipNotification(message);
            return;
        }
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)targetObjtype);
        String[] props = prop.split("\\.");
        if (props.length > 1) {
            prop = props[props.length - 1];
        }
        IDataEntityProperty property = dataEntityType.findProperty(prop);
        TypeSelectStategy typeSelectStategy = new TypeSelectStategy(property);
        DefaultSelectStrategy strategy = null;
        if (sourceEntityType instanceof BillEntityType) {
            EntryNodeStrategy entrynodeStategy = new EntryNodeStrategy(Collections.singletonList(sourceBillEntry), true);
            strategy = new CompositeStrategy(Arrays.asList(typeSelectStategy, entrynodeStategy));
        } else {
            strategy = typeSelectStategy;
        }
        this.showColsTreePage(sourcebilltype, strategy, srcColCBName);
    }

    private void clickDefvalCol(String key) {
        IDataEntityProperty property;
        String entryName = null;
        String targetObjtype = null;
        String targetColName = null;
        String colCBName = null;
        switch (key) {
            case "mainfdefval": {
                entryName = "mainfentry";
                targetObjtype = "upm_masterfile";
                targetColName = "mainfcol";
                colCBName = MAINFDEF_COLCB;
                break;
            }
            case "trackdefval": {
                entryName = "trackentry";
                targetObjtype = "upm_movetrack";
                targetColName = "trackcol";
                colCBName = TRACKDEF_COLCB;
            }
        }
        IDataModel model = this.getModel();
        int index = model.getEntryCurrentRowIndex(entryName);
        String prop = (String)model.getValue(targetColName, index);
        if (StringUtils.isEmpty((CharSequence)prop)) {
            String message = ResManager.loadKDString((String)"\u5f53\u524d\u884c\u76ee\u6807\u4e1a\u52a1\u5bf9\u8c61\u5b9e\u4f53\u540d\u79f0\u4e3a\u7a7a\uff0c\u8bf7\u5148\u9009\u62e9\u76ee\u6807\u4e1a\u52a1\u5bf9\u8c61\u5b9e\u4f53\u540d\u79f0\u3002", (String)"UpmBillConfigEditPlugin_0", (String)"scmc-upm-form", (Object[])new Object[0]);
            this.getView().showTipNotification(message);
            return;
        }
        MainEntityType targetEntityType = EntityMetadataCache.getDataEntityType((String)targetObjtype);
        String[] props = prop.split("\\.");
        if (props.length > 1) {
            prop = props[props.length - 1];
        }
        if ((property = targetEntityType.findProperty(prop)) instanceof BasedataProp) {
            ActionFormCfgHelper.showListSelectPage((AbstractFormPlugin)this, ((BasedataProp)property).getBaseEntityId(), colCBName);
        } else {
            HashMap<String, Object> pageParam = new HashMap<String, Object>(2);
            pageParam.put("entitytype", targetObjtype);
            pageParam.put("fieldkey", prop);
            this.showDefaultValPage(pageParam, colCBName);
        }
    }

    private void showDefaultValPage(Map<String, Object> pageParam, String closeBackSymbol) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("upm_defaulval_form");
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, closeBackSymbol));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.getCustomParams().putAll(pageParam);
        this.getView().showForm(showParameter);
    }

    private String checkSourcebilltype(IDataModel model) {
        DynamicObject sourceBill = (DynamicObject)model.getValue("srcbillobj");
        if (sourceBill == null) {
            String message = ResManager.loadKDString((String)"\u5355\u636e\u4e3a\u7a7a\uff0c\u8bf7\u5148\u9009\u62e9\u5355\u636e\u3002", (String)"UpmBillConfigEditPlugin_1", (String)"scmc-upm-form", (Object[])new Object[0]);
            this.getView().showTipNotification(message);
            return null;
        }
        return sourceBill.getString("number");
    }

    private String checkSourceBillEntry(IDataModel model) {
        String sourceBillEntry = model.getDataEntity().getString("srcbillentry");
        if (sourceBillEntry == null || sourceBillEntry.isEmpty()) {
            String message = ResManager.loadKDString((String)"\u5355\u636e\u4f53\u4e3a\u7a7a\uff0c\u8bf7\u5148\u9009\u62e9\u5355\u636e\u4f53\u3002", (String)"UpmBillConfigEditPlugin_2", (String)"scmc-upm-form", (Object[])new Object[0]);
            this.getView().showTipNotification(message);
            return null;
        }
        return sourceBillEntry;
    }

    private void showColsTreePage(String entityNumber, IColsSelectStrategy strategy, String key) {
        IColsSelectStrategy selectStrategy = strategy;
        if (selectStrategy == null) {
            selectStrategy = new SimpleStrategy();
        }
        SelectParams params = new SelectParams();
        MetaHelper metaHelper = new MetaHelper(selectStrategy, entityNumber);
        String jsonTree = metaHelper.buildTree2JSON();
        params.setJsonTree(jsonTree);
        FormShowParameter fp = FormUtil.readyColsTreePage(params.toMap(), new CloseCallBack((IFormPlugin)this, key));
        this.getView().showForm(fp);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId;
        switch (actionId = e.getActionId()) {
            case "srcbillentryCB": 
            case "upmNumberCB": {
                this.objCloseCallBack(e, actionId);
                break;
            }
            case "mainfColCB": 
            case "trackColCB": 
            case "mainfsrcbillColCB": 
            case "tracksrcbillColCB": {
                this.objColCloseCallBack(e, actionId);
                break;
            }
            case "mainfdefvalColCB": 
            case "trackdefvalColCB": {
                this.objDefvalCloseCallBack(e, actionId);
            }
        }
    }

    private void objCloseCallBack(ClosedCallBackEvent e, String actionId) {
        MainEntityType meta;
        String col = null;
        String colName = null;
        boolean valProp = false;
        boolean valDBCol = false;
        switch (actionId) {
            case "srcbillentryCB": {
                col = "srcbillentry";
                colName = "srcbillentryname";
                break;
            }
            case "upmNumberCB": {
                col = "upmnumberfield";
                valProp = true;
                valDBCol = true;
                break;
            }
            default: {
                return;
            }
        }
        IDataModel model = this.getModel();
        JSONArray data = ColsTreeUtil.parseReturnData(e);
        if (data == null || data.isEmpty()) {
            return;
        }
        JSONObject info = data.getJSONObject(0);
        String id = info.getString("id");
        if (valProp && this.checkChooseEntity(id)) {
            return;
        }
        if (valDBCol && !this.checkDatabaseCol(meta = this.getSourceBillMainEntityType(), id)) {
            return;
        }
        model.setValue(col, (Object)id);
        if (colName != null) {
            model.setValue(colName, (Object)info.getString("text"));
        }
    }

    private void objColCloseCallBack(ClosedCallBackEvent e, String actionId) {
        MainEntityType meta;
        String entryName = null;
        String colNo = null;
        String col = null;
        String clrColNo = null;
        String clrCol = null;
        String srctypeCol = null;
        String defvalCol = null;
        String defvalidCol = null;
        boolean valSrcEntry = false;
        switch (actionId) {
            case "mainfColCB": {
                entryName = "mainfentry";
                colNo = "mainfcolno";
                col = "mainfcol";
                clrColNo = "mainfsrcbillcolno";
                clrCol = "mainfsrcbillcol";
                srctypeCol = "mainfsrctype";
                defvalCol = "mainfdefval";
                defvalidCol = "mainfdefvalid";
                meta = EntityMetadataCache.getDataEntityType((String)"upm_masterfile");
                break;
            }
            case "trackColCB": {
                entryName = "trackentry";
                colNo = "trackcolno";
                col = "trackcol";
                clrColNo = "tracksrcbillcolno";
                clrCol = "tracksrcbillcol";
                defvalCol = "trackdefval";
                defvalidCol = "trackdefvalid";
                meta = EntityMetadataCache.getDataEntityType((String)"upm_movetrack");
                break;
            }
            case "mainfsrcbillColCB": {
                entryName = "mainfentry";
                colNo = "mainfsrcbillcolno";
                col = "mainfsrcbillcol";
                valSrcEntry = true;
                meta = this.getSourceBillMainEntityType();
                break;
            }
            case "tracksrcbillColCB": {
                entryName = "trackentry";
                colNo = "tracksrcbillcolno";
                col = "tracksrcbillcol";
                valSrcEntry = true;
                meta = this.getSourceBillMainEntityType();
                break;
            }
            default: {
                return;
            }
        }
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        int index = model.getEntryCurrentRowIndex(entryName);
        JSONArray data = ColsTreeUtil.parseReturnData(e);
        if (data == null || data.isEmpty()) {
            return;
        }
        JSONObject info = data.getJSONObject(0);
        String id = info.getString("id");
        if (valSrcEntry && this.checkChooseEntity(id)) {
            return;
        }
        if (!this.checkDatabaseCol(meta, id)) {
            return;
        }
        model.beginInit();
        model.setValue(col, (Object)id, index);
        model.setValue(colNo, (Object)info.getString("text"), index);
        if (srctypeCol != null) {
            model.setValue(srctypeCol, (Object)"A", index);
        }
        if (clrColNo != null) {
            model.setValue(clrColNo, null, index);
        }
        if (clrCol != null) {
            model.setValue(clrCol, null, index);
        }
        if (defvalCol != null) {
            model.setValue(defvalCol, null, index);
        }
        if (defvalidCol != null) {
            model.setValue(defvalidCol, null, index);
        }
        model.endInit();
        view.updateView(entryName, index);
    }

    private void objDefvalCloseCallBack(ClosedCallBackEvent e, String actionId) {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        String entryName = null;
        String defvalCol = null;
        String defvalidCol = null;
        switch (actionId) {
            case "mainfdefvalColCB": {
                entryName = "mainfentry";
                defvalCol = "mainfdefval";
                defvalidCol = "mainfdefvalid";
                break;
            }
            case "trackdefvalColCB": {
                entryName = "trackentry";
                defvalCol = "trackdefval";
                defvalidCol = "trackdefvalid";
            }
        }
        int index = model.getEntryCurrentRowIndex(entryName);
        Object returnVal = e.getReturnData();
        String name = null;
        Object val = null;
        if (ObjectUtils.isEmpty((Object)returnVal)) {
            return;
        }
        if (returnVal instanceof Map) {
            Map returnMap = (Map)returnVal;
            name = MapUtils.getString((Map)returnMap, (Object)"defaultvalname");
            val = MapUtils.getObject((Map)returnMap, (Object)"defaultval");
        } else if (returnVal instanceof ListSelectedRowCollection) {
            ListSelectedRowCollection rows = (ListSelectedRowCollection)returnVal;
            ListSelectedRow row = rows.get(0);
            if (ObjectUtils.isNotEmpty((Object)row.getBillNo())) {
                name = row.getBillNo();
                val = row.getBillNo();
            } else if (ObjectUtils.isNotEmpty((Object)row.getName())) {
                name = row.getName();
                val = row.getPrimaryKeyValue();
            } else {
                name = row.getNumber();
                val = row.getPrimaryKeyValue();
            }
        }
        model.beginInit();
        model.setValue(defvalCol, (Object)name, index);
        model.setValue(defvalidCol, val, index);
        model.endInit();
        view.updateView(entryName, index);
    }

    private boolean checkChooseEntity(String prop) {
        MainEntityType meta = this.getSourceBillMainEntityType();
        if (meta != null) {
            return meta.getAllEntities().containsKey(prop);
        }
        return true;
    }

    private boolean checkDatabaseCol(MainEntityType meta, String id) {
        if (meta instanceof BillEntityType) {
            IDataEntityProperty prop;
            String[] keys = id.split("\\.");
            if (keys.length >= 2) {
                String entry = keys[keys.length - 2];
                String key = keys[keys.length - 1];
                prop = (IDataEntityProperty)((EntityType)meta.getAllEntities().get(entry)).getFields().get(key);
            } else {
                prop = (IDataEntityProperty)meta.getAllFields().get(id);
            }
            String dbCol = prop.getAlias();
            if (dbCol == null || dbCol.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u80fd\u9009\u62e9\u6570\u636e\u5e93\u5b57\u6bb5\u540d\u4e3a\u7a7a\u7684\u5b57\u6bb5\u3002", (String)"UpmBillConfigEditPlugin_3", (String)"scmc-upm-form", (Object[])new Object[0]));
                return false;
            }
        }
        return true;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        switch (key = e.getProperty().getName()) {
            case "srcbillobj": 
            case "srcbillentry": {
                this.changeSourceBill(e, key);
                break;
            }
            case "mainfcolno": 
            case "trackcolno": 
            case "mainfsrcbillcolno": 
            case "tracksrcbillcolno": {
                this.changeTargetObjCol(e, key);
                break;
            }
            case "mainfsrctype": 
            case "tracksrctype": {
                this.changeSrcType(e, key);
                break;
            }
            case "mainfdefval": 
            case "trackdefval": {
                this.changeDefval(e, key);
            }
        }
    }

    private void changeTargetObjCol(PropertyChangedArgs e, String key) {
        String entryName = null;
        String tarCol = null;
        String srcColNo = null;
        String srcCol = null;
        String defvalCol = null;
        String defvalidCol = null;
        switch (key) {
            case "mainfcolno": {
                entryName = "mainfentry";
                tarCol = "mainfcol";
                srcColNo = "mainfsrcbillcolno";
                srcCol = "mainfsrcbillcol";
                defvalCol = "mainfdefval";
                defvalidCol = "mainfdefvalid";
                break;
            }
            case "trackcolno": {
                entryName = "trackentry";
                tarCol = "trackcol";
                srcColNo = "tracksrcbillcolno";
                srcCol = "tracksrcbillcol";
                defvalCol = "trackdefval";
                defvalidCol = "trackdefvalid";
                break;
            }
            case "mainfsrcbillcolno": {
                entryName = "mainfentry";
                tarCol = "mainfsrcbillcol";
                break;
            }
            case "tracksrcbillcolno": {
                entryName = "trackentry";
                tarCol = "tracksrcbillcol";
            }
        }
        ChangeData[] changeSet = e.getChangeSet();
        IDataModel model = this.getModel();
        model.beginInit();
        for (ChangeData changeData : changeSet) {
            int rowIndex = changeData.getRowIndex();
            model.setValue(tarCol, null, rowIndex);
            if (srcColNo != null) {
                model.setValue(srcColNo, null, rowIndex);
            }
            if (srcCol != null) {
                model.setValue(srcCol, null, rowIndex);
            }
            if (defvalCol != null) {
                model.setValue(defvalCol, null, rowIndex);
            }
            if (defvalidCol == null) continue;
            model.setValue(defvalidCol, null, rowIndex);
        }
        model.endInit();
        this.getView().updateView(entryName);
    }

    private void changeSourceBill(PropertyChangedArgs e, String key) {
        int i;
        IDataModel model = this.getModel();
        model.beginInit();
        if ("srcbillobj".equals(key)) {
            MainEntityType entityType = this.getSourceBillMainEntityType();
            if (entityType instanceof BillEntityType) {
                model.setValue("srcbillentry", null);
                model.setValue("srcbillentryname", null);
            } else {
                model.setValue("srcbillentry", (Object)SRCENTRY_NOTNEED);
                model.setValue("srcbillentryname", (Object)SRCENTRY_NOTNEED);
            }
            model.setValue("operate", null);
            FilterGrid filterGrid = (FilterGrid)this.getControl("billfiltergrid");
            filterGrid.SetValue(new FilterCondition());
            model.setValue("billfilter", (Object)"");
            this.setCols4FilterGridAndOpe();
            this.setSrcEntryEnable(entityType);
        }
        model.setValue("upmnumberfield", null);
        DynamicObjectCollection mainfEntries = model.getEntryEntity("mainfentry");
        DynamicObjectCollection trackEntries = model.getEntryEntity("trackentry");
        if (!mainfEntries.isEmpty()) {
            for (i = 0; i < mainfEntries.size(); ++i) {
                model.setValue("mainfsrctype", (Object)"A", i);
                model.setValue("mainfsrcbillcolno", null, i);
                model.setValue("mainfsrcbillcol", null, i);
                model.setValue("mainfdefval", null, i);
                model.setValue("mainfdefvalid", null, i);
            }
        }
        if (!trackEntries.isEmpty()) {
            for (i = 0; i < trackEntries.size(); ++i) {
                model.setValue("tracksrcbillcolno", null, i);
                model.setValue("tracksrcbillcol", null, i);
            }
        }
        model.endInit();
        this.getView().updateView();
    }

    private void changeSrcType(PropertyChangedArgs e, String key) {
        String entryName = null;
        String srcbillCol = null;
        String srcbillnoCol = null;
        String defvalCol = null;
        String defvalidCol = null;
        switch (key) {
            case "mainfsrctype": {
                entryName = "mainfentry";
                srcbillCol = "mainfsrcbillcol";
                srcbillnoCol = "mainfsrcbillcolno";
                defvalCol = "mainfdefval";
                defvalidCol = "mainfdefvalid";
                break;
            }
            case "tracksrctype": {
                entryName = "trackentry";
                srcbillCol = "tracksrcbillcol";
                srcbillnoCol = "tracksrcbillcolno";
                defvalCol = "trackdefval";
                defvalidCol = "trackdefvalid";
            }
        }
        ChangeData[] changeSet = e.getChangeSet();
        IDataModel model = this.getModel();
        model.beginInit();
        for (ChangeData changeData : changeSet) {
            int rowIndex = changeData.getRowIndex();
            String srctype = (String)changeData.getNewValue();
            if ("A".equals(srctype)) {
                model.setValue(defvalCol, null, rowIndex);
                model.setValue(defvalidCol, null, rowIndex);
                continue;
            }
            if ("mainfsrctype".equals(key)) {
                String targetField = (String)model.getValue("mainfcol");
                if ("material".equals(targetField) || "org".equals(targetField)) {
                    String oldValue = (String)changeData.getOldValue();
                    model.setValue(key, (Object)oldValue, rowIndex);
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e3b\u6863\u5b57\u6bb5\u6620\u5c04\u4e2d\u7269\u6599\u548c\u7ec4\u7ec7\u5b57\u6bb5\u7684\u6765\u6e90\u53d6\u503c\u7c7b\u578b\u53ea\u80fd\u662f\u6e90\u5355\u5b57\u6bb5\u3002", (String)"UpmBillConfigEditPlugin_4", (String)"scmc-upm-form", (Object[])new Object[0]));
                    continue;
                }
                model.setValue(srcbillCol, null, rowIndex);
                model.setValue(srcbillnoCol, null, rowIndex);
                continue;
            }
            model.setValue(srcbillCol, null, rowIndex);
            model.setValue(srcbillnoCol, null, rowIndex);
        }
        model.endInit();
        this.getView().updateView(entryName);
    }

    private void changeDefval(PropertyChangedArgs e, String key) {
        String entryName = null;
        String defvalidCol = null;
        switch (key) {
            case "mainfdefval": {
                entryName = "mainfentry";
                defvalidCol = "mainfdefvalid";
                break;
            }
            case "trackdefval": {
                entryName = "trackentry";
                defvalidCol = "trackdefvalid";
            }
        }
        ChangeData[] changeSet = e.getChangeSet();
        IDataModel model = this.getModel();
        model.beginInit();
        for (ChangeData changeData : changeSet) {
            int rowIndex = changeData.getRowIndex();
            model.setValue(defvalidCol, null, rowIndex);
        }
        model.endInit();
        this.getView().updateView(entryName);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        String key;
        super.beforeDoOperation(e);
        switch (key = ((AbstractOperate)e.getSource()).getOperateKey()) {
            case "save": {
                this.beforeSave(e);
                break;
            }
        }
    }

    private void beforeSave(BeforeDoOperationEventArgs e) {
        IDataModel model = this.getModel();
        String billFilterInfo = this.parseBillFilterInfo();
        model.setValue("billfilter", (Object)billFilterInfo);
    }

    private String parseBillFilterInfo() {
        FilterGrid grid = (FilterGrid)this.getControl("billfiltergrid");
        FilterCondition condition = grid.getFilterGridState().getFilterCondition();
        String jsonStr = SerializationUtils.toJsonString((Object)condition);
        return jsonStr;
    }
}

