/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.upm.formplugin;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.BillEntityType;
import kd.bos.form.events.AfterQueryOfExportEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.scmc.upm.business.UpmImportIdAndNumberConvertHelper;
import org.apache.commons.collections4.map.MultiKeyMap;
import org.apache.commons.lang3.StringUtils;

public class UpmBillConfigListPlugin
extends AbstractListPlugin {
    public void afterQueryOfExport(AfterQueryOfExportEvent e) {
        HashMap<String, BillEntityType> entityTypeCache = new HashMap<String, BillEntityType>(4);
        MultiKeyMap keyCache = new MultiKeyMap();
        DynamicObject[] queryValues = e.getQueryValues();
        List<DynamicObject> billList = Arrays.stream(queryValues).collect(Collectors.toList());
        for (DynamicObject bill : billList) {
            DynamicObjectCollection masterfileRows = bill.getDynamicObjectCollection("mainfentry");
            for (DynamicObject masterfileRow : masterfileRows) {
                this.convertMasterFileDefaultValId2Number(entityTypeCache, (MultiKeyMap<String, String>)keyCache, "upm_masterfile", masterfileRow);
            }
            DynamicObjectCollection trackEntryRows = bill.getDynamicObjectCollection("trackentry");
            for (DynamicObject trackEntryRow : trackEntryRows) {
                this.convertTrackerDefaultValId2Number(entityTypeCache, (MultiKeyMap<String, String>)keyCache, "upm_movetrack", trackEntryRow);
            }
        }
        DynamicObject[] dynamicObjects = billList.toArray(new DynamicObject[0]);
        e.setCustomOrder(true);
        e.setQueryValues(dynamicObjects);
    }

    private void convertMasterFileDefaultValId2Number(Map<String, BillEntityType> entityTypeCache, MultiKeyMap<String, String> keyCache, String entityType, DynamicObject row) {
        String defaultValId = row.getString("mainfdefvalid");
        if (StringUtils.isBlank((CharSequence)defaultValId)) {
            return;
        }
        String fieldKey = row.getString("mainfcol");
        String defaultValNumber = UpmImportIdAndNumberConvertHelper.convertId2Number(entityTypeCache, keyCache, entityType, fieldKey, defaultValId);
        row.set("mainfdefvalnumber", (Object)defaultValNumber);
        row.set("mainfdefvalid", (Object)"");
    }

    private void convertTrackerDefaultValId2Number(Map<String, BillEntityType> entityTypeCache, MultiKeyMap<String, String> keyCache, String entityType, DynamicObject row) {
        String defaultValId = row.getString("trackdefvalid");
        if (StringUtils.isBlank((CharSequence)defaultValId)) {
            return;
        }
        String fieldKey = row.getString("trackcol");
        String defaultValNumber = UpmImportIdAndNumberConvertHelper.convertId2Number(entityTypeCache, keyCache, entityType, fieldKey, defaultValId);
        row.set("trackdefvalnumber", (Object)defaultValNumber);
        row.set("trackdefvalid", (Object)"");
    }
}

