/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.upm.formplugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.upm.business.MasterRelationHelper;
import kd.scmc.upm.business.MasterfileBillConfigHelper;
import kd.scmc.upm.business.masterfile.MasterfileHelper;
import kd.scmc.upm.common.util.FormUtil;

public class UpmCallActionHandlePlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String MASTERFILE = "masterfile";
    private static final String ACTION = "action";
    private static final String EXECACTION = "execaction";
    private static final String BILLTYPE = "billtype";
    private static final String BILLNO = "billno";
    private static final String OPERATE = "operate";
    private static final String CHECKCFG = "checkcfg";
    private static final String BILLOPEVALID = "billopevalid";
    private static final String BILLOPEEXEC = "billopeexec";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        FormUtil.addF7Listener(this, ACTION);
        this.addClickListeners(new String[]{EXECACTION, CHECKCFG, BILLOPEVALID, BILLOPEEXEC});
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "action": {
                this.beforeSelectAction(e);
            }
        }
    }

    private void beforeSelectAction(BeforeF7SelectEvent e) {
        IDataModel model = this.getModel();
        DynamicObject masterfile = (DynamicObject)model.getValue(MASTERFILE);
        if (masterfile != null) {
            DynamicObject mainStatus = masterfile.getDynamicObject("mainstatus");
            DynamicObject secondaryStatus = masterfile.getDynamicObject("secondarystatus");
            DynamicObject masterRelation = masterfile.getDynamicObject("masterrelation");
            HashMap<String, Object> masterStatusParam = new HashMap<String, Object>(16);
            masterStatusParam.put("mainstatus", mainStatus.getPkValue());
            masterStatusParam.put("secondarystatus", secondaryStatus.getPkValue());
            Long relationId = (Long)masterRelation.getPkValue();
            QFilter filter = MasterRelationHelper.getActionFilter(masterStatusParam, relationId);
            ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
            showParameter.getListFilterParameter().setFilter(filter);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        switch (key = e.getProperty().getName()) {
            case "masterfile": {
                this.clearAction();
                break;
            }
            case "billtype": {
                this.changeBillType(e);
            }
        }
    }

    private void clearAction() {
        IDataModel model = this.getModel();
        model.setValue(ACTION, null);
    }

    private void changeBillType(PropertyChangedArgs e) {
        IDataModel model = this.getModel();
        model.setValue(BILLNO, null);
        model.setValue(OPERATE, null);
        DynamicObject billtype = (DynamicObject)e.getChangeSet()[0].getNewValue();
        if (billtype != null) {
            String formid = billtype.getString("number");
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)formid);
            Map cfgs = BusinessDataServiceHelper.loadFromCache((String)"upm_billconf", (String)OPERATE, (QFilter[])new QFilter("srcbillobj", "=", (Object)formid).and("enable", "=", (Object)Boolean.TRUE).toArray());
            HashSet<String> cfgOpes = new HashSet<String>(cfgs.size());
            for (DynamicObject cfg : cfgs.values()) {
                String cfgOpe = cfg.getString(OPERATE);
                cfgOpes.add(cfgOpe);
            }
            List ops = EntityMetadataCache.getDataEntityOperate((String)entityType.getName());
            ArrayList<ComboItem> operationItems = new ArrayList<ComboItem>(10);
            ComboEdit operateEdit = (ComboEdit)this.getView().getControl(OPERATE);
            for (Map op : ops) {
                String opKey = (String)op.get("key");
                if (!cfgOpes.contains(opKey)) continue;
                operationItems.add(new ComboItem(LocaleString.fromMap((Map)((Map)op.get("name"))), opKey));
            }
            operateEdit.setComboItems(operationItems);
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "execaction": {
                this.execAction();
                break;
            }
            case "checkcfg": 
            case "billopevalid": 
            case "billopeexec": {
                this.billope(key);
            }
        }
    }

    private void execAction() {
        IDataModel model = this.getModel();
        DynamicObject masterfile = (DynamicObject)model.getValue(MASTERFILE);
        DynamicObject action = (DynamicObject)model.getValue(ACTION);
        if (masterfile != null && action != null) {
            String number = masterfile.getString("number");
            Long actionId = action.getLong("id");
            Map<String, String> param = Collections.singletonMap("number", number);
            List<Map<String, Object>> updateParams = Collections.singletonList(param);
            MasterfileHelper.handleAction("upm_masterfile", actionId, updateParams, false, false);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6267\u884c\u64cd\u4f5c\u6210\u529f\u3002", (String)"UpmCallActionHandlePlugin_0", (String)"scmc-upm-form", (Object[])new Object[0]));
            model.setValue(ACTION, null);
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5355\u4ef6\u4e3b\u6863\u548c\u52a8\u4f5c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"UpmCallActionHandlePlugin_1", (String)"scmc-upm-form", (Object[])new Object[0]));
        }
    }

    private void billope(String key) {
        IDataModel model = this.getModel();
        DynamicObject billtypeObj = (DynamicObject)model.getValue(BILLTYPE);
        if (billtypeObj != null) {
            String billtype = billtypeObj.getString("number");
            String billno = (String)model.getValue(BILLNO);
            String operate = (String)model.getValue(OPERATE);
            if (StringUtils.isNotBlank((CharSequence)billno) && StringUtils.isNotBlank((CharSequence)operate)) {
                List billids = QueryServiceHelper.queryPrimaryKeys((String)billtype, (QFilter[])new QFilter(BILLNO, "=", (Object)billno).toArray(), null, (int)1);
                if (!billids.isEmpty()) {
                    Long billid = (Long)billids.get(0);
                    Map<String, Set<String>> billCfgsMap = this.getBillCfgsMatchMap(billtype, operate, billid);
                    if (billCfgsMap.isEmpty()) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5339\u914d\u7684\u5355\u636e\u914d\u7f6e\uff0c\u5b9e\u9645\u6267\u884c\u8fc7\u7a0b\u4e2d\u5c06\u8df3\u8fc7\u5904\u7406\uff0c\u4e0d\u4f1a\u62a5\u9519\u3002", (String)"UpmCallActionHandlePlugin_2", (String)"scmc-upm-form", (Object[])new Object[0]));
                        return;
                    }
                    switch (key) {
                        case "checkcfg": {
                            StringBuilder matchMsg = new StringBuilder();
                            for (Map.Entry<String, Set<String>> billCfgsEntry : billCfgsMap.entrySet()) {
                                String ident = billCfgsEntry.getKey();
                                String[] identArray = ident.split("\\.");
                                String entrykey = identArray[0];
                                Set<String> cfgSet = billCfgsEntry.getValue();
                                matchMsg.append(ResManager.loadKDString((String)"\u5206\u5f55\u6807\u8bc6", (String)"UpmCallActionHandlePlugin_8", (String)"scmc-upm-form", (Object[])new Object[0])).append(entrykey).append(':').append(ResManager.loadKDString((String)"\u914d\u7f6e\u7f16\u7801", (String)"UpmCallActionHandlePlugin_9", (String)"scmc-upm-form", (Object[])new Object[0])).append(cfgSet.toString()).append('.');
                            }
                            this.getView().showSuccessNotification(matchMsg.toString());
                            break;
                        }
                        case "billopevalid": {
                            Map<Long, List<String>> validErrMsgData = MasterfileHelper.validByBillOperate(billtype, operate, Collections.singletonList(billid));
                            if (validErrMsgData.isEmpty()) {
                                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6267\u884c\u6821\u9a8c\u6210\u529f\u3002", (String)"UpmCallActionHandlePlugin_3", (String)"scmc-upm-form", (Object[])new Object[0]));
                                break;
                            }
                            StringBuilder errMsg = new StringBuilder();
                            for (List<String> validErrMsgs : validErrMsgData.values()) {
                                for (String validErrMsg : validErrMsgs) {
                                    errMsg.append(validErrMsg);
                                }
                            }
                            this.getView().showErrorNotification(errMsg.toString());
                            break;
                        }
                        case "billopeexec": {
                            for (Map.Entry<String, Set<String>> billCfgsEntry : billCfgsMap.entrySet()) {
                                Set<String> cfgSet = billCfgsEntry.getValue();
                                if (cfgSet.size() <= 1) continue;
                                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5339\u914d\u4e86\u591a\u4e2a\u89c4\u5219\uff0c\u82e5\u4e8c\u5f00\u573a\u666f\u4e0d\u8c03\u7528\u6821\u9a8c\u670d\u52a1\u800c\u76f4\u63a5\u8c03\u7528\u5904\u7406\u670d\u52a1\uff0c\u5c06\u53d6ID\u6700\u5c0f\u7684\u89c4\u5219\u8fdb\u884c\u5904\u7406\u3002", (String)"UpmCallActionHandlePlugin_4", (String)"scmc-upm-form", (Object[])new Object[0]));
                                return;
                            }
                            MasterfileHelper.handleByBillOperate(billtype, operate, Collections.singletonList(billid));
                            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6267\u884c\u64cd\u4f5c\u6210\u529f\u3002", (String)"UpmCallActionHandlePlugin_0", (String)"scmc-upm-form", (Object[])new Object[0]));
                        }
                    }
                } else {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\u4e0d\u5b58\u5728\u3002", (String)"UpmCallActionHandlePlugin_5", (String)"scmc-upm-form", (Object[])new Object[0]));
                }
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\u548c\u5355\u636e\u64cd\u4f5c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"UpmCallActionHandlePlugin_6", (String)"scmc-upm-form", (Object[])new Object[0]));
            }
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5355\u636e\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"UpmCallActionHandlePlugin_7", (String)"scmc-upm-form", (Object[])new Object[0]));
        }
    }

    private Map<String, Set<String>> getBillCfgsMatchMap(String formid, String operate, Long billid) {
        Collection<DynamicObject> cfgs = MasterfileBillConfigHelper.getBillConfig(formid, operate);
        return MasterfileBillConfigHelper.getBillCfgsMatchMap(formid, cfgs, Collections.singletonList(billid));
    }
}

