/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.upm.formplugin;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.upm.business.UpmActionHelper;
import kd.scmc.upm.business.WorkBenchExecuteHelper;

public class UpmChangeAgainstActionFormPlugin
extends AbstractFormPlugin {
    private static final Log log = LogFactory.getLog(UpmChangeAgainstActionFormPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_ok"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter fsp = this.getView().getFormShowParameter();
        Long masterFileId = (Long)fsp.getCustomParam("masterfileid");
        DynamicObject masterFile = BusinessDataServiceHelper.loadSingle((Object)masterFileId, (String)"upm_masterfile");
        this.getModel().setValue("number", (Object)masterFile.getString("number"));
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("btn_ok".equals(key)) {
            this.executeAction();
        }
    }

    private void executeAction() {
        FormShowParameter fsp = this.getView().getFormShowParameter();
        Long actionId = (Long)fsp.getCustomParam("actionid");
        List masterFileIds = (List)fsp.getCustomParam("masterFileIds");
        if (!ObjectUtils.isEmpty((Object)masterFileIds) && masterFileIds.size() > 1) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6279\u91cf\u51b2\u9500\u64cd\u4f5c", (String)"UpmChangeAgainstActionFormPlugin_0", (String)"scmc-upm-form", (Object[])new Object[0]));
            return;
        }
        List<Object[]> paramsList = this.buildParams(actionId, masterFileIds);
        try {
            WorkBenchExecuteHelper.execute(masterFileIds, (long)actionId, paramsList);
        }
        catch (Exception e) {
            log.error("\u4e3b\u6863\u52a8\u4f5c\u8c03\u7528\u5931\u8d25", (Throwable)e);
            this.getView().showErrorNotification(e.getMessage());
            return;
        }
        this.getView().returnDataToParent((Object)"true");
        this.getView().close();
    }

    private List<Object[]> buildParams(Long actionId, List<Long> masterFileIds) {
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>(16);
        List<DynamicObject> bizOpServiceList = this.getBizOpServiceList(actionId);
        Map<DynamicObject, Optional<DynamicObject>> masterFiledToSrcBillMap = UpmActionHelper.getMasterFiledToSrcBillMap(masterFileIds);
        List bills = masterFiledToSrcBillMap.values().stream().filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        for (DynamicObject bizOpService : bizOpServiceList) {
            String actionType = bizOpService.getString("actiontype");
            if (actionType.equals("BIZOP")) {
                if (ObjectUtils.isEmpty(bills)) continue;
                List<Object> ids = bills.stream().map(DataEntityBase::getPkValue).distinct().collect(Collectors.toList());
                HashMap<String, List<Object>> idMap = new HashMap<String, List<Object>>(16);
                idMap.put("id", ids);
                String entityNumber = ((DynamicObject)bills.get(0)).getDataEntityType().getName();
                Object[] obj = new Object[]{idMap, new HashMap(16), this.getOperateParams(ids, entityNumber)};
                paramsList.add(obj);
                continue;
            }
            if (!actionType.equals("SERVICE")) continue;
            HashMap map = new HashMap(16);
            ArrayList list = new ArrayList(16);
            if (!ObjectUtils.isEmpty(masterFiledToSrcBillMap)) {
                for (Map.Entry<DynamicObject, Optional<DynamicObject>> masterFileIdToDy : masterFiledToSrcBillMap.entrySet()) {
                    DynamicObject masterFile = masterFileIdToDy.getKey();
                    Optional<DynamicObject> srcBillOptional = masterFileIdToDy.getValue();
                    HashMap<String, Object> newMap = new HashMap<String, Object>(map);
                    newMap.put("number", masterFile.getString("number"));
                    if (srcBillOptional.isPresent()) {
                        DynamicObject srcBill = srcBillOptional.get();
                        HashMap<String, Object> tmpMap = new HashMap<String, Object>(16);
                        tmpMap.put("billid", srcBill.getLong("id"));
                        tmpMap.put("billtype", srcBill.getDataEntityType().getName());
                        tmpMap.put("billno", srcBill.getString("billno"));
                        newMap.put("upm_movetrack", tmpMap);
                    }
                    list.add(newMap);
                }
            }
            Object[] obj = new Object[]{"upm_masterfile", actionId, list};
            paramsList.add(obj);
        }
        return paramsList;
    }

    private Map<String, String> getOperateParams(List<Object> billPk, String caBillType) {
        Date date = (Date)this.getModel().getValue("cadate");
        String reason = (String)this.getModel().getValue("careason");
        HashMap<String, String> option = new HashMap<String, String>(16);
        option.put("caConfirm", "success");
        option.put("careason", reason);
        option.put("cadate", String.valueOf(date.getTime()));
        option.put("bookDate", String.valueOf(date.getTime()));
        option.put("caBillPk", String.valueOf(billPk.get(0)));
        option.put("caBillPks", String.valueOf(billPk));
        option.put("caBillType", caBillType);
        option.put("strictvalidation", String.valueOf(true));
        option.put("ignoreValidation", String.valueOf(false));
        option.put("isChargeAgainst", "1");
        return option;
    }

    private List<DynamicObject> getBizOpServiceList(Long actionId) {
        DynamicObject action = BusinessDataServiceHelper.loadSingle((Object)actionId, (String)"upm_masteraction");
        DynamicObjectCollection actionEntry = action.getDynamicObjectCollection("entryentity");
        ArrayList<DynamicObject> bizOpServiceList = new ArrayList<DynamicObject>();
        for (DynamicObject entry : actionEntry) {
            bizOpServiceList.add(entry.getDynamicObject("bizopservice"));
        }
        return bizOpServiceList;
    }

    private DynamicObject getSrcBillDym(String srcEntityNumber, Long masterFileId) {
        QFilter qFilter = new QFilter("masterfileid", "=", (Object)masterFileId);
        qFilter.and("billtype", "=", (Object)srcEntityNumber);
        DynamicObjectCollection cols = QueryServiceHelper.query((String)"upm_movetrack", (String)"billid", (QFilter[])qFilter.toArray(), (String)"id desc");
        if (ObjectUtils.isEmpty((Object)cols)) {
            return null;
        }
        return BusinessDataServiceHelper.loadSingle((Object)((DynamicObject)cols.get(0)).get("billid"), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)srcEntityNumber));
    }
}

