/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.upm.formplugin;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.scmc.upm.business.CreateBizBillHelper;
import kd.scmc.upm.business.WorkBenchExecuteHelper;
import kd.scmc.upm.business.actionform.MasterActionFormCfg;
import kd.scmc.upm.common.util.ActionFormUtil;
import kd.scmc.upm.formplugin.UpmPushActionFormPlugin;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.ObjectUtils;

public class UpmCreateBillActionFormPlugin
extends AbstractFormPlugin {
    private static final Log log = LogFactory.getLog(UpmPushActionFormPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void afterCreateNewData(EventObject e) {
        JSONObject paramMap = (JSONObject)this.getView().getFormShowParameter().getCustomParams();
        if (MapUtils.isEmpty((Map)paramMap)) {
            return;
        }
        Long masterfileid = paramMap.getLong("masterfileid");
        DynamicObject masterfileDym = BusinessDataServiceHelper.loadSingleFromCache((Object)masterfileid, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"upm_masterfile"));
        MasterActionFormCfg masterActionFormCfg = ActionFormUtil.getActionFormCfg(this.getView());
        if (masterActionFormCfg != null && ObjectUtils.isNotEmpty(masterActionFormCfg.getActionFormFieldList())) {
            for (MasterActionFormCfg.ActionFormField actionFormField : masterActionFormCfg.getActionFormFieldList()) {
                if (!"upm_masterfile".equals(actionFormField.getEntityType())) continue;
                String fieldKey = actionFormField.getFieldKey();
                Object val = masterfileDym.get(fieldKey);
                this.getModel().setValue(fieldKey, val);
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("btnok".equals(key)) {
            FormShowParameter fsp = this.getView().getFormShowParameter();
            Long actionId = (Long)fsp.getCustomParam("actionid");
            Long masterFileId = (Long)fsp.getCustomParam("masterfileid");
            DynamicObject masterFile = BusinessDataServiceHelper.loadSingle((Object)masterFileId, (String)"upm_masterfile");
            ArrayList<Object[]> paramsList = new ArrayList<Object[]>(16);
            DynamicObject targetEntityDy = CreateBizBillHelper.getTargetEntity(actionId);
            if (targetEntityDy == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u52a8\u4f5c\u6ca1\u6709\u6765\u6e90\u5b9e\u4f53", (String)"UpmCreateBillActionFormPlugin_0", (String)"scmc-upm-form", (Object[])new Object[0]));
            }
            String targetEntity = targetEntityDy.getString("number");
            DynamicObject newBizBill = CreateBizBillHelper.getNewBizBill(targetEntity);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newBizBill});
            Object[] createBillParams = this.buildCreateBillParams(newBizBill, targetEntity, actionId, masterFile);
            paramsList.add(createBillParams);
            Object[] masterTrackParams = this.buildUpdateMasterTrackParams(newBizBill, targetEntity, masterFile, actionId);
            paramsList.add(masterTrackParams);
            WorkBenchExecuteHelper.execute(masterFileId, actionId, paramsList);
            this.getView().returnDataToParent((Object)"true");
            this.getView().close();
        }
    }

    private Object[] buildUpdateMasterTrackParams(DynamicObject newBizBill, String targetEntity, DynamicObject masterFile, Long actionId) {
        HashMap<String, Object> masterParams = new HashMap<String, Object>(16);
        masterParams.put("number", masterFile.getString("number"));
        HashMap<String, Object> trackParams = new HashMap<String, Object>(16);
        trackParams.put("billid", newBizBill.getLong("id"));
        trackParams.put("billtype", targetEntity);
        trackParams.put("billno", newBizBill.getString("billno"));
        masterParams.put("upm_movetrack", trackParams);
        ArrayList<HashMap<String, Object>> lsit = new ArrayList<HashMap<String, Object>>(16);
        lsit.add(masterParams);
        Object[] params = new Object[]{"upm_masterfile", actionId, lsit};
        return params;
    }

    private Object[] buildCreateBillParams(DynamicObject newBizBill, String targetEntity, Long actionId, DynamicObject masterFile) {
        Object[] params = new Object[2];
        HashMap billMap = new HashMap(2);
        HashSet<Long> idSet = new HashSet<Long>(2);
        idSet.add(newBizBill.getLong("id"));
        billMap.put("id", idSet);
        params[0] = billMap;
        HashMap<String, Object> valueParams = new HashMap<String, Object>(16);
        DynamicObject dataEntity = this.getModel().getDataEntity();
        MasterActionFormCfg actionFormCfg = ActionFormUtil.getActionFormCfg(this.getView());
        CreateBizBillHelper.addActionCfgParams(valueParams, targetEntity, actionFormCfg, dataEntity);
        CreateBizBillHelper.addInvBalParams(valueParams, targetEntity, actionFormCfg, masterFile.getLong("id"));
        CreateBizBillHelper.addMainOrgCurrencyParam(valueParams, targetEntity, actionFormCfg);
        valueParams.put("creator", UserServiceHelper.getCurrentUserId());
        params[1] = valueParams;
        return params;
    }
}

