/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.upm.formplugin;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicComplexProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.entity.property.ItemClassTypeProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.businessfield.BasedataField;
import kd.bos.metadata.entity.businessfield.BillNoField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.servicehelper.MetadataServiceHelper;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.collections4.map.MultiKeyMap;

public class UpmDefaultValFormPlugin
extends AbstractFormPlugin {
    private static final Log log = LogFactory.getLog(UpmDefaultValFormPlugin.class);
    private final MultiKeyMap<String, EntityItem> entityItemCache = new MultiKeyMap();
    private final Map<String, MainEntityType> mainEntityTypeCache = new HashMap<String, MainEntityType>(4);
    public static final String ENTITY_TYPE = "entitytype";
    public static final String FIELD_KEY = "fieldkey";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        super.loadCustomControlMetas(e);
        Map customParams = ((FormShowParameter)e.getSource()).getCustomParams();
        FlexPanelAp headAp = this.createFormFields(customParams);
        HashMap<String, String> headMap = new HashMap<String, String>();
        headMap.put("id", "editcontent");
        Map itemMap = headAp.createControl();
        headMap.put("items", (String)itemMap.get("items"));
        e.getItems().add(headMap);
    }

    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
        String field = e.getKey();
        if (null == this.getModel().getDataEntityType().getProperties().get((Object)field)) {
            return;
        }
        String entityType = (String)this.getCustomPram(ENTITY_TYPE);
        String fieldKey = (String)this.getCustomPram(FIELD_KEY);
        if (null == entityType || null == fieldKey) {
            return;
        }
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)entityType);
        IDataEntityProperty property = mainEntityType.findProperty(field);
        if (property instanceof ItemClassTypeProp) {
            Field entityItem = (Field)this.findEntityItem(entityType, field);
            FieldEdit edit = entityItem.buildServerEditor();
            edit.setKey(e.getKey());
            edit.setView(this.getView());
            e.setControl((Control)edit);
        } else if (property instanceof ItemClassProp) {
            Field entityItem = (Field)this.findEntityItem(entityType, field);
            FieldEdit edit = entityItem.buildServerEditor();
            edit.setKey(e.getKey());
            edit.setView(this.getView());
            e.setControl((Control)edit);
        } else if (property instanceof BasedataProp) {
            BasedataEdit basedataEdit = new BasedataEdit();
            basedataEdit.setKey(field);
            basedataEdit.setView(this.getView());
            e.setControl((Control)basedataEdit);
        } else if (property instanceof MuliLangTextProp || property instanceof TextProp) {
            TextEdit edit = new TextEdit();
            edit.setKey(field);
            edit.setView(this.getView());
            e.setControl((Control)edit);
        } else {
            Field entityItem = (Field)this.findEntityItem(entityType, field);
            FieldEdit edit = entityItem.buildServerEditor();
            edit.setKey(e.getKey());
            edit.setView(this.getView());
            e.setControl((Control)edit);
        }
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        super.getEntityType(e);
        MainEntityType oldMainType = e.getOriginalEntityType();
        try {
            MainEntityType newMainType = this.createNewEntityType(oldMainType);
            e.setNewEntityType(newMainType);
        }
        catch (Exception exp) {
            throw new KDException((Throwable)exp, new ErrorCode("getEntityType", exp.getMessage()), new Object[0]);
        }
    }

    private FlexPanelAp createFormFields(Map<String, Object> customParams) {
        FlexPanelAp headAp = new FlexPanelAp();
        headAp.setKey("headAp");
        String entityType = (String)customParams.get(ENTITY_TYPE);
        String fieldKey = (String)customParams.get(FIELD_KEY);
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)entityType);
        IDataEntityProperty property = mainEntityType.findProperty(fieldKey);
        FieldAp fieldAp = new FieldAp();
        fieldAp.setId(fieldKey);
        fieldAp.setKey(fieldKey);
        fieldAp.setName(property.getDisplayName());
        fieldAp.setFireUpdEvt(true);
        fieldAp.setF7MultipleSelect(false);
        fieldAp.setQuickAddNew(false);
        fieldAp.setWidth(new LocaleString("200px"));
        fieldAp.setVisible("init,new,edit,view,submit,audit");
        fieldAp.setLock("");
        Field field = this.createField(mainEntityType, property);
        if (field != null) {
            fieldAp.setField(field);
            headAp.getItems().add(fieldAp);
        }
        return headAp;
    }

    private Field createField(MainEntityType mainEntityType, IDataEntityProperty property) {
        String entityType = mainEntityType.getName();
        String propertyName = property.getName();
        if (property instanceof ItemClassTypeProp) {
            return (Field)this.findEntityItem(entityType, propertyName);
        }
        if (property instanceof ItemClassProp) {
            return (Field)this.findEntityItem(entityType, propertyName);
        }
        if (property instanceof BasedataProp) {
            BasedataField field = new BasedataField();
            field.setId(propertyName);
            field.setKey(propertyName);
            field.setBaseEntityId(((BasedataProp)property).getBaseEntityId());
            return field;
        }
        if (mainEntityType instanceof BillEntityType && propertyName.equals(((BillEntityType)mainEntityType).getBillNo())) {
            BillNoField field = new BillNoField();
            field.setId(propertyName);
            field.setKey(propertyName);
            field.setEditStyle(1);
            return field;
        }
        if (property instanceof TextProp) {
            TextField field = new TextField();
            field.setId(propertyName);
            field.setKey(propertyName);
            return field;
        }
        return (Field)this.findEntityItem(entityType, propertyName);
    }

    private MainEntityType createNewEntityType(MainEntityType oldMainType) throws CloneNotSupportedException, InstantiationException, IllegalAccessException {
        IDataEntityProperty property;
        String entityType = (String)this.getCustomPram(ENTITY_TYPE);
        String fieldKey = (String)this.getCustomPram(FIELD_KEY);
        if (null == entityType || null == fieldKey) {
            return oldMainType;
        }
        MainEntityType mainEntityType = this.mainEntityTypeCache.get(entityType);
        if (mainEntityType == null) {
            mainEntityType = MetadataServiceHelper.getDataEntityType((String)entityType);
            this.mainEntityTypeCache.put(entityType, mainEntityType);
        }
        if ((property = mainEntityType.findProperty(fieldKey)) == null) {
            return oldMainType;
        }
        MainEntityType newMainType = (MainEntityType)oldMainType.clone();
        if (property instanceof ItemClassTypeProp) {
            newMainType.addProperty((DynamicProperty)property.clone());
        } else if (property instanceof ItemClassProp) {
            String fieldRefId = fieldKey + "_id";
            DynamicSimpleProperty refIdProp = (DynamicSimpleProperty)mainEntityType.findProperty(fieldRefId);
            ItemClassProp newProp = (ItemClassProp)property.clone();
            newProp.setRefIdProp((IDataEntityProperty)refIdProp);
            newMainType.registerSimpleProperty(refIdProp);
            newMainType.registerComplexProperty((DynamicComplexProperty)newProp);
        } else if (property instanceof BasedataProp) {
            String fieldRefId = fieldKey + "_id";
            BasedataProp oldBdProp = (BasedataProp)property;
            String alias = oldBdProp.getAlias();
            LongProp refId = new LongProp(true);
            refId.setPrimaryKey(false);
            refId.setName(fieldRefId);
            BasedataProp basedataProp = new BasedataProp();
            basedataProp.setName(fieldKey);
            basedataProp.setDisplayName(oldBdProp.getDisplayName());
            basedataProp.setDbIgnore(false);
            basedataProp.setAlias(alias);
            String baseEntityId = oldBdProp.getBaseEntityId();
            if (baseEntityId == null) {
                return oldMainType;
            }
            basedataProp.setBaseEntityId(baseEntityId);
            basedataProp.setComplexType((IDataEntityType)EntityMetadataCache.getDataEntityType((String)baseEntityId));
            basedataProp.setRefIdProp((IDataEntityProperty)refId);
            basedataProp.setRefIdPropName(fieldRefId);
            newMainType.registerSimpleProperty((DynamicSimpleProperty)refId);
            newMainType.registerComplexProperty((DynamicComplexProperty)basedataProp);
        } else if (property instanceof TextProp) {
            TextProp newProp = new TextProp();
            newProp.setName(fieldKey);
            newProp.setDisplayName(property.getDisplayName());
            newProp.setDbIgnore(false);
            newProp.setAlias("");
            newMainType.registerSimpleProperty((DynamicSimpleProperty)newProp);
        } else {
            newMainType.addProperty((DynamicProperty)property.clone());
        }
        return newMainType;
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Map customParams = ((IFormView)e.getSource()).getFormShowParameter().getCustomParams();
        FlexPanelAp headAp = this.createFormFields(customParams);
        Container myFldPanel = (Container)this.getView().getControl("editcontent");
        myFldPanel.getItems().addAll(((Container)headAp.buildRuntimeControl()).getItems());
        this.getView().createControlIndex(myFldPanel.getItems());
    }

    private EntityItem findEntityItem(String entityType, String field) {
        if (!this.entityItemCache.containsKey((Object)entityType)) {
            EntityMetadata entityMeta = (EntityMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)entityType, (MetaCategory)MetaCategory.Entity), (MetaCategory)MetaCategory.Entity);
            for (EntityItem entityItem : entityMeta.getItems()) {
                this.entityItemCache.put((Object)entityType, (Object)entityItem.getKey(), (Object)entityItem);
            }
        }
        return (EntityItem)this.entityItemCache.get((Object)entityType, (Object)field);
    }

    private Object getCustomPram(String field) {
        Map paramMap = this.getView().getFormShowParameter().getCustomParams();
        if (MapUtils.isEmpty((Map)paramMap)) {
            return null;
        }
        return paramMap.get(field);
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "btnok": {
                this.returnValue();
            }
        }
    }

    private void returnValue() {
        String fieldKey = (String)this.getCustomPram(FIELD_KEY);
        IDataEntityProperty property = this.getModel().getProperty(fieldKey);
        Object value = this.getModel().getValue(fieldKey);
        HashMap<String, Object> returnMap = new HashMap<String, Object>(2);
        if (null == value) {
            returnMap.put("defaultvalname", null);
            returnMap.put("defaultval", null);
        } else if (property instanceof ComboProp) {
            String strVal = (String)value;
            ComboProp comboProp = (ComboProp)property;
            String name = comboProp.getItemByName(strVal);
            returnMap.put("defaultvalname", name);
            returnMap.put("defaultval", strVal);
        } else if (property instanceof DateTimeProp) {
            Date dateVal = (Date)value;
            returnMap.put("defaultvalname", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(dateVal));
            returnMap.put("defaultval", dateVal.getTime());
        } else if (property instanceof TextProp) {
            String strVal = (String)value;
            returnMap.put("defaultvalname", strVal);
            returnMap.put("defaultval", strVal);
        } else if (property instanceof DecimalProp) {
            returnMap.put("defaultvalname", value.toString());
            returnMap.put("defaultval", value);
        } else if (property instanceof MulBasedataProp) {
            MulBasedataDynamicObjectCollection rows = (MulBasedataDynamicObjectCollection)value;
            ArrayList<String> nameList = new ArrayList<String>(rows.size());
            ArrayList<String> valueList = new ArrayList<String>(rows.size());
            for (DynamicObject row : rows) {
                DynamicObject dym = row.getDynamicObject("fbasedataid");
                nameList.add(dym.getString("name"));
                valueList.add(dym.getString("id"));
            }
            returnMap.put("defaultvalname", nameList.stream().collect(Collectors.joining(";")));
            returnMap.put("defaultval", SerializationUtils.toJsonString(valueList));
        }
        this.getView().returnDataToParent(returnMap);
        this.getView().close();
    }
}

