/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.upm.formplugin;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.scmc.upm.business.RoleDataIsolationHelper;

public class UpmMasterFileListEditPlugin
extends AbstractListPlugin {
    private static final String UPDREMARK = "updremark";
    private static final String UPDREMARK_CB = "updremark_cb";

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        List<Long> userRoleList = RoleDataIsolationHelper.getUserRoleList();
        List<Long> roleOrgList = RoleDataIsolationHelper.getRoleOrgList(userRoleList);
        List<Long> roleVehicleList = RoleDataIsolationHelper.getRoleVehicleList(userRoleList);
        QFilter qFilter = new QFilter("org", "in", roleOrgList);
        qFilter.and("material", "in", roleVehicleList);
        e.addCustomQFilter(qFilter);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String itemKey;
        super.afterDoOperation(afterDoOperationEventArgs);
        switch (itemKey = afterDoOperationEventArgs.getOperateKey()) {
            case "updremark": {
                this.openUpdRemark();
            }
        }
    }

    private void openUpdRemark() {
        IFormView view = this.getView();
        BillList billList = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection selectRows = billList.getSelectedRows();
        HashSet<Long> masterfileIds = new HashSet<Long>(selectRows.size());
        for (ListSelectedRow row : selectRows) {
            Long masterfileId = (Long)row.getPrimaryKeyValue();
            masterfileIds.add(masterfileId);
        }
        if (masterfileIds.isEmpty()) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"UpmMasterFileListEditPlugin_0", (String)"scmc-upm-form", (Object[])new Object[0]));
            return;
        }
        HashMap<String, String> paramMap = new HashMap<String, String>(2);
        paramMap.put("formId", "upm_updateremark");
        paramMap.put("masterfileIds", SerializationUtils.toJsonString(masterfileIds));
        FormShowParameter formShowParameter = FormShowParameter.createFormShowParameter(paramMap);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, UPDREMARK_CB));
        view.showForm(formShowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId;
        super.closedCallBack(e);
        switch (actionId = e.getActionId()) {
            case "updremark_cb": {
                BillList billList = (BillList)this.getControl("billlistap");
                billList.refresh();
            }
        }
    }
}

