/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.upm.formplugin;

import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.upm.business.WorkBenchExecuteHelper;
import kd.scmc.upm.business.actionform.MasterActionFormCfg;
import kd.scmc.upm.common.util.ActionFormUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class UpmPushActionFormPlugin
extends AbstractFormPlugin {
    private static final Log log = LogFactory.getLog(UpmPushActionFormPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        MasterActionFormCfg masterActionFormCfg = ActionFormUtil.getActionFormCfg(this.getView());
        if (masterActionFormCfg == null || ObjectUtils.isEmpty(masterActionFormCfg.getActionFormFieldList())) {
            return;
        }
        DynamicObject masterfileDym = this.getModel().getDataEntity().getDynamicObject("masterfile");
        if (masterfileDym == null) {
            return;
        }
        masterfileDym = BusinessDataServiceHelper.loadSingle((Object)masterfileDym.getPkValue(), (String)"upm_masterfile");
        MainEntityType mainEntityType = (MainEntityType)masterfileDym.getDataEntityType();
        for (MasterActionFormCfg.ActionFormField actionFormField : masterActionFormCfg.getActionFormFieldList()) {
            IDataEntityProperty property;
            String fieldKey = actionFormField.getFieldKey();
            if (!"upm_masterfile".equals(actionFormField.getEntityType()) || null == mainEntityType.findProperty(fieldKey) || !((property = mainEntityType.findProperty(fieldKey)).getParent() instanceof BillEntityType)) continue;
            Object val = masterfileDym.get(fieldKey);
            this.getModel().setValue(fieldKey, val);
        }
        DynamicObject botpRule = this.getBotpRule();
        if (null == botpRule) {
            return;
        }
        String srcEntityNumber = (String)botpRule.getDynamicObject("sourceentitynumber").getPkValue();
        QFilter qFilter = new QFilter("masterfileid", "=", masterfileDym.getPkValue());
        qFilter.and("billtype", "=", (Object)srcEntityNumber);
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"upm_movetrack", (String)"billid", (QFilter[])qFilter.toArray(), (String)"id desc");
        if (ObjectUtils.isEmpty((Object)collection)) {
            return;
        }
        DynamicObject srcBillDym = BusinessDataServiceHelper.loadSingle((Object)((DynamicObject)collection.get(0)).get("billid"), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)srcEntityNumber));
        for (MasterActionFormCfg.ActionFormField actionFormField : masterActionFormCfg.getActionFormFieldList()) {
            if (!srcEntityNumber.equals(actionFormField.getEntityType())) continue;
            String fieldKey = actionFormField.getFieldKey();
            Object val = this.getVal(srcBillDym, fieldKey);
            this.getModel().setValue(fieldKey, val);
        }
    }

    private Object getVal(DynamicObject dym, String fieldKey) {
        if (null == dym || StringUtils.isBlank((CharSequence)fieldKey)) {
            return null;
        }
        MainEntityType dataEntityType = (MainEntityType)dym.getDataEntityType();
        IDataEntityProperty property = dataEntityType.findProperty(fieldKey);
        if (null == property) {
            return null;
        }
        DynamicObject row = dym;
        IDataEntityType pet = property.getParent();
        if (pet instanceof EntryType) {
            DynamicObjectCollection rows = dym.getDynamicObjectCollection(pet.getName());
            if (CollectionUtils.isEmpty((Collection)rows)) {
                return null;
            }
            row = (DynamicObject)rows.get(0);
        }
        return row.get(fieldKey);
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "btnok": {
                this.executeBotp();
                break;
            }
        }
    }

    private void executeBotp() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long actionId = (Long)formShowParameter.getCustomParam("actionid");
        Long masterFileId = (Long)formShowParameter.getCustomParam("masterfileid");
        if (actionId == null || masterFileId == null) {
            return;
        }
        try {
            WorkBenchExecuteHelper.execute(masterFileId, actionId, Collections.singletonList(this.buildParams()));
        }
        catch (Exception e) {
            log.error("\u4e3b\u6863\u52a8\u4f5c\u8c03\u7528\u5931\u8d25", (Throwable)e);
            this.getView().showErrorNotification(e.getMessage());
            return;
        }
        this.getView().returnDataToParent((Object)"true");
        this.getView().close();
    }

    private Object[] buildParams() {
        Object[] params = new Object[]{new HashMap(4), new HashMap(4)};
        DynamicObject dataEntity = this.getModel().getDataEntity();
        MasterActionFormCfg masterActionFormCfg = ActionFormUtil.getActionFormCfg(this.getView());
        if (masterActionFormCfg != null && CollectionUtils.isNotEmpty(masterActionFormCfg.getActionFormFieldList())) {
            DynamicObject botpRule = this.getBotpRule();
            if (null == botpRule) {
                return params;
            }
            String srcEntityNumber = (String)botpRule.getDynamicObject("sourceentitynumber").getPkValue();
            String tgtEntityNumber = (String)botpRule.getDynamicObject("targetentitynumber").getPkValue();
            MainEntityType targetEntityType = MetadataServiceHelper.getDataEntityType((String)tgtEntityNumber);
            for (MasterActionFormCfg.ActionFormField actionFormField : masterActionFormCfg.getActionFormFieldList()) {
                BillEntityType srcEntityType;
                IDataEntityProperty property = targetEntityType.findProperty(actionFormField.getFieldKey());
                if (property == null) continue;
                if (srcEntityNumber.equals(actionFormField.getEntityType()) && (srcEntityType = (BillEntityType)MetadataServiceHelper.getDataEntityType((String)srcEntityNumber)).getBillNo().equals(actionFormField.getFieldKey())) {
                    HashMap<String, List<String>> srcBillNos = new HashMap<String, List<String>>();
                    srcBillNos.put("billno", Collections.singletonList(dataEntity.getString(actionFormField.getFieldKey())));
                    params[0] = srcBillNos;
                    continue;
                }
                if (!tgtEntityNumber.equals(actionFormField.getEntityType())) continue;
                if (params[1] == null) {
                    params[1] = new HashMap(4);
                }
                Map param = (Map)params[1];
                String key = actionFormField.getFieldKey();
                Object value = dataEntity.get(key);
                if (property.getParent() instanceof EntryType) {
                    String entryName = property.getParent().getName();
                    if (param.get(entryName) == null) {
                        param.put(entryName, new HashMap(4));
                    }
                    Map entryMap = (Map)param.get(entryName);
                    entryMap.put(key, ActionFormUtil.getValue(value));
                    continue;
                }
                param.put(key, ActionFormUtil.getValue(value));
            }
            this.fillBillEntryId(srcEntityNumber, params);
            this.fillInnerCode(masterActionFormCfg, targetEntityType, (Map)params[1]);
        }
        return params;
    }

    private void fillInnerCode(MasterActionFormCfg masterActionFormCfg, MainEntityType targetEntityType, Map<String, Object> paramMap) {
        if (StringUtils.isBlank((CharSequence)masterActionFormCfg.getBalFieldKey())) {
            return;
        }
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String innerCode = dataEntity.getDynamicObject("masterfile").getString("number");
        String balFieldKey = masterActionFormCfg.getBalFieldKey();
        IDataEntityProperty property = targetEntityType.findProperty(balFieldKey);
        if (property == null) {
            return;
        }
        if (property.getParent() instanceof EntryType) {
            String entryType = property.getParent().getName();
            if (!paramMap.containsKey(entryType)) {
                paramMap.put(entryType, new HashMap(2));
            }
            Map entryMap = (Map)paramMap.get(entryType);
            entryMap.put(balFieldKey, innerCode);
        } else {
            paramMap.put(balFieldKey, innerCode);
        }
    }

    private void fillBillEntryId(String entityNumber, Object[] params) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long masterFileId = (Long)formShowParameter.getCustomParam("masterfileid");
        BillEntityType billEntityType = (BillEntityType)MetadataServiceHelper.getDataEntityType((String)entityNumber);
        String billno = (String)this.getModel().getValue(billEntityType.getBillNo());
        QFilter qFilter = new QFilter("masterfileid", "=", (Object)masterFileId);
        qFilter.and("billtype", "=", (Object)entityNumber);
        qFilter.and("billno", "=", (Object)billno);
        DynamicObjectCollection movetrackCollection = QueryServiceHelper.query((String)"upm_movetrack", (String)"billentrytype,billentryid", (QFilter[])qFilter.toArray(), (String)"id desc", (int)1);
        if (CollectionUtils.isEmpty((Collection)movetrackCollection)) {
            return;
        }
        DynamicObject movetrackDym = (DynamicObject)movetrackCollection.get(0);
        String entryKey = movetrackDym.getString("billentrytype");
        Object entryId = movetrackDym.get("billentryid");
        if (params[1] == null) {
            params[1] = new HashMap(4);
        }
        Map param = (Map)params[1];
        param.put("entryKey", entryKey);
        param.put("entryId", entryId);
    }

    private DynamicObject getBotpRule() {
        DynamicObject actionDym = this.getModel().getDataEntity().getDynamicObject("masteraction");
        if (null == actionDym) {
            return null;
        }
        actionDym = BusinessDataServiceHelper.loadSingleFromCache((Object)actionDym.getPkValue(), (String)"upm_masteraction");
        DynamicObjectCollection entryRows = actionDym.getDynamicObjectCollection("entryentity");
        for (DynamicObject entryRow : entryRows) {
            DynamicObject opBizDym = entryRow.getDynamicObject("bizopservice");
            if (!"PUSH".equals(opBizDym.getString("actiontype"))) continue;
            Object botpId = opBizDym.getDynamicObject("botprule").getPkValue();
            return BusinessDataServiceHelper.loadSingleFromCache((Object)botpId, (String)"botp_crlist");
        }
        return null;
    }
}

