/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.upm.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.scmc.upm.business.UpmActionHelper;
import kd.scmc.upm.business.WorkBenchExecuteHelper;
import kd.scmc.upm.business.actionform.MasterActionFormCfg;
import kd.scmc.upm.common.util.ActionFormUtil;

public class UpmSimpleActionFormPlugin
extends AbstractFormPlugin {
    private static final Log log = LogFactory.getLog(UpmSimpleActionFormPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        MasterActionFormCfg masterActionFormCfg = ActionFormUtil.getActionFormCfg(this.getView());
        if (masterActionFormCfg == null || ObjectUtils.isEmpty(masterActionFormCfg.getActionFormFieldList())) {
            return;
        }
        Map<String, DynamicObject[]> entityDymMap = this.getEntityDymMap(masterActionFormCfg);
        this.setInitFormData(masterActionFormCfg, entityDymMap);
    }

    private Map<String, DynamicObject[]> getEntityDymMap(MasterActionFormCfg masterActionFormCfg) {
        FormShowParameter fsp = this.getView().getFormShowParameter();
        List masterFileIds = (List)fsp.getCustomParam("masterFileIds");
        DynamicObject[] masterFiles = BusinessDataServiceHelper.load((Object[])masterFileIds.toArray(new Object[0]), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"upm_masterfile"));
        String entityType = "";
        for (MasterActionFormCfg.ActionFormField actionFormField : masterActionFormCfg.getActionFormFieldList()) {
            if (actionFormField.getEntityType().equals("upm_masterfile")) continue;
            entityType = actionFormField.getEntityType();
            break;
        }
        HashMap<String, DynamicObject[]> entityDymMap = new HashMap<String, DynamicObject[]>(16);
        entityDymMap.put("upm_masterfile", masterFiles);
        if (StringUtils.isNotBlank((CharSequence)entityType)) {
            entityDymMap.put(entityType, Objects.requireNonNull(UpmActionHelper.getMasterFiledIdToSrcBillMap(masterFileIds)).values().toArray(new DynamicObject[0]));
        }
        return entityDymMap;
    }

    private void setInitFormData(MasterActionFormCfg masterActionFormCfg, Map<String, DynamicObject[]> entityDymMap) {
        DynamicObject[] masterFiles = entityDymMap.get("upm_masterfile");
        String balFieldKey = masterActionFormCfg.getBalFieldKey();
        String masterNumber = masterFiles[0].getString("number");
        for (MasterActionFormCfg.ActionFormField actionFormField : masterActionFormCfg.getActionFormFieldList()) {
            Object fieldVal;
            String fieldEntityType = actionFormField.getEntityType();
            if (!entityDymMap.containsKey(fieldEntityType)) continue;
            String fieldKey = actionFormField.getFieldKey();
            MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)fieldEntityType);
            IDataEntityProperty property = mainEntityType.findProperty(fieldKey);
            if (property.getParent() instanceof EntryType) {
                if (ObjectUtils.isEmpty((Object)balFieldKey)) continue;
                String entryName = property.getParent().getName();
                DynamicObjectCollection entrys = entityDymMap.get(fieldEntityType)[0].getDynamicObjectCollection(entryName);
                DynamicObject entry = entrys.stream().filter(obj -> masterNumber.equals(obj.getString(balFieldKey))).findFirst().orElse(null);
                if (entry == null) continue;
                fieldVal = entry.get(fieldKey);
            } else {
                fieldVal = entityDymMap.get(fieldEntityType)[0].get(fieldKey);
            }
            this.getModel().setValue(fieldKey, fieldVal);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("btnok".equals(key)) {
            this.executeAction();
        }
    }

    private void executeAction() {
        FormShowParameter fsp = this.getView().getFormShowParameter();
        Long actionId = (Long)fsp.getCustomParam("actionid");
        List masterFileIds = (List)fsp.getCustomParam("masterFileIds");
        List<Object[]> paramsList = this.buildParams(actionId, masterFileIds);
        try {
            WorkBenchExecuteHelper.execute(masterFileIds, (long)actionId, paramsList);
        }
        catch (Exception e) {
            log.error("\u4e3b\u6863\u52a8\u4f5c\u8c03\u7528\u5931\u8d25", (Throwable)e);
            this.getView().showErrorNotification(e.getMessage());
            return;
        }
        this.getView().returnDataToParent((Object)"true");
        this.getView().close();
    }

    private List<Object[]> buildParams(Long actionId, List<Long> masterFileIds) {
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>(16);
        List<DynamicObject> bizOpServiceList = this.getBizOpServiceList(actionId);
        Map<DynamicObject, Optional<DynamicObject>> masterFiledToSrcBillMap = UpmActionHelper.getMasterFiledToSrcBillMap(masterFileIds);
        List bills = masterFiledToSrcBillMap.values().stream().filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        for (DynamicObject bizOpService : bizOpServiceList) {
            Object obj;
            String actionType = bizOpService.getString("actiontype");
            if (actionType.equals("BIZOP")) {
                if (ObjectUtils.isEmpty(bills)) continue;
                List ids = bills.stream().map(DataEntityBase::getPkValue).distinct().collect(Collectors.toList());
                HashMap idMap = new HashMap(16);
                idMap.put("id", ids);
                obj = new Object[]{idMap};
                paramsList.add((Object[])obj);
                continue;
            }
            if (!actionType.equals("SERVICE")) continue;
            HashMap<String, Object> map = new HashMap<String, Object>(16);
            this.addActionCfgParams(map, "upm_masterfile");
            ArrayList<HashMap<String, Object>> list = new ArrayList<HashMap<String, Object>>(16);
            if (!ObjectUtils.isEmpty(masterFiledToSrcBillMap)) {
                for (Map.Entry entry : masterFiledToSrcBillMap.entrySet()) {
                    DynamicObject masterFile = (DynamicObject)entry.getKey();
                    Optional srcBillOptional = (Optional)entry.getValue();
                    HashMap<String, Object> newMap = new HashMap<String, Object>(map);
                    newMap.put("number", masterFile.getString("number"));
                    if (srcBillOptional.isPresent()) {
                        DynamicObject srcBill = (DynamicObject)srcBillOptional.get();
                        HashMap<String, Object> tmpMap = new HashMap<String, Object>(16);
                        tmpMap.put("billid", srcBill.getLong("id"));
                        tmpMap.put("billtype", srcBill.getDataEntityType().getName());
                        tmpMap.put("billno", srcBill.getString("billno"));
                        newMap.put("upm_movetrack", tmpMap);
                    }
                    list.add(newMap);
                }
            }
            obj = new Object[]{"upm_masterfile", actionId, list};
            paramsList.add((Object[])obj);
        }
        return paramsList;
    }

    private void addActionCfgParams(Map<String, Object> valueParams, String entityNumber) {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        MasterActionFormCfg actionFormCfg = ActionFormUtil.getActionFormCfg(this.getView());
        if (actionFormCfg == null || ObjectUtils.isEmpty(actionFormCfg.getActionFormFieldList())) {
            return;
        }
        List<MasterActionFormCfg.ActionFormField> actionFormFieldList = actionFormCfg.getActionFormFieldList();
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)entityNumber);
        for (MasterActionFormCfg.ActionFormField field : actionFormFieldList) {
            String fieldKey = field.getFieldKey();
            IDataEntityProperty property = mainEntityType.findProperty(fieldKey);
            if (property == null || !entityNumber.equals(field.getEntityType())) continue;
            Object value = dataEntity.get(fieldKey);
            if ("number".equals(fieldKey)) {
                valueParams.put(fieldKey, ActionFormUtil.getValue(value));
                continue;
            }
            Map<String, Object> tmpMap = valueParams.containsKey("upm_masterfile") ? (HashMap<String, Object>)valueParams.get("upm_masterfile") : new HashMap<String, Object>(16);
            tmpMap.put(fieldKey, ActionFormUtil.getValue(value));
            valueParams.put("upm_masterfile", tmpMap);
            tmpMap = valueParams.containsKey("upm_movetrack") ? (Map)valueParams.get("upm_movetrack") : new HashMap(16);
            tmpMap.put(fieldKey, ActionFormUtil.getValue(value));
            valueParams.put("upm_movetrack", tmpMap);
        }
    }

    private List<DynamicObject> getBizOpServiceList(Long actionId) {
        DynamicObject action = BusinessDataServiceHelper.loadSingle((Object)actionId, (String)"upm_masteraction");
        DynamicObjectCollection actionEntry = action.getDynamicObjectCollection("entryentity");
        ArrayList<DynamicObject> bizOpServiceList = new ArrayList<DynamicObject>();
        for (DynamicObject entry : actionEntry) {
            bizOpServiceList.add(entry.getDynamicObject("bizopservice"));
        }
        return bizOpServiceList;
    }
}

