/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.upm.formplugin.vehiclerole;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;

public class VehicleRoleListPlugin
extends AbstractListPlugin {
    private Map<String, String> kv = new HashMap(16){
        {
            this.put("upm_adduserrole", "upm_userrole");
            this.put("upm_addroleorg", "upm_roleorg");
            this.put("upm_addrolematerialmod", "upm_rolematerial");
            this.put("upm_addroleaction", "upm_roleaction");
        }
    };
    private static final String ADDUSER = "adduser";
    private static final String ADDORG = "addorg";
    private static final String ADDMATERIALMOD = "addmaterialmod";
    private static final String ADDACTION = "addaction";
    private static final String BILLLISTAP = "billlistap";

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        FormOperate formOperate = (FormOperate)e.getSource();
        String key = formOperate.getOperateKey();
        if (ADDUSER.equals(key) || ADDORG.equals(key) || ADDMATERIALMOD.equals(key) || ADDACTION.equals(key)) {
            BillList billlist = (BillList)this.getControl(BILLLISTAP);
            List<Object> entryPriList = billlist.getSelectedRows().stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
            if (ADDUSER.equals(key)) {
                this.showDefineView("upm_adduserrole", ADDUSER, entryPriList);
            }
            if (ADDORG.equals(key)) {
                this.showDefineView("upm_addroleorg", ADDORG, entryPriList);
            }
            if (ADDMATERIALMOD.equals(key)) {
                this.showDefineView("upm_addrolematerialmod", ADDMATERIALMOD, entryPriList);
            }
            if (ADDACTION.equals(key)) {
                this.showDefineView("upm_addroleaction", ADDACTION, entryPriList);
            }
        }
    }

    private void showDefineView(String formId, String opKey, List<Object> entryPriList) {
        FormShowParameter parameterShow = new FormShowParameter();
        parameterShow.setFormId(formId);
        parameterShow.setCustomParam("roleinfo", entryPriList);
        parameterShow.setCustomParam("entity", (Object)this.kv.get(formId));
        parameterShow.setCloseCallBack(new CloseCallBack((IFormPlugin)this, opKey));
        parameterShow.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(parameterShow);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String result;
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        if ((ADDUSER.equals(actionId) || ADDORG.equals(actionId) || ADDMATERIALMOD.equals(actionId) || ADDACTION.equals(actionId)) && "true".equals(result = (String)evt.getReturnData())) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5206\u914d\u6210\u529f", (String)"VehicleRoleListPlugin_0", (String)"scmc-upm-form", (Object[])new Object[0]));
        }
    }
}

