/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.upm.formplugin.workbench;

import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.filter.CompareTypeEnum;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scmc.upm.business.WorkBenchExecuteHelper;

public class UpmWorkbenchExeLogListPlugin
extends AbstractListPlugin {
    private static final Log logger = LogFactory.getLog(UpmWorkbenchExeLogListPlugin.class);
    private static final String REPEATSYMBOL = "repeatexe";
    private static final String BILLLISTAP = "billlistap";

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        CommonFilterColumn filterColumn = (CommonFilterColumn)args.getFilterColumn("creator.number");
        if (filterColumn != null) {
            filterColumn.setConstantDefaultValue((Object)CompareTypeEnum.CURRENTUSER.getId());
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String k = e.getOperateKey();
        if (REPEATSYMBOL.equals(k)) {
            BillList billList = (BillList)this.getControl(BILLLISTAP);
            Long exeLogId = (Long)billList.getCurrentSelectedRowInfo().getPrimaryKeyValue();
            DynamicObject currentLog = BusinessDataServiceHelper.loadSingleFromCache((Object)exeLogId, (String)"upm_wb_exelog");
            String status = currentLog.getString("status");
            if (!"B".equals(status)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u6267\u884c\u72b6\u6001\u662f\u5931\u8d25\u624d\u80fd\u91cd\u8bd5\u3002", (String)"UpmWorkbenchExeLogListPlugin_0", (String)"scmc-upm-form", (Object[])new Object[0]));
                return;
            }
            try {
                Long masterFileId = (Long)currentLog.getDynamicObject("masterfile").getPkValue();
                Long actionId = (Long)currentLog.getDynamicObject("action").getPkValue();
                String parameter = currentLog.getString("parameter_tag");
                List paramsList = SerializationUtils.fromJsonStringToList((String)parameter, Object.class);
                WorkBenchExecuteHelper.retryExecute(masterFileId, actionId, paramsList, exeLogId);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u91cd\u8bd5\u6210\u529f", (String)"UpmWorkbenchExeLogListPlugin_1", (String)"scmc-upm-form", (Object[])new Object[0]));
            }
            catch (Exception exp) {
                this.getView().showErrorNotification(exp.getMessage());
                String expMsg = exp.getMessage().concat(Arrays.toString(exp.getStackTrace()));
                logger.error("\u65e5\u5fd7\u91cd\u8bd5\u65f6\u51fa\u73b0\u5982\u4e0b\u5f02\u5e38:{}", (Object)expMsg);
                return;
            }
        }
    }
}

