/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.upm.formplugin.workbench;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.olap.util.Pair;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.print.api.PrintTask;
import kd.bos.print.api.PrintWork;
import kd.bos.print.core.service.PrtAttach;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.scmc.upm.business.CreateBizBillHelper;
import kd.scmc.upm.business.MasterRelationHelper;
import kd.scmc.upm.business.PushServiceHelper;
import kd.scmc.upm.business.RoleDataIsolationHelper;
import kd.scmc.upm.business.UpmActionHelper;
import kd.scmc.upm.business.WorkBenchExecuteHelper;
import kd.scmc.upm.business.action.PrintActionModel;
import kd.scmc.upm.business.actionform.ActionFormCfgHelper;
import kd.scmc.upm.business.actionform.MasterActionFormCfg;
import kd.scmc.upm.common.consts.UpmStateField;
import kd.scmc.upm.common.util.FormUtil;
import kd.sdk.scmc.upm.extpoint.ExtDataDefineInfo;

public class UpmWorkbenchPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener,
HyperLinkClickListener,
RowClickEventListener {
    private static final Log logger = LogFactory.getLog(UpmWorkbenchPlugin.class);
    private static final String EXEOP = "exeop";
    private static final String QUERY = "query";
    private static final String QUERYPANEL = "querypanel";
    private static final String COMMONFILTERSYMBOL = "commonfiltersymbol";
    private static final String TRUE = "true";

    public void registerListener(EventObject e) {
        FormUtil.addF7Listener(this, "action", "qry_org", "qry_material");
        this.addClickListeners(new String[]{"commonfilter", EXEOP});
        EntryGrid control = (EntryGrid)this.getControl("entry");
        if (control != null) {
            control.addHyperClickListener((HyperLinkClickListener)this);
            control.addRowClickListener((RowClickEventListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        long orgId = RequestContext.get().getOrgId();
        boolean exist = RoleDataIsolationHelper.isExist(orgId);
        if (exist) {
            this.getModel().setValue("qry_org", (Object)orgId);
        }
    }

    public void entryRowClick(RowClickEvent e) {
        IDataModel model;
        DynamicObject action;
        EntryGrid entry = (EntryGrid)e.getSource();
        String entryKey = entry.getEntryKey();
        if ("entry".equals(entryKey) && (action = (DynamicObject)(model = this.getModel()).getValue("action")) != null) {
            model.setValue("action", null);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        e.setCheckDataChange(false);
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "action": {
                this.beforeSelectAction(e);
                break;
            }
            case "qry_material": {
                List<Long> userRoleVehicleList = RoleDataIsolationHelper.getUserRoleVehicleList();
                QFilter vehicleQFilter = new QFilter("id", "in", userRoleVehicleList);
                ListShowParameter show = (ListShowParameter)e.getFormShowParameter();
                show.getListFilterParameter().setFilter(vehicleQFilter);
                break;
            }
            case "qry_org": {
                List<Long> userRoleOrgList = RoleDataIsolationHelper.getUserRoleOrgList(0L);
                QFilter roleQFilter = new QFilter("id", "in", userRoleOrgList);
                ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
                showParameter.getListFilterParameter().setFilter(roleQFilter);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String operateKey;
        switch (operateKey = e.getOperateKey()) {
            case "query": {
                this.queryAndShowData();
                break;
            }
        }
    }

    public void queryAndShowData() {
        int masterFileSize;
        IDataModel model = this.getModel();
        model.deleteEntryData("entry");
        List<ExtDataDefineInfo> extDataInfoList = WorkBenchExecuteHelper.getExtDataInfo(this.getModel());
        Map<String, DynamicObject> kv = WorkBenchExecuteHelper.getMasterCombCfg();
        String queryFields = this.getQueryFields();
        queryFields = this.getFullQueryFields(queryFields, extDataInfoList, kv);
        DataSet masterFileList = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"upm_masterfile", (String)queryFields, (QFilter[])this.getQFilter(), null);
        ArrayList extFields = new ArrayList(16);
        if (extDataInfoList != null && extDataInfoList.size() > 0) {
            for (ExtDataDefineInfo extInfo : extDataInfoList) {
                DynamicObject vl;
                String billSymbol = extInfo.getBillSymbol();
                DataSet extDataSet = extInfo.getExtDataSet();
                List fields = extInfo.getFields();
                if (billSymbol == null || extDataSet == null || fields == null || (vl = kv.get(billSymbol)) == null) continue;
                queryFields = queryFields.concat(",").concat(String.join((CharSequence)",", fields));
                String masterField = vl.getString("masterfield");
                String additionalField = vl.getString("additionalfield");
                masterFileList = masterFileList.join(extDataSet).on(masterField, additionalField).select(queryFields.split(",")).finish();
                extFields.addAll(extInfo.getFields());
            }
        }
        if ((masterFileSize = masterFileList.copy().count("id", false)) > 0) {
            int rowIndex = 0;
            TableValueSetter vs = new TableValueSetter(new String[0]);
            for (Row row : masterFileList) {
                vs.set("masterfile", (Object)row.getLong("id"), rowIndex);
                String[] fieldArray = "org,material,usability,location,masterrelation,mainstatus,mainstatusdate,secondarystatus,secondstatusdate,productdate,oldmasterfile,creator,createtime".split(",");
                for (String propertyField : fieldArray) {
                    vs.set(propertyField, row.get(propertyField), rowIndex);
                }
                for (String field : extFields) {
                    IDataEntityProperty property = model.getProperty(field);
                    if (property == null) continue;
                    vs.set(field, row.get(field), rowIndex);
                }
                ++rowIndex;
            }
            AbstractFormDataModel abstractFormDataModel = (AbstractFormDataModel)this.getModel();
            abstractFormDataModel.batchCreateNewEntryRow("entry", vs);
        }
        if (masterFileList != null) {
            masterFileList.close();
        }
        ((Container)this.getControl(QUERYPANEL)).setCollapse(true);
        model.setDataChanged(false);
        this.getView().updateView();
    }

    private String getFullQueryFields(String queryFields, List<ExtDataDefineInfo> extDataInfoList, Map<String, DynamicObject> kv) {
        if (extDataInfoList != null && extDataInfoList.size() > 0) {
            List<String> queryFieldList = Arrays.asList(queryFields.split(","));
            for (ExtDataDefineInfo extInfo : extDataInfoList) {
                String masterField;
                DynamicObject vl;
                String billSymbol = extInfo.getBillSymbol();
                if (StringUtils.isBlank((String)billSymbol) || (vl = kv.get(billSymbol)) == null || queryFieldList.contains(masterField = vl.getString("masterfield"))) continue;
                queryFieldList.add(masterField);
            }
            return String.join((CharSequence)",", queryFieldList);
        }
        return queryFields;
    }

    private String getQueryFields() {
        String allProperty = "org,material,usability,location,masterrelation,mainstatus,mainstatusdate,secondarystatus,secondstatusdate,productdate,oldmasterfile,creator,createtime";
        allProperty = allProperty.concat(",").concat("id");
        return allProperty;
    }

    private QFilter[] getQFilter() {
        Date createTime;
        Date secondStatusDate;
        DynamicObject secondaryStatus;
        Date mainStatusDate;
        DynamicObject mainStatus;
        DynamicObject location;
        DynamicObject usability;
        DynamicObject material;
        DynamicObject org;
        List<Long> userRoleList = RoleDataIsolationHelper.getUserRoleList();
        List<Long> roleOrgList = RoleDataIsolationHelper.getRoleOrgList(userRoleList);
        List<Long> roleVehicleList = RoleDataIsolationHelper.getRoleVehicleList(userRoleList);
        QFilter qFilter = new QFilter("org", "in", roleOrgList);
        qFilter.and("material", "in", roleVehicleList);
        IDataModel model = this.getModel();
        String number = (String)model.getValue("qry_number");
        if (StringUtils.isNotEmpty((String)number)) {
            qFilter.and("number", "=", (Object)number);
        }
        if ((org = (DynamicObject)model.getValue("qry_org")) != null) {
            qFilter.and("org", "=", org.getPkValue());
        }
        if ((material = (DynamicObject)model.getValue("qry_material")) != null) {
            qFilter.and("material", "=", material.getPkValue());
        }
        if ((usability = (DynamicObject)model.getValue("qry_usability")) != null) {
            qFilter.and("usability", "=", usability.getPkValue());
        }
        if ((location = (DynamicObject)model.getValue("qry_location")) != null) {
            qFilter.and("location", "=", location.getPkValue());
        }
        if ((mainStatus = (DynamicObject)model.getValue("qry_mainstatus")) != null) {
            qFilter.and("mainstatus", "=", mainStatus.getPkValue());
        }
        if ((mainStatusDate = (Date)model.getValue("qry_mainstatusdate")) != null) {
            qFilter.and("mainstatusdate", ">=", (Object)mainStatusDate);
            qFilter.and("mainstatusdate", "<=", (Object)WorkBenchExecuteHelper.getStartOrEndDate(mainStatusDate, true));
        }
        if ((secondaryStatus = (DynamicObject)model.getValue("qry_secondarystatus")) != null) {
            qFilter.and("secondarystatus", "=", secondaryStatus.getPkValue());
        }
        if ((secondStatusDate = (Date)model.getValue("qry_secondstatusdate")) != null) {
            qFilter.and("secondstatusdate", ">=", (Object)secondStatusDate);
            qFilter.and("secondstatusdate", "<=", (Object)WorkBenchExecuteHelper.getStartOrEndDate(secondStatusDate, true));
        }
        if ((createTime = (Date)model.getValue("qry_createtime")) != null) {
            qFilter.and("createtime", ">=", (Object)createTime);
            qFilter.and("createtime", "<=", (Object)WorkBenchExecuteHelper.getStartOrEndDate(createTime, true));
        }
        List<QFilter> commonQFilter = this.getCommonQFilter();
        commonQFilter.add(qFilter);
        return commonQFilter.toArray(new QFilter[0]);
    }

    private List<QFilter> getCommonQFilter() {
        IDataModel model = this.getModel();
        String filterJSON = (String)model.getValue("filtervalue");
        if (filterJSON != null && !"".equals(filterJSON)) {
            CRCondition condition = (CRCondition)SerializationUtils.fromJsonString((String)filterJSON, CRCondition.class);
            FilterCondition filterCondition = condition.getFilterCondition();
            FilterBuilder fb = new FilterBuilder(EntityMetadataCache.getDataEntityType((String)"upm_masterfile"), filterCondition);
            fb.buildFilter();
            return fb.getQFilters();
        }
        return new ArrayList<QFilter>();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        switch (key) {
            case "commonfilter": {
                String value = (String)newValue;
                if (value != null && !"".equals(value)) break;
                this.getModel().setValue("filtervalue", null);
                break;
            }
        }
    }

    public void click(EventObject evt) {
        String clickKey;
        block38: {
            Map<DynamicObject, Optional<DynamicObject>> masterFiledToSrcBillMap;
            DynamicObject firstMasterFile;
            boolean isAsync;
            String actionType;
            Long actionId;
            DynamicObject action;
            block42: {
                Set billNos;
                Set billIds;
                PrintActionModel.ExeResultInfo exeResultInfoPrint;
                Throwable throwable;
                TXHandle tx;
                Map<String, Object> exeResultInfoObj;
                List<Long> masterFileIds;
                block39: {
                    block40: {
                        block41: {
                            clickKey = ((Control)evt.getSource()).getKey();
                            if (!EXEOP.equals(clickKey)) break block38;
                            action = (DynamicObject)this.getModel().getValue("action");
                            if (action == null) {
                                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u52a8\u4f5c", (String)"UpmWorkbenchPlugin_0", (String)"scmc-upm-form", (Object[])new Object[0]));
                                return;
                            }
                            String number = action.getString("number");
                            if ("CRE1".equals(number) || "TIRS".equals(number)) break block38;
                            EntryGrid control = (EntryGrid)this.getControl("entry");
                            int[] selectRows = control.getSelectRows();
                            if (selectRows.length <= 0) {
                                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"UpmWorkbenchPlugin_4", (String)"scmc-upm-form", (Object[])new Object[0]));
                                return;
                            }
                            actionId = (Long)action.getPkValue();
                            DynamicObject bizOpService = WorkBenchExecuteHelper.getBizOpService(actionId);
                            if (bizOpService == null) {
                                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u52a8\u4f5c\u4e0d\u5b58\u5728\u52a8\u4f5c\u670d\u52a1\u914d\u7f6e\u3002", (String)"UpmWorkbenchPlugin_11", (String)"scmc-upm-form", (Object[])new Object[0]));
                                return;
                            }
                            actionType = bizOpService.getString("actiontype");
                            isAsync = bizOpService.getBoolean("isasync");
                            List<DynamicObject> masterFiles = this.listMasterFileBySelectRow(selectRows);
                            firstMasterFile = masterFiles.get(0);
                            masterFileIds = masterFiles.stream().map(file -> file.getLong("id")).collect(Collectors.toList());
                            masterFiledToSrcBillMap = UpmActionHelper.getMasterFiledToSrcBillMap(masterFileIds);
                            if (!"PRINT".equals(actionType)) break block42;
                            exeResultInfoObj = WorkBenchExecuteHelper.getPrintActionParameter(actionId);
                            tx = TX.required((String)UpmWorkbenchPlugin.class.getName());
                            throwable = null;
                            exeResultInfoPrint = (PrintActionModel.ExeResultInfo)exeResultInfoObj.get("PRINT");
                            if (exeResultInfoPrint == null) break block38;
                            Pair<Set<Long>, Set<String>> billPair = this.getMasterFileBillPair(new ArrayList<Optional<DynamicObject>>(masterFiledToSrcBillMap.values()));
                            billIds = (Set)billPair.getValue0();
                            billNos = (Set)billPair.getValue1();
                            if (billIds != null) break block39;
                            String srcObjName = exeResultInfoPrint.getSrcObjName();
                            String msg = String.format(ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u4e3b\u6863\u4e0d\u5b58\u5728%s\u7684\u8f68\u8ff9\uff0c\u4e0d\u80fd\u6267\u884c\u6253\u5370\u64cd\u4f5c\u3002", (String)"UpmWorkbenchPlugin_8", (String)"scmc-upm-form", (Object[])new Object[0]), srcObjName);
                            this.getView().showTipNotification(msg);
                            if (tx == null) break block40;
                            if (throwable == null) break block41;
                            try {
                                tx.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            break block40;
                        }
                        tx.close();
                    }
                    return;
                }
                try {
                    try {
                        Map<String, Object> result = this.exePrintAction(exeResultInfoPrint, billIds);
                        String success = (String)result.get("success");
                        if (TRUE.equals(success)) {
                            List exeResultInfoList;
                            ArrayList<Object[]> masterFileParameter = new ArrayList<Object[]>(16);
                            PrintActionModel.ExeResultInfo exeResultInfoService = (PrintActionModel.ExeResultInfo)exeResultInfoObj.get("SERVICE");
                            ArrayList parameterList = new ArrayList(16);
                            if (exeResultInfoService != null) {
                                for (Map.Entry<DynamicObject, Optional<DynamicObject>> entry : masterFiledToSrcBillMap.entrySet()) {
                                    HashMap<String, Object> parameter = new HashMap<String, Object>(16);
                                    DynamicObject masterFile = entry.getKey();
                                    Optional<DynamicObject> billInfoOptional = entry.getValue();
                                    parameter.put("number", masterFile.getString("number"));
                                    HashMap<String, Object> moveTrackParameter = new HashMap<String, Object>(16);
                                    if (billInfoOptional.isPresent()) {
                                        DynamicObject billInfo = billInfoOptional.get();
                                        moveTrackParameter.put("billid", billInfo.getLong("id"));
                                        moveTrackParameter.put("billtype", billInfo.getDataEntityType().getName());
                                        moveTrackParameter.put("billno", billInfo.getString("billno"));
                                    }
                                    parameter.put("upm_movetrack", moveTrackParameter);
                                    parameterList.add(parameter);
                                }
                            }
                            if (parameterList.size() > 0) {
                                Object[] array_1 = new Object[]{"upm_masterfile", actionId, parameterList};
                                masterFileParameter.add(array_1);
                            }
                            if ((exeResultInfoList = (List)exeResultInfoObj.get("BIZOP")).size() > 0) {
                                for (PrintActionModel.ExeResultInfo info : exeResultInfoList) {
                                    ArrayList bizBillIdList = new ArrayList(16);
                                    bizBillIdList.addAll(billIds);
                                    ArrayList bizBillNoList = new ArrayList(16);
                                    bizBillNoList.addAll(billNos);
                                    HashMap opParameter = new HashMap(16);
                                    opParameter.put("id", bizBillIdList);
                                    opParameter.put("billno", bizBillNoList);
                                    Object[] array = new Object[]{opParameter};
                                    masterFileParameter.add(array);
                                }
                            }
                            WorkBenchExecuteHelper.execute(masterFileIds, (long)actionId, masterFileParameter);
                            this.refreshWorkBench();
                            WorkBenchExecuteHelper.preview(this.getView(), this.getView(), result.get("taskid"), (List)result.get("attachdetaillist"));
                        }
                        String expmsg = (String)result.get("expmsg");
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u6267\u884c\u6253\u5370\u52a8\u4f5c\u5f02\u5e38:", (String)"UpmWorkbenchPlugin_5", (String)"scmc-upm-form", (Object[])new Object[0]) + expmsg);
                    }
                    catch (Exception exp) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u6267\u884c\u6253\u5370\u52a8\u4f5c\u5f02\u5e38:", (String)"UpmWorkbenchPlugin_5", (String)"scmc-upm-form", (Object[])new Object[0]) + exp.getMessage());
                        tx.markRollback();
                        logger.error("\u6267\u884c\u6253\u5370\u52a8\u4f5c\u51fa\u73b0\u4e86\u5f02\u5e38:{}", (Object)Arrays.toString(exp.getStackTrace()));
                    }
                }
                catch (Throwable exp) {
                    throwable = exp;
                    throw exp;
                }
                catch (Throwable throwable3) {
                    throw throwable3;
                }
                finally {
                    if (tx != null) {
                        if (throwable != null) {
                            try {
                                tx.close();
                            }
                            catch (Throwable exp) {
                                throwable.addSuppressed(exp);
                            }
                        } else {
                            tx.close();
                        }
                    }
                }
            }
            if ("LOAD".equals(actionType)) {
                if (!this.isMultipleBill(new ArrayList<Optional<DynamicObject>>(masterFiledToSrcBillMap.values()))) {
                    this.queryAndOpenBill(action, firstMasterFile.getLong("id"));
                } else {
                    this.queryAndOpenBill(action, new ArrayList<Optional<DynamicObject>>(masterFiledToSrcBillMap.values()));
                }
            } else if ("CERBILL".equals(actionType) && !isAsync) {
                this.generateAndOpenBill(action, firstMasterFile.getLong("id"));
            } else if (ActionFormCfgHelper.isOpenPushPage(actionId)) {
                this.pushAndOpenBill(action, firstMasterFile.getLong("id"));
            } else {
                QFilter formQfilter = new QFilter("masteraction", "=", action.getPkValue());
                formQfilter.and("enable", "=", (Object)Boolean.TRUE);
                DynamicObject actionFormCfgDym = BusinessDataServiceHelper.loadSingleFromCache((String)"upm_actionformcfg", (String)"formtype,otherformid", (QFilter[])formQfilter.toArray());
                if (null != actionFormCfgDym) {
                    String formType = actionFormCfgDym.getString("formtype");
                    DynamicObject otherformid = actionFormCfgDym.getDynamicObject("otherformid");
                    String formid = "other_form".equals(formType) ? otherformid.getString("number") : formType;
                    this.showSimpleActionPage(action, formid, EXEOP);
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u52a8\u4f5c\u754c\u9762\u914d\u7f6e\u4e0d\u5b58\u5728\u6216\u5df2\u7981\u7528\u3002", (String)"UpmActionFormTplPlugin_0", (String)"scmc-upm-form", (Object[])new Object[0]));
                }
            }
        }
        if ("commonfilter".equals(clickKey)) {
            Object filterExpress = this.getModel().getValue("filtervalue");
            this.showCommonFilterView(filterExpress, "upm_masterfile", COMMONFILTERSYMBOL);
        }
    }

    private void pushAndOpenBill(DynamicObject action, long masterId) {
        Long actionId = (Long)action.getPkValue();
        DynamicObject targetBill = PushServiceHelper.pushAndSave(masterId, actionId);
        if (targetBill == null) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u52a8\u4f5c\u6ca1\u6709\u6765\u6e90\u5b9e\u4f53\u3002", (String)"UpmWorkbenchPlugin_9", (String)"scmc-upm-form", (Object[])new Object[0]), action.getString("name")));
            return;
        }
        String entityType = targetBill.getDataEntityType().getName();
        long billId = (Long)targetBill.getPkValue();
        this.showBizBillForm(entityType, billId);
    }

    private void generateAndOpenBill(DynamicObject action, long masterId) {
        long actionId = action.getLong("id");
        DynamicObject targetEntity = CreateBizBillHelper.getTargetEntity(actionId);
        if (targetEntity == null) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u52a8\u4f5c\u6ca1\u6709\u6765\u6e90\u5b9e\u4f53\u3002", (String)"UpmWorkbenchPlugin_9", (String)"scmc-upm-form", (Object[])new Object[0]), action.getString("name")));
            return;
        }
        DynamicObject cfgDym = CreateBizBillHelper.getActionFormCfg(actionId);
        MasterActionFormCfg actionFormCfg = MasterActionFormCfg.createInstance(cfgDym);
        String formId = targetEntity.getString("number");
        long billId = CreateBizBillHelper.generateBill(formId, actionFormCfg, masterId);
        this.showBizBillForm(formId, billId);
    }

    private void queryAndOpenBill(DynamicObject action, long masterId) {
        DynamicObject targetEntity = CreateBizBillHelper.getTargetEntity(action.getLong("id"));
        if (targetEntity == null) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u52a8\u4f5c\u6ca1\u6709\u6765\u6e90\u5b9e\u4f53\u3002", (String)"UpmWorkbenchPlugin_9", (String)"scmc-upm-form", (Object[])new Object[0]), action.getString("name")));
            return;
        }
        String formId = targetEntity.getString("number");
        Map<String, Object> moveTrackBillId = WorkBenchExecuteHelper.getMoveTrackBillId(formId, masterId);
        Long billId = Long.valueOf((String)moveTrackBillId.get("billid"));
        if (billId == null) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u4e3b\u6863\u4e0d\u5b58\u5728%s\u7684\u8f68\u8ff9\u3002", (String)"UpmWorkbenchPlugin_10", (String)"scmc-upm-form", (Object[])new Object[0]), targetEntity.getString("name")));
            return;
        }
        this.showBizBillForm(formId, billId);
    }

    private Map<String, Object> exePrintAction(PrintActionModel.ExeResultInfo info, Long bizBillId) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
        try {
            PrintWork work = WorkBenchExecuteHelper.getPrintWork(info.getPrintLang(), "pdf", this.getView().getPageId());
            ArrayList<PrintTask> printTaskList = new ArrayList<PrintTask>(16);
            PrintTask printTask = WorkBenchExecuteHelper.getPrintTask(info.getSrcObj(), info.getPrintTemplate());
            ArrayList<Long> bizBillIdList = new ArrayList<Long>(16);
            bizBillIdList.add(bizBillId);
            printTask.setPkIds(bizBillIdList);
            printTaskList.add(printTask);
            work.setTaskList(printTaskList);
            PrtAttach prtAttach = WorkBenchExecuteHelper.doPrint(work);
            String taskId = prtAttach.getTaskId();
            List attachDetailList = prtAttach.getAttachDetail();
            resultMap.put("success", TRUE);
            resultMap.put("taskid", taskId);
            resultMap.put("attachdetaillist", attachDetailList);
        }
        catch (Exception exp) {
            logger.error("\u8c03\u7528\u5e73\u53f0\u6253\u5370\u63a5\u53e3\u65f6\u51fa\u73b0\u4e86\u95ee\u9898:{}", (Object)exp.getMessage().concat(Arrays.toString(exp.getStackTrace())));
            resultMap.put("success", "false");
            resultMap.put("expmsg", exp.getMessage());
        }
        return resultMap;
    }

    private void showBizBillForm(String formId, long pkId) {
        BillShowParameter billShowParameter = new BillShowParameter();
        billShowParameter.setPkId((Object)pkId);
        billShowParameter.setFormId(formId);
        billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)billShowParameter);
    }

    private void showCommonFilterView(Object filterExpress, String filterEntity, String commonfiltersymbol) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("msbd_commonfilter");
        showParameter.getCustomParams().put("formula", filterExpress);
        showParameter.getCustomParams().put("entitynumber", filterEntity);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, commonfiltersymbol));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private void showSimpleActionPage(DynamicObject action, String formId, String closeBackSymbol) {
        EntryGrid control = (EntryGrid)this.getControl("entry");
        int[] selectRows = control.getSelectRows();
        DynamicObject masterFile = null;
        if (selectRows.length != 0) {
            int selectRow = selectRows[0];
            masterFile = (DynamicObject)this.getModel().getValue("masterfile", selectRow);
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(formId);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, closeBackSymbol));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("actionid", action.getPkValue());
        if (masterFile != null) {
            showParameter.setCustomParam("masterfileid", masterFile.getPkValue());
        }
        this.setMultipleParameter(showParameter);
        showParameter.setCaption(action.getString("name"));
        this.getView().showForm(showParameter);
    }

    private void refreshWorkBench() {
        this.queryAndShowData();
        this.getModel().setValue("action", null);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String conditionJson;
        String result;
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        if (EXEOP.equals(actionId) && TRUE.equals(result = (String)evt.getReturnData())) {
            this.refreshWorkBench();
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6267\u884c\u64cd\u4f5c\u6210\u529f", (String)"UpmWorkbenchPlugin_3", (String)"scmc-upm-form", (Object[])new Object[0]));
        }
        if (COMMONFILTERSYMBOL.equals(actionId) && StringUtils.isNotEmpty((String)(conditionJson = (String)evt.getReturnData()))) {
            CRCondition condition = (CRCondition)SerializationUtils.fromJsonString((String)conditionJson, CRCondition.class);
            String exprTran = condition.getExprDesc();
            this.getModel().setValue("filtervalue", (Object)conditionJson);
            this.getModel().setValue("commonfilter", (Object)exprTran);
        }
    }

    private Map<String, Object> getMoveTrackBillId(String formId) {
        int[] selectRows = ((EntryGrid)this.getControl("entry")).getSelectRows();
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entry");
        DynamicObject row = (DynamicObject)entryEntity.get(selectRows[0]);
        DynamicObject masterFile = row.getDynamicObject("masterfile");
        return WorkBenchExecuteHelper.getMoveTrackBillId(formId, (Long)masterFile.getPkValue());
    }

    private void beforeSelectAction(BeforeF7SelectEvent e) {
        EntryGrid control = (EntryGrid)this.getControl("entry");
        int[] selectRows = control.getSelectRows();
        if (selectRows.length <= 0) {
            ArrayList numberList = new ArrayList(16);
            Collections.addAll(numberList, "CRE1");
            QFilter filter = new QFilter("number", "in", numberList);
            ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
            showParameter.getListFilterParameter().setFilter(filter);
        } else {
            List<UpmStateField> stateFields = MasterRelationHelper.listUpmStateField(selectRows, this.getModel().getEntryEntity("entry"));
            Set<Long> matchedActionId = MasterRelationHelper.listMatchedActionId(stateFields);
            QFilter filter = new QFilter("id", "in", matchedActionId);
            List<Long> userRoleList = RoleDataIsolationHelper.getUserRoleList();
            List<Long> roleActionList = RoleDataIsolationHelper.getRoleActionList(userRoleList);
            QFilter roleActionQFilter = new QFilter("id", "in", roleActionList);
            filter.and(roleActionQFilter);
            ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
            showParameter.getListFilterParameter().setFilter(filter);
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        EntryGrid control = (EntryGrid)this.getControl("entry");
        int selectRow = control.getSelectRows()[0];
        DynamicObject masterFile = (DynamicObject)this.getModel().getValue("masterfile", selectRow);
        if (masterFile != null) {
            BillShowParameter fsp = new BillShowParameter();
            fsp.setFormId("upm_masterfile");
            fsp.setStatus(OperationStatus.VIEW);
            fsp.setPkId(masterFile.getPkValue());
            fsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)fsp);
        }
    }

    private void setMultipleParameter(FormShowParameter showParameter) {
        EntryGrid control = (EntryGrid)this.getControl("entry");
        int[] selectRows = control.getSelectRows();
        ArrayList<Long> masterFileIds = new ArrayList<Long>(16);
        showParameter.getCustomParams().put("multiple", selectRows.length > 1 ? "1" : "0");
        DynamicObjectCollection entry = this.getModel().getEntryEntity("entry");
        for (int rowIndex : selectRows) {
            DynamicObject entryRow = (DynamicObject)entry.get(rowIndex);
            masterFileIds.add(entryRow.getLong("masterfile.id"));
        }
        showParameter.getCustomParams().put("masterFileIds", masterFileIds);
    }

    private List<DynamicObject> listMasterFileBySelectRow(int[] selectRows) {
        ArrayList<DynamicObject> masterFiles = new ArrayList<DynamicObject>(16);
        for (int selectRow : selectRows) {
            masterFiles.add((DynamicObject)this.getModel().getValue("masterfile", selectRow));
        }
        return masterFiles;
    }

    private Map<String, Object> exePrintAction(PrintActionModel.ExeResultInfo info, Set<Long> bizBillIds) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
        try {
            PrintWork work = WorkBenchExecuteHelper.getPrintWork(info.getPrintLang(), "pdf", this.getView().getPageId());
            ArrayList<PrintTask> printTaskList = new ArrayList<PrintTask>(16);
            PrintTask printTask = WorkBenchExecuteHelper.getPrintTask(info.getSrcObj(), info.getPrintTemplate());
            ArrayList<Long> bizBillIdList = new ArrayList<Long>(16);
            bizBillIdList.addAll(bizBillIds);
            printTask.setPkIds(bizBillIdList);
            printTaskList.add(printTask);
            work.setTaskList(printTaskList);
            PrtAttach prtAttach = WorkBenchExecuteHelper.doPrint(work);
            String taskId = prtAttach.getTaskId();
            List attachDetailList = prtAttach.getAttachDetail();
            resultMap.put("success", TRUE);
            resultMap.put("taskid", taskId);
            resultMap.put("attachdetaillist", attachDetailList);
        }
        catch (Exception exp) {
            logger.error("\u8c03\u7528\u5e73\u53f0\u6253\u5370\u63a5\u53e3\u65f6\u51fa\u73b0\u4e86\u95ee\u9898:{}", (Object)exp.getMessage().concat(Arrays.toString(exp.getStackTrace())));
            resultMap.put("success", "false");
            resultMap.put("expmsg", exp.getMessage());
        }
        return resultMap;
    }

    private Pair<Set<Long>, Set<String>> getMasterFileBillPair(List<Optional<DynamicObject>> bills) {
        HashSet<Long> billIds = new HashSet<Long>(16);
        HashSet<String> billNos = new HashSet<String>(16);
        for (Optional<DynamicObject> billOptional : bills) {
            if (!billOptional.isPresent()) continue;
            DynamicObject bill = billOptional.get();
            billIds.add(bill.getLong("id"));
            billNos.add(bill.getString("billno"));
        }
        return new Pair(billIds, billNos);
    }

    private void queryAndOpenBill(DynamicObject action, List<Optional<DynamicObject>> bills) {
        DynamicObject targetEntity = CreateBizBillHelper.getTargetEntity(action.getLong("id"));
        if (targetEntity == null) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u52a8\u4f5c\u6ca1\u6709\u6765\u6e90\u5b9e\u4f53\u3002", (String)"UpmWorkbenchPlugin_9", (String)"scmc-upm-form", (Object[])new Object[0]), action.getString("name")));
            return;
        }
        String entityNumber = targetEntity.getString("number");
        HashSet<Long> billIds = new HashSet<Long>(16);
        for (Optional<DynamicObject> bill : bills) {
            if (ObjectUtils.isEmpty(bill) || !bill.isPresent()) continue;
            billIds.add(bill.get().getLong("id"));
        }
        if (ObjectUtils.isEmpty(billIds)) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u4e3b\u6863\u4e0d\u5b58\u5728%s\u7684\u8f68\u8ff9\u3002", (String)"UpmWorkbenchPlugin_10", (String)"scmc-upm-form", (Object[])new Object[0]), targetEntity.getString("name")));
            return;
        }
        this.showBizListForm(entityNumber, billIds);
    }

    private void showBizListForm(String entityNumber, Set<Long> billIds) {
        ListShowParameter parameter = new ListShowParameter();
        parameter.setBillFormId(entityNumber);
        ListFilterParameter filterParameter = new ListFilterParameter();
        filterParameter.setFilter(new QFilter("id", "in", billIds));
        parameter.setListFilterParameter(filterParameter);
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)parameter);
    }

    private boolean isMultipleBill(ArrayList<Optional<DynamicObject>> bills) {
        Set billIds = bills.stream().filter(Optional::isPresent).map(option -> ((DynamicObject)option.get()).getLong("id")).collect(Collectors.toSet());
        return billIds.size() > 1;
    }
}

