/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.upm.opplugin.validator;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.scmc.upm.business.actionform.ActionFormCfgHelper;
import org.apache.commons.lang3.ObjectUtils;

public class UpmActionFormCfgSaveValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] entities;
        for (ExtendedDataEntity entity : entities = this.getDataEntities()) {
            this.validateHead(entity);
            this.validateEntry(entity);
        }
    }

    private void validateHead(ExtendedDataEntity entity) {
        DynamicObject actionDym;
        DynamicObject botpRule;
        DynamicObject data = entity.getDataEntity();
        String formType = data.getString("formtype");
        if ("upm_createbillactionform".equals(formType)) {
            Object mappingCfgId = data.get("mappingcfg");
            Object balFieldName = data.get("balfieldname");
            if (ObjectUtils.isEmpty((Object)mappingCfgId)) {
                this.notEmpty("mappingcfg", entity);
            }
            if (ObjectUtils.isEmpty((Object)balFieldName)) {
                this.notEmpty("balfieldname", entity);
            }
        } else if ("other_form".equals(formType)) {
            String otherFormId = data.getString("otherformid");
            if (StringUtils.isBlank((CharSequence)otherFormId)) {
                this.notEmpty("otherformid", entity);
            }
        } else if ("upm_pushactionform".equals(formType) && null == (botpRule = ActionFormCfgHelper.getBotpRule((Long)(actionDym = data.getDynamicObject("masteraction")).getPkValue()))) {
            this.addErrorMessage(entity, ResManager.loadKDString((String)"\u4e3b\u6863\u52a8\u4f5c\u4e0e\u8868\u5355\u7c7b\u578b\u4e0d\u5339\u914d\u3002", (String)"UpmActionFormCfgSaveValidator_2", (String)"scmc-upm-form", (Object[])new Object[0]));
        }
    }

    private void notEmpty(String field, ExtendedDataEntity entity) {
        DynamicObject data = entity.getDataEntity();
        BillEntityType billEntityType = (BillEntityType)data.getDataEntityType();
        IDataEntityProperty property = billEntityType.findProperty(field);
        String fieldName = property.getDisplayName().getLocaleValue();
        this.addErrorMessage(entity, fieldName + ResManager.loadKDString((String)"\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"UpmActionFormCfgSaveValidator_1", (String)"scmc-upm-form", (Object[])new Object[0]));
    }

    private void validateEntry(ExtendedDataEntity entity) {
        DynamicObject data = entity.getDataEntity();
        DynamicObject actionDym = data.getDynamicObject("masteraction");
        if (null == actionDym) {
            return;
        }
        Long actionId = (Long)actionDym.getPkValue();
        boolean isOpenPushPage = ActionFormCfgHelper.isOpenPushPage(actionId);
        String formType = data.getString("formtype");
        if ("upm_pushactionform".equals(formType) && isOpenPushPage) {
            return;
        }
        DynamicObjectCollection entryRows = data.getDynamicObjectCollection("showentry");
        if (ObjectUtils.isEmpty((Object)entryRows) && !"other_form".equals(formType)) {
            this.notEmpty("showentry", entity);
            return;
        }
        for (int rowIdx = 0; rowIdx < entryRows.size(); ++rowIdx) {
            DynamicObject entryRow = (DynamicObject)entryRows.get(rowIdx);
            DynamicObject entityTypeDym = entryRow.getDynamicObject("entitytype");
            if (null == entityTypeDym) continue;
            BillEntityType billEntityType = (BillEntityType)MetadataServiceHelper.getDataEntityType((String)entityTypeDym.getString("number"));
            String fileKey = entryRow.getString("fieldkey");
            billEntityType.findProperty(fileKey);
            if (!StringUtils.isNotBlank((CharSequence)fileKey) || null != billEntityType.findProperty(fileKey)) continue;
            this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5b57\u6bb5\u6807\u8bc6\u4e0d\u5b58\u5728\u3002", (String)"UpmActionFormCfgSaveValidator_0", (String)"scmc-upm-form", (Object[])new Object[0]), rowIdx + 1));
        }
    }
}

