/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.upm.opplugin.validator;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.util.StringUtils;
import kd.scmc.upm.business.MasterfileBillConfigHelper;

public class UpmBillConfigSaveValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] entities;
        for (ExtendedDataEntity entity : entities = this.getDataEntities()) {
            DynamicObject cfg = entity.getDataEntity();
            Boolean iscreate = cfg.getBoolean("iscreate");
            if (iscreate.booleanValue()) {
                String materialCol = MasterfileBillConfigHelper.getMaterialCol(cfg);
                String orgCol = MasterfileBillConfigHelper.getOrgCol(cfg);
                if (materialCol == null) {
                    this.addErrorMessage(entity, ResManager.loadKDString((String)"\u521b\u5efa\u4e3b\u6863\u7684\u5355\u636e\u5fc5\u987b\u914d\u7f6e\u7269\u6599\u5b57\u6bb5\u7684\u6620\u5c04\u3002", (String)"UpmBillConfigSaveValidator_0", (String)"scmc-upm-form", (Object[])new Object[0]));
                }
                if (orgCol == null) {
                    this.addErrorMessage(entity, ResManager.loadKDString((String)"\u521b\u5efa\u4e3b\u6863\u7684\u5355\u636e\u5fc5\u987b\u914d\u7f6e\u7ec4\u7ec7\u5b57\u6bb5\u7684\u6620\u5c04\u3002", (String)"UpmBillConfigSaveValidator_1", (String)"scmc-upm-form", (Object[])new Object[0]));
                }
            }
            this.validEntrySrctype(entity, "mainfentry", "mainfsrctype", "mainfsrcbillcol");
            this.validEntrySrctype(entity, "trackentry", "tracksrctype", "tracksrcbillcol");
        }
    }

    private void validEntrySrctype(ExtendedDataEntity entity, String entrykey, String srctypeCol, String srcbillCol) {
        DynamicObject cfg = entity.getDataEntity();
        DynamicObjectCollection entries = cfg.getDynamicObjectCollection(entrykey);
        for (DynamicObject entry : entries) {
            String field;
            String srcbillVal;
            Integer seq = entry.getInt("seq");
            String srctype = entry.getString(srctypeCol);
            if ("A".equals(srctype) && StringUtils.isBlank((String)(srcbillVal = entry.getString(srcbillCol)))) {
                if ("mainfentry".equals(entrykey)) {
                    this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u4e3b\u6863\u5b57\u6bb5\u6620\u5c04\u884c%d \u6765\u6e90\u53d6\u503c\u7c7b\u578b\u4e3a\u6e90\u5355\u5b57\u6bb5\u65f6\u6765\u6e90\u5355\u636e\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"UpmBillConfigSaveValidator_2", (String)"scmc-upm-form", (Object[])new Object[0]), seq));
                } else if ("trackentry".equals(entrykey)) {
                    this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u8f68\u8ff9\u5b57\u6bb5\u6620\u5c04\u884c%d \u6765\u6e90\u53d6\u503c\u7c7b\u578b\u4e3a\u6e90\u5355\u5b57\u6bb5\u65f6\u6765\u6e90\u5355\u636e\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"UpmBillConfigSaveValidator_3", (String)"scmc-upm-form", (Object[])new Object[0]), seq));
                }
            }
            if ("mainfentry".equals(entrykey)) {
                field = entry.getString("mainfcol");
                if (!StringUtils.isBlank((String)field) && null != MetadataServiceHelper.getDataEntityType((String)"upm_masterfile").findProperty(field)) continue;
                this.addErrorMessage(entity, ResManager.loadKDString((String)"\u4e3b\u6863\u5b57\u6bb5\u6620\u5c04\u884c{0} \u4e3b\u6863\u5b9e\u4f53\u6807\u8bc6\u4e0d\u5b58\u5728\u3002", (String)"UpmBillConfigSaveValidator_4", (String)"scmc-upm-form", (Object[])new Object[]{seq}));
                continue;
            }
            if (!"trackentry".equals(entrykey) || !StringUtils.isBlank((String)(field = entry.getString("trackcol"))) && null != MetadataServiceHelper.getDataEntityType((String)"upm_movetrack").findProperty(field)) continue;
            this.addErrorMessage(entity, ResManager.loadKDString((String)"\u8f68\u8ff9\u5b57\u6bb5\u6620\u5c04\u884c{0} \u8f68\u8ff9\u5b9e\u4f53\u6807\u8bc6\u4e0d\u5b58\u5728\u3002", (String)"UpmBillConfigSaveValidator_5", (String)"scmc-upm-form", (Object[])new Object[]{seq}));
        }
    }
}

