/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.ebg.trd.proxy;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Date;
import java.util.Iterator;
import kd.sdk.ebg.trd.exception.SDKException;
import kd.sdk.ebg.trd.proxy.pgp.SDKPrivateKey;
import kd.sdk.ebg.trd.proxy.pgp.SDKPublicKey;
import kd.sdk.ebg.trd.proxy.pgp.SDKSecretKey;
import kd.sdk.ebg.trd.proxy.pgp.SDKSecretKeyRingCollection;
import org.apache.commons.io.IOUtils;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openpgp.PGPCompressedData;
import org.bouncycastle.openpgp.PGPCompressedDataGenerator;
import org.bouncycastle.openpgp.PGPEncryptedDataGenerator;
import org.bouncycastle.openpgp.PGPEncryptedDataList;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPLiteralData;
import org.bouncycastle.openpgp.PGPLiteralDataGenerator;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPOnePassSignatureList;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyEncryptedData;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.PGPSignatureList;
import org.bouncycastle.openpgp.PGPSignatureSubpacketGenerator;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.PGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.PGPContentVerifierBuilderProvider;
import org.bouncycastle.openpgp.operator.PGPDataEncryptorBuilder;
import org.bouncycastle.openpgp.operator.PGPKeyEncryptionMethodGenerator;
import org.bouncycastle.openpgp.operator.PublicKeyDataDecryptorFactory;
import org.bouncycastle.openpgp.operator.jcajce.JcaKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentVerifierBuilderProvider;
import org.bouncycastle.openpgp.operator.jcajce.JcePBESecretKeyDecryptorBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcePGPDataEncryptorBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcePublicKeyDataDecryptorFactoryBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcePublicKeyKeyEncryptionMethodGenerator;
import org.bouncycastle.util.io.Streams;

public class SDKPgpHelper {
    private static BouncyCastleProvider bouncyCastleProvider = null;
    private static SDKPgpHelper instance;

    private static synchronized BouncyCastleProvider getProviderInstance() {
        if (bouncyCastleProvider == null) {
            bouncyCastleProvider = new BouncyCastleProvider();
        }
        return bouncyCastleProvider;
    }

    public static synchronized SDKPgpHelper getInstance() {
        if (instance == null) {
            instance = new SDKPgpHelper();
        }
        return instance;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SDKPublicKey readPublicKey(InputStream in) throws SDKException {
        try (InputStream decoderStream = PGPUtil.getDecoderStream((InputStream)in);){
            PGPPublicKeyRingCollection pgpPub = new PGPPublicKeyRingCollection(decoderStream, (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
            PGPPublicKey key = null;
            Iterator rIt = pgpPub.getKeyRings();
            while (key == null && rIt.hasNext()) {
                PGPPublicKeyRing kRing = (PGPPublicKeyRing)rIt.next();
                Iterator kIt = kRing.getPublicKeys();
                while (kIt.hasNext()) {
                    PGPPublicKey k = (PGPPublicKey)kIt.next();
                    if (!k.isEncryptionKey()) continue;
                    key = k;
                }
            }
            if (key == null) {
                throw new SDKException("Can't find encryption key in key ring.");
            }
            SDKPublicKey sDKPublicKey = new SDKPublicKey(key);
            return sDKPublicKey;
        }
        catch (PGPException e) {
            throw new SDKException("PGPException:", e);
        }
        catch (IOException e) {
            throw new SDKException("IOException:", e);
        }
    }

    public boolean verifySignature(InputStream data, byte[] b, SDKPublicKey publicKey) throws SDKException {
        PGPSignatureList p3;
        PGPPublicKey key;
        block21: {
            key = publicKey.getPgpPublicKey();
            PGPObjectFactory pgpFact = new PGPObjectFactory(b, (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
            p3 = null;
            Object o = null;
            try {
                o = pgpFact.nextObject();
            }
            catch (IOException e) {
                throw new SDKException("IOException:", e);
            }
            if (o instanceof PGPCompressedData) {
                PGPCompressedData c1 = (PGPCompressedData)o;
                try (InputStream dataStream = c1.getDataStream();){
                    pgpFact = new PGPObjectFactory(dataStream, (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
                    p3 = (PGPSignatureList)pgpFact.nextObject();
                    break block21;
                }
                catch (PGPException e) {
                    throw new SDKException("PGPException:", e);
                }
                catch (IOException e) {
                    throw new SDKException("IOException:", e);
                }
            }
            p3 = (PGPSignatureList)o;
        }
        if (p3 != null) {
            PGPSignature sig = p3.get(0);
            try {
                sig.init((PGPContentVerifierBuilderProvider)new JcaPGPContentVerifierBuilderProvider().setProvider((Provider)SDKPgpHelper.getProviderInstance()), key);
                sig.update(IOUtils.toByteArray((InputStream)data));
                data.close();
                return sig.verify();
            }
            catch (Throwable e) {
                throw new SDKException("PGPException:", e);
            }
        }
        return false;
    }

    public byte[] createSignature(InputStream fIn, SDKPrivateKey privateKey, boolean armor) throws SDKException {
        PGPPrivateKey keyIn = privateKey.getPgpPrivateKey();
        PGPSignatureGenerator sGen = new PGPSignatureGenerator((PGPContentSignerBuilder)new JcaPGPContentSignerBuilder(keyIn.getPublicKeyPacket().getAlgorithm(), 10).setProvider((Provider)SDKPgpHelper.getProviderInstance()));
        try {
            sGen.init(0, keyIn);
        }
        catch (PGPException e) {
            throw new SDKException("PGPException:", e);
        }
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        ArmoredOutputStream aOut = new ArmoredOutputStream((OutputStream)byteOut);
        try {
            sGen.update(IOUtils.toByteArray((InputStream)fIn));
            aOut.endClearText();
            fIn.close();
            BCPGOutputStream bOut = new BCPGOutputStream((OutputStream)byteOut);
            sGen.generate().encode((OutputStream)bOut);
            if (armor) {
                aOut.close();
            }
        }
        catch (Throwable t) {
            throw new SDKException("PGPException:", t);
        }
        return byteOut.toByteArray();
    }

    public SDKPrivateKey findSecretKey(SDKSecretKey secretKey, char[] pass) throws SDKException {
        PGPSecretKey pgpSecKey = secretKey.getPgpSecretKey();
        try {
            PGPPrivateKey pgpPrivateKey = pgpSecKey.extractPrivateKey(new JcePBESecretKeyDecryptorBuilder().setProvider((Provider)SDKPgpHelper.getProviderInstance()).build(pass));
            return new SDKPrivateKey(pgpPrivateKey);
        }
        catch (PGPException e) {
            throw new SDKException("PGPException:", e);
        }
    }

    public SDKPrivateKey findSecretKey(SDKSecretKeyRingCollection secretKeyRingCollection, long keyID, char[] pass) throws SDKException {
        PGPSecretKeyRingCollection pgpSec = secretKeyRingCollection.getPgpSecretKeyRingCollection();
        try {
            PGPSecretKey pgpSecKey = pgpSec.getSecretKey(keyID);
            if (pgpSecKey == null) {
                throw new SDKException("pgpSecKey is null");
            }
            PGPPrivateKey privateKey = pgpSecKey.extractPrivateKey(new JcePBESecretKeyDecryptorBuilder().setProvider((Provider)SDKPgpHelper.getProviderInstance()).build(pass));
            return new SDKPrivateKey(privateKey);
        }
        catch (PGPException e) {
            throw new SDKException("PGPException:", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SDKSecretKey readSecretKey(InputStream input) throws SDKException {
        try (InputStream ds = PGPUtil.getDecoderStream((InputStream)input);){
            PGPSecretKeyRingCollection pgpSec = new PGPSecretKeyRingCollection(ds, (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
            Iterator keyRingIter = pgpSec.getKeyRings();
            block12: while (true) {
                if (!keyRingIter.hasNext()) throw new IllegalArgumentException("Can't find signing key in key ring.");
                PGPSecretKeyRing keyRing = (PGPSecretKeyRing)keyRingIter.next();
                Iterator keyIter = keyRing.getSecretKeys();
                while (true) {
                    if (!keyIter.hasNext()) continue block12;
                    PGPSecretKey key = (PGPSecretKey)keyIter.next();
                    if (key.isSigningKey()) {
                        SDKSecretKey secretKey;
                        SDKSecretKey sDKSecretKey = secretKey = new SDKSecretKey(key);
                        return sDKSecretKey;
                    }
                    continue;
                    break;
                }
                break;
            }
        }
        catch (Throwable t) {
            throw new SDKException("PGPException:", t);
        }
    }

    public void decryptStream(InputStream in, OutputStream out, InputStream keyIn, char[] password) throws SDKException {
        Security.addProvider((Provider)SDKPgpHelper.getProviderInstance());
        try (InputStream decoderStream2 = PGPUtil.getDecoderStream((InputStream)in);){
            PGPObjectFactory pgpF = new PGPObjectFactory(decoderStream2, (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
            Object o = pgpF.nextObject();
            PGPEncryptedDataList enc = o instanceof PGPEncryptedDataList ? (PGPEncryptedDataList)o : (PGPEncryptedDataList)pgpF.nextObject();
            Iterator it = enc.getEncryptedDataObjects();
            PGPPublicKeyEncryptedData pbe = null;
            try (InputStream keyStream = PGPUtil.getDecoderStream((InputStream)keyIn);){
                PGPSecretKeyRingCollection pgpSec = new PGPSecretKeyRingCollection(keyStream, (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
                SDKSecretKeyRingCollection secretKeyRingCollection = new SDKSecretKeyRingCollection(pgpSec);
                PGPPrivateKey sKey = null;
                while (sKey == null && it.hasNext()) {
                    pbe = (PGPPublicKeyEncryptedData)it.next();
                    SDKPrivateKey sdkPrivateKey = this.findSecretKey(secretKeyRingCollection, pbe.getKeyID(), password);
                    sKey = sdkPrivateKey.getPgpPrivateKey();
                }
                PublicKeyDataDecryptorFactory b = new JcePublicKeyDataDecryptorFactoryBuilder().setProvider((Provider)SDKPgpHelper.getProviderInstance()).setContentProvider((Provider)SDKPgpHelper.getProviderInstance()).build(sKey);
                if (pbe == null) {
                    throw new Exception("Hasn't read pgp entryData.");
                }
                try (InputStream clear = pbe.getDataStream(b);){
                    PGPObjectFactory plainFact = new PGPObjectFactory(clear, (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
                    Object message = plainFact.nextObject();
                    try (ByteArrayOutputStream actualOutput = new ByteArrayOutputStream();){
                        while (message != null) {
                            if (message instanceof PGPCompressedData) {
                                PGPCompressedData compressedData = (PGPCompressedData)message;
                                plainFact = new PGPObjectFactory(compressedData.getDataStream(), (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
                                message = plainFact.nextObject();
                            }
                            if (message instanceof PGPLiteralData) {
                                Streams.pipeAll((InputStream)((PGPLiteralData)message).getInputStream(), (OutputStream)actualOutput);
                            } else if (!(message instanceof PGPOnePassSignatureList) && !(message instanceof PGPSignatureList)) {
                                throw new PGPException("message unknown message type.");
                            }
                            message = plainFact.nextObject();
                        }
                        byte[] output = actualOutput.toByteArray();
                        out.write(output);
                    }
                }
                out.flush();
            }
        }
        catch (Throwable t) {
            throw new SDKException("PGPException", t);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException decoderStream2) {}
            }
        }
    }

    public void encryptAndSign(OutputStream out, InputStream inputStream, SDKPublicKey sdkPublicKey, SDKPrivateKey sdkPrivateKey) throws SDKException {
        PGPPublicKey encKey = sdkPublicKey.getPgpPublicKey();
        PGPPrivateKey privateKey = sdkPrivateKey.getPgpPrivateKey();
        out = new ArmoredOutputStream(out);
        try {
            PGPEncryptedDataGenerator encGen = new PGPEncryptedDataGenerator((PGPDataEncryptorBuilder)new JcePGPDataEncryptorBuilder(9).setWithIntegrityPacket(true).setSecureRandom(new SecureRandom()).setProvider((Provider)SDKPgpHelper.getProviderInstance()));
            encGen.addMethod((PGPKeyEncryptionMethodGenerator)new JcePublicKeyKeyEncryptionMethodGenerator(encKey).setProvider((Provider)SDKPgpHelper.getProviderInstance()));
            try (OutputStream encryptedOut = encGen.open(out, new byte[inputStream.available()]);){
                PGPCompressedDataGenerator comData = new PGPCompressedDataGenerator(1);
                try (OutputStream compressedData = comData.open(encryptedOut);){
                    PGPSignatureGenerator sGen = new PGPSignatureGenerator((PGPContentSignerBuilder)new JcaPGPContentSignerBuilder(privateKey.getPublicKeyPacket().getAlgorithm(), 10).setProvider((Provider)SDKPgpHelper.getProviderInstance()));
                    sGen.init(0, privateKey);
                    Iterator it = encKey.getUserIDs();
                    if (it.hasNext()) {
                        PGPSignatureSubpacketGenerator spGen = new PGPSignatureSubpacketGenerator();
                        spGen.setSignerUserID(false, (String)it.next());
                        sGen.setHashedSubpackets(spGen.generate());
                    }
                    sGen.generateOnePassVersion(false).encode(compressedData);
                    PGPLiteralDataGenerator lGen = new PGPLiteralDataGenerator();
                    try (OutputStream lOut = lGen.open(compressedData, 'b', "Sample-Data", new Date(), new byte[inputStream.available()]);){
                        byte[] data = IOUtils.toByteArray((InputStream)inputStream);
                        lOut.write(data);
                        sGen.update(data);
                        lGen.close();
                        sGen.generate().encode(compressedData);
                        comData.close();
                        compressedData.close();
                        encryptedOut.close();
                        encGen.close();
                    }
                }
            }
        }
        catch (PGPException e) {
            throw new SDKException("pgp error:", e);
        }
        catch (Exception e) {
            throw new SDKException("pgp sign process error:", e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

