/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.epm.bgmd.util.model;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.sdk.annotation.SdkPublic;
import kd.sdk.epm.bgmd.util.base.AbstractUtils;

@SdkPublic
public final class CubeUtils
extends AbstractUtils {
    public static final Log log = LogFactory.getLog(CubeUtils.class);
    public static final String MODEL_ENTITY = "epm_model";
    public static final String MODEL_FIELDS = "id,name,number,shownumber,reportType,version,datasource,creator,level";

    public static DynamicObjectCollection getModels(String fields, String userNumber) {
        DynamicObject user;
        Long userId = null;
        if (userNumber != null && (user = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_user", (String)"id,number,name", (QFilter[])new QFilter("number", "=", (Object)userNumber).toArray())) != null) {
            userId = user.getLong("id");
        }
        if (userId == null || userId == 0L) {
            userId = RequestContext.get().getCurrUserId();
        }
        DynamicObjectCollection models = new DynamicObjectCollection();
        try {
            Set _modelIds;
            Class<?> _class = Class.forName("kd.epm.eb.model.permission.MemberPermHelper");
            Method _method = _class.getMethod("getLimitedModelListByUser", Long.class);
            Object _obj = _method.invoke(null, userId);
            if (_obj instanceof Set && !(_modelIds = (Set)_obj).isEmpty()) {
                String _fields = fields != null ? fields : MODEL_FIELDS;
                QFilter _filter = new QFilter("id", "in", (Object)_modelIds);
                models = QueryServiceHelper.query((String)MODEL_ENTITY, (String)_fields, (QFilter[])_filter.toArray());
            }
        }
        catch (Exception ex) {
            log.error("f7-error:", (Throwable)ex);
            throw new KDBizException(ex.getMessage());
        }
        return models;
    }

    public static DynamicObject getModel(Long modelId, String fields) {
        CubeUtils.verifyModelId(modelId);
        String _fields = fields != null ? fields : MODEL_FIELDS;
        return BusinessDataServiceHelper.loadSingleFromCache((Object)modelId, (String)MODEL_ENTITY, (String)_fields);
    }

    public static DynamicObjectCollection getModel(String ... modelNumbers) {
        if (modelNumbers == null || modelNumbers.length == 0) {
            return new DynamicObjectCollection();
        }
        QFilter number = new QFilter("number", "in", Arrays.asList(modelNumbers));
        return QueryServiceHelper.query((String)MODEL_ENTITY, (String)MODEL_FIELDS, (QFilter[])number.toArray());
    }
}

