/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.epm.bgmd.util.model;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.sdk.annotation.SdkPublic;
import kd.sdk.epm.bgmd.util.base.AbstractUtils;

@SdkPublic
public final class DimensionUtils
extends AbstractUtils {
    public static final String DIMENSION_ENTITY = "epm_dimension";
    public static final String DIMENSION_FIELDS = "id,name,number,membermodel,shortnumber";

    public static DynamicObject getDimension(Long modelId, String dimensionNumber, String fields) {
        DimensionUtils.verifyModelId(modelId);
        DimensionUtils.verifyDimensionNumber(dimensionNumber);
        QFilter model = new QFilter("model", "=", (Object)modelId);
        QFilter number = new QFilter("number", "=", (Object)dimensionNumber);
        String _fields = fields != null && fields.trim().length() > 0 ? fields : DIMENSION_FIELDS;
        return BusinessDataServiceHelper.loadSingleFromCache((String)DIMENSION_ENTITY, (String)_fields, (QFilter[])new QFilter[]{model, number});
    }

    public static DynamicObject getDimension(Long modelId, Long dimensionId, String fields) {
        DimensionUtils.verifyModelId(modelId);
        DimensionUtils.verifyDimensionId(dimensionId);
        QFilter model = new QFilter("model", "=", (Object)modelId);
        QFilter dimension = new QFilter("id", "=", (Object)dimensionId);
        String _fields = fields != null && fields.trim().length() > 0 ? fields : DIMENSION_FIELDS;
        return BusinessDataServiceHelper.loadSingleFromCache((String)DIMENSION_ENTITY, (String)_fields, (QFilter[])new QFilter[]{model, dimension});
    }

    public static Long getDimensionId(Long modelId, String dimensionNumber) {
        DimensionUtils.verifyModelId(modelId);
        DimensionUtils.verifyDimensionNumber(dimensionNumber);
        QFilter model = new QFilter("model", "=", (Object)modelId);
        QFilter number = new QFilter("number", "=", (Object)dimensionNumber);
        DynamicObject dimension = BusinessDataServiceHelper.loadSingleFromCache((String)DIMENSION_ENTITY, (String)"id", (QFilter[])new QFilter[]{model, number});
        if (dimension != null) {
            return dimension.getLong("id");
        }
        return null;
    }
}

