/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.epm.bgmd.util.model;

import java.util.Collection;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.sdk.annotation.SdkPublic;
import kd.sdk.epm.bgmd.util.base.AbstractUtils;
import kd.sdk.epm.bgmd.util.model.DimensionUtils;

@SdkPublic
public final class MemberUtils
extends AbstractUtils {
    public static final String MEMBER_FIELDS = "id,name,number";

    public static DynamicObjectCollection getMembers(Long modelId, Long dimensionId, Collection<String> memberNumbers, String fields) {
        MemberUtils.verifyModelId(modelId);
        MemberUtils.verifyDimensionId(dimensionId);
        MemberUtils.verifyMemberNumbers(memberNumbers);
        DynamicObjectCollection members = new DynamicObjectCollection();
        DynamicObject dimension = DimensionUtils.getDimension(modelId, dimensionId, null);
        if (dimension != null) {
            QFilter modelFilter = new QFilter("model", "=", (Object)modelId);
            QFilter dimFilter = new QFilter("dimension", "=", (Object)dimensionId);
            QFilter memFilter = new QFilter("number", "in", memberNumbers);
            String _fields = fields != null && fields.trim().length() > 0 ? fields : MEMBER_FIELDS;
            members = QueryServiceHelper.query((String)dimension.getString("membermodel"), (String)_fields, (QFilter[])new QFilter[]{modelFilter, dimFilter, memFilter}, null, (int)5000);
        }
        return members;
    }
}

