/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.fi.gl.business.service.bd;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.LRUCacheMap;
import kd.bos.util.ThreadLocals;
import kd.sdk.fi.gl.interfaces.service.bd.IBaseDataFormatService;

public class BaseDataFormatServiceImpl
implements IBaseDataFormatService {
    private static final ThreadLocal<Map<String, Map<Long, String>>> CACHE = ThreadLocals.create();

    private Map<Long, String> getCacheMap(String entity) {
        LRUCacheMap cacheMap = CACHE.get();
        if (cacheMap == null) {
            cacheMap = new LRUCacheMap(32);
            CACHE.set((Map<String, Map<Long, String>>)cacheMap);
        }
        return cacheMap.computeIfAbsent((String)entity, k -> new LRUCacheMap(2000));
    }

    @Override
    public Map<Long, String> getDisplayValue(String entity, Set<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return new HashMap<Long, String>(1);
        }
        HashMap<Long, String> result = new HashMap<Long, String>(ids.size());
        Map<Long, String> cacheMap = this.getCacheMap(entity);
        HashSet<Long> notFoundIds = new HashSet<Long>(16);
        for (Long id : ids) {
            String val = cacheMap.get(id);
            if (val == null) {
                notFoundIds.add(id);
                continue;
            }
            result.put(id, val);
        }
        if (!notFoundIds.isEmpty()) {
            Map<Long, String> queryResult = this.query(entity, notFoundIds);
            for (Long notFoundId : notFoundIds) {
                String queryVal = queryResult.getOrDefault(notFoundId, "");
                cacheMap.put(notFoundId, queryVal);
                result.put(notFoundId, queryVal);
            }
        }
        return result;
    }

    private Map<Long, String> query(String entity, Set<Long> ids) {
        HashMap<Long, String> result = new HashMap<Long, String>(ids.size());
        BasedataEntityType entityType = (BasedataEntityType)EntityMetadataCache.getDataEntityType((String)entity);
        Lists.partition(new ArrayList<Long>(ids), (int)1000).forEach(partIds -> {
            Map loadFromCache = BusinessDataServiceHelper.loadFromCache((Object[])partIds.toArray(), (DynamicObjectType)entityType.getSubEntityType(Arrays.asList(entityType.getNameProperty(), entityType.getNumberProperty())));
            result.putAll(loadFromCache.entrySet().stream().collect(Collectors.toMap(x -> (Long)x.getKey(), x -> ((DynamicObject)x.getValue()).getString(entityType.getNumberProperty()) + "," + ((DynamicObject)x.getValue()).getString(entityType.getNameProperty()))));
        });
        return result;
    }
}

