/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.fi.gl.business.service.flex;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.flex.FlexEntityMetaUtils;
import kd.bos.entity.flex.FlexProperty;
import kd.bos.util.LRUCacheMap;
import kd.bos.util.StringUtils;
import kd.bos.util.ThreadLocals;
import kd.sdk.fi.gl.business.GLServiceFactory;
import kd.sdk.fi.gl.interfaces.service.bd.IBaseDataFormatService;
import kd.sdk.fi.gl.interfaces.service.flex.IFlexValueFormatService;

public class FlexValueFormatServiceImpl
implements IFlexValueFormatService {
    private static final ThreadLocal<Map<Long, String>> CACHE = ThreadLocals.create();

    private Map<Long, String> getCacheMap() {
        LRUCacheMap cacheMap = CACHE.get();
        if (cacheMap == null) {
            cacheMap = new LRUCacheMap(2000);
            CACHE.set((Map<Long, String>)cacheMap);
        }
        return cacheMap;
    }

    @Override
    public Map<Long, String> getDisplayValue(Map<Long, String> assGrpId2val) {
        if (assGrpId2val == null || assGrpId2val.isEmpty()) {
            return new HashMap<Long, String>(1);
        }
        HashMap<Long, String> result = new HashMap<Long, String>(assGrpId2val.size());
        HashMap<Long, String> notFoundParas = new HashMap<Long, String>(16);
        Map<Long, String> cacheMap = this.getCacheMap();
        assGrpId2val.forEach((assGrpId, assGrpVal) -> {
            String val = (String)cacheMap.get(assGrpId);
            if (val == null) {
                notFoundParas.put((Long)assGrpId, (String)assGrpVal);
            } else {
                result.put((Long)assGrpId, val);
            }
        });
        if (!notFoundParas.isEmpty()) {
            Map<Long, String> queryResult = this.query(notFoundParas);
            notFoundParas.forEach((assGrpId, assGrpVal) -> {
                String queryVal = queryResult.getOrDefault(assGrpId, "");
                cacheMap.put((Long)assGrpId, queryVal);
                result.put((Long)assGrpId, queryVal);
            });
        }
        return result;
    }

    private Map<Long, String> query(Map<Long, String> assGrpId2val) {
        HashMap<Long, String> result = new HashMap<Long, String>(assGrpId2val.size());
        FlexValueCollector collector = new FlexValueCollector();
        assGrpId2val.forEach(collector::collect);
        StringBuilder stringBuilder = new StringBuilder();
        collector.getAssGrpId2val().forEach((assGrpId, assGrpValMap) -> {
            stringBuilder.setLength(0);
            assGrpValMap.forEach((flexProperty, val) -> {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append("\uff1b");
                }
                stringBuilder.append(flexProperty.getGLName()).append("\uff1a");
                if ("3".equalsIgnoreCase(flexProperty.getValueType())) {
                    stringBuilder.append(val);
                } else {
                    stringBuilder.append(collector.getBaseDataFormatVal(flexProperty.getValueSource(), (Long)val));
                }
            });
            result.put((Long)assGrpId, stringBuilder.toString());
        });
        return result;
    }

    static class FlexValueCollector {
        private final Map<String, FlexProperty> flexPropertyMap = new HashMap<String, FlexProperty>(8);
        private final Map<Long, Map<FlexProperty, Object>> assGrpId2val = new HashMap<Long, Map<FlexProperty, Object>>(16);
        private final Map<String, Set<Long>> entity2Ids = new HashMap<String, Set<Long>>(16);
        private final Map<String, Map<Long, String>> baseDataFormatCache = new HashMap<String, Map<Long, String>>(16);
        private final IBaseDataFormatService baseDataFormatService = GLServiceFactory.getService(IBaseDataFormatService.class);

        FlexValueCollector() {
        }

        public Map<Long, Map<FlexProperty, Object>> getAssGrpId2val() {
            return this.assGrpId2val;
        }

        public void collect(Long assGrpId, String assGrpVal) {
            if (this.assGrpId2val.containsKey(assGrpId)) {
                return;
            }
            if (StringUtils.isEmpty((String)assGrpVal)) {
                return;
            }
            Map map = (Map)SerializationUtils.fromJsonString((String)assGrpVal, Map.class);
            HashMap valMap = new HashMap(map.size());
            map.forEach((k, v) -> {
                FlexProperty flexProperty = this.flexPropertyMap.computeIfAbsent((String)k, FlexEntityMetaUtils::getFlexProperty);
                if (flexProperty != null) {
                    if (!"3".equalsIgnoreCase(flexProperty.getValueType())) {
                        v = Long.valueOf(v.toString());
                        String valueSource = flexProperty.getValueSource();
                        if (StringUtils.isNotEmpty((String)valueSource)) {
                            this.entity2Ids.computeIfAbsent(valueSource, flex -> new HashSet(16)).add((Long)v);
                        }
                    }
                    valMap.put(flexProperty, v);
                }
            });
            this.assGrpId2val.put(assGrpId, valMap);
        }

        String getBaseDataFormatVal(String entity, Long id) {
            Map cacheMap = this.baseDataFormatCache.computeIfAbsent(entity, k -> this.baseDataFormatService.getDisplayValue((String)k, this.entity2Ids.get(k)));
            return cacheMap.computeIfAbsent(id, k -> "");
        }
    }
}

