/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.hr.common.helper;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;

public class HpfsMetaDataServiceHelper {
    public static final HRBaseServiceHelper FORMMETA_SERVICE_HELPER = new HRBaseServiceHelper("bos_formmeta");
    private static final String PARENTID_NUMBER = "parentid.number";
    private static final String HPFS_HRHOMBILLORGTPL = "hpfs_hrhombillorgtpl";
    private static final String HPFS_HRHOMBILLORGTPL_ID = "3VJ+MQIXAJL3";
    private static final String INHERITPATH = "inheritpath";

    public static Set<String> getAllParentAndSelfEntityName(String entityNum, String bizAppId) {
        HashSet<String> entityNums = new HashSet<String>(16);
        entityNums.add(entityNum);
        if (StringUtils.isBlank((CharSequence)bizAppId)) {
            DynamicObject dynamicObject = FORMMETA_SERVICE_HELPER.queryOne("parentid.number,bizappid", new QFilter[]{new QFilter("number", "=", (Object)entityNum)});
            bizAppId = dynamicObject.getString("bizappid");
        }
        String tmpEntityNum = entityNum;
        while ((tmpEntityNum = HpfsMetaDataServiceHelper.getParentEntityName(tmpEntityNum, bizAppId, entityNums)) != null) {
        }
        return entityNums;
    }

    private static String getParentEntityName(String entityNum, String bizAppId, Set<String> entityNums) {
        DynamicObject dynamicObject = FORMMETA_SERVICE_HELPER.queryOne("parentid.number,bizappid", new QFilter[]{new QFilter("number", "=", (Object)entityNum), new QFilter("bizappid", "=", (Object)bizAppId)});
        if (Objects.isNull(dynamicObject)) {
            return null;
        }
        String parentNum = dynamicObject.getString(PARENTID_NUMBER);
        if (StringUtils.isBlank((CharSequence)parentNum) || parentNum.equals(entityNum)) {
            return null;
        }
        entityNums.add(entityNum);
        return parentNum;
    }

    public static boolean isInhTpl(String parentEntityNum, String pageParentId, String entityNum) {
        if (parentEntityNum.equals(entityNum)) {
            return true;
        }
        String parentNum = entityNum;
        AtomicBoolean flag = new AtomicBoolean(false);
        while ((parentNum = HpfsMetaDataServiceHelper.getParentId(pageParentId, parentNum, flag)) != null && !flag.get()) {
        }
        return flag.get();
    }

    public static boolean isHomTpl(String entityNum) {
        if (HPFS_HRHOMBILLORGTPL.equals(entityNum)) {
            return true;
        }
        String parentNum = entityNum;
        AtomicBoolean flag = new AtomicBoolean(false);
        while ((parentNum = HpfsMetaDataServiceHelper.getParentId(HPFS_HRHOMBILLORGTPL_ID, parentNum, flag)) != null && !flag.get()) {
        }
        return flag.get();
    }

    private static String getParentId(String pageParentId, String entityNum, AtomicBoolean flag) {
        DynamicObject dynamicObject = FORMMETA_SERVICE_HELPER.queryOne(PARENTID_NUMBER, new QFilter[]{new QFilter("number", "=", (Object)entityNum)});
        if (Objects.isNull(dynamicObject)) {
            return null;
        }
        String parentId = dynamicObject.getString("parentid.id");
        if (pageParentId.equals(parentId)) {
            flag.set(true);
            return null;
        }
        String parentNum = dynamicObject.getString(PARENTID_NUMBER);
        if (StringUtils.isBlank((CharSequence)parentNum) || parentNum.equals(entityNum)) {
            return null;
        }
        return parentNum;
    }

    public static DynamicObject[] getChildDys() {
        QFilter qFilter1 = new QFilter(INHERITPATH, "like", (Object)"%15VVWN7=X+QW%");
        QFilter qFilter2 = new QFilter(INHERITPATH, "like", (Object)"%29W29SXLSB7N%");
        QFilter qFilter = qFilter1.or(qFilter2);
        DynamicObject[] dys = FORMMETA_SERVICE_HELPER.query("number", new QFilter[]{qFilter});
        List<String> numbers = Arrays.stream(dys).map(data -> data.getString("number")).collect(Collectors.toList());
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("bos_objecttype");
        return serviceHelper.loadDynamicObjectArray((Object[])numbers.toArray(new String[0]));
    }
}

