/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.hr.common.plugin;

import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.datamodel.events.BeforeSetItemValueEventArgs;
import kd.bos.entity.datamodel.events.IDataModelChangeListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.AfterBindingDataEvent;
import kd.bos.form.field.events.BasedataEditListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.sdk.hr.hpfs.common.constants.PerChgNewBillTplConstants;
import kd.sdk.hr.hpfs.utils.PerChgNewBillUtils;

public class CmpEmpDisplayPropDyExt
extends AbstractFormPlugin
implements BasedataEditListener,
IDataModelChangeListener,
PerChgNewBillTplConstants {
    private static final Log LOGGER = LogFactory.getLog(CmpEmpDisplayPropDyExt.class);

    public void initialize() {
        super.initialize();
        DataEntityPropertyCollection properties = this.getModel().getDataEntityType().getProperties();
        List<String> cmpEmpFields = this.getModel().getDataEntityType().getProperties().stream().filter(data -> data.getName().endsWith("_cmpemp")).map(IMetadata::getName).collect(Collectors.toList());
        cmpEmpFields.forEach(data -> {
            BasedataEdit cmpEmp = (BasedataEdit)this.getControl((String)data);
            cmpEmp.addBasedataEditListener((BasedataEditListener)this);
        });
        try {
            List<String> entryList = PerChgNewBillUtils.getEntryList(properties, "entry_");
            entryList.forEach(data -> {
                for (IDataEntityProperty property : this.getModel().getEntryEntity(data).getDynamicObjectType().getProperties()) {
                    if (!property.getName().endsWith("_cmpemp")) continue;
                    BasedataEdit cmpEmp = (BasedataEdit)this.getControl(property.getName());
                    cmpEmp.addBasedataEditListener((BasedataEditListener)this);
                }
            });
        }
        catch (Exception exception) {
            LOGGER.warn((Throwable)exception);
        }
    }

    public void afterBindingData(AfterBindingDataEvent evt) {
        BasedataEdit edit = (BasedataEdit)evt.getSource();
        if (edit == null || edit.getKey() == null || !edit.getKey().endsWith("_cmpemp")) {
            return;
        }
        Object value = evt.getDataEntity();
        if (!(value instanceof DynamicObject)) {
            return;
        }
        String displayProp = ((DynamicObject)value).getString("managingscope.name");
        String editSearchProp = ((DynamicObject)value).getString("managingscope.number");
        evt.setDisplayProp(displayProp == null ? "" : displayProp.toString());
        evt.setEditSearchProp(editSearchProp == null ? "" : editSearchProp.toString());
    }

    public void beforeSetItemValue(BeforeSetItemValueEventArgs arg) {
        Object value = arg.getValue();
        if (value == null) {
            return;
        }
        IDataEntityProperty property = arg.getProperty();
        if (property == null || property.getName() == null || !property.getName().endsWith("_cmpemp")) {
            return;
        }
        String searchKey = "managingscope.name";
        String[] split = value.toString().split(",|;");
        String[] qfliterArr = new String[split.length];
        for (int i = 0; i < split.length; ++i) {
            qfliterArr[i] = split[i].split("[( )]")[0];
        }
        arg.setSearchKey(searchKey);
        arg.setSearchArgs(qfliterArr);
    }
}

