/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.hr.common.plugin.perm;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.sdk.hr.common.plugin.perm.service.BizMserviceInvokeService;
import kd.sdk.hr.common.plugin.perm.service.DataFilterService;
import kd.sdk.hr.common.plugin.perm.service.DimValueResultDTO;
import kd.sdk.hr.common.plugin.perm.service.FieldConfigMap;
import kd.sdk.hr.common.plugin.perm.service.FieldNameInfo;
import kd.sdk.hr.common.plugin.perm.service.PositionTypeEnum;

public class CommonPermissionEdit
extends HRDataBaseEdit
implements BeforeF7SelectListener {
    private static final Log LOG = LogFactory.getLog(CommonPermissionEdit.class);
    private static final String ORGDESIGNPERM = "OrgdesignPerm";
    private static final String ORGTEAMPERM = "OrgteamPerm";
    private static final String STDPOS_FILTER = "STDPOS_FILTER";
    private FieldNameInfo fieldNameInfo;
    private DynamicObject curEntity;

    private FieldNameInfo getFieldInfo() {
        if (this.fieldNameInfo == null) {
            String entityId = this.getView().getEntityId();
            this.fieldNameInfo = FieldConfigMap.getFieldName(entityId);
        }
        return this.fieldNameInfo;
    }

    private void initValue(BeforeF7SelectEvent evt) {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        String entryKey = ((BasedataEdit)evt.getSource()).getEntryKey();
        int row = evt.getRow();
        DynamicObject entry = null;
        if (HRStringUtils.isNotEmpty((String)entryKey) && row >= 0) {
            entry = (DynamicObject)dataEntity.getDynamicObjectCollection(entryKey).get(row);
        }
        for (String fieldName : this.getFieldInfo().getFieldNames()) {
            long value;
            if (dataEntity.containsProperty(fieldName)) {
                value = this.getDynamicObjectFieldId(dataEntity, fieldName);
                this.getFieldInfo().getFieldValueMap().put(fieldName, value);
            }
            if (entry == null || !entry.containsProperty(fieldName)) continue;
            value = this.getDynamicObjectFieldId(entry, fieldName);
            this.getFieldInfo().getFieldValueMap().put(fieldName, value);
        }
        LOG.info("beforef7_initvalue_data [" + this.getFieldInfo().toString() + "]");
    }

    private void initCurEntity(PropertyChangedArgs args) {
        ChangeData changeData = args.getChangeSet()[0];
        this.curEntity = changeData.getDataEntity();
        DynamicObject dataEntity = this.getModel().getDataEntity();
        for (String fieldName : this.getFieldInfo().getFieldNames()) {
            long value;
            if (dataEntity.containsProperty(fieldName)) {
                value = this.getDynamicObjectFieldId(dataEntity, fieldName);
                this.getFieldInfo().getFieldValueMap().put(fieldName, value);
            }
            if (changeData.getRowIndex() < 0 || !this.curEntity.containsProperty(fieldName)) continue;
            value = this.getDynamicObjectFieldId(this.curEntity, fieldName);
            this.getFieldInfo().getFieldValueMap().put(fieldName, value);
        }
        LOG.info("propertychanged_initvalue_data [" + this.getFieldInfo().toString() + "]");
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        for (String fieldName : this.getFieldInfo().getRegisterFieldNames()) {
            BasedataEdit basedataEdit;
            if (HRStringUtils.isEmpty((String)fieldName) || (basedataEdit = (BasedataEdit)this.getView().getControl(fieldName)) == null) continue;
            basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String fieldKey = evt.getProperty().getName();
        if (!this.getFieldInfo().getRegisterFieldNames().contains(fieldKey)) {
            return;
        }
        this.initValue(evt);
        this.setPositionFilter(evt, fieldKey);
        this.setStdPositionFilter(evt, fieldKey);
        this.setJobFilter(evt, fieldKey);
        this.setJobGradeScmFilter(evt, fieldKey);
        this.setJobLevelScmFilter(evt, fieldKey);
        this.setJobGradeFilter(evt, fieldKey);
        this.setJobLevelFilter(evt, fieldKey);
    }

    private void setPositionFilter(BeforeF7SelectEvent evt, String fieldKey) {
        if (!HRStringUtils.equals((String)fieldKey, (String)this.getFieldInfo().getPositionFieldName())) {
            return;
        }
        long adminorgId = this.getFieldInfo().getFieldValue(this.getFieldInfo().getAdminOrgFieldName());
        if (adminorgId != 0L) {
            evt.getFormShowParameter().setCustomParam("adminorg.id", (Object)adminorgId);
            this.addQFilter(evt, new QFilter("adminorg.id", "=", (Object)adminorgId));
        }
    }

    private void setStdPositionFilter(BeforeF7SelectEvent evt, String fieldKey) {
        if (!HRStringUtils.equals((String)fieldKey, (String)this.getFieldInfo().getStdPositionFieldName())) {
            return;
        }
        this.setOrgDesignUseOrgId(evt, this.getFieldInfo().isFollowOrgDesign());
        long adminorgId = this.getFieldInfo().getFieldValue(this.getFieldInfo().getAdminOrgFieldName());
        QFilter filter = this.getStdQfilterFromCache(adminorgId);
        if (filter == null) {
            if (adminorgId == 0L) {
                DimValueResultDTO dimValueWithSub = this.getOrgTeamPerm();
                if (dimValueWithSub != null && !dimValueWithSub.isAll()) {
                    filter = DataFilterService.getInstance().getQFilterWithStdposition(dimValueWithSub.getOrgIds());
                }
            } else {
                filter = DataFilterService.getInstance().getQFilterWithStdposition(adminorgId);
            }
            if (filter == null) {
                filter = new QFilter("1", "=", (Object)1);
            }
            this.getPageCache().put(STDPOS_FILTER + adminorgId, filter.toSerializedString());
        }
        this.addQFilter(evt, filter);
    }

    private QFilter getStdQfilterFromCache(long adminorgId) {
        String filterStr = this.getPageCache().get(STDPOS_FILTER + adminorgId);
        if (HRStringUtils.isEmpty((String)filterStr)) {
            return null;
        }
        return QFilter.fromSerializedString((String)filterStr);
    }

    private void setJobFilter(BeforeF7SelectEvent evt, String fieldKey) {
        if (!HRStringUtils.equals((String)fieldKey, (String)this.getFieldInfo().getJobFieldName())) {
            return;
        }
        this.setOrgDesignUseOrgId(evt, this.getFieldInfo().isFollowOrgDesign());
    }

    private void setJobGradeScmFilter(BeforeF7SelectEvent evt, String fieldKey) {
        if (!HRStringUtils.equals((String)fieldKey, (String)this.getFieldInfo().getJobGradeScmFieldName())) {
            return;
        }
        this.setOrgDesignUseOrgId(evt, true);
        QFilter filter = DataFilterService.getInstance().getQFilterWithJobgradeScm(this.getFieldInfo());
        if (!HRObjectUtils.isEmpty((Object)filter)) {
            this.addQFilter(evt, filter);
        }
    }

    private void setJobLevelScmFilter(BeforeF7SelectEvent evt, String fieldKey) {
        if (!HRStringUtils.equals((String)fieldKey, (String)this.getFieldInfo().getJobLevelScmFieldName())) {
            return;
        }
        this.setOrgDesignUseOrgId(evt, true);
        QFilter filter = DataFilterService.getInstance().getQFilterWithJoblevelScm(this.getFieldInfo());
        if (!HRObjectUtils.isEmpty((Object)filter)) {
            this.addQFilter(evt, filter);
        }
    }

    private void setJobGradeFilter(BeforeF7SelectEvent evt, String fieldKey) {
        if (!HRStringUtils.equals((String)fieldKey, (String)this.getFieldInfo().getJobGradeFieldName())) {
            return;
        }
        QFilter filter = DataFilterService.getInstance().getQFilterWithJobGrade(this.getFieldInfo());
        if (!HRObjectUtils.isEmpty((Object)filter)) {
            this.addQFilter(evt, filter);
        } else {
            long orgdesignId = this.getFieldInfo().getFieldValue(this.getFieldInfo().getJobScmOrgFieldName());
            if (orgdesignId != 0L) {
                filter = DataFilterService.getInstance().getJobGradeScmQFilterWithUseorgIdList(Collections.singletonList(orgdesignId));
                if (!HRObjectUtils.isEmpty((Object)filter)) {
                    this.addQFilter(evt, filter);
                }
            } else {
                DimValueResultDTO dimValueWithSub = this.getPermOrgList();
                if (dimValueWithSub != null && !dimValueWithSub.isAll() && !HRObjectUtils.isEmpty((Object)(filter = DataFilterService.getInstance().getJobGradeScmQFilterWithUseorgIdList(this.getPermOrgList().getOrgIds())))) {
                    this.addQFilter(evt, filter);
                }
            }
        }
    }

    private void setJobLevelFilter(BeforeF7SelectEvent evt, String fieldKey) {
        if (!HRStringUtils.equals((String)fieldKey, (String)this.getFieldInfo().getJobLevelFieldName())) {
            return;
        }
        QFilter filter = DataFilterService.getInstance().getQFilterWithJobLevel(this.getFieldInfo());
        if (!HRObjectUtils.isEmpty((Object)filter)) {
            this.addQFilter(evt, filter);
        } else {
            long orgdesignId = this.getFieldInfo().getFieldValue(this.getFieldInfo().getJobScmOrgFieldName());
            if (orgdesignId != 0L) {
                filter = DataFilterService.getInstance().getJobLevelScmQFilterWithUseorgIdList(Collections.singletonList(orgdesignId));
                if (!HRObjectUtils.isEmpty((Object)filter)) {
                    this.addQFilter(evt, filter);
                }
            } else {
                DimValueResultDTO dimValueWithSub = this.getPermOrgList();
                if (dimValueWithSub != null && !dimValueWithSub.isAll() && !HRObjectUtils.isEmpty((Object)(filter = DataFilterService.getInstance().getJobLevelScmQFilterWithUseorgIdList(this.getPermOrgList().getOrgIds())))) {
                    this.addQFilter(evt, filter);
                }
            }
        }
    }

    private DynamicObject getDynamicObjectValue(DynamicObject entity, String fieldName) {
        Object value;
        if (entity.containsProperty(fieldName) && (value = entity.get(fieldName)) instanceof DynamicObject) {
            return (DynamicObject)value;
        }
        return null;
    }

    private long getDynamicObjectFieldId(DynamicObject entity, String fieldName) {
        if (entity == null) {
            return 0L;
        }
        if (HRStringUtils.equals((String)fieldName, (String)this.getFieldInfo().getPositionTypeFieldName()) && HRStringUtils.isNotEmpty((String)entity.getString(fieldName))) {
            return Long.parseLong(entity.getString(fieldName));
        }
        if (!entity.containsProperty(fieldName)) {
            return 0L;
        }
        Object fieldValue = entity.get(fieldName);
        if (fieldValue == null) {
            return 0L;
        }
        if (fieldValue instanceof DynamicObject) {
            return ((DynamicObject)fieldValue).getLong("id");
        }
        return fieldValue instanceof Long ? (Long)fieldValue : 0L;
    }

    private DimValueResultDTO getPermOrgList() {
        String entityNum = this.getView().getEntityId();
        String orgdesignPerm = this.getPageCache().get(ORGDESIGNPERM);
        if (!HRStringUtils.isEmpty((String)orgdesignPerm)) {
            return (DimValueResultDTO)((Object)JSONObject.parseObject((String)orgdesignPerm, DimValueResultDTO.class));
        }
        DimValueResultDTO permResult = DataFilterService.getInstance().getOrgDesignPerm(entityNum);
        this.getPageCache().put(ORGDESIGNPERM, JSONObject.toJSONString((Object)((Object)permResult)));
        return permResult;
    }

    private DimValueResultDTO getOrgTeamPerm() {
        String entityNum = this.getView().getEntityId();
        String orgdesignPerm = this.getPageCache().get(ORGTEAMPERM);
        if (!HRStringUtils.isEmpty((String)orgdesignPerm)) {
            return (DimValueResultDTO)((Object)JSONObject.parseObject((String)orgdesignPerm, DimValueResultDTO.class));
        }
        DimValueResultDTO permResult = DataFilterService.getInstance().getOrgTeamPerm(entityNum, this.getFieldInfo().getAdminOrgFieldName());
        this.getPageCache().put(ORGTEAMPERM, JSONObject.toJSONString((Object)((Object)permResult)));
        return permResult;
    }

    private void setOrgDesignUseOrgId(BeforeF7SelectEvent evt, boolean followOrgDesign) {
        long orgdesignId = this.getFieldInfo().getFieldValue(this.getFieldInfo().getJobScmOrgFieldName());
        ListShowParameter parameter = (ListShowParameter)evt.getFormShowParameter();
        if (orgdesignId != 0L && followOrgDesign) {
            parameter.setUseOrgIds(Collections.singletonList(orgdesignId));
        } else {
            DimValueResultDTO dimValueWithSub;
            List qfilters = parameter.getListFilterParameter().getQFilters();
            if (!CollectionUtils.isEmpty((Collection)qfilters)) {
                qfilters.removeIf(qFilter -> HRStringUtils.equals((String)"ctrlstrategy", (String)qFilter.getProperty()));
                parameter.setUseOrgId(0L);
            }
            if ((dimValueWithSub = this.getPermOrgList()) != null && !dimValueWithSub.isAll()) {
                parameter.setUseOrgIds(dimValueWithSub.getOrgIds());
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        if (!this.getFieldInfo().isDoPropertychange()) {
            return;
        }
        String fieldKey = args.getProperty().getName();
        if (!this.getFieldInfo().getRegisterFieldNames().contains(fieldKey)) {
            return;
        }
        this.initCurEntity(args);
        this.setValueByPosition(fieldKey);
        this.setValueByStdPosition(fieldKey);
        this.setValueByJob(fieldKey);
        this.setValueByJobGradeScm(fieldKey);
        this.setValueByJobLevelScm(fieldKey);
        this.setValueByJobGrade(fieldKey);
        this.setValueByJobLevel(fieldKey);
    }

    private void setValueByPosition(String fieldKey) {
        if (!HRStringUtils.equals((String)fieldKey, (String)this.getFieldInfo().getPositionFieldName())) {
            return;
        }
        long positionId = this.getFieldInfo().getFieldValue(fieldKey);
        if (positionId == 0L) {
            this.setNullWithJobInfo(true);
            return;
        }
        Map<String, Object> resultMap = BizMserviceInvokeService.getInstance().getHrIpositionSingle(positionId);
        if (!HRObjectUtils.isEmpty(resultMap)) {
            this.setModelValue(this.getFieldInfo().getJobScmOrgFieldName(), resultMap.get("orgdesignbu"));
            this.setModelValue(this.getFieldInfo().getJobFieldName(), resultMap.get("job"));
            this.setModelValue(this.getFieldInfo().getJobLevelScmFieldName(), resultMap.get("highjoblevel.joblevelscm"));
            this.setModelValue(this.getFieldInfo().getJobGradeScmFieldName(), resultMap.get("highjobgrade.jobgradescm"));
            this.setJobleveGradeWhenOnlyOne();
        } else {
            this.setNullWithJobInfo(true);
        }
    }

    private void setValueByStdPosition(String fieldKey) {
        if (!HRStringUtils.equals((String)fieldKey, (String)this.getFieldInfo().getStdPositionFieldName())) {
            return;
        }
        long stdPositionId = this.getFieldInfo().getFieldValue(fieldKey);
        if (stdPositionId == 0L) {
            this.setNullWithJobInfo(true);
            return;
        }
        Map<String, Object> resultMap = BizMserviceInvokeService.getInstance().getStandardIpositionSingle(stdPositionId);
        if (!HRObjectUtils.isEmpty(resultMap)) {
            this.setModelValue(this.getFieldInfo().getJobScmOrgFieldName(), resultMap.get("orgdesignbu.id"));
            this.setModelValue(this.getFieldInfo().getJobFieldName(), resultMap.get("job.id"));
            this.setModelValue(this.getFieldInfo().getJobLevelScmFieldName(), resultMap.get("joblevelscm.id"));
            this.setModelValue(this.getFieldInfo().getJobGradeScmFieldName(), resultMap.get("jobgradescm.id"));
            this.setJobleveGradeWhenOnlyOne();
        } else {
            this.setNullWithJobInfo(true);
        }
    }

    private void setValueByJob(String fieldKey) {
        if (!HRStringUtils.equals((String)fieldKey, (String)this.getFieldInfo().getJobFieldName())) {
            return;
        }
        String positionType = String.valueOf(this.getFieldInfo().getFieldValue(this.getFieldInfo().getPositionTypeFieldName()));
        if (!HRStringUtils.equals((String)PositionTypeEnum.POSITIONTYPE_JOB.getValue(), (String)positionType)) {
            return;
        }
        this.setNullWithJobInfo(false);
        long jobId = this.getFieldInfo().getFieldValue(fieldKey);
        if (jobId == 0L) {
            return;
        }
        this.setJobleveGradeWhenOnlyOne();
    }

    private void setValueByJobGradeScm(String fieldKey) {
        if (!HRStringUtils.equals((String)fieldKey, (String)this.getFieldInfo().getJobGradeScmFieldName())) {
            return;
        }
        DynamicObject jobgrade = this.getDynamicObjectValue(this.curEntity, this.getFieldInfo().getJobGradeFieldName());
        if (jobgrade == null) {
            return;
        }
        if (this.getDynamicObjectFieldId(jobgrade, "jobgradescm") == this.getFieldInfo().getFieldValue(fieldKey).longValue()) {
            return;
        }
        this.setModelValue(this.getFieldInfo().getJobGradeFieldName(), null);
    }

    private void setValueByJobLevelScm(String fieldKey) {
        if (!HRStringUtils.equals((String)fieldKey, (String)this.getFieldInfo().getJobLevelScmFieldName())) {
            return;
        }
        DynamicObject joblevel = this.getDynamicObjectValue(this.curEntity, this.getFieldInfo().getJobLevelFieldName());
        if (joblevel == null) {
            return;
        }
        if (this.getDynamicObjectFieldId(joblevel, "joblevelscm") == this.getFieldInfo().getFieldValue(fieldKey).longValue()) {
            return;
        }
        this.setModelValue(this.getFieldInfo().getJobLevelFieldName(), null);
    }

    private void setValueByJobGrade(String fieldKey) {
        if (!HRStringUtils.equals((String)fieldKey, (String)this.getFieldInfo().getJobGradeFieldName())) {
            return;
        }
        DynamicObject jobgradeNew = this.curEntity.getDynamicObject(fieldKey);
        if (jobgradeNew == null) {
            return;
        }
        long jobgradescmNew = this.getDynamicObjectFieldId(jobgradeNew, "jobgradescm");
        this.setModelValue(this.getFieldInfo().getJobGradeScmFieldName(), jobgradescmNew);
    }

    private void setValueByJobLevel(String fieldKey) {
        if (!HRStringUtils.equals((String)fieldKey, (String)this.getFieldInfo().getJobLevelFieldName())) {
            return;
        }
        DynamicObject joblevelNew = this.curEntity.getDynamicObject(fieldKey);
        if (joblevelNew == null) {
            return;
        }
        long joblevelscmNew = this.getDynamicObjectFieldId(joblevelNew, "joblevelscm");
        this.setModelValue(this.getFieldInfo().getJobLevelScmFieldName(), joblevelscmNew);
    }

    private void setNullWithJobInfo(boolean clearJob) {
        if (clearJob) {
            this.setModelValue(this.getFieldInfo().getJobFieldName(), null);
            this.setModelValue(this.getFieldInfo().getJobScmOrgFieldName(), null);
        }
        this.setModelValue(this.getFieldInfo().getJobGradeScmFieldName(), null);
        this.setModelValue(this.getFieldInfo().getJobLevelScmFieldName(), null);
        this.setModelValue(this.getFieldInfo().getJobGradeFieldName(), null);
        this.setModelValue(this.getFieldInfo().getJobLevelFieldName(), null);
    }

    private void setModelValue(String fieldName, Object value) {
        if (!this.curEntity.containsProperty(fieldName)) {
            return;
        }
        this.getModel().setValue(fieldName, value);
        this.getFieldInfo().getFieldValueMap().put(fieldName, CommonPermissionEdit.getLongValOfCustomParam(value));
    }

    private void setJobleveGradeWhenOnlyOne() {
        List jobleves;
        String positionType = String.valueOf(this.getFieldInfo().getFieldValue(this.getFieldInfo().getPositionTypeFieldName()));
        long jobId = this.getFieldInfo().getFieldValue(this.getFieldInfo().getJobFieldName());
        Map<Object, Object> jobInfoMap = new HashMap();
        if (jobId != 0L) {
            Map<Long, Map<String, Object>> resultMap = BizMserviceInvokeService.getInstance().getJobLevelGradeRangeInfoByJobIds((List<Long>)ImmutableList.of((Object)jobId));
            jobInfoMap = resultMap.get(jobId);
        }
        long joblevelscmId = this.getFieldInfo().getFieldValue(this.getFieldInfo().getJobLevelScmFieldName());
        long jobgradescmId = this.getFieldInfo().getFieldValue(this.getFieldInfo().getJobGradeScmFieldName());
        if (joblevelscmId == 0L && jobgradescmId == 0L && jobInfoMap != null) {
            joblevelscmId = CommonPermissionEdit.getLongValOfCustomParam(jobInfoMap.get("joblevelScmid"));
            jobgradescmId = CommonPermissionEdit.getLongValOfCustomParam(jobInfoMap.get("jobgradeScmid"));
            if (HRStringUtils.equals((String)PositionTypeEnum.POSITIONTYPE_JOB.getValue(), (String)positionType)) {
                this.setModelValue(this.getFieldInfo().getJobScmOrgFieldName(), CommonPermissionEdit.getLongValOfCustomParam(jobInfoMap.get("createOrg")));
            }
            this.setModelValue(this.getFieldInfo().getJobLevelScmFieldName(), joblevelscmId);
            this.setModelValue(this.getFieldInfo().getJobGradeScmFieldName(), jobgradescmId);
        }
        Map<String, Object> levelGradeMap = new HashMap<String, Object>();
        if (HRStringUtils.equals((String)PositionTypeEnum.POSITIONTYPE_STDPOSITION.getValue(), (String)positionType)) {
            long stdPositionId = this.getFieldInfo().getFieldValue(this.getFieldInfo().getStdPositionFieldName());
            Map<Long, Object> jobInfoByStdPosMap = BizMserviceInvokeService.getInstance().queryJobLevelAndJobGradeByStdPositionIds((List<Long>)ImmutableList.of((Object)stdPositionId));
            if (!CollectionUtils.isEmpty(jobInfoByStdPosMap)) {
                levelGradeMap = (Map)jobInfoByStdPosMap.get(stdPositionId);
            }
        } else if (HRStringUtils.equals((String)PositionTypeEnum.POSITIONTYPE_POSITION.getValue(), (String)positionType)) {
            Long positionId = this.getFieldInfo().getFieldValue(this.getFieldInfo().getPositionFieldName());
            Map<Long, Object> jobInfoByPosMap = BizMserviceInvokeService.getInstance().queryJobLevelAndJobGradeByPositionIds((List<Long>)ImmutableList.of((Object)positionId));
            if (!CollectionUtils.isEmpty(jobInfoByPosMap)) {
                levelGradeMap = (Map)jobInfoByPosMap.get(positionId);
            }
        }
        List jobGrades = this.getJobGrade(levelGradeMap);
        if (CollectionUtils.isEmpty(jobGrades) && jobInfoMap != null) {
            jobGrades = (List)jobInfoMap.get("jobgradeRanges");
        }
        if (!CollectionUtils.isEmpty(jobGrades) && jobGrades.size() == 1) {
            this.setModelValue(this.getFieldInfo().getJobGradeFieldName(), ((DynamicObject)jobGrades.get(0)).get("id"));
        }
        if (CollectionUtils.isEmpty(jobleves = this.getJobLevel(levelGradeMap)) && jobInfoMap != null) {
            jobleves = (List)jobInfoMap.get("joblevelRanges");
        }
        if (!CollectionUtils.isEmpty(jobleves) && jobleves.size() == 1) {
            this.setModelValue(this.getFieldInfo().getJobLevelFieldName(), ((DynamicObject)jobleves.get(0)).get("id"));
        }
    }

    private static long getLongValOfCustomParam(Object object) {
        if (object == null) {
            return 0L;
        }
        if (object instanceof Long) {
            return (Long)object;
        }
        if (object instanceof DynamicObject) {
            return ((DynamicObject)object).getLong("id");
        }
        return Long.parseLong(object.toString());
    }

    private List<DynamicObject> getJobLevel(Map<String, Object> levelGradeMap) {
        if (!ObjectUtils.isEmpty(levelGradeMap) && !ObjectUtils.isEmpty((Object)levelGradeMap.get("joblevel"))) {
            return (List)levelGradeMap.get("joblevel");
        }
        return new ArrayList<DynamicObject>();
    }

    private List<DynamicObject> getJobGrade(Map<String, Object> levelGradeMap) {
        if (!ObjectUtils.isEmpty(levelGradeMap) && !ObjectUtils.isEmpty((Object)levelGradeMap.get("jobgrade"))) {
            return (List)levelGradeMap.get("jobgrade");
        }
        return new ArrayList<DynamicObject>();
    }

    private void addQFilter(BeforeF7SelectEvent evt, QFilter qFilter) {
        if (qFilter == null) {
            return;
        }
        List oldList = evt.getCustomQFilters();
        ArrayList<QFilter> list = new ArrayList<QFilter>();
        list.add(qFilter);
        if (oldList == null) {
            evt.setCustomQFilters(list);
        } else if (oldList instanceof ArrayList) {
            oldList.addAll(list);
        }
    }
}

