/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.hr.common.plugin.perm;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kd.bos.basedata.service.BaseDataServiceImpl;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.sdk.hr.common.plugin.perm.service.DataFilterService;
import kd.sdk.hr.common.plugin.perm.service.DimValueResultDTO;
import kd.sdk.hr.common.plugin.perm.service.FieldConfigMap;
import kd.sdk.hr.common.plugin.perm.service.FieldNameInfo;

public class CommonPermissionList
extends HRDataBaseList {
    private static final String ORGDESIGNPERM = "OrgdesignPerm";
    private static final String ORGTEAMPERM = "OrgteamPerm";
    private static final String OrgdesignPerm_FILTER = "OrgdesignPerm_FILTER";
    private static final String JOBLEVEL_FILTER = "JOBLEVEL_FILTER";
    private static final String JOBGRADE_FILTER = "JOBGRADE_FILTER";
    private static final String STDPOS_FILTER = "STDPOS_FILTER";
    private FieldNameInfo fieldNameInfo;
    private static final List<String> orgdesignField = Arrays.asList("hbjm_jobhr", "hbjm_jobscmhr", "hbjm_jobseqhr", "hbjm_jobfamilyhr", "hbjm_jobclasshr", "hbjm_jobgradescmhr", "hbjm_joblevelscmhr", "hbpm_stposition");

    private FieldNameInfo getFieldInfo(String entityId) {
        if (this.fieldNameInfo == null) {
            this.fieldNameInfo = FieldConfigMap.getFieldName(entityId);
        }
        return this.fieldNameInfo;
    }

    public void filterColumnSetFilter(SetFilterEvent args) {
        String entityNum = ((ListShowParameter)this.getView().getFormShowParameter()).getBillFormId();
        String fieldEntityId = ((CommonFilterColumn)args.getSource()).getFilterField().getRefEntityId();
        this.setCustomFilter(args, entityNum, fieldEntityId);
        super.filterColumnSetFilter(args);
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        String entityNum = ((ListShowParameter)this.getView().getFormShowParameter()).getBillFormId();
        String fieldEntityId = args.getRefEntityId();
        this.setCustomFilter(args, entityNum, fieldEntityId);
        super.filterContainerBeforeF7Select(args);
    }

    private void setCustomFilter(Object args, String entityNum, String fieldEntityId) {
        if (orgdesignField.contains(fieldEntityId)) {
            this.addPermOrgFilter(args, entityNum, fieldEntityId);
        } else if (HRStringUtils.equals((String)fieldEntityId, (String)"hbjm_jobgradehr")) {
            this.addJobGradeScmFilter(args, entityNum);
        } else if (HRStringUtils.equals((String)fieldEntityId, (String)"hbjm_joblevelhr")) {
            this.addJobLevelScmFilter(args, entityNum);
        }
        if (HRStringUtils.equals((String)fieldEntityId, (String)"hbpm_stposition")) {
            this.addAdminorgSuitRangeFilter(args, entityNum);
        }
    }

    private void addPermOrgFilter(Object args, String entityNum, String fieldEntityId) {
        boolean added = this.addQFilterFromCache(args, OrgdesignPerm_FILTER + fieldEntityId);
        if (added) {
            return;
        }
        QFilter filter = null;
        DimValueResultDTO dimValueWithSub = this.getOrgDesignPerm(entityNum);
        if (dimValueWithSub != null && !dimValueWithSub.isAll()) {
            filter = new BaseDataServiceImpl().getBaseDataFilter(fieldEntityId, dimValueWithSub.getOrgIds(), true);
        }
        this.addQFilter(args, filter, false, OrgdesignPerm_FILTER + fieldEntityId);
    }

    private void addJobGradeScmFilter(Object args, String entityNum) {
        boolean added = this.addQFilterFromCache(args, JOBGRADE_FILTER);
        if (added) {
            return;
        }
        QFilter filter = null;
        DimValueResultDTO dimValueWithSub = this.getOrgDesignPerm(entityNum);
        if (dimValueWithSub != null && !dimValueWithSub.isAll()) {
            filter = DataFilterService.getInstance().getJobGradeScmQFilterWithUseorgIdList(dimValueWithSub.getOrgIds());
        }
        this.addQFilter(args, filter, false, JOBGRADE_FILTER);
    }

    private void addJobLevelScmFilter(Object args, String entityNum) {
        boolean added = this.addQFilterFromCache(args, JOBLEVEL_FILTER);
        if (added) {
            return;
        }
        QFilter filter = null;
        DimValueResultDTO dimValueWithSub = this.getOrgDesignPerm(entityNum);
        if (dimValueWithSub != null && !dimValueWithSub.isAll()) {
            filter = DataFilterService.getInstance().getJobLevelScmQFilterWithUseorgIdList(dimValueWithSub.getOrgIds());
        }
        this.addQFilter(args, filter, false, JOBLEVEL_FILTER);
    }

    private void addAdminorgSuitRangeFilter(Object args, String entityNum) {
        boolean added = this.addQFilterFromCache(args, STDPOS_FILTER);
        if (added) {
            return;
        }
        QFilter filter = null;
        DimValueResultDTO dimValueWithSub = this.getOrgTeamPerm(entityNum);
        if (dimValueWithSub != null && !dimValueWithSub.isAll()) {
            filter = DataFilterService.getInstance().getQFilterWithStdposition(dimValueWithSub.getOrgIds());
        }
        this.addQFilter(args, filter, false, STDPOS_FILTER);
    }

    private DimValueResultDTO getOrgDesignPerm(String entityNum) {
        String orgdesignPerm = this.getPageCache().get(ORGDESIGNPERM);
        if (!HRStringUtils.isEmpty((String)orgdesignPerm)) {
            return (DimValueResultDTO)((Object)JSONObject.parseObject((String)orgdesignPerm, DimValueResultDTO.class));
        }
        DimValueResultDTO permResult = DataFilterService.getInstance().getOrgDesignPerm(entityNum);
        this.getPageCache().put(ORGDESIGNPERM, JSONObject.toJSONString((Object)((Object)permResult)));
        return permResult;
    }

    private DimValueResultDTO getOrgTeamPerm(String entityNum) {
        DimValueResultDTO permResult;
        String orgdesignPerm = this.getPageCache().get(ORGTEAMPERM);
        if (!HRStringUtils.isEmpty((String)orgdesignPerm)) {
            return (DimValueResultDTO)((Object)JSONObject.parseObject((String)orgdesignPerm, DimValueResultDTO.class));
        }
        if (HRStringUtils.isEmpty((String)this.getFieldInfo(entityNum).getAdminOrgFieldName())) {
            permResult = new DimValueResultDTO();
            permResult.setAll(true);
        } else {
            permResult = DataFilterService.getInstance().getOrgTeamPerm(entityNum, this.getFieldInfo(entityNum).getAdminOrgFieldName());
        }
        this.getPageCache().put(ORGTEAMPERM, JSONObject.toJSONString((Object)((Object)permResult)));
        return permResult;
    }

    private boolean addQFilterFromCache(Object args, String cacheKey) {
        String filterStr = this.getPageCache().get(cacheKey);
        if (HRStringUtils.isEmpty((String)filterStr)) {
            return false;
        }
        QFilter filter = QFilter.fromSerializedString((String)filterStr);
        this.addQFilter(args, filter, true, cacheKey);
        return true;
    }

    private void addQFilter(Object args, QFilter filter, boolean fromCache, String cacheKey) {
        if (filter == null) {
            filter = new QFilter("1", "=", (Object)1);
        }
        if (args instanceof SetFilterEvent) {
            this.addQFilter((SetFilterEvent)args, filter);
        }
        if (args instanceof BeforeFilterF7SelectEvent) {
            this.addQFilter((BeforeFilterF7SelectEvent)args, filter);
        }
        if (!fromCache) {
            this.getPageCache().put(cacheKey, filter.toSerializedString());
        }
    }

    private void addQFilter(SetFilterEvent evt, QFilter qFilter) {
        if (qFilter == null) {
            return;
        }
        List oldList = evt.getCustomQFilters();
        ArrayList<QFilter> list = new ArrayList<QFilter>();
        list.add(qFilter);
        if (oldList == null) {
            evt.setCustomQFilters(list);
        } else if (oldList instanceof ArrayList) {
            oldList.addAll(list);
        }
    }

    private void addQFilter(BeforeFilterF7SelectEvent evt, QFilter qFilter) {
        if (qFilter == null) {
            return;
        }
        List oldList = evt.getCustomQFilters();
        ArrayList<QFilter> list = new ArrayList<QFilter>();
        list.add(qFilter);
        if (oldList == null) {
            evt.setCustomQFilters(list);
        } else if (oldList instanceof ArrayList) {
            oldList.addAll(list);
        }
    }
}

