/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.hr.hpfs.business.mservice.helper;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DBRoute;
import kd.bos.entity.property.ComboProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRBaseUtils;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRMapUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.hr.common.bean.ChgActionMappedBean;
import kd.sdk.hr.common.bean.DepempBean;
import kd.sdk.hr.common.bean.EmpBean;
import kd.sdk.hr.common.bean.PerChgBizInfoNew;
import kd.sdk.hr.common.bean.PersonBean;
import kd.sdk.hr.hpfs.business.mservice.helper.ChgRecordHelper;
import kd.sdk.hr.hpfs.business.perchg.executor.enums.ChgModeEnum;
import kd.sdk.hr.hpfs.business.perchg.executor.model.ChgRecordEntryDto;
import kd.sdk.hr.hpfs.utils.ChgApiDataReturnUtils;
import kd.sdk.hr.hpfs.utils.RepositoryUtils;

public class HPFSNewChgHelper {
    private static final Log LOG = LogFactory.getLog(HPFSNewChgHelper.class);
    public static final Set<Long> LICENSE_IN = Sets.newHashSet((Object[])new Long[]{1010L, 1060L, 1150L});

    public static List<Map<Long, Map<String, Object>>> queryMappedApi(Set<Long> chgActionIds) {
        List<ChgActionMappedBean> beanList = HPFSNewChgHelper.queryMapped(chgActionIds);
        return ChgActionMappedBean.apiDataReturn(beanList);
    }

    public static List<ChgActionMappedBean> queryMapped(Set<Long> chgActionIds) {
        if (CollectionUtils.isEmpty(chgActionIds)) {
            return new ArrayList<ChgActionMappedBean>(1);
        }
        List<ChgActionMappedBean> beanList = ChgApiDataReturnUtils.initData(chgActionIds);
        QFilter filter = new QFilter("id", "in", chgActionIds);
        DynamicObject[] chgActions = RepositoryUtils.queryDynamicObjects("hpfs_chgaction", "", filter);
        if (chgActions == null) {
            for (ChgActionMappedBean bean : beanList) {
                bean.setSuccess(false);
                bean.setErrMsg(ResManager.loadKDString((String)"\u53d8\u52a8\u64cd\u4f5c\u4e0d\u5b58\u5728\uff1b", (String)"HPFSNewChgSerivce_0", (String)"sdk-hr", (Object[])new Object[0]));
            }
            return beanList;
        }
        Map<Long, DynamicObject> actionIdDy = Arrays.stream(chgActions).collect(Collectors.toMap(action -> action.getLong("id"), action -> action, (oldval, newval) -> newval));
        for (ChgActionMappedBean bean : beanList) {
            Long chgActionId = bean.getChgActionId();
            DynamicObject chgActionDy = actionIdDy.get(chgActionId);
            if (chgActionDy == null) {
                bean.setSuccess(false);
                bean.setErrMsg(ResManager.loadKDString((String)"\u53d8\u52a8\u64cd\u4f5c\u4e0d\u5b58\u5728\uff1b", (String)"HPFSNewChgSerivce_0", (String)"sdk-hr", (Object[])new Object[0]));
                continue;
            }
            bean.setChgActionDy(chgActionDy);
            bean.setCategoryId(chgActionDy.getLong("chgcategory.id"));
            DynamicObject mappedDy = chgActionDy.getDynamicObject("filemapping");
            bean.setSuccess(true);
            bean.setMappedDy(mappedDy);
        }
        return beanList;
    }

    public static Map<String, List<Long>> getFileTypeByLabAndPosTypeList(Collection<String> labAndPosTypes) {
        if (CollectionUtils.isEmpty(labAndPosTypes)) {
            return Maps.newHashMapWithExpectedSize((int)labAndPosTypes.size());
        }
        DynamicObject[] dys = HPFSNewChgHelper.queryFileType(labAndPosTypes);
        HashMap<String, List<Long>> result = new HashMap<String, List<Long>>(dys.length * 3);
        for (DynamicObject dy : dys) {
            MulBasedataDynamicObjectCollection labRelTypes = (MulBasedataDynamicObjectCollection)dy.getDynamicObjectCollection("laborreltypemul");
            String postypeIdStr = dy.getString("postype_id");
            long fileTypeId = dy.getLong("id");
            labRelTypes.forEach(labRelType -> {
                String labTypeIdStr = labRelType.getString("fbasedataid.id");
                String key = labTypeIdStr + "_" + postypeIdStr;
                ArrayList<Long> fileTypeIds = (ArrayList<Long>)result.get(key);
                if (CollectionUtils.isEmpty((Collection)fileTypeIds)) {
                    fileTypeIds = new ArrayList<Long>();
                }
                if (!fileTypeIds.contains(fileTypeId)) {
                    fileTypeIds.add(fileTypeId);
                }
                result.put(key, fileTypeIds);
            });
        }
        return result;
    }

    public static Map<String, Long> getFileTypeByLabAndPosType(Collection<String> labAndPosTypes) {
        if (CollectionUtils.isEmpty(labAndPosTypes)) {
            return Maps.newHashMapWithExpectedSize((int)labAndPosTypes.size());
        }
        DynamicObject[] dys = HPFSNewChgHelper.queryFileType(labAndPosTypes);
        HashMap<String, Long> result = new HashMap<String, Long>(dys.length * 3);
        for (DynamicObject dy : dys) {
            MulBasedataDynamicObjectCollection labRelTypes = (MulBasedataDynamicObjectCollection)dy.getDynamicObjectCollection("laborreltypemul");
            String postypeIdStr = dy.getString("postype_id");
            long fileTypeId = dy.getLong("id");
            labRelTypes.forEach(labRelType -> {
                String labTypeIdStr = labRelType.getString("fbasedataid.id");
                result.put(labTypeIdStr + "_" + postypeIdStr, fileTypeId);
            });
        }
        return result;
    }

    private static DynamicObject[] queryFileType(Collection<String> labAndPosTypes) {
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter filter = null;
        for (String item : labAndPosTypes) {
            String[] items = item.split("_");
            Long labTypeId = Long.valueOf(items[0]);
            Long posTypeId = Long.valueOf(items[1]);
            QFilter labTypeFilter = new QFilter("laborreltypemul.fbasedataid", "=", (Object)labTypeId);
            QFilter posTypeFilter = new QFilter("postype", "=", (Object)posTypeId);
            QFilter labAndPosTypeFilter = labTypeFilter.and(posTypeFilter);
            if (filter == null) {
                filter = labAndPosTypeFilter;
                continue;
            }
            filter.or(labAndPosTypeFilter);
        }
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hspm_erfiletype");
        return helper.query("id,postype_id,laborreltype_id,laborreltypemul", new QFilter[]{filter, enableFilter});
    }

    public static DynamicObject[] queryFileTypeByIds(List<Long> ids) {
        QFilter filter = new QFilter("id", "in", ids);
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hspm_erfiletype");
        return helper.query("id,name", new QFilter[]{filter});
    }

    public static void setInit(DynamicObject hisDy) {
        DataEntityPropertyCollection depc = hisDy.getDataEntityType().getProperties();
        if (Objects.nonNull(depc.get((Object)"initstatus"))) {
            hisDy.set("initstatus", (Object)"2");
        }
    }

    public static void setCreateField(DynamicObject hisDy) {
        long userId;
        long l = userId = hisDy.get("creator") instanceof DynamicObject ? hisDy.getDynamicObject("creator").getLong("id") : 0L;
        if (userId == 0L) {
            long userIdLong = RequestContext.get().getCurrUserId();
            hisDy.set("creator", (Object)userIdLong);
        }
        if (hisDy.getDate("createtime") == null) {
            hisDy.set("createtime", (Object)new Date());
        }
    }

    public static void setModifyField(DynamicObject hisDy) {
        hisDy.set("modifier", (Object)RequestContext.get().getCurrUserId());
        hisDy.set("modifytime", (Object)new Date());
    }

    public static void setSysField(DynamicObject hisDy) {
        HPFSNewChgHelper.setCreateField(hisDy);
        HPFSNewChgHelper.setModifyField(hisDy);
        HPFSNewChgHelper.setInit(hisDy);
    }

    public static void setFieldMapping(DynamicObject sourceDy, DynamicObjectCollection fieldEntry, PerChgBizInfoNew bizInfoNew, DynamicObject newHis) {
        DataEntityPropertyCollection properties = sourceDy.getDataEntityType().getProperties();
        for (DynamicObject fieldDy : fieldEntry) {
            String targetField = fieldDy.getString("targetfieldnew.number");
            String sourceField = fieldDy.getString("sourcefieldtag");
            if (!properties.containsKey((Object)sourceField)) {
                LOG.info("==sourceField:{} targetField_NotHavaField:{}== ", (Object)sourceField, (Object)targetField);
                continue;
            }
            Object sourceObject = sourceDy.get(sourceField);
            LOG.info("==sourceField:{} targetField:{}== ", (Object)sourceField, (Object)targetField);
            HPFSNewChgHelper.setValue(newHis, targetField, sourceObject);
        }
        HPFSNewChgHelper.setSysField(newHis);
        HPFSNewChgHelper.setIdFromCache(bizInfoNew, newHis);
    }

    public static void setMappingField(DynamicObject sourceDy, DynamicObjectCollection fieldEntry, PerChgBizInfoNew bizInfoNew, DynamicObject newHis) {
        for (DynamicObject fieldDy : fieldEntry) {
            DataEntityPropertyCollection sourceType = sourceDy.getDataEntityType().getProperties();
            String targetField = fieldDy.getString("targetfieldnew.number");
            String sourceField = fieldDy.getString("sourcefieldtag");
            if (!sourceType.containsKey((Object)sourceField)) {
                LOG.info("==extField_sourceFieldNotHaveField:{} targetField:{}== ", (Object)sourceField, (Object)targetField);
                continue;
            }
            Object sourceObject = sourceDy.get(sourceField);
            LOG.info("==extField_sourceField:{} targetField:{}== ", (Object)sourceField, (Object)targetField);
            HPFSNewChgHelper.setValue(newHis, targetField, sourceObject);
        }
    }

    public static void setFieldMappingHCF(DynamicObject sourceDy, DynamicObjectCollection fieldEntry, PerChgBizInfoNew bizInfoNew, DynamicObject newHis) {
        for (DynamicObject fieldDy : fieldEntry) {
            String targetField = fieldDy.getString("targetfieldnew_c.number");
            String sourceField = fieldDy.getString("sourcefieldtag_c");
            Object sourceObject = sourceDy.get(sourceField);
            LOG.info("==sourceField:{} targetField:{}== ", (Object)sourceField, (Object)targetField);
            HPFSNewChgHelper.setValue(newHis, targetField, sourceObject);
        }
        HPFSNewChgHelper.setSysField(newHis);
        HPFSNewChgHelper.setIdFromCache(bizInfoNew, newHis);
    }

    public static DynamicObject formatAttachment(DynamicObject attach, Long newId, String hrpiEntity) {
        DynamicObject dynamicObject = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bos_attachment"));
        HRDynamicObjectUtils.copy((DynamicObject)attach, (DynamicObject)dynamicObject);
        dynamicObject.set("id", (Object)ORM.create().genLongId("bos_attachment"));
        dynamicObject.set("finterid", (Object)newId);
        dynamicObject.set("fbilltype", (Object)hrpiEntity);
        dynamicObject.set("fattachmentpanel", (Object)"attachmentpanelap_std");
        dynamicObject.set("fcreatetime", (Object)new Date());
        dynamicObject.set("fmodifytime", (Object)new Date());
        return dynamicObject;
    }

    public static void setValue(DynamicObject targetDy, String targetField, Object sourceObject) {
        DataEntityPropertyCollection targetProps = targetDy.getDataEntityType().getProperties();
        if (!targetProps.containsKey((Object)targetField)) {
            return;
        }
        if (sourceObject instanceof DynamicObject && targetDy.get(targetField) instanceof Long) {
            targetDy.set(targetField, (Object)((DynamicObject)sourceObject).getLong("id"));
            return;
        }
        if (sourceObject instanceof DynamicObject && targetDy.get(targetField) instanceof String) {
            targetDy.set(targetField, (Object)((DynamicObject)sourceObject).getLong("name"));
            return;
        }
        DynamicProperty targetProperty = (DynamicProperty)targetProps.get((Object)targetField);
        if (HRStringUtils.equals((String)ComboProp.class.getSimpleName(), (String)targetProperty.getClass().getSimpleName()) && sourceObject instanceof Boolean) {
            String val = (Boolean)sourceObject != false ? "1" : "0";
            targetDy.set(targetField, (Object)val);
            return;
        }
        if (sourceObject instanceof MulBasedataDynamicObjectCollection && ((MulBasedataDynamicObjectCollection)sourceObject).size() > 0) {
            DynamicObjectCollection formEntityDys = (DynamicObjectCollection)sourceObject;
            DynamicObjectCollection toEntityDys = targetDy.getDynamicObjectCollection(targetField);
            if (toEntityDys != null) {
                DynamicObjectType entityType = toEntityDys.getDynamicObjectType();
                formEntityDys.forEach(formEntity -> {
                    DynamicObject newEntry = new DynamicObject(entityType);
                    HRDynamicObjectUtils.copy((DynamicObject)formEntity, (DynamicObject)newEntry);
                    toEntityDys.add((Object)newEntry);
                });
                return;
            }
        }
        targetDy.set(targetField, sourceObject);
    }

    public static void setIdFromCache(PerChgBizInfoNew chgBizInfoNew, DynamicObject hisDy) {
        List<PersonBean> personList = chgBizInfoNew.getPersonList();
        List<EmpBean> empListList = chgBizInfoNew.getEmpList();
        List<DepempBean> depeList = chgBizInfoNew.getDepempList();
        DynamicObject cmpempDy = chgBizInfoNew.getCmpempDy();
        PersonBean perBean = personList.get(personList.size() - 1);
        EmpBean empBean = empListList.get(empListList.size() - 1);
        DepempBean depBean = depeList.get(depeList.size() - 1);
        HPFSNewChgHelper.setPersonModelVal(hisDy, perBean, empBean, cmpempDy, depBean);
        HPFSNewChgHelper.setModelVal(hisDy, "empentrel", empBean.getaEntId());
        HPFSNewChgHelper.setModelVal(hisDy, "empposrel", depBean.getaEmpposId());
        HPFSNewChgHelper.setModelVal(hisDy, "pernontsprop", perBean.getaPernonId());
        if (Objects.nonNull(hisDy.getDataEntityType().getProperties().get((Object)"bsed")) && Objects.isNull(hisDy.get("bsed"))) {
            DynamicObject mainBillDy = chgBizInfoNew.getDy();
            Date effectiveDateValue = (Date)mainBillDy.get("b_effectivedate");
            if (effectiveDateValue == null) {
                effectiveDateValue = chgBizInfoNew.getEffectivedate();
            }
            hisDy.set("bsed", (Object)effectiveDateValue);
        }
    }

    protected static void setPersonModelVal(DynamicObject hisDy, PersonBean perBean, EmpBean empBean, DynamicObject cmpempDy, DepempBean depBean) {
        Long personId = perBean.getaPersonId() == null || perBean.getaPersonId() != 0L ? perBean.getaPersonId() : perBean.getbPersonId();
        Long employeeId = empBean.getaEmpId() == null || empBean.getaEmpId() != 0L ? empBean.getaEmpId() : empBean.getbEmpId();
        Long comEmpId = cmpempDy != null ? Long.valueOf(cmpempDy.getLong("id")) : depBean.getaManagescopeId();
        Long depEmpId = depBean.getaDeempId() == null || depBean.getaDeempId() != 0L ? depBean.getaDeempId() : depBean.getbDepempId();
        HPFSNewChgHelper.setModelVal(hisDy, "person", personId);
        HPFSNewChgHelper.setModelVal(hisDy, "employee", employeeId);
        HPFSNewChgHelper.setModelVal(hisDy, "cmpemp", comEmpId);
        HPFSNewChgHelper.setModelVal(hisDy, "depemp", depEmpId);
    }

    protected static void setModelVal(DynamicObject hisDy, String modelField, Long val) {
        DataEntityPropertyCollection depc = hisDy.getDataEntityType().getProperties();
        if (!Objects.isNull(depc.get((Object)modelField)) && val != null && val != 0L) {
            if (hisDy.get(modelField) instanceof DynamicObject) {
                hisDy.set(modelField + "_id", (Object)val);
            }
            hisDy.set(modelField, (Object)val);
        }
    }

    public static void checkBusistatus(String chgType, DynamicObject dy) {
        DataEntityPropertyCollection properties = dy.getDataEntityType().getProperties();
        if (ChgModeEnum.INVALID.getChgMode().equals(chgType) && properties.containsKey((Object)"businessstatus")) {
            String entityName = dy.getDynamicObjectType().getName();
            if ("hspm_ermanfile".equals(entityName)) {
                dy.set("businessstatus", (Object)"-1");
            } else {
                dy.set("businessstatus", (Object)"2");
            }
        }
    }

    public static void handlePersonParams(List<PerChgBizInfoNew> successData) {
        for (PerChgBizInfoNew perChgBizInfoNew : successData) {
            HashMap dynMap = Maps.newHashMapWithExpectedSize((int)successData.size());
            Map<String, List<ChgRecordEntryDto>> entityRecord = perChgBizInfoNew.getEntityRecord();
            for (Map.Entry<String, List<ChgRecordEntryDto>> entry : entityRecord.entrySet()) {
                String entityName = entry.getKey();
                List<ChgRecordEntryDto> chgRecords = entry.getValue();
                List filterRecords = chgRecords.stream().filter(record -> !ChgModeEnum.UNCHANGED.getChgMode().equals(record.getChgMode()) && !ChgModeEnum.DELETE.getChgMode().equals(record.getChgMode())).collect(Collectors.toList());
                for (ChgRecordEntryDto chgRecord : filterRecords) {
                    DynamicObjectCollection doc;
                    DynamicObject dy = chgRecord.getDataDy();
                    if (dynMap.containsKey(entityName)) {
                        doc = (DynamicObjectCollection)dynMap.get(entityName);
                        doc.add((Object)dy);
                        continue;
                    }
                    doc = new DynamicObjectCollection();
                    doc.add((Object)dy);
                    dynMap.put(entityName, doc);
                }
            }
            List<Map<String, DynamicObjectCollection>> dynList = HPFSNewChgHelper.formatDataByApiFormat(dynMap);
            Map<String, Object> personParams = HPFSNewChgHelper.formatParamMap(dynList, perChgBizInfoNew);
            perChgBizInfoNew.setPersonParams(personParams);
            Map<String, List<DynamicObject>> delParams = perChgBizInfoNew.getDelParams();
            if (!CollectionUtils.isEmpty(delParams)) {
                List<Map<String, Object>> delList = HPFSNewChgHelper.formatListDataByApiFormat(delParams);
                Map<String, Object> delPersonParams = HPFSNewChgHelper.formatDelParamMap(delList);
                perChgBizInfoNew.setDelPersonParams(delPersonParams);
            }
            HPFSNewChgHelper.printSyncPersonLog(perChgBizInfoNew, dynList);
        }
    }

    private static void printSyncPersonLog(PerChgBizInfoNew perChgBizInfoNew, List<Map<String, DynamicObjectCollection>> dynList) {
        try {
            if (perChgBizInfoNew == null) {
                LOG.info("==syncPersonLog_billInfo_Empty==");
                return;
            }
            LOG.info("==syncPersonLog_billInfo:{}==", (Object)perChgBizInfoNew.toString());
            List<PersonBean> personList = perChgBizInfoNew.getPersonList();
            List<EmpBean> empList = perChgBizInfoNew.getEmpList();
            List<DepempBean> depemList = perChgBizInfoNew.getDepempList();
            if (!CollectionUtils.isEmpty(personList)) {
                LOG.info("==syncPersonLog_personInfo:{}==", (Object)personList.toString());
            }
            if (!CollectionUtils.isEmpty(empList)) {
                LOG.info("==syncPersonLog_employeeInfo:{}==", empList.stream().map(EmpBean::toPrintString).collect(Collectors.toSet()));
            }
            if (!CollectionUtils.isEmpty(depemList)) {
                LOG.info("==syncPersonLog_depInfo:{}==", depemList.stream().map(DepempBean::toPrintString).collect(Collectors.toSet()));
            }
            Map<String, List<ChgRecordEntryDto>> entityRecord = perChgBizInfoNew.getEntityRecord();
            StringBuilder entityInfo = new StringBuilder();
            if (!HRMapUtils.isEmpty(entityRecord)) {
                for (Map.Entry<String, List<ChgRecordEntryDto>> entry : entityRecord.entrySet()) {
                    entityInfo.append("{");
                    String string = entry.getKey();
                    entityInfo.append(string);
                    entityInfo.append("=");
                    if (CollectionUtils.isEmpty((Collection)entry.getValue())) {
                        entityInfo.append("-");
                    } else {
                        Set entitySet = entry.getValue().stream().map(ChgRecordEntryDto::toPrintString).collect(Collectors.toSet());
                        entityInfo.append(entitySet);
                    }
                    entityInfo.append("}");
                }
            }
            LOG.info("==syncPersonLog_entity:{}==", (Object)entityInfo.toString());
            StringBuilder syncInfo = new StringBuilder();
            if (!CollectionUtils.isEmpty(dynList)) {
                for (Map<String, DynamicObjectCollection> map : dynList) {
                    for (Map.Entry<String, DynamicObjectCollection> entries : map.entrySet()) {
                        syncInfo.append("{");
                        String key = entries.getKey();
                        DynamicObjectCollection dys = entries.getValue();
                        if (CollectionUtils.isEmpty((Collection)dys)) {
                            syncInfo.append(key);
                            syncInfo.append("=");
                            syncInfo.append("-");
                        } else {
                            String name = dys.getDynamicObjectType().getName();
                            syncInfo.append(name);
                            syncInfo.append("=");
                            for (DynamicObject dy : dys) {
                                syncInfo.append("[");
                                String hisModeField = HPFSNewChgHelper.getHisModeField(dy);
                                syncInfo.append(hisModeField);
                                syncInfo.append("]");
                            }
                        }
                        syncInfo.append("}");
                    }
                }
            }
            LOG.info("==syncPersonLog_syncSaveInfo:{}==", (Object)syncInfo.toString());
            Map<String, Object> map = perChgBizInfoNew.getDelPersonParams();
            LOG.info("==syncPersonLog_syncDelInfo:{}==", map);
        }
        catch (Exception ex) {
            LOG.error("==syncPersonLog_Error==", (Throwable)ex);
        }
    }

    public static boolean isSkipCreateNewPerson(PerChgBizInfoNew bizInfoNew) {
        Long chgEventId = ChgRecordHelper.getChgEventId(bizInfoNew);
        List<PersonBean> personList = bizInfoNew.getPersonList();
        if (!CollectionUtils.isEmpty(personList)) {
            PersonBean personBean = personList.get(personList.size() - 1);
            String chgType = personBean.getaChgMethod();
            return HPFSNewChgHelper.configOn() && Objects.nonNull(chgEventId) && LICENSE_IN.contains(chgEventId) && HRStringUtils.isNotEmpty((String)chgType) && chgType.equals(ChgModeEnum.UNCHANGED.getChgMode());
        }
        return false;
    }

    public static boolean configOn() {
        String selectSql = "select fbusinessvalue from t_hpfs_devconfig where fbusinesskey = ?";
        AtomicBoolean configOn = new AtomicBoolean(false);
        return (Boolean)HRDBUtil.query((DBRoute)new DBRoute("hr"), (String)selectSql, (Object[])new Object[]{"person_model_switch"}, rs -> {
            while (rs.next()) {
                configOn.set("true".equals(rs.getString("fbusinessvalue")));
            }
            return configOn.get();
        });
    }

    public static List<Map<String, DynamicObjectCollection>> formatDataByApiFormat(Map<String, DynamicObjectCollection> dynMap) {
        return dynMap.values().stream().map(collection -> {
            HashMap<String, DynamicObjectCollection> map = new HashMap<String, DynamicObjectCollection>();
            map.put("hisDyns", (DynamicObjectCollection)collection);
            return map;
        }).collect(Collectors.toList());
    }

    public static List<Map<String, Object>> formatListDataByApiFormat(Map<String, List<DynamicObject>> dynMap) {
        ArrayList<Map<String, Object>> delList = new ArrayList<Map<String, Object>>(dynMap.size());
        for (Map.Entry<String, List<DynamicObject>> entry : dynMap.entrySet()) {
            String entityNum = entry.getKey();
            HashMap<String, Object> map = new HashMap<String, Object>();
            List<DynamicObject> dyList = entry.getValue();
            map.put("entityNumber", entityNum);
            map.put("boIdList", dyList.stream().map(dy -> dy.getLong("boid")).collect(Collectors.toList()));
            delList.add(map);
        }
        return delList;
    }

    public static Map<String, Object> formatParamMap(List<Map<String, DynamicObjectCollection>> dynList, PerChgBizInfoNew bizInfo) {
        HashMap<String, Object> map = new HashMap<String, Object>(8);
        map.put("caller", "hpfs");
        map.put("eventId", bizInfo.getEventId());
        map.put("mustAllSuccess", Boolean.TRUE);
        map.put("syncBosUser", Boolean.TRUE);
        map.put("chgActionId", bizInfo.getChgActionId());
        LOG.info("syncPersonLog_HPFSNewChgHelper#formatParamMap paramMap is {}", map);
        map.put("data", dynList);
        return map;
    }

    public static Map<String, Object> formatDelParamMap(List<Map<String, Object>> dynList) {
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        map.put("caller", "hpfs");
        map.put("data", dynList);
        return map;
    }

    public static void fixDate(DynamicObject hisDy, Date bsed) {
        DataEntityPropertyCollection depc = hisDy.getDataEntityType().getProperties();
        if (Objects.nonNull(depc.get((Object)"bsed"))) {
            hisDy.set("bsed", (Object)bsed);
        }
        if (Objects.nonNull(depc.get((Object)"startdate"))) {
            hisDy.set("startdate", (Object)bsed);
        }
        if (Objects.nonNull(depc.get((Object)"bsled")) && Objects.isNull(hisDy.get("bsled"))) {
            hisDy.set("bsled", (Object)HRBaseUtils.getMaxEndDate());
        }
        if (Objects.nonNull(depc.get((Object)"enddate")) && Objects.isNull(hisDy.get("enddate"))) {
            hisDy.set("enddate", (Object)HRBaseUtils.getMaxEndDate());
        }
        if (Objects.nonNull(depc.get((Object)"sysenddate")) && Objects.isNull(hisDy.get("sysenddate"))) {
            hisDy.set("sysenddate", (Object)HRBaseUtils.getMaxEndDate());
        }
        if (Objects.nonNull(depc.get((Object)"lastworkdate")) && Objects.isNull(hisDy.get("lastworkdate"))) {
            hisDy.set("lastworkdate", (Object)HRBaseUtils.getMaxEndDate());
        }
        if (Objects.nonNull(depc.get((Object)"createtime")) && Objects.isNull(hisDy.get("createtime"))) {
            hisDy.set("createtime", (Object)new Date());
        }
    }

    public static long getId(DynamicObjectType dyType) {
        return ORM.create().genLongId((IDataEntityType)dyType);
    }

    public static String getHisModeField(DynamicObject dy) {
        DataEntityPropertyCollection properties = dy.getDataEntityType().getProperties();
        if (dy == null) {
            return "-";
        }
        boolean containsBsed = properties.containsKey((Object)"bsed");
        Date date = null;
        if (containsBsed) {
            date = dy.getDate("bsed");
        }
        long boId = 0L;
        boolean containsKey = properties.containsKey((Object)"boid");
        if (containsKey) {
            boId = dy.getLong("boid");
        }
        return "id=" + dy.getString("id") + "-" + "bsed" + "=" + boId + "-" + "boid" + "=" + date;
    }
}

