/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.hr.hpfs.business.perchg;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.hr.hpfs.business.Repository.EmpSuprelRepository;
import kd.sdk.hr.hpfs.business.perchg.executor.enums.ChgFlowTypeEnum;
import kd.sdk.hr.hpfs.business.perchg.executor.model.ChgRecordEntryDto;
import kd.sdk.hr.hspm.common.utils.QFilterUtil;

public class PerChgEmpSuprelHelper {
    private static final Log LOGGER = LogFactory.getLog(PerChgEmpSuprelHelper.class);
    private static final Set<Long> INVALID_EMPSUPREL_CHGEVENT = Sets.newHashSet((Object[])new Long[]{1070L, 1020L, 1080L});

    public static List<ChgRecordEntryDto> invalidateEmpSuprelByEmp(List<DynamicObject> empposorgrel, long chgEvent, Map<String, Object> param) {
        ArrayList<ChgRecordEntryDto> invalidateEmpSuprel = new ArrayList<ChgRecordEntryDto>();
        List<DynamicObject> invalidEmps = PerChgEmpSuprelHelper.filterInvalidEmp(empposorgrel);
        if (null == invalidEmps || invalidEmps.size() == 0) {
            LOGGER.warn("PerChgEmpSuprelHelper#invalidateEmpSuprelByEmp invalidEmps is empty");
            return invalidateEmpSuprel;
        }
        boolean isQuit = chgEvent == 1070L || chgEvent == 1080L;
        Object[] empSuprels = PerChgEmpSuprelHelper.getEmpSuprel(invalidEmps, chgEvent, isQuit);
        if (HRArrayUtils.isEmpty((Object[])empSuprels)) {
            LOGGER.info("PerChgEmpSuprelHelper#invalidateEmpSuprelByEmp empSuprels is empty, invalidateEmpSuprelByEmp end");
            return invalidateEmpSuprel;
        }
        Map<Long, DynamicObject> empMap = invalidEmps.stream().collect(Collectors.toMap(dy -> dy.getLong("employee.id"), dy -> dy, (dy1, dy2) -> dy2));
        Map<Long, DynamicObject> depempMap = invalidEmps.stream().collect(Collectors.toMap(dy -> dy.getLong("depemp.id"), dy -> dy, (dy1, dy2) -> dy2));
        Set<Long> employeeIds = empMap.keySet();
        Set<Long> depempIds = depempMap.keySet();
        HashSet boidSet = new HashSet();
        if (INVALID_EMPSUPREL_CHGEVENT.contains(chgEvent)) {
            Arrays.stream(empSuprels).filter(empSuprel -> isQuit ? employeeIds.contains(empSuprel.getLong("superioremployee.id")) : depempIds.contains(empSuprel.getLong("superiordepemp.id"))).forEach(empSuprel -> {
                if (boidSet.add(empSuprel.getLong("boid"))) {
                    DynamicObject empDy = isQuit ? (DynamicObject)empMap.get(empSuprel.getLong("superioremployee.id")) : (DynamicObject)depempMap.get(empSuprel.getLong("superiordepemp.id"));
                    PerChgEmpSuprelHelper.buildInvalidEmpSuprel(empDy, empSuprel, invalidateEmpSuprel, false);
                }
            });
        }
        Arrays.stream(empSuprels).filter(empSuprel -> isQuit ? employeeIds.contains(empSuprel.getLong("employee.id")) : depempIds.contains(empSuprel.getLong("depemp.id"))).forEach(empSuprel -> {
            if (boidSet.add(empSuprel.getLong("boid"))) {
                DynamicObject empDy = isQuit ? (DynamicObject)empMap.get(empSuprel.getLong("employee.id")) : (DynamicObject)depempMap.get(empSuprel.getLong("depemp.id"));
                PerChgEmpSuprelHelper.buildInvalidEmpSuprel(empDy, empSuprel, invalidateEmpSuprel, isQuit);
            }
        });
        return invalidateEmpSuprel;
    }

    private static void buildInvalidEmpSuprel(DynamicObject empposorgrel, DynamicObject empSuprel, List<ChgRecordEntryDto> invalidateEmpSuprel, boolean isQuit) {
        DynamicObject newHis = EmpSuprelRepository.generateEmptyDynamicObject();
        HRDynamicObjectUtils.copy((DynamicObject)empSuprel, (DynamicObject)newHis);
        PerChgEmpSuprelHelper.buildLoseEffectCommon(empposorgrel, newHis, isQuit);
        ChgRecordEntryDto recordEntryDto = ChgRecordEntryDto.formatRecord(empSuprel.getLong("boid"), empposorgrel.getLong("id"), newHis.getLong("boid"), newHis.getLong("id"), "2", ChgFlowTypeEnum.FLOW_UNRELATED.getFlowType(), newHis);
        invalidateEmpSuprel.add(recordEntryDto);
    }

    private static List<DynamicObject> filterInvalidEmp(List<DynamicObject> empposorgrel) {
        if (null == empposorgrel || empposorgrel.size() == 0) {
            LOGGER.warn("PerChgEmpSuprelHelper#invalidateEmpSuprelByEmp empposorgrel is empty");
            return Collections.emptyList();
        }
        return empposorgrel.stream().filter(emp -> HRStringUtils.equals((String)emp.getString("businessstatus"), (String)"2")).collect(Collectors.toList());
    }

    private static void buildLoseEffectCommon(DynamicObject empDy, DynamicObject dbDy, boolean isQuit) {
        dbDy.set("bsed", empDy.get("bsed"));
        dbDy.set("bsled", empDy.get("bsled"));
        dbDy.set("id", (Object)ORM.create().genLongId("hrpi_empsuprel"));
        if (!isQuit) {
            dbDy.set("businessstatus", (Object)"2");
        }
        dbDy.set("enddate", empDy.get("enddate"));
        dbDy.set("sysenddate", empDy.get("sysenddate"));
        dbDy.set("modifier", (Object)RequestContext.get().getCurrUserId());
        dbDy.set("modifytime", (Object)new Date());
        dbDy.set("initstatus", (Object)"2");
    }

    private static DynamicObject[] getEmpSuprel(List<DynamicObject> empposorgrels, long chgEvent, boolean isQuit) {
        QFilter reporterQFilter;
        LOGGER.info("PerChgEmpSuprelHelper#getQueryQFilter chgEvent is {}", (Object)chgEvent);
        if (null == empposorgrels || empposorgrels.size() == 0) {
            LOGGER.error("PerChgEmpSuprelHelper#getQueryQFilter error, the empposorgrels is empty");
            return null;
        }
        Set employeeIds = empposorgrels.stream().map(dy -> dy.getLong("employee.id")).collect(Collectors.toSet());
        Set depempIds = empposorgrels.stream().map(dy -> dy.getLong("depemp.id")).collect(Collectors.toSet());
        if (isQuit) {
            reporterQFilter = new QFilter("employee", "in", employeeIds);
            reporterQFilter.or(new QFilter("superioremployee", "in", employeeIds));
        } else {
            reporterQFilter = new QFilter("depemp", "in", depempIds);
            if (1020L == chgEvent) {
                reporterQFilter.or(new QFilter("superiordepemp", "in", depempIds));
            }
        }
        reporterQFilter.and(QFilterUtil.getBusinessStatus()).and(QFilterUtil.getDataStatusFilter()).and(QFilterUtil.getCurrentQf()).and(QFilterUtil.getInitStatusFinish());
        return EmpSuprelRepository.queryEmpSuprelByCustomerQFilter(reporterQFilter);
    }
}

