/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.hr.hpfs.business.perchg.executor.enums;

import java.util.Arrays;
import kd.hr.hbp.common.util.HRStringUtils;

public enum AttachmentEnum {
    HOM_PERCRE("hrpi_percre", "hcf_cancre"),
    HOM_EDU_EXP("hrpi_pereduexpcert", "hcf_educertificate"),
    HOM_CERT_EXP("hrpi_pereduexpcert", "hcf_caneduexp"),
    HOM_LANGUAGE_SKILL("hrpi_languageskills", "hcf_canlgability"),
    HOM_PRE_WORK_EXP("hrpi_preworkexp", "hcf_canprework"),
    HOM_RSMPATINV("hrpi_rsmpatinv", "hcf_rsmpatinv");

    private final String hrpi;
    private final String hcf;

    private AttachmentEnum(String hrpi, String hcf) {
        this.hrpi = hrpi;
        this.hcf = hcf;
    }

    public String getHrpi() {
        return this.hrpi;
    }

    public String getHcf() {
        return this.hcf;
    }

    public static String getHrpiByBusiness(String business) {
        return Arrays.stream(AttachmentEnum.values()).filter(row -> HRStringUtils.equals((String)row.getHrpi(), (String)business)).findAny().map(AttachmentEnum::getHrpi).orElse(null);
    }

    public static String getHcfByBusiness(String business) {
        return Arrays.stream(AttachmentEnum.values()).filter(row -> HRStringUtils.equals((String)row.getHcf(), (String)business)).findAny().map(AttachmentEnum::getHcf).orElse(null);
    }
}

