/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.hr.hpfs.business.service.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRMapUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.hr.common.bean.EmpBean;
import kd.sdk.hr.common.bean.PerChgBizInfoNew;
import kd.sdk.hr.common.bean.PersonBean;
import kd.sdk.hr.hpfs.business.mservice.helper.ChgRecordHelper;
import kd.sdk.hr.hpfs.business.mservice.helper.SendMsgHelper;
import kd.sdk.hr.hpfs.business.perchg.executor.model.ChgRecordEntryDto;
import kd.sdk.hr.hpfs.business.service.IPerSaveSuccessService;
import kd.sdk.hr.hpfs.common.enums.PerChgStatusEnum;
import kd.sdk.hr.hpfs.utils.ChgRecordMsgUtils;
import kd.sdk.hr.hpfs.utils.RepositoryUtils;

public class PerSaveSuccessService
implements IPerSaveSuccessService {
    private static final Log LOG = LogFactory.getLog(PerSaveSuccessService.class);

    @Override
    public void doIfPerSaveSuccessOperate(PerChgBizInfoNew perChgBizInfoNew, Map<String, Object> res) {
        LOG.info("==SAVE PERSON RESULT:{} ==", res);
        LOG.info("==SAVE PERSON perChgBizInfoNew:{} ==", (Object)perChgBizInfoNew);
        if (perChgBizInfoNew == null) {
            LOG.info("===perChgBizInfoNew is null=");
            return;
        }
        if (!perChgBizInfoNew.isSuccess()) {
            LOG.info("===perChgBizInfoNew is fail=");
            return;
        }
        if (res == null) {
            LOG.info("==doIfPerSaveSuccessOperate IHRPIPersonGenericService.validate api res is null");
            return;
        }
        if (((Boolean)res.get("success")).booleanValue()) {
            String msgNumber;
            List<PerChgBizInfoNew> perInfoNews = Collections.singletonList(perChgBizInfoNew);
            ChgRecordHelper.doWriteBackVidAfterSuccess(perChgBizInfoNew, res);
            try (TXHandle txHandle = TX.requiresNew();){
                try {
                    ChgRecordHelper.addFileChgRecord(perInfoNews);
                    ChgRecordHelper.generatePersonFlow(perInfoNews);
                    this.syncLicebseCert(perChgBizInfoNew);
                }
                catch (Exception ex) {
                    txHandle.markRollback();
                    LOG.error((Throwable)ex);
                }
            }
            txHandle = TX.requiresNew();
            var5_5 = null;
            try {
                try {
                    this.saveBosAttach(perChgBizInfoNew);
                }
                catch (Exception ex) {
                    txHandle.markRollback();
                    LOG.error((Throwable)ex);
                }
            }
            catch (Throwable throwable) {
                var5_5 = throwable;
                throw throwable;
            }
            finally {
                if (txHandle != null) {
                    if (var5_5 != null) {
                        try {
                            txHandle.close();
                        }
                        catch (Throwable throwable) {
                            var5_5.addSuppressed(throwable);
                        }
                    } else {
                        txHandle.close();
                    }
                }
            }
            this.syncBosUser(perChgBizInfoNew);
            DynamicObject chgActionDy = perChgBizInfoNew.getChgActionDy();
            if (chgActionDy != null && HRStringUtils.isNotEmpty((String)(msgNumber = chgActionDy.getString("msgnumber")))) {
                SendMsgHelper.sendHpfsMsg(msgNumber, perChgBizInfoNew);
            }
        }
    }

    public Map<String, Object> syncBosUser(PerChgBizInfoNew perChgBizInfoNew) {
        LOG.info("PerSaveSuccessService#syncBosUser begin");
        Map<String, Object> retMap = new HashMap<String, Object>();
        HashSet<Long> employeeIds = new HashSet<Long>();
        List<ChgRecordEntryDto> employeeRecordList = perChgBizInfoNew.getEntityRecord().get("hrpi_employee");
        for (ChgRecordEntryDto employeeRecord : employeeRecordList) {
            if (null != employeeRecord.getIdAfter() && employeeRecord.getIdAfter() > 0L) {
                employeeIds.add(employeeRecord.getIdAfter());
                continue;
            }
            employeeIds.add(employeeRecord.getIdBefore());
        }
        if (employeeIds.size() > 0) {
            List syncParams = employeeIds.stream().map(employeeId -> {
                HashMap<String, Long> param = new HashMap<String, Long>();
                param.put("employeeId", (Long)employeeId);
                param.put("actionId", perChgBizInfoNew.getChgActionId());
                return param;
            }).collect(Collectors.toList());
            try {
                retMap = (Map)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonService", (String)"syncHRPersonToSysUser", (Object[])new Object[]{syncParams});
            }
            catch (Exception ex) {
                LOG.error("PerSaveSuccessService#syncBosUser exception", (Throwable)ex);
            }
        } else {
            LOG.info("PerSaveSuccessService#syncBosUser params is empty");
        }
        LOG.info("PerSaveSuccessService#syncBosUser end");
        return retMap;
    }

    @Override
    public void afterPerSaveSuccess(PerChgBizInfoNew perChgBizInfoNew, Map<String, Object> res, DynamicObject billDy) {
        DynamicObject chgActionDy;
        LOG.info("==SAVE_PERSON RESULT:{} ==", res);
        LOG.info("==SAVE_PERSON perChgBizInfoNew:{} ==", (Object)perChgBizInfoNew);
        if (ChgRecordMsgUtils.notSuccessTips(perChgBizInfoNew, res, billDy)) {
            return;
        }
        List<String> existStatus = ChgRecordMsgUtils.getStatus(billDy);
        List<PerChgBizInfoNew> perInfoNews = Collections.singletonList(perChgBizInfoNew);
        ChgRecordHelper.doWriteBackVidAfterSuccess(perChgBizInfoNew, res);
        try (TXHandle txHandle = TX.requiresNew();){
            try {
                if (ChgRecordMsgUtils.notExistSuccessStep(existStatus, "80")) {
                    ChgRecordHelper.addFileChgRecord(perInfoNews);
                    ChgRecordMsgUtils.setStatusAndMsgByEnum(billDy, PerChgStatusEnum.SYNC_LOG_S, true, perInfoNews.get(0));
                }
                if (ChgRecordMsgUtils.notExistSuccessStep(existStatus, "40")) {
                    ChgRecordHelper.generatePersonFlow(perInfoNews);
                    ChgRecordMsgUtils.setStatusAndMsgByEnum(billDy, PerChgStatusEnum.SYNC_FLOW_S, true, perInfoNews.get(0));
                }
                if (ChgRecordMsgUtils.notExistSuccessStep(existStatus, "60")) {
                    this.syncLicebseCert(perChgBizInfoNew);
                    ChgRecordMsgUtils.setStatusAndMsgByEnum(billDy, PerChgStatusEnum.SYNC_LINENCE_S, true, perChgBizInfoNew);
                }
            }
            catch (Exception ex) {
                ChgRecordMsgUtils.setStatusAndMsgByEnum(billDy, PerChgStatusEnum.SYNC_LOG_F, false, perInfoNews.get(0));
                ChgRecordMsgUtils.setStatusAndMsgByEnum(billDy, PerChgStatusEnum.SYNC_FLOW_F, false, perInfoNews.get(0));
                ChgRecordMsgUtils.setStatusAndMsgByEnum(billDy, PerChgStatusEnum.SYNC_LINENCE_F, false, perChgBizInfoNew);
                txHandle.markRollback();
                LOG.error("==afterPerSaveSuccess_synInfo==", (Throwable)ex);
            }
        }
        txHandle = TX.requiresNew();
        var7_7 = null;
        try {
            try {
                if (ChgRecordMsgUtils.notExistSuccessStep(existStatus, "110")) {
                    this.saveBosAttach(perChgBizInfoNew);
                    ChgRecordMsgUtils.setStatusAndMsgByEnum(billDy, PerChgStatusEnum.SYNC_ATTMENT_S, true, perChgBizInfoNew);
                }
            }
            catch (Exception ex) {
                txHandle.markRollback();
                LOG.error("==afterPerSaveSuccess_synAttach==", (Throwable)ex);
                ChgRecordMsgUtils.setStatusAndMsgByEnum(billDy, PerChgStatusEnum.SYNC_ATTMENT_F, true, perChgBizInfoNew);
            }
        }
        catch (Throwable throwable) {
            var7_7 = throwable;
            throw throwable;
        }
        finally {
            if (txHandle != null) {
                if (var7_7 != null) {
                    try {
                        txHandle.close();
                    }
                    catch (Throwable throwable) {
                        var7_7.addSuppressed(throwable);
                    }
                } else {
                    txHandle.close();
                }
            }
        }
        if (ChgRecordMsgUtils.notExistSuccessStep(existStatus, "110")) {
            Map<String, Object> retMap = this.syncBosUser(perChgBizInfoNew);
            if (!HRMapUtils.isEmpty(retMap) && retMap.containsKey("success") && !((Boolean)res.get("success")).booleanValue()) {
                ChgRecordMsgUtils.setStatusAndMsgByEnum(billDy, PerChgStatusEnum.SYNC_BOSUSER_S, true, perChgBizInfoNew);
            } else {
                ChgRecordMsgUtils.setStatusAndMsgByEnum(billDy, PerChgStatusEnum.SYNC_BOSUSER_F, true, perChgBizInfoNew);
            }
        }
        if ((chgActionDy = perChgBizInfoNew.getChgActionDy()) != null && HRStringUtils.isNotEmpty((String)chgActionDy.getString("msgnumber"))) {
            try {
                if (ChgRecordMsgUtils.notExistSuccessStep(existStatus, "50")) {
                    String msgNumber = chgActionDy.getString("msgnumber");
                    SendMsgHelper.sendHpfsMsg(msgNumber, perChgBizInfoNew);
                    ChgRecordMsgUtils.setStatusAndMsgByEnum(billDy, PerChgStatusEnum.SYNC_MSG_S, true, perChgBizInfoNew);
                }
            }
            catch (Exception ex) {
                ChgRecordMsgUtils.setStatusAndMsgByEnum(billDy, PerChgStatusEnum.SYNC_MSG_F, false, perChgBizInfoNew);
                LOG.error("==syncSendHpfsMsgError==", (Throwable)ex);
                throw new KDException((Throwable)ex, new ErrorCode("55", PerChgStatusEnum.getFieldTypeByCode("55")), new Object[0]);
            }
        }
    }

    private void syncLicebseCert(PerChgBizInfoNew perChgBizInfoNew) {
        LOG.info("==begin syncLicebseCert==");
        List<PersonBean> personList = perChgBizInfoNew.getPersonList();
        PersonBean personBean = personList.get(personList.size() - 1);
        List<EmpBean> empList = perChgBizInfoNew.getEmpList();
        EmpBean empBean = empList.get(empList.size() - 1);
        Long chgeventId = ChgRecordHelper.getChgEventId(perChgBizInfoNew);
        Long oldPersonId = personBean.getbPersonId();
        Long newPersonId = personBean.getaPersonId();
        Long oldEmpId = empBean.getbEmpId();
        String number = HRStringUtils.isEmpty((String)empBean.getaEmpnumber()) ? empBean.getbEmpnumber() : empBean.getaEmpnumber();
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        params.put("chgeventId", chgeventId);
        params.put("oldEmpId", oldEmpId);
        params.put("oldPersonId", oldPersonId);
        params.put("number", number);
        params.put("newPersonId", newPersonId);
        HRMServiceHelper.invokeBizService((String)"hr", (String)"hpfs", (String)"IHPFSLicenseService", (String)"addOrDelCertService", (Object[])new Object[]{params});
    }

    private void saveBosAttach(PerChgBizInfoNew perChgBizInfoNew) {
        List<DynamicObject> bosAttachs = perChgBizInfoNew.getBosAttachs();
        if (!CollectionUtils.isEmpty(bosAttachs)) {
            RepositoryUtils.saveDynamicObjects("bos_attachment", bosAttachs);
        }
    }
}

