/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.hr.hpfs.formplugin.chgPlugin;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.sdk.hr.common.helper.HpfsMetaDataServiceHelper;
import kd.sdk.hr.hpfs.business.perchg.executor.enums.ChgModeEnum;
import kd.sdk.hr.hpfs.common.constants.PerChgNewBillTplConstants;
import kd.sdk.hr.hpfs.utils.PerChgNewBillUtils;

public class PerChgAddEntryEdit
extends AbstractBillPlugIn
implements PerChgNewBillTplConstants {
    private static final Log LOGGER = LogFactory.getLog(PerChgAddEntryEdit.class);

    public void propertyChanged(PropertyChangedArgs args) {
        String fieldName = args.getProperty().getName();
        ChangeData[] changeSet = args.getChangeSet();
        if (changeSet == null || changeSet.length == 0) {
            return;
        }
        if (Objects.nonNull(changeSet[0].getNewValue()) && changeSet[0].getNewValue().equals(changeSet[0].getOldValue())) {
            return;
        }
        if ("b_ermanfile".equals(fieldName) || "affaction".equals(fieldName)) {
            this.changeMainProp();
        }
    }

    private void changeMainProp() {
        DynamicObject mainBillDy = this.getModel().getDataEntity();
        DynamicObject actionNewDy = mainBillDy.getDynamicObject("affaction");
        DynamicObject fileDy = mainBillDy.getDynamicObject("b_ermanfile");
        if (Objects.nonNull(actionNewDy) && actionNewDy.getBoolean("isnewchgaction") && Objects.nonNull(fileDy)) {
            this.setBeforeDepEmpEntry();
        }
    }

    private void setBeforeDepEmpEntry() {
        DynamicObject mainBillDy = this.getModel().getDataEntity();
        IDataEntityType dataEntityType = mainBillDy.getDataEntityType();
        String name = dataEntityType.getName();
        long employeeId = mainBillDy.getLong("bb_e_tid");
        long depEmpId = mainBillDy.getLong("bb_d_tid");
        QFilter employeeFilter = new QFilter("employee", "=", (Object)employeeId);
        boolean htmTpl = false;
        boolean endTpl = HpfsMetaDataServiceHelper.isInhTpl("hpfs_hrendbillorgtplext", "4A0/J/2X1WQP", name);
        if (endTpl) {
            QFilter mainFilter = new QFilter("isprimary", "=", (Object)"1");
            mainFilter.or(new QFilter("depemp", "=", (Object)depEmpId));
            employeeFilter.and(mainFilter);
        } else {
            htmTpl = HpfsMetaDataServiceHelper.isInhTpl("hpfs_hrhtmbillorgtplext", "4A/NH6L97DAK", name);
        }
        if (endTpl || htmTpl) {
            this.queryDataAndSetEntry(mainBillDy, employeeFilter, endTpl, htmTpl);
        }
        LOGGER.info("PerChgAddEntryEdit_setBeforeDepEmpEntry_end=={},{}", (Object)endTpl, (Object)htmTpl);
    }

    private void queryDataAndSetEntry(DynamicObject mainBillDy, QFilter employeeFilter, boolean endTpl, boolean htmTpl) {
        DynamicObjectCollection entryEntityDys = mainBillDy.getDynamicObjectCollection("entry_b_depemp");
        Map<Long, DynamicObject> entryMap = entryEntityDys.stream().collect(Collectors.toMap(item -> item.getLong("b_d_tid"), item -> item, (k1, k2) -> k1));
        Object[] empPosDys = PerChgAddEntryEdit.getEmployeeAttach(employeeFilter, "hrpi_empposorgrel");
        if (HRArrayUtils.isEmpty((Object[])empPosDys)) {
            return;
        }
        List depEmpIds = Arrays.stream(empPosDys).map(dy -> dy.getLong("depemp.id")).collect(Collectors.toList());
        QFilter depFilter = new QFilter("depemp", "in", depEmpIds);
        Object[] fileDys = PerChgAddEntryEdit.getEmployeeAttach(depFilter, "hspm_ermanfile");
        if (HRArrayUtils.isEmpty((Object[])fileDys)) {
            return;
        }
        Map<Long, DynamicObject> fileMap = Arrays.stream(fileDys).collect(Collectors.toMap(dy -> dy.getLong("depemp.id"), dy -> dy, (k1, k2) -> k1));
        List<String> entryList = Collections.singletonList("entry_b_depemp");
        Map<String, List<String>> entryAndFieldMap = PerChgNewBillUtils.getEntryAndFieldMap(mainBillDy, entryList);
        List<String> fields = entryAndFieldMap.get("entry_b_depemp");
        for (Object empPosDy : empPosDys) {
            String primary = empPosDy.getString("isprimary");
            Long depId = empPosDy.getLong("depemp.id");
            DynamicObject depEmpEntryEntityDy = entryMap.get(depId);
            if (depEmpEntryEntityDy != null) {
                this.setChgTypeAndField(mainBillDy, fileMap, htmTpl, primary, depEmpEntryEntityDy);
                continue;
            }
            depEmpEntryEntityDy = entryEntityDys.addNew();
            Map<String, Object> dmpFieldAndValue = PerChgNewBillUtils.getDepEmpFieldAndValue(fields, (DynamicObject)empPosDy);
            dmpFieldAndValue.forEach((arg_0, arg_1) -> ((DynamicObject)depEmpEntryEntityDy).set(arg_0, arg_1));
            this.setChgTypeAndField(mainBillDy, fileMap, htmTpl, primary, depEmpEntryEntityDy);
        }
        if (this.getView() != null) {
            this.getView().getModel().updateEntryCache(mainBillDy.getDynamicObjectCollection("entry_b_depemp"));
            this.getView().updateView("entry_b_depemp");
        }
    }

    private void setChgTypeAndField(DynamicObject mainBillDy, Map<Long, DynamicObject> fileMap, boolean htmTpl, String primary, DynamicObject depEmpEntryEntityDy) {
        long depEmpId = mainBillDy.getLong("bb_d_tid");
        if (htmTpl) {
            depEmpEntryEntityDy.set("b_d_chgtype", (Object)ChgModeEnum.INVALID.getChgMode());
            depEmpEntryEntityDy.set("b_d_businessstatus", (Object)ChgModeEnum.INVALID.getChgMode());
        } else if ("1".equals(primary)) {
            depEmpEntryEntityDy.set("b_d_chgtype", (Object)ChgModeEnum.MODIFY.getChgMode());
            DynamicObject postState = new HRBaseServiceHelper("hbss_poststate").loadDynamicObject(new QFilter("id", "=", (Object)1020L));
            depEmpEntryEntityDy.set("b_d_posstatus", (Object)postState);
        } else {
            depEmpEntryEntityDy.set("b_d_businessstatus", (Object)ChgModeEnum.INVALID.getChgMode());
            depEmpEntryEntityDy.set("b_d_chgtype", (Object)ChgModeEnum.INVALID.getChgMode());
        }
        DynamicObject fileDy = fileMap.get(depEmpId);
        if (fileDy == null) {
            return;
        }
        if (Objects.isNull(depEmpEntryEntityDy.get("b_d_org"))) {
            depEmpEntryEntityDy.set("b_d_org", fileDy.get("org"));
        }
        if (Objects.isNull(depEmpEntryEntityDy.get("b_d_affiliateadminorg"))) {
            depEmpEntryEntityDy.set("b_d_affiliateadminorg", fileDy.get("affiliateadminorg"));
        }
        if (Objects.isNull(depEmpEntryEntityDy.get("b_d_empgroup"))) {
            depEmpEntryEntityDy.set("b_d_empgroup", fileDy.get("empgroup"));
        }
    }

    private static DynamicObject[] getEmployeeAttach(QFilter qFilter, String entityName) {
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)entityName);
        Set field = dataEntityType.getAllFields().keySet();
        QFilter commonFilter = new QFilter("datastatus", "=", (Object)"1").and(new QFilter("businessstatus", "=", (Object)"1")).and(new QFilter("iscurrentversion", "=", (Object)"1"));
        DynamicObject[] dyArray = (DynamicObject[])HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonSyncService", (String)"listFieldsFilterInfo", (Object[])new Object[]{String.join((CharSequence)",", field), commonFilter.and(qFilter), entityName});
        LOGGER.info("PerChgAddEntryEdit_getEmployeeAttach_end,entityName:{},result:{}", (Object)entityName, (Object)dyArray);
        return dyArray;
    }
}

