/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.hr.hpfs.opplugin;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sdk.hr.common.bean.PerChgBizInfoNew;
import kd.sdk.hr.hpfs.utils.PerChgNewBillUtils;
import kd.sdk.hr.hpfs.utils.PersonParamsBuilder;
import org.apache.commons.lang3.SerializationUtils;

public class PerChgTplSubmitEffectValidator
extends AbstractValidator {
    private static final Log LOGGER = LogFactory.getLog(PerChgTplSubmitEffectValidator.class);

    public void validate() {
        ExtendedDataEntity[] dataEntities;
        for (ExtendedDataEntity extendedDataEntity : dataEntities = this.getDataEntities()) {
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            try {
                PerChgNewBillUtils.setEntryAndBillFields(dataEntity);
                PerChgNewBillUtils.setEntryFields(dataEntity);
            }
            catch (Exception exception) {
                LOGGER.error("==PerChgTplSubmitValidator=={} , error:", (Object)dataEntity.getString("id"), (Object)exception);
            }
        }
        DynamicObject[] bills = (DynamicObject[])Arrays.stream(dataEntities).map(ExtendedDataEntity::getDataEntity).toArray(DynamicObject[]::new);
        this.saveEntryFields(bills);
        List<PerChgBizInfoNew> perChgBizInfoNews = this.personParamsBuilder(bills);
        Map<String, List<PerChgBizInfoNew>> buildMap = perChgBizInfoNews.stream().collect(Collectors.groupingBy(PerChgBizInfoNew::getBillNo));
        for (ExtendedDataEntity extendedDataEntity : dataEntities) {
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            String billNo = dataEntity.getString("billNo");
            this.buildSyncParam(buildMap, extendedDataEntity, billNo);
        }
    }

    private void saveEntryFields(DynamicObject[] bills) {
        String entityName = bills[0].getDataEntityType().getName();
        new HRBaseServiceHelper(entityName).save(bills);
    }

    private void buildSyncParam(Map<String, List<PerChgBizInfoNew>> buildMap, ExtendedDataEntity extendedDataEntity, String billNo) {
        DynamicObject dataEntity = extendedDataEntity.getDataEntity();
        List<PerChgBizInfoNew> bizInfoNews = buildMap.get(billNo);
        if (CollectionUtils.isNotEmpty(bizInfoNews)) {
            PerChgBizInfoNew perChgBizInfoNew = bizInfoNews.get(0);
            boolean success = perChgBizInfoNew.isSuccess();
            if (!success) {
                this.addErrorMessage(extendedDataEntity, perChgBizInfoNew.getErrMsg());
            } else {
                byte[] serialize = SerializationUtils.serialize((Serializable)perChgBizInfoNew);
                dataEntity.set("perchgbizinfo_tag", (Object)Base64.getEncoder().encodeToString(serialize));
            }
        }
    }

    private List<PerChgBizInfoNew> personParamsBuilder(DynamicObject[] bills) {
        PersonParamsBuilder builder = new PersonParamsBuilder();
        ArrayList<PerChgBizInfoNew> allPerList = new ArrayList<PerChgBizInfoNew>();
        Arrays.stream(bills).forEach(bill -> {
            PerChgBizInfoNew perChgBizInfoNew = new PerChgBizInfoNew();
            perChgBizInfoNew.setBillId(bill.getLong("id"));
            perChgBizInfoNew.setBillNo(bill.getString("billNo"));
            perChgBizInfoNew.setBillSource(bill.getDataEntityType().getName());
            perChgBizInfoNew.setChgActionId(bill.getLong("affaction.id"));
            allPerList.add(perChgBizInfoNew);
        });
        builder.validParamsAndBuildParams(allPerList);
        return allPerList;
    }
}

