/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.hr.hpfs.opplugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRInteDateTimeUtil;
import kd.hr.hbp.common.util.HRMapUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class PerChgTplSubmitValidator
extends AbstractValidator {
    private static final Log LOGGER = LogFactory.getLog(PerChgTplSubmitValidator.class);

    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        ArrayList<Map<String, Object>> reqParamList = new ArrayList<Map<String, Object>>(10);
        for (ExtendedDataEntity extendedDataEntity : dataEntities) {
            DynamicObject stdPostDy;
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            String name = dataEntity.getDataEntityType().getName();
            Date effectDate = dataEntity.getDate("b_effectivedate");
            DynamicObject jobDy = dataEntity.getDynamicObject("ba_d_job");
            if (jobDy != null && HRDateTimeUtils.dayBefore((Date)effectDate, (Date)jobDy.getDate("firstbsed"))) {
                this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u8f93\u5165\u4fe1\u606f\u6709\u8bef\uff0c\u804c\u4f4d\u7684\u521b\u5efa\u665a\u4e8e%s\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"PerChgTplSubmitValidator_3", (String)"sdk-hr", (Object[])new Object[0]), HRInteDateTimeUtil.formatDate((String)name, (String)"b_effectivedate", (Date)jobDy.getDate("firstbsed"))));
            }
            if ((stdPostDy = dataEntity.getDynamicObject("ba_d_stdposition")) != null && HRDateTimeUtils.dayBefore((Date)effectDate, (Date)stdPostDy.getDate("firstbsed"))) {
                this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u8f93\u5165\u4fe1\u606f\u6709\u8bef\uff0c\u6807\u51c6\u5c97\u4f4d\u7684\u521b\u5efa\u665a\u4e8e%s\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"PerChgTplSubmitValidator_2", (String)"sdk-hr", (Object[])new Object[0]), HRInteDateTimeUtil.formatDate((String)name, (String)"b_effectivedate", (Date)stdPostDy.getDate("firstbsed"))));
            }
            this.buildCrossValidParams(reqParamList, dataEntity);
        }
        Map retMap = (Map)HRMServiceHelper.invokeHRService((String)"hpfs", (String)"IHPFSPersonChgService", (String)"crossValidateBatch", (Object[])new Object[]{reqParamList});
        for (ExtendedDataEntity extendedDataEntity : dataEntities) {
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            String billNo = dataEntity.getString("billNo");
            String number = dataEntity.getString("b_ermanfile.name");
            String billActionName = dataEntity.getString("affaction.name");
            if (!((Boolean)retMap.get("success")).booleanValue()) {
                LOGGER.error("==PerChgTplSubmitValidator_tip=={}", retMap.get("errorMsg"));
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u6821\u9a8c\u5f02\u5e38", (String)"PerChgTplSubmitValidator_0", (String)"sdk-hr", (Object[])new Object[0]));
            }
            this.setCrossValidate(retMap, extendedDataEntity, billNo, number, billActionName);
        }
    }

    void setCrossValidate(Map<String, Object> retMap, ExtendedDataEntity extendedDataEntity, String billNo, String number, String billActionName) {
        Map batchCrossValidateResult = (Map)retMap.get("data");
        if (HRMapUtils.isEmpty((Map)batchCrossValidateResult)) {
            return;
        }
        for (Map.Entry result : batchCrossValidateResult.entrySet()) {
            List crossList = (List)result.getValue();
            if (CollectionUtils.isEmpty((Collection)crossList)) continue;
            Map<String, List<Map>> crossMapRet = crossList.stream().collect(Collectors.groupingBy(cross -> String.valueOf(cross.get("billNoSource"))));
            for (Map.Entry<String, List<Map>> cross2 : crossMapRet.entrySet()) {
                String ebillNo = cross2.getKey();
                List<Map> crossValidateList = cross2.getValue();
                if (CollectionUtils.isEmpty(crossValidateList) || !billNo.equals(ebillNo)) continue;
                for (Map crossMap : crossValidateList) {
                    String matchBillNo = (String)crossMap.get("billNo");
                    String actionName = (String)crossMap.get("actionName");
                    String tip = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230%1$s\u5df2\u53d1\u751f%2$s\uff08%3$s\uff09\uff0c\u4e0d\u53ef\u53d1\u8d77%4$s\u3002", (String)"PerChgTplSubmitValidator_1", (String)"sdk-hr", (Object[])new Object[0]);
                    this.addErrorMessage(extendedDataEntity, String.format(tip, number, actionName, matchBillNo, billActionName));
                }
            }
        }
    }

    void buildCrossValidParams(List<Map<String, Object>> reqParamList, DynamicObject dataEntity) {
        Date effectDate = dataEntity.getDate("b_effectivedate");
        String billNo = dataEntity.getString("billNo");
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        String actionId = dataEntity.getString("affaction.id");
        String pid = dataEntity.getString("bb_p_tid");
        String eid = dataEntity.getString("bb_e_tid");
        String did = dataEntity.getString("bb_d_tid");
        if (HRStringUtils.isEmpty((String)pid)) {
            pid = dataEntity.getString("ba_p_tid");
            eid = dataEntity.getString("ba_p_tid");
            did = dataEntity.getString("ba_p_tid");
        }
        map.put("actionId", actionId);
        if (effectDate != null) {
            map.put("effectTime", effectDate.getTime());
        }
        map.put("personId", pid);
        map.put("employeeId", eid);
        map.put("depEmpId", did);
        map.put("billNo", billNo);
        reqParamList.add(map);
    }
}

