/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.hr.hpfs.utils;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.cache.CacheFactory;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DBRoute;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.IFormView;
import kd.bos.sqlscript.PreInsDataScriptBuilder;
import kd.sdk.hr.hpfs.common.InsertTableInfo;

public class GenerateInsertKSQLUtils {
    public static String generateInsertKsql(List<InsertTableInfo> insertTableInfos) {
        StringBuilder result = new StringBuilder();
        if (Objects.isNull(insertTableInfos) || insertTableInfos.size() == 0) {
            return result.toString();
        }
        insertTableInfos.forEach(insertTable -> {
            if (StringUtils.isNotEmpty((CharSequence)insertTable.getTableName())) {
                PreInsDataScriptBuilder builder = new PreInsDataScriptBuilder();
                try {
                    Map map = builder.genInsertSQLScript(DBRoute.of((String)insertTable.getRoute()), insertTable.getTableName(), insertTable.getSelectField(), insertTable.getWhere(), null, null);
                    result.append(map.get("sql")).append('\r');
                }
                catch (Exception e) {
                    throw new KDBizException((Throwable)e, BosErrorCode.bOS, new Object[]{String.format("KSQLExpPlugin error:%s.", e.getMessage())});
                }
            }
        });
        return result.toString();
    }

    public static void exportFile(IFormView view, String sql, String sqlFileName) {
        try (ByteArrayInputStream ins = new ByteArrayInputStream(sql.getBytes(StandardCharsets.UTF_8));){
            String url = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(sqlFileName, (InputStream)ins, 5000);
            view.download(url);
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.downloadFailed, new Object[]{String.format("KSQLExpPlugin error:%s.", e.getMessage())});
        }
    }
}

